[VMware.VimAutomation.Sdk.Interop.V1.CoreServiceFactory]::CoreService.OnImportModule(
    "VMware.VimAutomation.Cis.Core.Commands",
    (Split-Path $script:MyInvocation.MyCommand.Path));

function global:Get-CisCommand([string] $Name = "*") {
<#
.SYNOPSIS
This function retrieves all commands of the VMware.VimAutomation.Cis.Core module.
.DESCRIPTION
This function retrieves all commands of the VMware.VimAutomation.Cis.Core module, including cmdlets, aliases, and functions.
.PARAMETER Name
Specifies the name of the command you want to retrieve.
#>
  get-command -module VMware.VimAutomation.Cis.Core -Name $Name
}

# SIG # Begin signature block
# MIID0gYJKoZIhvcNAQcCoIIDwzCCA78CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUUcHTQuNJXWXOlQTgmyVXxADq
# QjagggH/MIIB+zCCAWSgAwIBAgIQ18907PngVoVDxSbOLQ8BUzANBgkqhkiG9w0B
# AQQFADAVMRMwEQYDVQQDEwpWTXdhcmVUZXN0MCAXDTA2MDEwMTA3MDAwMFoYDzIw
# OTkwMTAxMDcwMDAwWjAVMRMwEQYDVQQDEwpWTXdhcmVUZXN0MIGfMA0GCSqGSIb3
# DQEBAQUAA4GNADCBiQKBgQDmacgVpuOBXRDeqygplNoCKFw8/pnraVAWvTQIANfb
# wt54jsZyX8wC2xv9Olgh6723Xg9s7qMBaJwQ4MCtUB18cx4grDcGeyigsmToBxFA
# zs3lqCP6RfZQzFcLIFdI9XeXvGOebP7rMFh0F5nUuvHIOtPF6I5tEhtxcGIR1gO+
# 5wIDAQABo0owSDBGBgNVHQEEPzA9gBA5XdDY7iSoQWy8DWL2BWjboRcwFTETMBEG
# A1UEAxMKVk13YXJlVGVzdIIQ18907PngVoVDxSbOLQ8BUzANBgkqhkiG9w0BAQQF
# AAOBgQCL864AWy1uUq69aswJAGcTBc7nGzM+3HCJT3tPLiiC76GYcnkxSQYHU8ER
# BdOwSKfPWKgjvdAvZR0/pLU6bIvQxEguFqgHVhbufx1njj7eH4dRWiDq672+OKJN
# IrcBnlMopCu75ryHAOH7j+dTUa2ykyt8FOk/OKVpnBfMfygrczGCAT0wggE5AgEB
# MCkwFTETMBEGA1UEAxMKVk13YXJlVGVzdAIQ18907PngVoVDxSbOLQ8BUzAJBgUr
# DgMCGgUAoGwwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwIwYJKoZIhvcNAQkE
# MRYEFHaBrjf3mIElCnGHnyCCYCUeVjcYMCoGCisGAQQBgjcCAQwxHDAaoRiAFmh0
# dHA6Ly93d3cudm13YXJlLmNvbS8wDQYJKoZIhvcNAQEBBQAEgYDhtAxjhNI0JV9Q
# unapii1+2LgZPc9ZzTFm7UK13xKpclRGcH2Oc76ixtT5DRratnPeIUKyNGp0MICX
# a53F0yCOikRqgOwbPeiESxrFj0YmedPn0SpNjgbAz/j7/eAoY0pqJvT32dfDGiAc
# wzUDhRo0ZTtfbfZviFn2Eo0UNqcpIQ==
# SIG # End signature block
