/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal.util;

public class NumericAlphaVersion
implements Comparable {
    private int numeric;
    private String alpha;

    public NumericAlphaVersion(String string) {
        try {
            this.extract(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unsupported numeric-alpha version format: " + string + "; " + exception);
        }
    }

    public int compareTo(Object object) {
        NumericAlphaVersion numericAlphaVersion = (NumericAlphaVersion)object;
        if (this.numeric != numericAlphaVersion.numeric) {
            return this.numeric < numericAlphaVersion.numeric ? -1 : 1;
        }
        return this.alpha.compareTo(numericAlphaVersion.alpha);
    }

    public boolean equals(Object object) {
        boolean bl;
        try {
            bl = this.compareTo(object) == 0;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.numeric + this.alpha.hashCode();
    }

    public String toString() {
        return this.numeric + this.alpha;
    }

    private void extract(String string) {
        this.numeric = 0;
        this.alpha = "";
        if (string.equals("")) {
            return;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) break;
            ++n;
        }
        this.numeric = Integer.parseInt(string.substring(0, n));
        this.alpha = string.substring(n);
    }
}

