/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.AxisInterface;
import javachart.chart.DataRepresentation;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Plotarea;
import javachart.chart.Transform;

public class Line
extends DataRepresentation
implements Serializable {
    boolean scatterPlot;
    boolean doClip = false;
    Transform dataXfm;
    double xAxisStart;
    double xAxisEnd;
    double yAxisStart;
    double yAxisEnd;
    protected int numDatasets;

    public Line() {
    }

    public Line(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        this.datasets = datasetArray;
        this.xAxis = axisInterface;
        this.yAxis = axisInterface2;
        this.plotarea = plotarea;
        this.globals = this.plotarea.globals;
    }

    protected void buildDataXfm() {
        this.xAxisStart = this.xAxis.getAxisStart();
        this.xAxisEnd = this.xAxis.getAxisEnd();
        this.yAxisStart = this.yAxis.getAxisStart();
        this.yAxisEnd = this.yAxis.getAxisEnd();
        this.dataXfm = new Transform(this.xAxisStart, this.yAxisStart, this.xAxisEnd, this.yAxisEnd, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY));
        this.dataXfm.logXScaling = this.xAxis.getLogScaling();
        this.dataXfm.logYScaling = this.yAxis.getLogScaling();
    }

    private synchronized int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    protected void doElementLabel(Graphics graphics, int n, int n2) {
        Datum datum = this.datasets[n].getDataElementAt(n2);
        String string = datum.label != null ? datum.label : this.formatLabel(datum.y);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Point point = this.dataXfm.point(datum.x, datum.y);
        this.datasets[n].gc.drawSmartString(graphics, point.x, point.y + 2, 2, this.labelAngle, fontMetrics, string);
    }

    protected void doLabels(Graphics graphics) {
        int n = 0;
        while (this.datasets[n] != null) {
            graphics.setFont(this.datasets[n].labelFont);
            graphics.setColor(this.datasets[n].labelColor);
            int n2 = 0;
            while (n2 < this.datasets[n].data.size()) {
                this.doElementLabel(graphics, n, n2);
                ++n2;
            }
            ++n;
        }
    }

    protected void doLine(Graphics graphics, int n) {
        double[] dArray = this.datasets[n].getXValues();
        double[] dArray2 = this.datasets[n].getYValues();
        if (!this.globals.threeD) {
            this.datasets[n].gc.drawPolyline(graphics, this.dataXfm.pointList(dArray, dArray2));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addPolyline(this.datasets[n], this.dataXfm.pointList(dArray, dArray2));
                this.globals.displayList.addPolyline(this, this.dataXfm.pointList(dArray, dArray2));
            }
        } else {
            int n2 = this.globals.xOffset / this.numDatasets;
            int n3 = this.globals.yOffset / this.numDatasets;
            int n4 = n2 * n;
            int n5 = n3 * n;
            Point[] pointArray = new Point[4];
            int n6 = 0;
            while (n6 < dArray.length - 1) {
                pointArray[0] = this.dataXfm.point(dArray[n6], dArray2[n6]);
                pointArray[0].translate(n4, n5);
                pointArray[1] = new Point(pointArray[0].x + n2, pointArray[0].y + n3);
                pointArray[3] = this.dataXfm.point(dArray[n6 + 1], dArray2[n6 + 1]);
                pointArray[3].translate(n4, n5);
                pointArray[2] = new Point(pointArray[3].x + n2, pointArray[3].y + n3);
                this.datasets[n].gc.drawPolygon(graphics, pointArray);
                this.datasets[n].gc.drawPolyline(graphics, pointArray);
                if (this.useDisplayList && this.globals.useDisplayList) {
                    this.globals.displayList.addPolygon(this.datasets[n], pointArray);
                    this.globals.displayList.addPolyline(this, pointArray);
                }
                ++n6;
            }
        }
    }

    protected synchronized void doLines(Graphics graphics, boolean bl) {
        Graphics graphics2 = graphics;
        this.numDatasets = this.datasetsInUse();
        this.buildDataXfm();
        if (this.doClip) {
            Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
            Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
            graphics = graphics.create();
            graphics.clipRect(point.x, this.globals.maxY - point2.y, point2.x - point.x, point2.y - point.y);
        }
        int n = 0;
        while (n < this.numDatasets) {
            if (bl) {
                this.doMarkers(graphics, this.numDatasets - 1 - n);
            } else {
                this.doLine(graphics, this.numDatasets - 1 - n);
                this.doMarkers(graphics, this.numDatasets - 1 - n);
            }
            if (this.labelsOn) {
                this.doLabels(graphics);
            }
            ++n;
        }
        if (this.doClip) {
            graphics = graphics2;
        }
    }

    protected void doMarkers(Graphics graphics, int n) {
        int n2;
        int n3;
        boolean bl = true;
        if (this.datasets[n].gc.image == null) {
            if (this.useDisplayList) {
                bl = false;
            } else {
                return;
            }
        }
        double[] dArray = this.datasets[n].getXValues();
        double[] dArray2 = this.datasets[n].getYValues();
        if (bl) {
            n3 = this.datasets[n].gc.image.getWidth(null);
            n2 = this.datasets[n].gc.image.getHeight(null);
        } else {
            n3 = 8;
            n2 = 8;
        }
        int n4 = 0;
        while (n4 < dArray2.length) {
            if (bl) {
                this.datasets[n].gc.drawImage(graphics, this.dataXfm.point(dArray[n4], dArray2[n4]));
            }
            if (this.useDisplayList && this.globals.useDisplayList) {
                Point point = this.dataXfm.point(dArray[n4], dArray2[n4]);
                point.translate(n3 / 2, n2 / 2);
                Point point2 = new Point(point.x - n3, point.y - n2);
                this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n4), point2, point);
                this.globals.displayList.addRectangle(this.datasets[n], point2, point);
                this.globals.displayList.addRectangle(this, point2, point);
            }
            ++n4;
        }
    }

    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.doLines(graphics, this.scatterPlot);
    }

    synchronized void drawSet(Graphics graphics, int n, boolean bl) {
        this.buildDataXfm();
        this.numDatasets = 1;
        if (this.doClip) {
            Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
            Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
            graphics.clipRect(point.x, this.globals.maxY - point2.y, point2.x - point.x, point2.y - point.y);
        }
        if (bl) {
            this.doMarkers(graphics, n);
        } else {
            this.doLine(graphics, n);
            this.doMarkers(graphics, n);
        }
        if (this.labelsOn) {
            this.doLabels(graphics);
        }
        if (this.doClip) {
            graphics.clipRect(0, 0, this.globals.maxX, this.globals.maxY);
        }
    }

    public boolean getClip() {
        return this.doClip;
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public Plotarea getPlotarea() {
        return this.plotarea;
    }

    public boolean isScatterPlot() {
        return this.scatterPlot;
    }

    public void setClip(boolean bl) {
        this.doClip = bl;
    }

    public void setScatterPlot(boolean bl) {
        this.scatterPlot = bl;
    }
}

