/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Globals;
import javachart.chart.Plotarea;

public abstract class DataRepresentation
implements Serializable {
    protected Plotarea plotarea;
    protected Globals globals;
    protected AxisInterface xAxis;
    protected AxisInterface yAxis;
    protected Dataset[] datasets;
    protected boolean useDisplayList = true;
    protected int labelAngle = 0;
    protected int labelFormat = 1;
    protected boolean labelsOn = false;
    protected int labelPrecision = 2;
    protected Format userFormat = null;
    NumberFormat numberFormat = NumberFormat.getInstance();

    public abstract void draw(Graphics var1);

    protected String formatLabel(double d) {
        if (this.userFormat != null) {
            return this.userFormat.format(new Double(d));
        }
        return this.numberFormat.format(d);
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public Format getFormat() {
        return this.userFormat;
    }

    public int getLabelAngle() {
        return this.labelAngle;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public boolean getLabelsOn() {
        return this.labelsOn;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    public void setDatasets(Dataset[] datasetArray) {
        this.datasets = datasetArray;
        if (this.globals == null) {
            return;
        }
        int n = 0;
        while (n < datasetArray.length) {
            if (datasetArray[n] != null && datasetArray[n].globals != this.globals) {
                datasetArray[n].setGlobals(this.globals);
            }
            ++n;
        }
    }

    public void setFormat(Format format) {
        this.userFormat = format;
    }

    public void setGlobals(Globals globals) {
        if (globals == null) {
            return;
        }
        this.globals = globals;
        this.xAxis.setGlobals(globals);
        this.yAxis.setGlobals(globals);
        this.plotarea.globals = globals;
        if (this.datasets != null) {
            int n = 0;
            while (n < this.datasets.length) {
                if (this.datasets[n] != null && this.datasets[n].globals != globals) {
                    this.datasets[n].setGlobals(globals);
                }
                ++n;
            }
        }
    }

    public void setLabelAngle(int n) {
        this.labelAngle = n;
    }

    public void setLabelFormat(int n) {
        if (n == 2) {
            this.numberFormat = NumberFormat.getNumberInstance(Locale.FRANCE);
        }
        if (n == 1) {
            this.numberFormat = NumberFormat.getNumberInstance(Locale.US);
        }
        if (n == 0) {
            this.numberFormat = NumberFormat.getNumberInstance();
        }
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
        if (this.userFormat != null && this.userFormat instanceof NumberFormat) {
            ((NumberFormat)this.userFormat).setMinimumFractionDigits(n);
            ((NumberFormat)this.userFormat).setMaximumFractionDigits(n);
        }
        if (n != -1) {
            this.numberFormat.setMinimumFractionDigits(n);
            this.numberFormat.setMaximumFractionDigits(n);
        } else {
            this.numberFormat = NumberFormat.getInstance();
        }
    }

    public void setLabelsOn(boolean bl) {
        this.labelsOn = bl;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public void setXAxis(AxisInterface axisInterface) {
        axisInterface.setGlobals(this.globals);
        axisInterface.setPlotarea(this.plotarea);
        axisInterface.setDatasets(this.datasets);
        axisInterface.setIsXAxis(true);
        this.xAxis = axisInterface;
    }

    public void setYAxis(AxisInterface axisInterface) {
        axisInterface.setGlobals(this.globals);
        axisInterface.setPlotarea(this.plotarea);
        axisInterface.setDatasets(this.datasets);
        axisInterface.setIsXAxis(false);
        this.yAxis = axisInterface;
    }
}

