/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import java.text.DateFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;

public class DateAxis
extends Axis
implements AxisInterface {
    Date startDate = new Date(0L);
    Date endDate = new Date(0L);
    Date tmpDate = new Date(0L);
    protected Calendar calendar = Calendar.getInstance();
    private Calendar tmpCalendar = (Calendar)this.calendar.clone();
    protected DateFormat dateFormat = null;
    protected DateFormat userDateFormat = null;
    protected DateFormat secondaryUserDateFormat = null;
    protected Integer userScalingType = null;
    long stepSize;
    int scalingType = 4;
    public static final int SECOND_SCALING = 1;
    public static final int MINUTE_SCALING = 2;
    public static final int HOUR_SCALING = 3;
    public static final int DAY_SCALING = 4;
    public static final int WEEK_SCALING = 5;
    public static final int MONTH_SCALING = 6;
    public static final int YEAR_SCALING = 7;
    static final long oneMinute = 60000L;
    static final long oneHour = 3600000L;
    static final long oneDay = 86400000L;
    static final long oneWeek = 604800000L;
    static final long oneMonth = 2592000000L;
    static final long oneYear = 31536000000L;

    public DateAxis() {
    }

    public DateAxis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        super(datasetArray, bl, plotarea);
    }

    protected void doDayScale() {
        this.calendar.setTime(this.endDate);
        long l = this.calendar.getTime().getTime();
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        long l2 = this.calendar.getTime().getTime();
        if (l - l2 > 0L) {
            this.calendar.add(5, 1);
        }
        this.endDate = this.calendar.getTime();
        this.calendar.setTime(this.startDate);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.startDate = this.calendar.getTime();
        int n = this.getDayIncrement(this.startDate, this.endDate);
        this.calendar.setTime(this.startDate);
        this.startDate = this.calendar.getTime();
        int n2 = 0;
        this.tmpDate = this.calendar.getTime();
        while (this.tmpDate.before(this.endDate)) {
            this.calendar.add(5, 1);
            this.tmpDate = this.calendar.getTime();
            ++n2;
        }
        this.calendar.setTime(this.endDate);
        while (n2 % n != 0) {
            this.calendar.add(5, 1);
            ++n2;
        }
        this.endDate = this.calendar.getTime();
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.stepSize = n;
        this.numLabels = n2 / n;
    }

    protected void doHourScale() {
        Calendar calendar = this.tmpCalendar;
        calendar.setTime(this.endDate);
        int n = calendar.get(12);
        if (n > 0) {
            calendar.set(11, calendar.get(11) + 1);
            calendar.set(12, calendar.getMinimum(12));
            calendar.set(13, calendar.getMinimum(13));
            calendar.set(14, calendar.getMinimum(14));
            this.endDate = calendar.getTime();
        }
        this.calendar.setTime(this.startDate);
        this.calendar.set(12, 0);
        this.calendar.set(13, this.calendar.getMinimum(13));
        this.calendar.set(14, this.calendar.getMinimum(14));
        this.startDate = this.calendar.getTime();
        int n2 = 0;
        long l = this.startDate.getTime();
        while (l < calendar.getTime().getTime()) {
            ++n2;
            l += 3600000L;
        }
        int n3 = this.getHourIncrement(n2);
        this.calendar.setTime(this.startDate);
        n = this.calendar.get(11);
        l = this.startDate.getTime();
        while (n % n3 != 0) {
            this.startDate.setTime(l -= 3600000L);
            this.calendar.setTime(this.startDate);
            n = this.calendar.get(11);
            ++n2;
        }
        n = calendar.get(11);
        l = this.endDate.getTime();
        while (n % n3 != 0) {
            this.endDate.setTime(l += 3600000L);
            calendar.setTime(this.endDate);
            n = calendar.get(11);
            ++n2;
        }
        this.endDate.setTime(l);
        this.stepSize = n3;
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.numLabels = n2 / n3;
        this.tmpDate.setTime(this.startDate.getTime() + (long)(3600000 * n2));
        this.calendar.setTime(this.startDate);
        this.calendar.add(10, n2);
        if (this.calendar.getTime().getTime() < this.tmpDate.getTime()) {
            ++this.numLabels;
        }
    }

    protected void doMinuteScale() {
        int n = this.getSpan(12, this.startDate, this.endDate);
        int n2 = this.getMinuteIncrement(n);
        Calendar calendar = this.tmpCalendar;
        Calendar calendar2 = this.calendar;
        calendar2.setTime(this.startDate);
        int n3 = calendar2.get(12);
        while (n3 % n2 != 0) {
            --n3;
            calendar2.add(12, -1);
            ++n;
        }
        calendar.setTime(this.endDate);
        n3 = calendar.get(12);
        while (n3 % n2 != 0) {
            ++n3;
            calendar.add(12, 1);
            ++n;
        }
        this.startDate = calendar2.getTime();
        this.endDate = calendar.getTime();
        this.stepSize = n2;
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.numLabels = n / n2;
    }

    protected void doMonthScale() {
        this.calendar.setTime(this.endDate);
        if (this.calendar.get(5) > 1) {
            this.calendar.set(2, this.calendar.get(2) + 1);
        }
        this.calendar.set(5, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.endDate = this.calendar.getTime();
        this.calendar.setTime(this.startDate);
        this.calendar.set(5, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.startDate = this.calendar.getTime();
        int n = this.getSpan(2, this.startDate, this.endDate);
        int n2 = n / 5;
        if (n2 == 0) {
            n2 = 1;
        }
        this.tmpCalendar.setTime(this.endDate);
        while (n % n2 != 0) {
            ++n;
            this.tmpCalendar.add(2, 1);
        }
        this.endDate = this.tmpCalendar.getTime();
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.stepSize = n2;
        this.numLabels = n / (int)this.stepSize;
    }

    protected void doSecondScale() {
        long l;
        long l2;
        long l3 = this.endDate.getTime();
        long l4 = l3 - (l2 = this.startDate.getTime());
        long l5 = this.getMagnitude(l4);
        if (l5 < 0L) {
            l = this.getMsIncrement(l4, l5);
            while (l2 % l != 0L) {
                --l2;
            }
            while (l3 % l != 0L) {
                ++l3;
            }
        } else {
            l = this.getSIncrement(l4 / 1000L, l5);
            this.calendar.setTime(this.startDate);
            this.calendar.set(14, 0);
            int n = this.calendar.get(13);
            while ((long)n % l != 0L) {
                this.calendar.add(13, -1);
                --n;
            }
            this.startDate = this.calendar.getTime();
            this.calendar.setTime(this.endDate);
            if (this.calendar.get(14) > 0) {
                this.calendar.add(13, 1);
                this.calendar.set(14, 0);
            }
            n = this.calendar.get(13);
            while ((long)n % l != 0L) {
                this.calendar.add(13, 1);
                ++n;
            }
            this.endDate = this.calendar.getTime();
            l2 = this.startDate.getTime();
            l3 = this.endDate.getTime();
            l *= 1000L;
        }
        this.stepSize = l;
        this.axisStart = l2;
        this.axisEnd = l3;
        this.numLabels = (int)((this.axisEnd - this.axisStart) / (double)this.stepSize);
    }

    protected void doWeekScale() {
        Calendar calendar = this.tmpCalendar;
        calendar.setTime(this.endDate);
        int n = calendar.get(10);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.calendar.set(14, 0);
        if (n > 0) {
            calendar.add(5, 1);
        }
        this.calendar.setTime(this.startDate);
        this.calendar.set(10, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        n = this.calendar.getMinimum(7);
        while (this.calendar.get(7) != n) {
            this.calendar.add(7, -1);
        }
        this.startDate = this.calendar.getTime();
        n = this.calendar.get(7);
        while (calendar.get(7) != n) {
            calendar.add(5, 1);
        }
        this.endDate = calendar.getTime();
        int n2 = this.getSpan(5, this.startDate, this.endDate);
        this.stepSize = this.getWIncrement(n2 /= this.calendar.getMaximum(7));
        calendar.setTime(this.endDate);
        while ((long)n2 % this.stepSize != 0L) {
            calendar.add(5, 7);
            ++n2;
        }
        this.endDate = calendar.getTime();
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.numLabels = n2 / (int)this.stepSize;
    }

    protected void doYearScale() {
        this.calendar.setTime(this.endDate);
        if (this.calendar.get(2) > 0) {
            this.calendar.set(1, this.calendar.get(1) + 1);
        }
        this.calendar.set(2, 0);
        this.calendar.set(5, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.endDate = this.calendar.getTime();
        this.calendar.setTime(this.startDate);
        this.calendar.set(2, 0);
        this.calendar.set(5, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.startDate = this.calendar.getTime();
        int n = this.getSpan(1, this.startDate, this.endDate);
        int n2 = n / 5;
        Calendar calendar = this.tmpCalendar;
        calendar.setTime(this.endDate);
        if (n2 == 0) {
            n2 = 1;
        }
        while (n % n2 != 0) {
            ++n;
            calendar.add(1, 1);
        }
        this.axisStart = this.startDate.getTime();
        this.axisEnd = calendar.getTime().getTime();
        this.stepSize = n2;
        this.numLabels = n / n2;
    }

    public synchronized void draw(Graphics graphics) {
        if (this.userDateFormat != null) {
            this.dateFormat = this.userDateFormat;
        }
        if (this.autoScale) {
            this.scale();
        } else {
            this.stepSize = -1L;
        }
        if (this.lineVis) {
            this.drawLine(graphics);
        }
        this.drawTicks(graphics);
        if (!this.autoScale) {
            this.stepSize = -1L;
        }
        if (this.gridVis) {
            if (!this.globals.threeD) {
                this.drawGrids(graphics);
            } else {
                this.draw3Dgrids(graphics);
            }
        }
        if (!this.autoScale) {
            this.stepSize = -1L;
        }
        if (this.labelVis) {
            this.drawLabels(graphics);
        }
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.buildDisplayList();
        }
        this.dateFormat = null;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    protected int getDayIncrement(Date date, Date date2) {
        int n = 0;
        this.calendar.setTime(date);
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTime(date2);
        while (this.calendar.before(calendar)) {
            this.calendar.add(5, 1);
            ++n;
        }
        if (n <= 7) {
            return 1;
        }
        if (n <= 14) {
            return 2;
        }
        if (n <= 28) {
            return 3;
        }
        int n2 = n / 5;
        while (n2 % this.calendar.getMaximum(7) > 0) {
            ++n2;
        }
        return n2;
    }

    protected String getDayLabel(int n) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateInstance(3);
        }
        this.tmpDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.tmpDate);
        this.calendar.add(5, (int)((long)n * this.stepSize));
        this.tmpDate = this.calendar.getTime();
        return this.dateFormat.format(this.tmpDate);
    }

    /*
     * Unable to fully structure code
     */
    int getHourIncrement(int var1_1) {
        if (var1_1 <= 3) {
            return 1;
        }
        var2_2 = var1_1 / 5;
        if (var2_2 <= 1) {
            return 2;
        }
        if (var2_2 > 3) ** GOTO lbl9
        return 3;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl9:
            // 2 sources

            ** while (var2_2 % 6 > 0)
        }
lbl10:
        // 1 sources

        return var2_2;
    }

    protected String getHourLabel(int n) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getTimeInstance(3);
        }
        this.tmpDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.tmpDate);
        this.calendar.add(10, (int)((long)n * this.stepSize));
        this.tmpDate = this.calendar.getTime();
        if (this.calendar.get(11) == 0) {
            if (this.secondaryUserDateFormat == null) {
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                return dateFormat.format(this.tmpDate);
            }
            return this.secondaryUserDateFormat.format(this.tmpDate);
        }
        return this.dateFormat.format(this.tmpDate);
    }

    protected String getLabel(double d, int n) {
        if (this.barScaling && (n == 0 || n == this.numLabels - 1)) {
            return " ";
        }
        switch (this.scalingType) {
            case 1: {
                return this.getSecondLabel(n);
            }
            case 2: {
                return this.getMinuteLabel(n);
            }
            case 3: {
                return this.getHourLabel(n);
            }
            case 4: {
                return this.getDayLabel(n);
            }
            case 5: {
                return this.getWeekLabel(n);
            }
            case 6: {
                return this.getMonthLabel(n);
            }
            case 7: {
                return this.getYearLabel(n);
            }
        }
        return "bad";
    }

    public Format getLabelFormat() {
        return this.userDateFormat;
    }

    long getMagnitude(long l) {
        if (l > 2000L) {
            long l2 = 15000L;
            int n = 1;
            while (true) {
                if (l2 > l) {
                    return n - 1;
                }
                l2 += 15000L;
                ++n;
            }
        }
        if (l < 10L) {
            return -1L;
        }
        if (l < 100L) {
            return -2L;
        }
        return -3L;
    }

    protected double getMaxValsFromData(int n) {
        if (this.barScaling) {
            return super.getMaxValsFromData(n) + 1.0;
        }
        return super.getMaxValsFromData(n);
    }

    /*
     * Unable to fully structure code
     */
    int getMinuteIncrement(int var1_1) {
        block5: {
            block4: {
                if (var1_1 <= 5) {
                    return 1;
                }
                var2_2 = var1_1 / 4;
                if (var2_2 > 5) break block4;
                while (var2_2 % 2 > 0) {
                    ++var2_2;
                }
                break block5;
            }
            if (var2_2 > 5) ** GOTO lbl16
            while (var2_2 % 5 > 0) {
                ++var2_2;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ++var2_2;
lbl16:
                // 2 sources

                ** while (var2_2 % 15 > 0)
            }
        }
        return var2_2;
    }

    protected String getMinuteLabel(int n) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getTimeInstance(3);
        }
        this.tmpDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.tmpDate);
        this.calendar.add(12, (int)((long)n * this.stepSize));
        if (this.calendar.get(12) == 0 && this.calendar.get(10) == 0) {
            if (this.secondaryUserDateFormat == null) {
                DateFormat dateFormat = DateFormat.getDateInstance(2);
                this.tmpDate = this.calendar.getTime();
                return dateFormat.format(this.tmpDate);
            }
            return this.secondaryUserDateFormat.format(this.tmpDate);
        }
        this.tmpDate = this.calendar.getTime();
        return this.dateFormat.format(this.tmpDate);
    }

    protected double getMinValsFromData(int n) {
        if (this.barScaling) {
            return super.getMinValsFromData(n) - 10.0;
        }
        return super.getMinValsFromData(n);
    }

    protected String getMonthLabel(int n) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateInstance(3);
        }
        this.tmpDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.tmpDate);
        this.calendar.add(2, (int)((long)n * this.stepSize));
        this.tmpDate = this.calendar.getTime();
        if (this.calendar.get(2) == this.calendar.getMinimum(2)) {
            if (this.secondaryUserDateFormat == null) {
                DateFormat dateFormat = DateFormat.getDateInstance(2);
                this.tmpDate = this.calendar.getTime();
                return dateFormat.format(this.tmpDate);
            }
            return this.secondaryUserDateFormat.format(this.tmpDate);
        }
        return this.dateFormat.format(this.tmpDate);
    }

    long getMsIncrement(long l, long l2) {
        double d = l2 == -1L ? 1.0 : (l2 == -2L ? 10.0 : 100.0);
        double d2 = (double)l / (5.0 * d);
        double d3 = d2 > 0.0 && d2 < 0.5 ? d * 0.5 : (d2 > 0.5 && d2 < 1.0 ? d : (d2 > 1.0 && d2 < 9.0 ? d * 2.0 : d));
        return (long)d3;
    }

    long getPosition(int n, int n2) {
        this.startDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.startDate);
        this.calendar.add(n2, (int)((long)n * this.stepSize));
        return this.calendar.getTime().getTime();
    }

    public int getScalingType() {
        return this.scalingType;
    }

    protected String getSecondLabel(int n) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getTimeInstance();
        }
        this.tmpDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.tmpDate);
        this.calendar.add(14, (int)((long)n * this.stepSize));
        this.tmpDate = this.calendar.getTime();
        if (this.calendar.get(14) == 0 && this.calendar.get(13) == 0 && this.calendar.get(12) == 0 && this.calendar.get(10) == 0) {
            if (this.secondaryUserDateFormat == null) {
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                return dateFormat.format(this.tmpDate);
            }
            return this.secondaryUserDateFormat.format(this.tmpDate);
        }
        return this.dateFormat.format(this.tmpDate);
    }

    /*
     * Unable to fully structure code
     */
    long getSIncrement(long var1_1, long var3_2) {
        block5: {
            block4: {
                if (var1_1 <= 5L) {
                    return 1L;
                }
                var5_3 = var1_1 / 4L;
                if (var5_3 > 5L) break block4;
                while (var5_3 % 2L > 0L) {
                    ++var5_3;
                }
                break block5;
            }
            if (var5_3 > 20L) ** GOTO lbl16
            while (var5_3 % 10L > 0L) {
                ++var5_3;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ++var5_3;
lbl16:
                // 2 sources

                ** while (var5_3 % 30L > 0L)
            }
        }
        return var5_3;
    }

    private int getSpan(int n, Date date, Date date2) {
        Calendar calendar = this.calendar;
        Calendar calendar2 = this.tmpCalendar;
        calendar.setTime(date);
        calendar2.setTime(date2);
        int n2 = 0;
        while (calendar.before(calendar2)) {
            calendar.add(n, 1);
            ++n2;
        }
        return n2;
    }

    protected String getWeekLabel(int n) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateInstance(3);
        }
        this.tmpDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.tmpDate);
        this.calendar.add(3, (int)((long)n * this.stepSize));
        this.tmpDate = this.calendar.getTime();
        return this.dateFormat.format(this.tmpDate);
    }

    long getWIncrement(long l) {
        if (l <= 1L) {
            return 1L;
        }
        if (l <= 2L) {
            return 2L;
        }
        if (l <= 4L) {
            return 3L;
        }
        return l / 5L;
    }

    protected String getYearLabel(int n) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateInstance(3);
        }
        this.tmpDate.setTime((long)this.axisStart);
        this.calendar.setTime(this.tmpDate);
        this.calendar.add(1, (int)((long)n * this.stepSize));
        this.tmpDate = this.calendar.getTime();
        return this.dateFormat.format(this.tmpDate);
    }

    public synchronized void scale() {
        int n = this.datasetsInUse();
        if (n == 0 && (this.userAxisStart == null || this.userAxisEnd == null)) {
            return;
        }
        long l = (long)this.getMaxValsFromData(n);
        long l2 = (long)this.getMinValsFromData(n);
        long l3 = l - l2;
        this.startDate.setTime(l2);
        this.endDate.setTime(l);
        if (this.userScalingType != null) {
            this.scalingType = this.userScalingType;
            switch (this.scalingType) {
                case 1: {
                    this.doSecondScale();
                    break;
                }
                case 2: {
                    this.doMinuteScale();
                    break;
                }
                case 3: {
                    this.doHourScale();
                    break;
                }
                case 4: {
                    this.doDayScale();
                    break;
                }
                case 5: {
                    this.doWeekScale();
                    break;
                }
                case 6: {
                    this.doMonthScale();
                    break;
                }
                case 7: {
                    this.doYearScale();
                }
            }
        } else {
            if (l3 < 0L) {
                System.out.println("doesn't work with reverse scales");
                return;
            }
            if (l3 < 180000L) {
                this.doSecondScale();
                this.scalingType = 1;
            } else if (l3 < 14400000L) {
                this.doMinuteScale();
                this.scalingType = 2;
            } else if (l3 < 172800000L) {
                this.doHourScale();
                this.scalingType = 3;
            } else if (l3 < 2419200000L) {
                this.doDayScale();
                this.scalingType = 4;
            } else if (l3 < 10368000000L) {
                this.doWeekScale();
                this.scalingType = 5;
            } else if (l3 < 126144000000L) {
                this.doMonthScale();
                this.scalingType = 6;
            } else {
                this.doYearScale();
                this.scalingType = 7;
            }
        }
        this.numMajTicks = this.numLabels;
        this.numGrids = this.numLabels;
        this.numMinTicks = 2 * this.numLabels;
        if (this.barScaling) {
            ++this.numLabels;
        }
    }

    public void setAxisEnd(double d) {
        super.setAxisEnd(d);
        this.endDate.setTime((long)d);
    }

    public void setAxisStart(double d) {
        super.setAxisStart(d);
        this.startDate.setTime((long)d);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.tmpCalendar = (Calendar)calendar.clone();
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.userDateFormat = dateFormat;
    }

    public void setLabelFormat(Format format) {
        if (format instanceof DateFormat) {
            this.userDateFormat = (DateFormat)format;
        } else {
            super.setLabelFormat(format);
        }
    }

    public void setLogScaling(boolean bl) {
    }

    public void setScalingType(int n) {
        if (n == -1) {
            this.userScalingType = null;
            return;
        }
        this.userScalingType = new Integer(n);
        this.scalingType = n;
    }

    public void setSecondaryDateFormat(DateFormat dateFormat) {
        this.secondaryUserDateFormat = dateFormat;
    }

    /*
     * Unable to fully structure code
     */
    protected int whereOnAxis(int var1_1, int var2_2) {
        block43: {
            block44: {
                var3_3 = 0.0;
                if (this.autoScale || this.stepSize != -1L) break block43;
                if (this.scalingType == 7) {
                    this.stepSize = this.getSpan(1, this.startDate, this.endDate);
                } else if (this.scalingType == 6) {
                    this.stepSize = this.getSpan(2, this.startDate, this.endDate);
                } else if (this.scalingType == 5) {
                    this.stepSize = this.getSpan(5, this.startDate, this.endDate);
                    this.stepSize /= (long)this.calendar.getMaximum(7);
                } else if (this.scalingType == 4) {
                    this.stepSize = this.getSpan(5, this.startDate, this.endDate);
                } else if (this.scalingType == 3) {
                    var7_4 = 0;
                    var8_5 = this.startDate.getTime();
                    while (var8_5 < this.endDate.getTime()) {
                        ++var7_4;
                        var8_5 += 3600000L;
                    }
                    this.stepSize = var7_4;
                } else {
                    this.stepSize = this.scalingType == 2 ? (long)this.getSpan(12, this.startDate, this.endDate) : (long)(this.axisEnd - this.axisStart);
                }
                if (this.scalingType == 1) break block44;
                switch (var2_2) {
                    case 2: {
                        if (this.stepSize <= (long)this.numGrids) ** GOTO lbl35
                        while (this.stepSize % (long)this.numGrids != 0L) {
                            ++this.numGrids;
                        }
                        break;
lbl-1000:
                        // 1 sources

                        {
                            --this.numGrids;
lbl35:
                            // 2 sources

                            ** while (this.stepSize % (long)this.numGrids != 0L)
                        }
lbl36:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        if (this.stepSize <= (long)this.numLabels) ** GOTO lbl44
                        while (this.stepSize % (long)this.numLabels != 0L) {
                            ++this.numLabels;
                        }
                        break;
lbl-1000:
                        // 1 sources

                        {
                            --this.numLabels;
lbl44:
                            // 2 sources

                            ** while (this.stepSize % (long)this.numLabels != 0L)
                        }
lbl45:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        if (this.stepSize <= (long)this.numMajTicks) ** GOTO lbl53
                        while (this.stepSize % (long)this.numMajTicks != 0L) {
                            ++this.numMajTicks;
                        }
                        break;
lbl-1000:
                        // 1 sources

                        {
                            --this.numMajTicks;
lbl53:
                            // 2 sources

                            ** while (this.stepSize % (long)this.numMajTicks != 0L)
                        }
lbl54:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        if (this.stepSize <= (long)this.numMinTicks) ** GOTO lbl62
                        while (this.stepSize % (long)this.numMinTicks != 0L) {
                            ++this.numMinTicks;
                        }
                        break;
lbl-1000:
                        // 1 sources

                        {
                            --this.numMinTicks;
lbl62:
                            // 2 sources

                            ** while (this.stepSize % (long)this.numMinTicks != 0L)
                        }
                    }
                }
            }
            switch (var2_2) {
                case 2: {
                    this.stepSize /= (long)this.numGrids;
                    break;
                }
                case 1: {
                    this.stepSize /= (long)this.numLabels;
                    break;
                }
                case 4: {
                    this.stepSize /= (long)this.numMajTicks;
                    break;
                }
                case 3: {
                    this.stepSize /= (long)this.numMinTicks;
                }
            }
            if (this.stepSize == 0L) {
                this.stepSize = 1L;
            }
        }
        if (this.scalingType == 1) {
            if (this.side == 0 || this.side == 2) {
                return this.startPoint.x + (int)(this.increment * (float)var1_1);
            }
            return this.startPoint.y + (int)(this.increment * (float)var1_1);
        }
        switch (this.scalingType) {
            case 7: {
                var3_3 = (double)this.getPosition(var1_1, 1) - this.axisStart;
                break;
            }
            case 6: {
                var3_3 = (double)this.getPosition(var1_1, 2) - this.axisStart;
                break;
            }
            case 5: {
                var3_3 = (double)this.getPosition(var1_1 * this.calendar.getMaximum(7), 5) - this.axisStart;
                break;
            }
            case 4: {
                var3_3 = (double)this.getPosition(var1_1, 5) - this.axisStart;
                break;
            }
            case 3: {
                var3_3 = (double)this.getPosition(var1_1, 10) - this.axisStart;
                break;
            }
            case 2: {
                var3_3 = (double)this.getPosition(var1_1, 12) - this.axisStart;
            }
        }
        var5_6 = var3_3 / (this.axisEnd - this.axisStart);
        if (this.side == 0 || this.side == 2) {
            return this.startPoint.x + (int)(var5_6 * (double)(this.endPoint.x - this.startPoint.x));
        }
        return this.startPoint.y + (int)(var5_6 * (double)(this.endPoint.y - this.startPoint.y));
    }
}

