/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class BreakableGlassPane
extends JComponent
implements MouseInputListener {
    protected Component contentBelowGlassPane;
    protected Vector breaks;
    protected boolean ignoreBreaks;
    protected boolean mouseInDrag = false;
    protected Component dragComponent = null;

    public BreakableGlassPane(RootPaneContainer rootPaneContainer) {
        this.contentBelowGlassPane = rootPaneContainer.getLayeredPane();
        this.breaks = new Vector();
        this.ignoreBreaks = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addBreak(Component component) {
        if (this.breaks.contains(component)) {
            return;
        }
        this.breaks.addElement(component);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component = this.redispatchMouseEvent(mouseEvent);
        if (component != null) {
            this.mouseInDrag = true;
            this.dragComponent = component;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.redispatchMouseEvent(mouseEvent) == null && !this.mouseInDrag) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.mouseInDrag = false;
            this.dragComponent = null;
        }
    }

    protected Component redispatchMouseEvent(MouseEvent mouseEvent) {
        if (this.ignoreBreaks) {
            return null;
        }
        Component component = (Component)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        Component component2 = null;
        boolean bl = false;
        if (this.mouseInDrag) {
            component2 = this.dragComponent;
        } else {
            int n = this.breaks.size();
            int n2 = 0;
            while (n2 < n) {
                Point point2;
                Component component3 = (Component)this.breaks.elementAt(n2);
                if (component3.contains(point2 = SwingUtilities.convertPoint(component, point, component3))) {
                    bl = true;
                    component2 = SwingUtilities.getDeepestComponentAt(this.contentBelowGlassPane, point.x, point.y);
                    break;
                }
                ++n2;
            }
        }
        if (!bl && !this.mouseInDrag) {
            return null;
        }
        component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        return component2;
    }

    public void removeBreak(Component component) {
        this.breaks.removeElement(component);
    }

    public void setIgnoreBreaks(boolean bl) {
        if (this.ignoreBreaks == bl) {
            return;
        }
        this.ignoreBreaks = bl;
        if (this.ignoreBreaks) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        } else {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    protected void testForDrag(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.mouseInDrag = true;
        }
    }
}

