/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class STP_JDialog
extends CommonConfig_JDialog
implements ListSelectionListener,
KeyListener {
    JTabbedPane stp_JTabbedPane = null;
    JPanel vlanID_JPanel = null;
    JComboBox vlanID_JComboBox = null;
    JPanel uplinkFast_JPanel = null;
    JLabel uplinkFast_JLabel = null;
    JLabel maxUpdate_JLabel = null;
    JComboBox uplinkFast_JComboBox = null;
    JTextField uplinkFast_JTextField = null;
    boolean switchUplinkFastStatus = false;
    boolean switchCrossStackUFStatus = false;
    String userUplinkFastRate = null;
    String switchUplinkFastRate = null;
    JButton ok_JButton;
    JButton modify_JButton;
    JButton apply_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    TabbedPaneElement statusPane = null;
    TabbedPaneElement currentRootsPane = null;
    TabbedPaneElement rootParamsPane = null;
    TabbedPaneElement portParamsPane = null;
    TabbedPaneElement uplinkFastPane = null;
    String[] vlanIDs = null;
    boolean[] stpEnabled = null;
    ChangeEvent editingStoppedEvent = new ChangeEvent(this);
    Vector selectedIDs = null;
    Vector selectedDevices = null;
    boolean initializationComplete = false;
    DefaultComboBoxModel vlanComboBoxModel = null;
    String selectedVLAN = null;
    String lastVLANID = null;
    boolean changingVLANComboBox = false;
    Vector models;
    Vector vlanSTPChanged = new Vector();
    CollectData collectData = null;
    boolean dataGathering = false;
    boolean abortThreads = false;
    Thread mainCollectDataThread = null;
    Vector collectionThreads = null;

    public STP_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        super(frame, jApplet, commonSwitchArray, "Spanning Tree Protocol", 513, 305);
        this.buildDialog();
    }

    public STP_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame, jApplet, commonSwitchArray, commonSwitch, "Spanning Tree Protocol", 513, 305);
        this.buildDialog();
    }

    public STP_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray);
    }

    public STP_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    void STPJDialog_componentHidden(ComponentEvent componentEvent) {
    }

    void STPJDialog_mouseMoved(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        this.setCursor(new Cursor(3));
        this.statusPane.getTable().editingStopped(this.editingStoppedEvent);
        this.currentRootsPane.getTable().editingStopped(this.editingStoppedEvent);
        this.rootParamsPane.getTable().editingStopped(this.editingStoppedEvent);
        this.portParamsPane.getTable().editingStopped(this.editingStoppedEvent);
        if (this.isUplinkFastSupported()) {
            this.uplinkFastPane.getTable().editingStopped(this.editingStoppedEvent);
        }
        if ((object = actionEvent.getSource()) == this.devices_JCombo) {
            this.cancelAllThreads();
            this.setSelectedSwitch(this.devices_JCombo);
            this.setDefaultData();
            if (this.isUplinkFastSupported()) {
                if (this.uplinkFast_JPanel == null) {
                    this.buildUplinkFast();
                }
            } else if (this.uplinkFast_JPanel != null) {
                this.uplinkFast_JComboBox.removeActionListener(this);
                this.stp_JTabbedPane.remove(this.uplinkFastPane.getPanel());
                this.uplinkFast_JPanel = null;
            }
            this.flagInitializationInProgress();
            this.mainCollectDataThread = new ControllableThread(this.collectData);
            this.mainCollectDataThread.start();
        } else if (object == this.uplinkFast_JComboBox) {
            int n = this.uplinkFast_JComboBox.getSelectedIndex();
            if (n == 0) {
                this.maxUpdate_JLabel.setEnabled(true);
                this.uplinkFast_JTextField.setEnabled(true);
            } else if (n == 1) {
                this.maxUpdate_JLabel.setEnabled(false);
                this.uplinkFast_JTextField.setEnabled(false);
            }
            this.apply_JButton.setEnabled(true);
        } else if (object == this.uplinkFast_JTextField) {
            this.apply_JButton.setEnabled(true);
        } else if (object == this.vlanID_JComboBox) {
            int n = this.vlanID_JComboBox.getSelectedIndex();
            if (n == -1) {
                n = 0;
            }
            if (!this.changingVLANComboBox && this.vlanComboBoxModel.getSize() > n) {
                this.selectedVLAN = (String)this.vlanComboBoxModel.getElementAt(n);
                if (this.lastVLANID == null || this.selectedVLAN != null && this.selectedVLAN.compareTo(this.lastVLANID) != 0) {
                    Vector vector = ((STP_CustomModel)this.portParamsPane.getTable().getModel()).whatChangesOccurred();
                    ((Boolean)vector.elementAt(0)).booleanValue();
                    ((STP_CustomModel)this.portParamsPane.getModel()).gatherDataFromDevice(this.switchID, this.vlanIDs, this.stpEnabled, this.selectedVLAN);
                    this.lastVLANID = this.selectedVLAN;
                }
            }
        } else if (object == this.apply_JButton) {
            Vector vector = ((STP_CustomModel)this.statusPane.getTable().getModel()).whatChangesOccurred();
            boolean bl = (Boolean)vector.elementAt(0);
            this.applyChanges();
            if (bl) {
                boolean[][] blArray = (boolean[][])vector.elementAt(1);
                int n = 0;
                while (n < blArray.length) {
                    blArray[n][1] = true;
                    this.vlanSTPChanged.addElement(this.vlanIDs[n]);
                    ++n;
                }
                this.spanningTreeChanged();
            }
            this.apply_JButton.setEnabled(false);
        } else if (object == this.ok_JButton) {
            if (this.applyChanges()) {
                this.setCursor(new Cursor(0));
                this.dispose();
            }
        } else if (object == this.cancel_JButton) {
            this.cancelAllThreads();
            this.dataGathering = false;
            this.setCursor(new Cursor(0));
            this.dispose();
        } else if (object == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"stpdg");
        } else if (object == this.modify_JButton) {
            int[] nArray;
            int n = this.stp_JTabbedPane.getSelectedIndex();
            if (n == -1) {
                n = 0;
            }
            this.selectedIDs = new Vector();
            this.selectedDevices = new Vector();
            if (n == 0) {
                int[] nArray2 = this.statusPane.getTable().getSelectedRows();
                if (nArray2.length > 0) {
                    int n2 = 0;
                    while (n2 < nArray2.length) {
                        this.selectedIDs.addElement(this.vlanIDs[nArray2[n2]]);
                        this.selectedDevices.addElement(this.switchMembers[this.switchIndex]);
                        ++n2;
                    }
                    STPProtocolConfig_JDialog sTPProtocolConfig_JDialog = new STPProtocolConfig_JDialog(this.theApplet, this, this.selectedIDs, this.selectedDevices);
                    ModalDialog.show((RootPaneContainer)this, (Dialog)sTPProtocolConfig_JDialog, null);
                }
            } else if (n == 2) {
                int[] nArray3 = this.rootParamsPane.getTable().getSelectedRows();
                if (nArray3.length > 0) {
                    int n3 = 0;
                    while (n3 < nArray3.length) {
                        this.selectedIDs.addElement(this.vlanIDs[nArray3[n3]]);
                        this.selectedDevices.addElement(this.switchMembers[this.switchIndex]);
                        ++n3;
                    }
                    STPRootConfig_JDialog sTPRootConfig_JDialog = new STPRootConfig_JDialog(this.theApplet, this, this.selectedIDs, this.selectedDevices);
                    ModalDialog.show((RootPaneContainer)this, (Dialog)sTPRootConfig_JDialog, null);
                }
            } else if (n == 3) {
                Object[][] objectArray;
                int[] nArray4 = this.portParamsPane.getTable().getSelectedRows();
                if (nArray4.length > 0 && (objectArray = ((STP_PortParametersModel)this.portParamsPane.getModel()).getRowColData()) != null) {
                    int n4 = 0;
                    while (n4 < nArray4.length) {
                        this.selectedIDs.addElement((String)objectArray[nArray4[n4]][0]);
                        this.selectedDevices.addElement(this.switchMembers[this.switchIndex]);
                        ++n4;
                    }
                    STPPortConfig_JDialog sTPPortConfig_JDialog = new STPPortConfig_JDialog(this.theApplet, this, this.selectedIDs, this.selectedDevices, this.selectedVLAN);
                    ModalDialog.show((RootPaneContainer)this, (Dialog)sTPPortConfig_JDialog, null);
                }
            } else if (n == 4 && (nArray = this.uplinkFastPane.getTable().getSelectedRows()).length > 0) {
                int n5 = 0;
                while (n5 < nArray.length) {
                    this.selectedIDs.addElement(this.uplinkFastPane.getTable().getModel().getValueAt(nArray[n5], 0));
                    this.selectedDevices.addElement(this.switchMembers[this.switchIndex]);
                    ++n5;
                }
                STPCSUFConfig_JDialog sTPCSUFConfig_JDialog = new STPCSUFConfig_JDialog(this.theApplet, this, this.selectedIDs, this.selectedDevices);
                ModalDialog.show((RootPaneContainer)this, (Dialog)sTPCSUFConfig_JDialog, null);
            }
        }
        if (!this.dataGathering) {
            this.setCursor(new Cursor(0));
        }
    }

    public void addChangedVLAN(String string) {
        this.vlanSTPChanged.addElement(string);
    }

    protected void addDetails() {
        this.vlanID_JPanel = new JPanel();
        this.vlanID_JPanel.setBorder(BorderFactory.createTitledBorder("VLAN ID"));
        this.vlanComboBoxModel = new DefaultComboBoxModel();
        this.vlanID_JComboBox = new JComboBox(this.vlanComboBoxModel);
        this.vlanID_JComboBox.addActionListener(this);
        this.vlanID_JPanel.add(this.vlanID_JComboBox);
        this.stp_JTabbedPane = new JTabbedPane();
        this.models = new Vector();
        STP_CustomModel sTP_CustomModel = null;
        sTP_CustomModel = new STP_StatusModel(this.commonCLI);
        this.models.addElement(sTP_CustomModel);
        sTP_CustomModel.addTableModelListener(this);
        this.statusPane = new TabbedPaneElement(sTP_CustomModel, new BorderLayout(), "STP Status", this.stp_JTabbedPane);
        this.statusPane.getTable().getSelectionModel().addListSelectionListener(this);
        sTP_CustomModel = new STP_CurrentRootsModel(this.commonCLI);
        this.models.addElement(sTP_CustomModel);
        sTP_CustomModel.addTableModelListener(this);
        this.currentRootsPane = new TabbedPaneElement(sTP_CustomModel, new BorderLayout(), "Current Roots", this.stp_JTabbedPane);
        this.currentRootsPane.getTable().setRowSelectionAllowed(false);
        this.currentRootsPane.getTable().setColumnSelectionAllowed(false);
        sTP_CustomModel = new STP_RootOptionsModel(this.commonCLI);
        this.models.addElement(sTP_CustomModel);
        sTP_CustomModel.addTableModelListener(this);
        this.rootParamsPane = new TabbedPaneElement(sTP_CustomModel, new BorderLayout(), "Root Parameters", this.stp_JTabbedPane);
        this.rootParamsPane.getTable().getSelectionModel().addListSelectionListener(this);
        sTP_CustomModel = new STP_PortParametersModel(this.commonCLI);
        this.models.addElement(sTP_CustomModel);
        sTP_CustomModel.addTableModelListener(this);
        this.portParamsPane = new TabbedPaneElement(sTP_CustomModel, new BorderLayout(0, 0), "Port Parameters", this.stp_JTabbedPane);
        this.portParamsPane.getPanel().add((Component)this.vlanID_JPanel, "North");
        this.portParamsPane.getTable().getSelectionModel().addListSelectionListener(this);
        if (this.isUplinkFastSupported() && this.uplinkFast_JPanel == null) {
            this.buildUplinkFast();
        }
        this.getContentPane().add(this.stp_JTabbedPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.ok_JButton = new JButton("OK");
        this.apply_JButton = new JButton("Apply");
        this.apply_JButton.setEnabled(false);
        this.modify_JButton = new JButton("Modify ...");
        this.cancel_JButton = new JButton("Cancel");
        this.help_JButton = new JButton("Help");
        jPanel.add(this.ok_JButton);
        jPanel.add(this.apply_JButton);
        jPanel.add(this.modify_JButton);
        jPanel.add(this.cancel_JButton);
        jPanel.add(this.help_JButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.modify_JButton.addActionListener(this);
        this.apply_JButton.addActionListener(this);
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        this.devices_JCombo.addActionListener(this);
        this.stp_JTabbedPane.addChangeListener(this);
        SymMouseMotion symMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(symMouseMotion);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
        this.flagInitializationInProgress();
        this.collectionThreads = new Vector();
        this.collectData = new CollectData(this.models);
        this.mainCollectDataThread = new ControllableThread(this.collectData);
        this.mainCollectDataThread.start();
    }

    public boolean applyChanges() {
        ((STP_CustomModel)this.statusPane.getTable().getModel()).apply(this.switchID, this.vlanIDs);
        ((STP_CustomModel)this.currentRootsPane.getTable().getModel()).apply(this.switchID, this.vlanIDs);
        ((STP_CustomModel)this.rootParamsPane.getTable().getModel()).apply(this.switchID, this.vlanIDs);
        ((STP_CustomModel)this.portParamsPane.getTable().getModel()).apply(this.switchID, this.vlanIDs);
        ((STP_CustomModel)this.uplinkFastPane.getTable().getModel()).apply(this.switchID, this.vlanIDs);
        if (this.uplinkFast_JPanel != null) {
            int n = this.uplinkFast_JComboBox.getSelectedIndex();
            boolean bl = false;
            if (n == 0 || n == -1) {
                bl = true;
            }
            if (bl != this.switchUplinkFastStatus) {
                this.commonCLI.setSTPUplinkFastEnabled(this.switchID, bl);
            }
            this.userUplinkFastRate = this.uplinkFast_JTextField.getText();
            this.userUplinkFastRate = this.userUplinkFastRate.trim();
            if (this.uplinkFast_JTextField.isEnabled() && this.userUplinkFastRate.compareTo("") != 0) {
                if (!this.maxUpdateRateValid(this.userUplinkFastRate)) {
                    this.rangeError("Error: STP", "Max. Update Rate", "0", "1000");
                    return false;
                }
                if (this.userUplinkFastRate.compareTo(this.switchUplinkFastRate) != 0) {
                    this.commonCLI.setSTPUplinkFastRate(this.switchID, this.userUplinkFastRate);
                }
            }
            this.getUplinkFastInfo();
            this.updateUplinkFast();
        }
        return true;
    }

    protected void buildUplinkFast() {
        STP_CrossStackUplinkfastModel sTP_CrossStackUplinkfastModel = null;
        this.uplinkFast_JPanel = new JPanel();
        this.uplinkFast_JPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.uplinkFast_JPanel.setLayout(new LabelFieldLayout(5, 5));
        this.uplinkFast_JPanel.setName("Uplinkfast");
        this.uplinkFast_JLabel = new JLabel("UplinkFast");
        this.uplinkFast_JPanel.add(this.uplinkFast_JLabel);
        this.uplinkFast_JComboBox = new JComboBox();
        this.uplinkFast_JComboBox.addItem("Enable");
        this.uplinkFast_JComboBox.addItem("Disable");
        this.uplinkFast_JComboBox.addActionListener(this);
        this.uplinkFast_JPanel.add(this.uplinkFast_JComboBox);
        this.maxUpdate_JLabel = new JLabel("Max. Update Rate (0-1000 Packets/Second):");
        this.uplinkFast_JPanel.add(this.maxUpdate_JLabel);
        this.uplinkFast_JTextField = new JTextField();
        this.uplinkFast_JTextField.setEnabled(false);
        this.uplinkFast_JTextField.addActionListener(this);
        this.uplinkFast_JTextField.addKeyListener(this);
        this.uplinkFast_JPanel.add(this.uplinkFast_JTextField);
        sTP_CrossStackUplinkfastModel = new STP_CrossStackUplinkfastModel(this.commonCLI, this.switchMembers);
        this.models.addElement(sTP_CrossStackUplinkfastModel);
        sTP_CrossStackUplinkfastModel.addTableModelListener(this);
        this.uplinkFastPane = new TabbedPaneElement(sTP_CrossStackUplinkfastModel, new BorderLayout(), "UplinkFast", this.stp_JTabbedPane);
        this.uplinkFastPane.getPanel().add((Component)this.uplinkFast_JPanel, "North");
        this.uplinkFastPane.getScrollPane().setVisible(false);
        this.uplinkFastPane.getScrollPane().setBorder(BorderFactory.createTitledBorder("Cross-Stack UplinkFast"));
        this.uplinkFastPane.getTable().getSelectionModel().addListSelectionListener(this);
        this.uplinkFastPane.getTable().setSelectionMode(0);
    }

    public void cancelAllThreads() {
        this.abortThreads = true;
        this.interruptCollectionThreads();
        this.waitForCollectionThreads();
        if (this.mainCollectDataThread != null && this.mainCollectDataThread.isAlive()) {
            try {
                this.mainCollectDataThread.interrupt();
            }
            catch (SecurityException securityException) {}
            try {
                this.mainCollectDataThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.abortThreads = false;
    }

    public boolean changesOccurred() {
        boolean bl = false;
        bl = ((STP_CustomModel)this.statusPane.getTable().getModel()).changesOccurred();
        if (!bl) {
            bl = ((STP_CustomModel)this.currentRootsPane.getTable().getModel()).changesOccurred();
        }
        if (!bl) {
            bl = ((STP_CustomModel)this.rootParamsPane.getTable().getModel()).changesOccurred();
        }
        if (!bl) {
            bl = ((STP_CustomModel)this.portParamsPane.getTable().getModel()).changesOccurred();
        }
        if (!bl) {
            bl = ((STP_CustomModel)this.uplinkFastPane.getTable().getModel()).changesOccurred();
        }
        if (!bl && this.uplinkFast_JPanel != null) {
            int n = this.uplinkFast_JComboBox.getSelectedIndex();
            boolean bl2 = false;
            if (n == 0 || n == -1) {
                bl2 = true;
            }
            if (bl2 != this.switchUplinkFastStatus) {
                bl = true;
            } else {
                this.userUplinkFastRate = this.uplinkFast_JTextField.getText();
                if (this.userUplinkFastRate.compareTo(this.switchUplinkFastRate) != 0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected void completeInitialization() {
        if (!this.dataGathering) {
            this.initializationComplete = true;
            if (this.isUplinkFastSupported()) {
                this.uplinkFast_JLabel.setEnabled(true);
                this.uplinkFast_JComboBox.setEnabled(true);
                this.updateUplinkFast();
            }
            this.ok_JButton.setEnabled(true);
            int n = this.stp_JTabbedPane.getSelectedIndex();
            this.determineModifyState();
            this.vlanID_JComboBox.setEnabled(true);
            this.getContentPane().validate();
            this.setCursor(new Cursor(0));
        }
    }

    protected void determineModifyState() {
        boolean bl = false;
        if (this.initializationComplete) {
            int n = this.stp_JTabbedPane.getSelectedIndex();
            switch (n) {
                case 0: {
                    if (this.statusPane.getTable().getSelectedRowCount() <= 0) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (this.rootParamsPane.getTable().getSelectedRowCount() <= 0) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (this.portParamsPane.getTable().getSelectedRowCount() <= 0) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (this.uplinkFastPane.getTable().getSelectedRowCount() <= 0) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                this.modify_JButton.setEnabled(false);
            } else {
                this.modify_JButton.setEnabled(true);
            }
        }
    }

    protected void flagInitializationInProgress() {
        this.setCursor(new Cursor(3));
        this.initializationComplete = false;
        if (this.isUplinkFastSupported()) {
            this.uplinkFast_JLabel.setEnabled(false);
            this.uplinkFast_JComboBox.setEnabled(false);
            this.maxUpdate_JLabel.setEnabled(false);
            this.uplinkFast_JTextField.setEnabled(false);
            this.uplinkFastPane.getScrollPane().setVisible(false);
        }
        this.ok_JButton.setEnabled(false);
        this.apply_JButton.setEnabled(false);
        this.modify_JButton.setEnabled(false);
        this.vlanID_JComboBox.setEnabled(false);
    }

    public boolean getAbortThreads() {
        return this.abortThreads;
    }

    public void getCurrentSpanningTree() {
        this.changingVLANComboBox = true;
        this.lastVLANID = null;
        this.selectedVLAN = null;
        this.stpEnabled = new boolean[this.vlanIDs.length];
        if (this.vlanComboBoxModel.getSize() > 0) {
            this.vlanComboBoxModel.removeAllElements();
        }
        if (this.vlanIDs != null) {
            String string = null;
            int n = 0;
            while (n < this.vlanIDs.length) {
                string = this.vlanIDs[n];
                if (string != null) {
                    this.stpEnabled[n] = this.commonCLI.getSpanningTreeEnabled(this.switchID, string);
                    if (this.stpEnabled[n]) {
                        this.vlanComboBoxModel.addElement(this.vlanIDs[n]);
                    }
                }
                ++n;
            }
        }
        this.selectedVLAN = this.vlanComboBoxModel.getSize() == 0 ? null : (String)this.vlanComboBoxModel.getElementAt(0);
        this.changingVLANComboBox = false;
    }

    public TabbedPaneElement getPortParamsPane() {
        return this.portParamsPane;
    }

    public TabbedPaneElement getRootParamsPane() {
        return this.rootParamsPane;
    }

    protected void getUplinkFastInfo() {
        this.switchUplinkFastStatus = this.commonCLI.getSTPUplinkFastEnabled(this.switchID);
        this.switchCrossStackUFStatus = this.commonCLI.getSTPCrossStackUplinkFastEnabled(this.switchID);
        this.switchUplinkFastRate = this.switchUplinkFastStatus ? this.commonCLI.getSTPUplinkFastRate(this.switchID) : " ";
    }

    protected void getVLAN_IDs() {
        this.vlanIDs = this.commonCLI.getVlanIDs(this.switchID);
        this.getCurrentSpanningTree();
    }

    public void interruptCollectionThreads() {
        int n = 0;
        while (n < this.collectionThreads.size()) {
            ControllableThread controllableThread = (ControllableThread)this.collectionThreads.elementAt(n);
            if (controllableThread.isAlive()) {
                try {
                    controllableThread.interrupt();
                }
                catch (SecurityException securityException) {}
            }
            ++n;
        }
    }

    protected boolean isEnterprise() {
        boolean bl = false;
        if (this.switchMembers[this.switchIndex].statusCode != null && this.switchMembers[this.switchIndex].statusCode.compareTo("Down") != 0) {
            if (this.switchMembers[this.switchIndex].enterpriseEdition) {
                bl = true;
            }
        } else {
            bl = this.commonCLI.isEnterpriseEdition(this.switchID);
        }
        return bl;
    }

    protected boolean isUplinkFastSupported() {
        return this.isEnterprise() && (this.switchMembers[this.switchIndex].deviceType.indexOf("WS-C29") == -1 || this.switchMembers[this.switchIndex].DRAMSize != 4);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.apply_JButton.setEnabled(true);
    }

    protected boolean maxUpdateRateValid(String string) {
        return Validation.isValidInteger(string, 0, 1000);
    }

    public void setCursor(Cursor cursor) {
        if (!this.dataGathering) {
            super.setCursor(cursor);
        } else {
            super.setCursor(new Cursor(3));
        }
    }

    protected void setDefaultData() {
        int n = 0;
        while (n < this.models.size()) {
            ((STP_CustomModel)this.models.elementAt(n)).setDefaultData();
            ++n;
        }
    }

    public void setSelectedSwitch(JComboBox jComboBox) {
        String string = (String)this.devices_JCombo.getSelectedItem();
        int n = 0;
        while (n < this.switchMembers.length && !this.switchMembers[n].switchName.equals(string)) {
            ++n;
        }
        if (n < this.switchMembers.length) {
            this.switchIndex = n;
            this.switchID = this.switchMembers[this.switchIndex].esn;
        }
    }

    public void spanningTreeChanged() {
        this.getCurrentSpanningTree();
        this.updateTable(this.statusPane.getTable());
        this.updateTable(this.currentRootsPane.getTable());
        this.updateTable(this.portParamsPane.getTable());
        this.updateTable(this.uplinkFastPane.getTable());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.determineModifyState();
    }

    public void updateCurrentSpanningTree() {
        int n;
        boolean bl = false;
        this.changingVLANComboBox = true;
        this.lastVLANID = null;
        this.selectedVLAN = null;
        int n2 = 0;
        while (n2 < this.vlanSTPChanged.size() && !bl) {
            n = 0;
            while (n < this.vlanComboBoxModel.getSize() && !bl) {
                String string;
                String string2 = (String)this.vlanSTPChanged.elementAt(n2);
                if (string2.equals(string = (String)this.vlanComboBoxModel.getElementAt(n))) {
                    bl = true;
                    this.vlanComboBoxModel.removeElementAt(n);
                }
                if (string2.compareTo(string) > 0) {
                    bl = true;
                    this.vlanComboBoxModel.insertElementAt(string2, n);
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < this.vlanIDs.length) {
            this.stpEnabled[n] = this.commonCLI.getSpanningTreeEnabled(this.switchID, this.vlanIDs[n]);
            if (this.stpEnabled[n]) {
                this.vlanComboBoxModel.addElement(this.vlanIDs[n]);
            }
            ++n;
        }
        this.selectedVLAN = this.vlanComboBoxModel.getSize() == 0 ? null : (String)this.vlanComboBoxModel.getElementAt(0);
        this.changingVLANComboBox = false;
    }

    protected void updateTable(JTable jTable) {
        ((STP_CustomModel)jTable.getModel()).gatherDataFromDevice(this.switchID, this.vlanIDs, this.stpEnabled, this.selectedVLAN);
    }

    protected void updateTables() {
        this.updateTable(this.statusPane.getTable());
        this.updateTable(this.currentRootsPane.getTable());
        this.updateTable(this.rootParamsPane.getTable());
        this.updateTable(this.portParamsPane.getTable());
        this.updateTable(this.uplinkFastPane.getTable());
    }

    protected void updateUplinkFast() {
        if (this.switchUplinkFastStatus) {
            this.uplinkFast_JComboBox.setSelectedIndex(0);
            ((Component)this.uplinkFast_JTextField).enable();
        } else {
            this.uplinkFast_JComboBox.setSelectedIndex(1);
            this.maxUpdate_JLabel.setEnabled(false);
            this.uplinkFast_JTextField.setEnabled(false);
        }
        String string = this.commonCLI.getSwVersion(this.switchID).toUpperCase();
        if ((string.indexOf("WC") != -1 || string.indexOf("XW") != -1) && this.switchMembers[this.switchIndex].razorPort) {
            this.uplinkFastPane.getScrollPane().setVisible(true);
        } else {
            this.uplinkFastPane.getScrollPane().setVisible(false);
        }
        this.uplinkFast_JTextField.setText(this.switchUplinkFastRate);
        this.apply_JButton.setEnabled(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.determineModifyState();
    }

    public void waitForCollectionThreads() {
        boolean bl = false;
        int n = 0;
        while (n < this.collectionThreads.size() && !bl) {
            ControllableThread controllableThread;
            ControllableThread controllableThread2 = controllableThread = (ControllableThread)this.collectionThreads.elementAt(n);
            synchronized (controllableThread2) {
                if (controllableThread.isAlive()) {
                    try {
                        controllableThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
            }
            ++n;
        }
    }

    private class CollectSpecificData
    implements Runnable {
        STP_CustomModel model = null;

        CollectSpecificData(STP_CustomModel sTP_CustomModel) {
            this.model = sTP_CustomModel;
        }

        public void run() {
            this.model.gatherDataFromDevice(STP_JDialog.this.switchID, STP_JDialog.this.vlanIDs, STP_JDialog.this.stpEnabled, STP_JDialog.this.selectedVLAN);
        }
    }

    private class CollectData
    implements Runnable {
        Vector models = null;

        CollectData(Vector vector) {
            this.models = vector;
        }

        static /* synthetic */ STP_JDialog access$0(CollectData collectData) {
            return collectData.STP_JDialog.this;
        }

        public void run() {
            Runnable runnable;
            STP_JDialog.this.dataGathering = true;
            if (!STP_JDialog.this.abortThreads) {
                STP_JDialog.this.getVLAN_IDs();
                STP_JDialog.this.selectedVLAN = STP_JDialog.this.vlanComboBoxModel.getSize() > 0 ? (String)STP_JDialog.this.vlanComboBoxModel.getElementAt(0) : null;
            }
            if (!STP_JDialog.this.abortThreads) {
                runnable = null;
                ControllableThread controllableThread = null;
                int n = 0;
                while (n < this.models.size()) {
                    runnable = new CollectSpecificData((STP_CustomModel)this.models.elementAt(n));
                    controllableThread = new ControllableThread(runnable);
                    STP_JDialog.this.collectionThreads.addElement(controllableThread);
                    controllableThread.start();
                    ++n;
                }
            }
            if (!STP_JDialog.this.abortThreads) {
                STP_JDialog.this.lastVLANID = STP_JDialog.this.selectedVLAN;
                if (STP_JDialog.this.isUplinkFastSupported()) {
                    STP_JDialog.this.getUplinkFastInfo();
                }
            }
            STP_JDialog.this.waitForCollectionThreads();
            if (!STP_JDialog.this.abortThreads) {
                STP_JDialog.this.dataGathering = false;
            }
            runnable = new Runnable(this){
                private final /* synthetic */ CollectData this$1;
                {
                    this.this$1 = collectData;
                }

                public void run() {
                    CollectData.access$0(this.this$1).completeInitialization();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == STP_JDialog.this) {
                STP_JDialog.this.STPJDialog_mouseMoved(mouseEvent);
            }
        }
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == STP_JDialog.this) {
                STP_JDialog.this.STPJDialog_componentHidden(componentEvent);
            }
        }
    }
}

