/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class ProfileSettingDialog
extends JDialog
implements ActionListener {
    public static final int PUBLIC_MODE = 0;
    public static final int PRIVATE_MODE = 1;
    public static final int CLUSTER_MODE = 2;
    private final String[] BORDER_TITLES = new String[]{"Public Mode Profile Setting", "Private Mode Profile Setting", "Public Mode Profile Setting By Cluster"};
    private int blockCount = 0;
    private String HELP_CODE = "profset";
    private String DIALOG_TITLE = "Profile Setting";
    private String OK = "OK";
    private String CANCEL = "Cancel";
    private String HELP = "Help";
    private final int STRUT_WIDTH = 30;
    private JPanel buttonsPanel = new JPanel();
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private ProfileModeDialog profileModeDialog = null;
    private ProfileSettingPanel settingPanel = null;
    private TitledBorder settingPanelBorder = null;
    private JComboBox profileListBox = null;
    private Profile[] publicProfiles = null;
    private Profile[] privateProfiles = null;
    private int settingMode;

    public ProfileSettingDialog(ProfileModeDialog profileModeDialog) {
        this.setDefaultCloseOperation(1);
        this.setTitle(this.DIALOG_TITLE);
        ((Component)this).setSize(400, 300);
        this.setResizable(false);
        this.profileModeDialog = profileModeDialog;
        this.settingPanel = new ProfileSettingPanel();
        this.settingPanelBorder = new TitledBorder("");
        this.settingPanel.setBorder(this.settingPanelBorder);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.settingPanel, "Center");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.okButton = new JButton(this.OK);
        this.cancelButton = new JButton(this.CANCEL);
        this.helpButton = new JButton(this.HELP);
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.buttonsPanel.add(this.helpButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSettingDialog.this.clickOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSettingDialog.this.clickCancel();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSettingDialog.this.clickHelp();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void clickCancel() {
        this.dispose();
    }

    private void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.profileModeDialog.getApplet(), (String)this.HELP_CODE);
    }

    private void clickOK() {
        switch (this.settingMode) {
            case 0: {
                Profile profile = this.settingPanel.getSelectedProfile();
                this.profileModeDialog.registerPublicProfile(profile);
                break;
            }
            case 1: {
                this.profileModeDialog.registerPrivateProfile(this.settingPanel.getSelectedProfile());
                break;
            }
        }
        this.dispose();
    }

    public void setCursor(Cursor cursor) {
        if (this.blockCount == 0) {
            super.setCursor(cursor);
        } else {
            super.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void setDefaultCursor() {
        --this.blockCount;
        if (this.blockCount < 0) {
            this.blockCount = 0;
        }
        if (this.blockCount > 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProfileSettingDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void setWaitingCursor() {
        ++this.blockCount;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProfileSettingDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    public void showInMode(int n) {
        this.settingMode = n;
        this.settingPanelBorder.setTitle(this.BORDER_TITLES[n]);
        if (this.settingMode == 1) {
            this.privateProfiles = this.profileModeDialog.getAvailablePrivateProfiles();
            this.settingPanel.setProfileList(this.privateProfiles);
        } else {
            this.publicProfiles = this.profileModeDialog.getAvailablePublicProfiles();
            this.settingPanel.setProfileList(this.publicProfiles);
        }
        ((Component)this).setVisible(true);
    }

    class ProfileSettingPanel
    extends JPanel
    implements ItemListener {
        private int count = 0;
        private String PROFILE = "Profile Name:";
        private String USRATE = "Upstream Rate (Mbps):";
        private String DSRATE = "Downstream Rate (Mbps):";
        private JLabel profileTitle = new JLabel(this.PROFILE);
        private JLabel usRateTitle = new JLabel(this.USRATE);
        private JLabel dsRateTitle = new JLabel(this.DSRATE);
        private JLabel usRateValue = new JLabel();
        private JLabel dsRateValue = new JLabel();
        private JComboBox profileBox = new JComboBox();

        public ProfileSettingPanel() {
            this.profileBox.addItemListener(this);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(Box.createVerticalStrut(40));
            jPanel2.add(this.setupWrappingPanel());
            jPanel2.add(Box.createVerticalGlue());
            jPanel.add((Component)jPanel2, "West");
            this.usRateValue.setForeground(Color.black);
            this.dsRateValue.setForeground(Color.black);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
        }

        public Profile getSelectedProfile() {
            return (Profile)this.profileBox.getSelectedItem();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            Profile profile = (Profile)this.profileBox.getSelectedItem();
            if (profile == null) {
                return;
            }
            this.usRateValue.setText(profile.getUsRate());
            this.dsRateValue.setText(profile.getDsRate());
            this.revalidate();
            this.repaint();
        }

        public void setProfileList(Profile[] profileArray) {
            if (this.profileBox.getItemCount() > 0) {
                this.profileBox.removeAllItems();
            }
            int n = 0;
            while (n < profileArray.length) {
                this.profileBox.addItem(profileArray[n]);
                ++n;
            }
            this.profileBox.setSelectedIndex(0);
            this.usRateValue.setText(profileArray[0].getUsRate());
            this.dsRateValue.setText(profileArray[0].getDsRate());
            this.repaint();
        }

        private JPanel setupTitlePanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1, 10, 10));
            jPanel.add(this.profileTitle);
            jPanel.add(this.usRateTitle);
            jPanel.add(this.dsRateTitle);
            return jPanel;
        }

        private JPanel setupValuePanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1, 10, 10));
            jPanel.add(this.profileBox);
            jPanel.add(this.usRateValue);
            jPanel.add(this.dsRateValue);
            return jPanel;
        }

        private JPanel setupWrappingPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(40, 40));
            jPanel.add((Component)this.setupTitlePanel(), "West");
            jPanel.add((Component)this.setupValuePanel(), "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(40));
            jPanel2.add(jPanel);
            jPanel2.add(Box.createHorizontalGlue());
            return jPanel2;
        }
    }
}

