/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;

public class AddrMgmtNewAddress_JDialog
extends JDialog
implements ActionListener,
ModalDialog.ParentDelegate {
    boolean updated = true;
    boolean frameSizeAdjusted = false;
    JPanel newAddress_JPanel = new JPanel();
    JLabel macAddress_JLabel = new JLabel();
    JLabel interface_JLabel = new JLabel();
    JLabel vlanId_JLabel = new JLabel();
    JTextField macAddress_JTextField = new JTextField();
    JComboBox interface_JComboBox = new JComboBox();
    JComboBox vlan_JComboBox = new JComboBox();
    JTextField vlanId_JTextField = new JTextField();
    JPanel buttons_JPanel;
    JButton ok_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    String[] interfaces;
    String dialogType = null;
    AddrMgmt_AddressModel model = null;
    CommonIOSCLIs commonCLI = null;
    String switchID = null;
    String[] sharedVLANMap = null;
    String[] forwardingMap = null;
    JApplet theApplet = null;
    JDialog parent = null;

    public AddrMgmtNewAddress_JDialog(JApplet jApplet, String string, CommonIOSCLIs commonIOSCLIs, String string2, AddrMgmt_AddressModel addrMgmt_AddressModel) {
        this(null, jApplet, string, commonIOSCLIs, string2, addrMgmt_AddressModel);
    }

    public AddrMgmtNewAddress_JDialog(JDialog jDialog, JApplet jApplet, String string, CommonIOSCLIs commonIOSCLIs, String string2, AddrMgmt_AddressModel addrMgmt_AddressModel) {
        this.parent = jDialog;
        this.theApplet = jApplet;
        this.commonCLI = commonIOSCLIs;
        this.switchID = string2;
        this.dialogType = string;
        this.model = addrMgmt_AddressModel;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.setDefaultCloseOperation(2);
        if (string.equals("secure")) {
            this.setTitle("New Secure Address");
            n = 305;
            n2 = 96;
            n3 = 98;
            this.newAddress_JPanel.setBorder(BorderFactory.createTitledBorder("Secure Address Entry"));
        } else {
            this.setTitle("New Static Address");
            n = 272;
            n2 = 63;
            n3 = 65;
            this.newAddress_JPanel.setBorder(BorderFactory.createTitledBorder("Static Address Entry"));
        }
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(405, n);
        this.setVisible(false);
        this.newAddress_JPanel.setLayout(null);
        this.getContentPane().add("Center", this.newAddress_JPanel);
        this.newAddress_JPanel.setBounds(0, 0, 405, n);
        this.macAddress_JLabel.setText("MAC Address:");
        this.newAddress_JPanel.add(this.macAddress_JLabel);
        this.macAddress_JLabel.setBounds(8, 30, 102, 22);
        this.macAddress_JTextField.setBounds(122, 28, 176, 26);
        this.newAddress_JPanel.add(this.macAddress_JTextField);
        this.interfaces = commonIOSCLIs.getL2Interfaces(string2);
        if (string.equals("secure")) {
            this.interface_JLabel.setText("Interface:");
            this.newAddress_JPanel.add(this.interface_JLabel);
            this.interface_JLabel.setBounds(8, 63, 102, 22);
            this.newAddress_JPanel.add(this.interface_JComboBox);
            this.interface_JComboBox.setBounds(122, 63, 176, 26);
            int n4 = 0;
            while (n4 < this.interfaces.length) {
                this.interface_JComboBox.addItem(this.interfaces[n4]);
                ++n4;
            }
            this.vlanId_JLabel.setText("VLAN ID (1-1005):");
            this.newAddress_JPanel.add(this.vlanId_JLabel);
            this.vlanId_JLabel.setBounds(8, n2, 102, 22);
            this.newAddress_JPanel.add(this.vlanId_JTextField);
            this.vlanId_JTextField.setBounds(122, n3, 176, 26);
        } else {
            this.vlanId_JLabel.setText("VLAN ID :");
            this.newAddress_JPanel.add(this.vlanId_JLabel);
            this.vlanId_JLabel.setBounds(8, n2, 102, 22);
            this.newAddress_JPanel.add(this.vlan_JComboBox);
            this.vlan_JComboBox.setBounds(122, n3, 176, 26);
            String[] stringArray = commonIOSCLIs.getVlanIDs(string2);
            int n5 = 0;
            while (n5 < stringArray.length) {
                this.vlan_JComboBox.addItem(stringArray[n5]);
                ++n5;
            }
        }
        this.getContentPane().add((Component)this.newAddress_JPanel, "Center");
        this.buttons_JPanel = new JPanel();
        this.ok_JButton = new JButton("OK");
        this.cancel_JButton = new JButton("Cancel");
        this.help_JButton = new JButton("Help");
        this.buttons_JPanel.add(this.ok_JButton);
        this.buttons_JPanel.add(this.cancel_JButton);
        this.buttons_JPanel.add(this.help_JButton);
        this.getContentPane().add((Component)this.buttons_JPanel, "South");
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        if (actionEvent.getSource() == this.help_JButton) {
            if (this.dialogType.equalsIgnoreCase("static")) {
                HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"newstcdg");
            } else {
                HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"newsecdg");
            }
        } else if (actionEvent.getSource() == this.ok_JButton) {
            String string = null;
            String string2 = null;
            String string3 = null;
            this.updated = true;
            string = this.macAddress_JTextField.getText();
            if (!Validation.isMACAddress(string)) {
                JOptionPane.showMessageDialog(this.getContentPane(), "The value specified for 'MAC Address' is not valid.\nPlease specify a valid address in the form xxxx.xxxx.xxxx.\n", "Error: Address Management", 0);
                ((Component)this).setCursor(new Cursor(0));
                return;
            }
            if (this.dialogType.equals("secure")) {
                string2 = this.vlanId_JTextField.getText();
                if (!Validation.isVLANID(string2)) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "The value specified for 'VLAN ID' is not valid.\nPlease specify a value between 1 and 1005.\n", "Error: Address Management", 0);
                    ((Component)this).setCursor(new Cursor(0));
                    return;
                }
                int n = this.interface_JComboBox.getSelectedIndex();
                if (n == -1) {
                    n = 0;
                }
                string3 = this.interfaces[n];
                String[] stringArray = this.commonCLI.addSecureAddress(this.switchID, string, string3, string2);
                StringBuffer stringBuffer = new StringBuffer("");
                if (stringArray != null && stringArray[0].compareTo("") != 0) {
                    stringBuffer.append(stringArray[0]);
                    if (stringArray[0].equals("Input address entry value not valid.")) {
                        stringBuffer.append("\nYou may have reached the maximum number").append(" of secure addresses for this port");
                    }
                    this.updated = false;
                    JOptionPane.showMessageDialog(this.getContentPane(), stringBuffer.toString(), "Error: Address Management", 0);
                    ((Component)this).setCursor(new Cursor(0));
                    return;
                }
                if (this.updated) {
                    this.model.gatherDataFromDevice(this.switchID);
                }
            } else {
                string2 = (String)this.vlan_JComboBox.getSelectedItem();
                this.sharedVLANMap = this.commonCLI.getSharedVLANMap(this.switchID, string2);
                this.forwardingMap = this.commonCLI.getForwardingMap(this.switchID, string);
                if (!this.isVLANShared()) {
                    this.updated = false;
                    JOptionPane.showMessageDialog(this.getContentPane(), "There must be at least two interfaces defined to\na VLAN to define Static Forwarding for that VLAN.\n", "Error: Address Management", 0);
                    ((Component)this).setCursor(new Cursor(0));
                    return;
                }
                this.interfaces = this.commonCLI.getVLANInterfaces(this.switchID, string2);
                StaticForwardModify_JDialog staticForwardModify_JDialog = new StaticForwardModify_JDialog(this.theApplet, this.commonCLI, this.switchID, string, string2, this.interfaces, -1, this.sharedVLANMap, this.forwardingMap, ((AddrMgmt_JDialog)this.parent).getInterfaces());
                ModalDialog.show((RootPaneContainer)this, (Dialog)staticForwardModify_JDialog, (ModalDialog.ParentDelegate)this);
            }
            ((Component)this).setCursor(new Cursor(0));
            this.dispose();
        } else {
            this.dispose();
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public boolean isVLANShared() {
        boolean bl = false;
        int n = 0;
        while (n < this.interfaces.length && !bl) {
            int n2 = 0;
            while (n2 < this.interfaces.length && !bl) {
                if (n != n2 && this.sharedVLANMap[n].charAt(n2) != '0') {
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    public void modalDialogClosed(Dialog dialog) {
        if (this.updated) {
            this.model.gatherDataFromDevice(this.switchID);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }
}

