/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class WrrPanel
extends JPanel
implements ItemListener,
KeyListener {
    private CommonSwitch theSwitch;
    private WRRModel wrrModel = null;
    private boolean dataChanged;
    private JPanel qidPanel = new JPanel();
    JTextField[] wrrTexts = new JTextField[]{new JTextField(3), new JTextField(3), new JTextField(3), new JTextField(3)};
    JLabel[] qidLabels = new JLabel[]{new JLabel("1"), new JLabel("2"), new JLabel("3"), new JLabel("4")};
    JLabel queue = new JLabel("Queue");
    JLabel wrr = new JLabel("WRR (1-255)");
    JCheckBox wrrCheckBox = new JCheckBox("Enable Weighted Round Robin priority", true);
    TabbedPaneListener tbdListener = null;

    WrrPanel(CommonSwitch commonSwitch) {
        this.theSwitch = commonSwitch;
        this.wrrModel = new WRRModel();
        this.setLayout(new GridBagLayout());
        this.qidPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(6, 6, 3, 6);
        this.qidPanel.add(this.queue, gridBagConstraints, -1);
        gridBagConstraints.insets = new Insets(6, 18, 3, 6);
        int n = 0;
        while (n < this.qidLabels.length - 1) {
            this.qidLabels[n].setHorizontalAlignment(0);
            this.qidPanel.add(this.qidLabels[n], gridBagConstraints, -1);
            ++n;
        }
        gridBagConstraints.gridwidth = 0;
        this.qidPanel.add(this.qidLabels[n], gridBagConstraints, -1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(6, 6, 3, 6);
        this.qidPanel.add(this.wrr, gridBagConstraints, -1);
        n = 0;
        while (n < this.wrrTexts.length) {
            this.wrrTexts[n].addKeyListener(this);
            this.qidPanel.add(this.wrrTexts[n], gridBagConstraints, -1);
            ++n;
        }
        this.fillData();
        this.wrrCheckBox.addItemListener(this);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 0);
        JPanel jPanel = new JPanel();
        jPanel.add(this.wrrCheckBox);
        this.add(jPanel, gridBagConstraints2, -1);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints2.gridwidth = 0;
        this.add(jPanel2, gridBagConstraints2, -1);
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add(this.qidPanel, gridBagConstraints2, -1);
        this.dataChanged(true);
        this.applyChanges();
        this.dataChanged(false);
    }

    public void addTabbedPaneListener(TabbedPaneListener tabbedPaneListener) {
        this.tbdListener = tabbedPaneListener;
    }

    public boolean applyChanges() {
        if (!this.dataChanged()) {
            return true;
        }
        if (this.wrrCheckBox.isSelected()) {
            if (this.validateData() && this.wrrModel.setWRRBandwidth(new String[]{this.wrrTexts[0].getText(), this.wrrTexts[1].getText(), this.wrrTexts[2].getText(), this.wrrTexts[3].getText()})) {
                WrrPanel.setContainerEnabled(this.qidPanel, true);
                this.dataChanged(false);
                return true;
            }
        } else if (this.wrrModel.enableWRR(false)) {
            WrrPanel.setContainerEnabled(this.qidPanel, false);
            this.dataChanged(false);
            return true;
        }
        return false;
    }

    private boolean dataChanged() {
        return this.dataChanged;
    }

    private void dataChanged(boolean bl) {
        this.dataChanged = bl;
        if (this.dataChanged && this.tbdListener != null) {
            this.tbdListener.dataChanged();
        }
    }

    public void fillData() {
        String[][] stringArray = this.wrrModel.getWRRBandwidth();
        boolean bl = stringArray[1][0].equals("-1");
        int n = 0;
        while (n < this.wrrTexts.length) {
            this.wrrTexts[n].setText(bl ? "" : stringArray[1][n]);
            ++n;
        }
        this.wrrCheckBox.setSelected(bl ^ true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(340, 175);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.wrrCheckBox) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.queue.setEnabled(bl);
            this.wrr.setEnabled(bl);
            int n = 0;
            while (n < this.qidLabels.length) {
                this.qidLabels[n].setEnabled(bl);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.wrrTexts.length) {
                this.wrrTexts[n2].setText("");
                this.wrrTexts[n2].setEnabled(bl);
                ++n2;
            }
            this.dataChanged(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.dataChanged(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.dataChanged(true);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.dataChanged(true);
    }

    protected static void setContainerEnabled(JComponent jComponent, boolean bl) {
        Component component = null;
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            try {
                component = jComponent.getComponent(n2);
                JComponent jComponent2 = (JComponent)component;
                WrrPanel.setContainerEnabled(jComponent2, bl);
            }
            catch (Exception exception) {}
            ++n2;
        }
        jComponent.setEnabled(bl);
    }

    public void setSwitch(CommonSwitch commonSwitch) {
        this.theSwitch = commonSwitch;
        this.fillData();
    }

    public boolean validateData() {
        if (this.wrrCheckBox.isSelected()) {
            int n = 0;
            while (n < this.wrrTexts.length) {
                String string = this.wrrTexts[n].getText();
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog(null, "WRR can not be empty", "WRR Error", 0);
                    ((JTabbedPane)this.getParent()).setSelectedComponent(this);
                    this.wrrTexts[n].requestFocus();
                    return false;
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Enter digits only", "WRR Error", 0);
                    ((JTabbedPane)this.getParent()).setSelectedComponent(this);
                    this.wrrTexts[n].requestFocus();
                    return false;
                }
                if (n2 <= 0) {
                    JOptionPane.showMessageDialog(null, "Priority must be greater than zero", "WRR Error", 0);
                    ((JTabbedPane)this.getParent()).setSelectedComponent(this);
                    this.wrrTexts[n].requestFocus();
                    return false;
                }
                if (n2 > 255) {
                    JOptionPane.showMessageDialog(null, "Priority can not be greater than 255", "WRR Error", 0);
                    ((JTabbedPane)this.getParent()).setSelectedComponent(this);
                    this.wrrTexts[n].requestFocus();
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private class WRRModel {
        WRRModel() {
        }

        public boolean enableWRR(boolean bl) {
            if (bl) {
                return false;
            }
            return ((WrrPanel)WrrPanel.this).theSwitch.Cli.enableWRR(((WrrPanel)WrrPanel.this).theSwitch.esn, bl);
        }

        public String[][] getWRRBandwidth() {
            return ((WrrPanel)WrrPanel.this).theSwitch.Cli.getWRRBandwidth(((WrrPanel)WrrPanel.this).theSwitch.esn);
        }

        public boolean setWRRBandwidth(String[] stringArray) {
            return ((WrrPanel)WrrPanel.this).theSwitch.Cli.setWRRBandwidth(((WrrPanel)WrrPanel.this).theSwitch.esn, stringArray);
        }
    }
}

