/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class DeviceDialog
extends JDialog
implements DeviceMirrorObject,
ActionListener,
WindowListener,
ComponentListener {
    protected static final String OK_BUTTON = "OK ";
    protected static final String APPLY_BUTTON = "APPLY ";
    protected static final String MODIFY_BUTTON = "MODIFY ";
    protected static final String REFRESH_BUTTON = "REFRESH ";
    protected static final String CANCEL_BUTTON = "CANCEL ";
    protected static final String HELP_BUTTON = "HELP ";
    protected static final String emptyComboBoxItem = " ";
    protected JApplet applet;
    protected Vector mirrors;
    protected Thread getThread;
    protected Thread setThread;
    private Toolkit toolkit;
    private BreakableGlassPane userGlassPane;
    private JPanel bottomButtonPanel;
    private JButton okButton;
    private JButton applyButton;
    protected JButton modifyButton;
    private JButton refreshButton;
    private JButton cancelButton;
    private JButton helpButton;
    private boolean blockCursor;
    private Cursor defaultCursor;
    private Cursor waitCursor;
    protected boolean maskButtons;
    private boolean maskAllButtons;
    protected boolean uiNeedsRefresh;
    protected boolean uiChanged;
    protected boolean enableOk;
    protected boolean enableApply;
    protected boolean enableModify;
    private boolean okButtonPressed;
    private boolean errorSettingConfig;

    public DeviceDialog(JApplet jApplet) {
        this.applet = jApplet;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.okButton_Action();
        } else if (object == this.applyButton) {
            this.applyButton_Action();
        } else if (object != this.modifyButton) {
            if (object == this.refreshButton) {
                this.refreshButton_Action();
            } else if (object == this.cancelButton) {
                this.cancelButton_Action();
            } else if (object == this.helpButton) {
                this.helpButton_Action();
            }
        }
    }

    private void applyButton_Action() {
        if (!this.getApplyConfirmation()) {
            this.okButtonPressed = false;
            return;
        }
        this.setPreventUserOps(true);
        try {
            this.errorSettingConfig = false;
            this.updateMirrorFromGui();
            this.setThread = new Thread(){

                public void run() {
                    DeviceDialog.this.setConfig();
                }
            };
            this.setThread.start();
        }
        catch (UserInputException userInputException) {
            this.errorSettingConfig = true;
            this.setConfigDone(this.errorSettingConfig);
        }
    }

    private void cancelButton_Action() {
        boolean bl;
        if (this.uiChanged && !(bl = this.getDiscardConfirmation())) {
            return;
        }
        this.dispose();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        if (component != this) {
            return;
        }
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getSize();
        boolean bl = false;
        if (dimension2.width < dimension.width) {
            dimension2.width = dimension.width;
            bl = true;
        }
        if (dimension2.height < dimension.height) {
            dimension2.height = dimension.height;
            bl = true;
        }
        if (bl) {
            ((Component)this).setSize(dimension2);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    protected void constructorInit() {
        this.layoutWidgets();
        this.mirrors = new Vector();
        this.getMirrorObjects(this.mirrors);
        this.mirrors.trimToSize();
        this.initializeMembers();
        this.hookupListeners();
        this.setDefaultCloseOperation(0);
    }

    protected void displayUserError(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.toolkit.beep();
        JOptionPane.showMessageDialog(this, string, "Error: " + this.getWindowTitle(), 0);
        throw new UserInputException();
    }

    protected boolean getApplyConfirmation() {
        return true;
    }

    protected abstract String getButtonsNeeded();

    protected void getConfig() {
        this.getThread = new Thread(){

            public void run() {
                DeviceDialog.this.updateMirrorFromDevice();
                try {
                    SwingUtilities.invokeAndWait(DeviceDialog.this.getConfigDoneRunnable());
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        };
        this.getThread.start();
    }

    private Runnable getConfigDoneRunnable() {
        Runnable runnable = new Runnable(){

            public void run() {
                DeviceDialog.this.updateGuiFromMirror();
                DeviceDialog.this.uiChanged = false;
                DeviceDialog.this.setPreventUserOps(false);
            }
        };
        return runnable;
    }

    protected abstract JPanel getContentPanel();

    protected boolean getDiscardConfirmation() {
        return true;
    }

    protected String getHelpUrl() {
        this.toolkit.beep();
        JOptionPane.showMessageDialog(this, "Help file not specified for this dialog.", "Error: " + this.getWindowTitle(), 0);
        return "";
    }

    protected abstract void getMirrorObjects(Vector var1);

    protected abstract String getWindowTitle();

    private void helpButton_Action() {
        HelpDialog.Factory.showHelp((JApplet)this.applet, (String)this.getHelpUrl());
    }

    public void hookupListeners() {
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.refreshButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.addWindowListener(this);
        this.addComponentListener(this);
        int n = 0;
        while (n < this.mirrors.size()) {
            DeviceMirrorObject deviceMirrorObject = (DeviceMirrorObject)this.mirrors.elementAt(n);
            deviceMirrorObject.hookupListeners();
            ++n;
        }
    }

    public void initializeMembers() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.blockCursor = false;
        this.defaultCursor = Cursor.getPredefinedCursor(0);
        this.waitCursor = Cursor.getPredefinedCursor(3);
        this.maskAllButtons = false;
        this.uiNeedsRefresh = false;
        this.uiChanged = false;
        this.enableOk = true;
        this.enableApply = false;
        this.enableModify = false;
        int n = 0;
        while (n < this.mirrors.size()) {
            DeviceMirrorObject deviceMirrorObject = (DeviceMirrorObject)this.mirrors.elementAt(n);
            deviceMirrorObject.initializeMembers();
            ++n;
        }
    }

    protected void layoutWidgets() {
        this.setTitle(this.getWindowTitle());
        JPanel jPanel = this.getContentPanel();
        this.okButton = new JButton("OK");
        this.applyButton = new JButton("Apply");
        this.modifyButton = new JButton("Modify ...");
        this.refreshButton = new JButton("Refresh");
        this.cancelButton = new JButton("Cancel");
        this.helpButton = new JButton("Help");
        this.bottomButtonPanel = new JPanel(new FlowLayout(1, 6, 0));
        String string = this.getButtonsNeeded();
        if (string.indexOf(OK_BUTTON) >= 0) {
            this.bottomButtonPanel.add(this.okButton);
        }
        if (string.indexOf(APPLY_BUTTON) >= 0) {
            this.bottomButtonPanel.add(this.applyButton);
        }
        if (string.indexOf(MODIFY_BUTTON) >= 0) {
            this.bottomButtonPanel.add(this.modifyButton);
        }
        if (string.indexOf(REFRESH_BUTTON) >= 0) {
            this.bottomButtonPanel.add(this.refreshButton);
        }
        if (string.indexOf(CANCEL_BUTTON) >= 0) {
            this.bottomButtonPanel.add(this.cancelButton);
        }
        if (string.indexOf(HELP_BUTTON) >= 0) {
            this.bottomButtonPanel.add(this.helpButton);
        }
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.gridx = 0;
        this.userGlassPane = new BreakableGlassPane((RootPaneContainer)this);
        this.userGlassPane.addBreak((Component)this.bottomButtonPanel);
        this.setGlassPane((Component)this.userGlassPane);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        if (jPanel != null) {
            container.add((Component)jPanel, gridBagConstraints);
        }
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 12;
        gridBagConstraints.insets.right = 12;
        gridBagConstraints.insets.bottom = 12;
        container.add((Component)this.bottomButtonPanel, gridBagConstraints);
    }

    protected void maskBottomButtons(boolean bl) {
        this.maskButtons = bl;
        this.updateBottomButtons();
    }

    private void okButton_Action() {
        if (this.uiChanged) {
            this.okButtonPressed = true;
            this.applyButton_Action();
        } else {
            this.dispose();
        }
    }

    protected void populateDeviceList() {
        this.setPreventUserOps(true);
        this.getConfig();
    }

    private void refreshButton_Action() {
        boolean bl;
        if (this.uiChanged && !(bl = this.getDiscardConfirmation())) {
            return;
        }
        this.setPreventUserOps(true);
        this.getConfig();
    }

    protected void removeFromList(JList jList, JButton jButton, JButton jButton2) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        int[] nArray = jList.getSelectedIndices();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n] - n;
            defaultListModel.remove(n2);
            ++n;
        }
        jButton.setEnabled(false);
        jButton2.setEnabled(defaultListModel.isEmpty() ^ true);
        this.uiChanged = true;
        this.updateBottomButtons();
    }

    public void setApplyButtonMode(boolean bl) {
        this.applyButton.setEnabled(bl);
    }

    protected void setApplyButtonText(String string) {
        this.applyButton.setText(string);
    }

    protected void setBlockCursor(boolean bl) {
        this.blockCursor = bl;
    }

    private void setConfig() {
        try {
            this.errorSettingConfig = false;
            this.updateDeviceFromMirror();
            if (this.uiNeedsRefresh && !this.okButtonPressed) {
                this.updateMirrorFromDevice();
            }
        }
        catch (UserInputException userInputException) {
            this.errorSettingConfig = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DeviceDialog.this.setConfigDone(DeviceDialog.this.errorSettingConfig);
            }
        });
    }

    private void setConfigDone(boolean bl) {
        if (!bl) {
            if (this.okButtonPressed) {
                this.dispose();
            }
            if (this.uiNeedsRefresh && !this.okButtonPressed) {
                this.updateGuiFromMirror();
                this.uiNeedsRefresh = false;
            }
            this.uiChanged = false;
        }
        this.okButtonPressed = false;
        this.setPreventUserOps(false);
    }

    protected static void setContainerEnabled(JComponent jComponent, boolean bl) {
        Component component = null;
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            try {
                component = jComponent.getComponent(n2);
                JComponent jComponent2 = (JComponent)component;
                DeviceDialog.setContainerEnabled(jComponent2, bl);
            }
            catch (Exception exception) {}
            ++n2;
        }
        jComponent.setEnabled(bl);
    }

    protected static void setContainerReadOnly(JComponent jComponent) {
        Component component = null;
        int n = jComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            try {
                component = jComponent.getComponent(n2);
                JComponent jComponent2 = (JComponent)component;
                DeviceDialog.setContainerReadOnly(jComponent2);
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (jComponent instanceof JTabbedPane || jComponent instanceof JScrollPane || jComponent instanceof JList || jComponent instanceof JLabel) {
            return;
        }
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setEditable(false);
        } else {
            jComponent.setEnabled(false);
        }
    }

    public void setCursor(Cursor cursor) {
        if (!this.blockCursor) {
            super.setCursor(cursor);
        }
    }

    protected void setMaskAllButtons(boolean bl) {
        this.maskAllButtons = bl;
    }

    protected void setOkButtonText(String string) {
        this.okButton.setText(string);
    }

    protected void setPreventUserOps(boolean bl) {
        this.maskBottomButtons(bl);
        this.userGlassPane.setVisible(bl);
        this.userGlassPane.setIgnoreBreaks(bl ^ true);
        if (bl) {
            this.setCursor(this.waitCursor);
            this.setBlockCursor(true);
        } else {
            this.setBlockCursor(false);
            this.setCursor(this.defaultCursor);
        }
    }

    public void setTableColumnTitleToolTips(JTable jTable) {
        JTable jTable2 = jTable;
        JTableHeader jTableHeader = jTable2.getTableHeader();
        class ColumnListener
        implements MouseMotionListener {
            private final /* synthetic */ JTable val$l_table;
            private TableColumnModel colModel;
            private int lastIndex;

            public ColumnListener(JTable jTable) {
                this.val$l_table = jTable;
                this.colModel = null;
                this.lastIndex = -1;
                this.colModel = jTable.getColumnModel();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.setTooltip(mouseEvent);
            }

            private void setTooltip(MouseEvent mouseEvent) {
                int n = this.colModel.getColumnIndexAtX(mouseEvent.getX());
                if (n == this.lastIndex) {
                    return;
                }
                this.lastIndex = n;
                TableColumn tableColumn = this.colModel.getColumn(n);
                this.val$l_table.getTableHeader().setToolTipText(tableColumn.getHeaderValue().toString());
            }
        }
        ColumnListener columnListener = new ColumnListener(jTable2);
        jTableHeader.addMouseMotionListener(columnListener);
    }

    protected void updateBottomButtons() {
        if (this.maskButtons) {
            this.okButton.setEnabled(false);
            this.applyButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.refreshButton.setEnabled(false);
            if (this.maskAllButtons) {
                this.cancelButton.setEnabled(false);
            }
        } else {
            this.okButton.setEnabled(this.enableOk);
            this.applyButton.setEnabled(this.uiChanged || this.enableApply);
            this.modifyButton.setEnabled(this.enableModify);
            this.refreshButton.setEnabled(true);
            if (this.maskAllButtons) {
                this.cancelButton.setEnabled(true);
            }
        }
    }

    public void updateDeviceFromMirror() {
        int n = 0;
        while (n < this.mirrors.size()) {
            DeviceMirrorObject deviceMirrorObject = (DeviceMirrorObject)this.mirrors.elementAt(n);
            deviceMirrorObject.updateDeviceFromMirror();
            ++n;
        }
    }

    public void updateGuiFromMirror() {
        int n = 0;
        while (n < this.mirrors.size()) {
            DeviceMirrorObject deviceMirrorObject = (DeviceMirrorObject)this.mirrors.elementAt(n);
            deviceMirrorObject.updateGuiFromMirror();
            ++n;
        }
    }

    public void updateMirrorFromDevice() {
        int n = 0;
        while (n < this.mirrors.size()) {
            DeviceMirrorObject deviceMirrorObject = (DeviceMirrorObject)this.mirrors.elementAt(n);
            deviceMirrorObject.updateMirrorFromDevice();
            ++n;
        }
    }

    public void updateMirrorFromGui() {
        int n = 0;
        while (n < this.mirrors.size()) {
            DeviceMirrorObject deviceMirrorObject = (DeviceMirrorObject)this.mirrors.elementAt(n);
            deviceMirrorObject.updateMirrorFromGui();
            ++n;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.cancelButton.isEnabled()) {
            this.cancelButton_Action();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.pack();
        this.setLocationRelativeTo(this.applet);
        this.okButtonPressed = false;
        this.populateDeviceList();
    }
}

