/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public class Port {
    private Node device;
    String name;
    private Vector edges = new Vector(1);

    public Port(Node node, String string) {
        this.device = node;
        this.name = string;
    }

    public void addEdge(Edge edge) {
        this.edges.addElement(edge);
    }

    public int edgeCount() {
        return this.edges.size();
    }

    public Node getDevice() {
        return this.device;
    }

    public Edge getEdgeTo(Node node) {
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.fromPort.getDevice() == node) {
                return edge;
            }
            if (edge.toPort.getDevice() != node) continue;
            return edge;
        }
        return null;
    }

    public Vector getEdges() {
        return this.edges;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasMultipleEdges() {
        int n = 0;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.isGBIC) continue;
            ++n;
        }
        return n > 1;
    }

    public boolean isRazor() {
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!edge.isGBIC) continue;
            return true;
        }
        return false;
    }

    public boolean removeEdge(Edge edge) {
        return this.edges.removeElement(edge);
    }

    public void setDevice(Node node) {
        this.device = node;
    }

    public void setEdges(Vector vector) {
        this.edges = vector;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" / ");
        stringBuffer.append(this.device.toString());
        return stringBuffer.toString();
    }
}

