/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Gc;
import javachart.chart.Globals;

public class Background
implements Serializable {
    protected Gc gc = new Gc(Color.white, null);
    protected Color titleColor = Color.black;
    protected Font titleFont = Gc.defaultFont;
    protected String titleString = null;
    protected Color subTitleColor = Color.black;
    protected Font subTitleFont = Gc.defaultFont;
    protected String subTitleString = null;
    protected boolean useDisplayList = true;
    protected Globals globals;
    Point startPoint = new Point(0, 0);

    public Background() {
    }

    public Background(Globals globals) {
        this.globals = globals;
        this.gc.globals = globals;
    }

    public synchronized void draw(Graphics graphics) {
        int n;
        FontMetrics fontMetrics;
        int n2 = 7;
        if (graphics == null) {
            System.out.println("null graphics in background");
            return;
        }
        this.gc.fillRect(graphics, this.startPoint, this.globals.maxX, this.globals.maxY);
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this, this.startPoint, new Point(this.globals.maxX, this.globals.maxY));
        }
        if (this.gc.image != null) {
            graphics.drawImage(this.gc.image, 0, 0, null);
        }
        if (this.titleString != null) {
            graphics.setFont(this.titleFont);
            graphics.setColor(this.titleColor);
            fontMetrics = graphics.getFontMetrics();
            n = (this.globals.maxX - this.startPoint.x) / 2 - fontMetrics.stringWidth(this.titleString) / 2;
            n2 = fontMetrics.getMaxAscent() + 10;
            graphics.drawString(this.titleString, n, n2);
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addTextString(this, n, n2, this.titleString, fontMetrics);
            }
        }
        if (this.subTitleString != null) {
            graphics.setFont(this.subTitleFont);
            graphics.setColor(this.subTitleColor);
            fontMetrics = graphics.getFontMetrics();
            n = (this.globals.maxX - this.startPoint.x) / 2 - fontMetrics.stringWidth(this.subTitleString) / 2;
            n2 = n2 + fontMetrics.getMaxAscent() + 3;
            graphics.drawString(this.subTitleString, n, n2);
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addTextString(this, n, n2, this.subTitleString, fontMetrics);
            }
        }
    }

    public Gc getGc() {
        return this.gc;
    }

    public Color getSubTitleColor() {
        return this.subTitleColor;
    }

    public Font getSubTitleFont() {
        return this.subTitleFont;
    }

    public String getSubTitleString() {
        return this.subTitleString;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public String getTitleString() {
        return this.titleString;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    protected synchronized void resize(int n, int n2) {
    }

    public void setGc(Gc gc) {
        this.gc = gc;
        this.gc.globals = this.globals;
    }

    public void setSubTitleColor(Color color) {
        this.subTitleColor = color;
    }

    public void setSubTitleFont(Font font) {
        this.subTitleFont = font;
    }

    public void setSubTitleString(String string) {
        this.subTitleString = string;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleString(String string) {
        this.titleString = string;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }
}

