/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SwUpgrade
extends DeviceListDialog {
    protected static final String switchTypeSelectionError = "Can not mix 3500, 2900, 2950 and\n2820/1900 line of switches.";
    protected static final String dramSizeSelectionError = "Can not mix devices with\n4M DRAM and 8M DRAM.";
    protected int firstSwitchType;
    protected int firstDramSize;
    protected String rebootWarning;
    protected String rebootButtonText;
    protected String rebootStart;
    protected SwUpgradeGui gui;

    public SwUpgrade(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray, null);
    }

    public SwUpgrade(JApplet jApplet, CommonSwitch[] commonSwitchArray, Vector vector) {
        super(jApplet, commonSwitchArray, vector);
        this.constructorInit();
        this.setMaskAllButtons(true);
    }

    private void checkCompatibility(DeviceListItem deviceListItem) {
        String string = deviceListItem.device.switchBoxName;
        if (!Switch.compatible(string, this.firstSwitchType)) {
            this.displayUserError(switchTypeSelectionError);
        }
        if (deviceListItem.device.DRAMSize != this.firstDramSize) {
            this.displayUserError(dramSizeSelectionError);
        }
    }

    protected String getButtonsNeeded() {
        String string = "APPLY CANCEL HELP ";
        return string;
    }

    protected JPanel getContentPanel() {
        this.gui = new SwUpgradeGui();
        return this.gui;
    }

    protected String getHelpUrl() {
        return "upgrdedg";
    }

    protected void getMirrorObjects(Vector vector) {
        vector.addElement(new Upgrade());
    }

    protected DeviceListItem getNewDeviceListItem(CommonSwitch commonSwitch) {
        return new UpgradeListItem(commonSwitch);
    }

    protected String getWindowTitle() {
        return "Software Upgrade";
    }

    protected boolean isDeviceSupported(CommonSwitch commonSwitch) {
        return true;
    }

    protected void isSelectionCompatible(int[] nArray) throws UserInputException {
        DeviceListItem deviceListItem = (DeviceListItem)this.availableListModel.get(nArray[0]);
        this.firstSwitchType = Switch.type(deviceListItem.device.switchBoxName);
        this.firstDramSize = deviceListItem.device.DRAMSize;
        int n = 1;
        while (n < nArray.length) {
            deviceListItem = (DeviceListItem)this.availableListModel.get(nArray[n]);
            this.checkCompatibility(deviceListItem);
            ++n;
        }
        if (this.selectedListModel.getSize() > 0) {
            deviceListItem = (DeviceListItem)this.selectedListModel.get(0);
            this.checkCompatibility(deviceListItem);
        }
    }

    protected void listsChanged() {
        super.listsChanged();
        this.updateBottomButtons();
    }

    protected void updateBottomButtons() {
        this.enableApply = true;
        if (this.selectedListModel.isEmpty()) {
            this.enableApply = false;
        } else if (this.gui.tftpField.getText().trim().equals("")) {
            this.enableApply = false;
        } else if (this.gui.imageField.getText().trim().equals("")) {
            this.enableApply = false;
        }
        this.gui.rebootButton.setEnabled(this.maskButtons ^ true);
        super.updateBottomButtons();
    }

    protected class Upgrade
    implements DeviceMirrorObject,
    ActionListener,
    DocumentListener,
    AdjustmentListener {
        protected boolean upgradeInProgress;
        protected Thread progressThread;
        protected String tftpAddr;
        protected String imageName;
        protected boolean retainImageNames;
        protected JScrollBar vScrollBar;
        protected boolean autoScrollToBottom = true;

        protected Upgrade() {
        }

        static /* synthetic */ SwUpgrade access$0(Upgrade upgrade) {
            return upgrade.SwUpgrade.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SwUpgrade.this.gui.rebootButton) {
                this.rebootButton_Action();
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.vScrollBar.getValueIsAdjusting()) {
                this.autoScrollToBottom = false;
                return;
            }
            int n = this.vScrollBar.getMaximum();
            int n2 = this.vScrollBar.getVisibleAmount();
            int n3 = this.vScrollBar.getValue();
            if (this.autoScrollToBottom) {
                this.vScrollBar.setValue(n);
            } else if (n3 == n - n2) {
                this.autoScrollToBottom = true;
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            SwUpgrade.this.updateBottomButtons();
        }

        protected CommonSwitch getInfoDevice() {
            int n = SwUpgrade.this.devices.length;
            if (n == 1) {
                return SwUpgrade.this.devices[0];
            }
            CommonSwitch commonSwitch = SwUpgrade.this.devices[0];
            int n2 = 0;
            while (n2 < n) {
                String string = SwUpgrade.this.devices[n2].memberType;
                if (string.equals("CC") || string.equals("AC")) {
                    commonSwitch = SwUpgrade.this.devices[n2];
                    break;
                }
                ++n2;
            }
            return commonSwitch;
        }

        protected String getTarFileName() {
            String string = "";
            StringTokenizer stringTokenizer = new StringTokenizer(SwUpgrade.this.gui.imageField.getText(), "/");
            while (stringTokenizer.hasMoreTokens()) {
                string = String.valueOf(string) + stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                string = String.valueOf(string) + "%5c/";
            }
            return string;
        }

        public void hookupListeners() {
            SwUpgrade.this.gui.tftpField.getDocument().addDocumentListener(this);
            SwUpgrade.this.gui.imageField.getDocument().addDocumentListener(this);
            SwUpgrade.this.gui.rebootButton.addActionListener(this);
            this.vScrollBar.addAdjustmentListener(this);
        }

        protected void indicateProgress() {
            this.upgradeInProgress = true;
            this.progressThread = new Thread(this){
                private final /* synthetic */ Upgrade this$1;
                {
                    this.this$1 = upgrade;
                }

                public void run() {
                    int n = 0;
                    while (this.this$1.upgradeInProgress) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        Upgrade.access$0((Upgrade)this.this$1).gui.statusTextArea.append(".");
                        if (++n != 100) continue;
                        Upgrade.access$0((Upgrade)this.this$1).gui.statusTextArea.append("\n");
                        n = 0;
                    }
                    if (n != 0) {
                        Upgrade.access$0((Upgrade)this.this$1).gui.statusTextArea.append("\n");
                    }
                }
            };
            this.progressThread.start();
        }

        public void initializeMembers() {
            SwUpgrade.this.gui.borderStatusPanel.setBorder(BorderFactory.createTitledBorder("Software Upgrade Status Messages"));
            this.vScrollBar = SwUpgrade.this.gui.statusScrollPane.getVerticalScrollBar();
            if (SwUpgrade.this.applet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
                SwUpgrade.this.rebootWarning = "Do you really want to reboot the device?";
                SwUpgrade.this.rebootButtonText = "Reboot Device";
                SwUpgrade.this.rebootStart = "The device";
                SwUpgrade.this.gui.rebootButton.setText(SwUpgrade.this.rebootButtonText);
                SwUpgrade.this.setApplyButtonText("Upgrade Device");
            } else {
                SwUpgrade.this.rebootWarning = "Do you really want to reboot the cluster?";
                SwUpgrade.this.rebootButtonText = "Reboot Cluster";
                SwUpgrade.this.rebootStart = "All devices in the cluster";
                SwUpgrade.this.gui.rebootButton.setText(SwUpgrade.this.rebootButtonText);
                SwUpgrade.this.setApplyButtonText("Upgrade Devices");
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SwUpgrade.this.updateBottomButtons();
        }

        protected void rebootButton_Action() {
            CommonSwitch commonSwitch = null;
            Object var2_2 = null;
            Toolkit.getDefaultToolkit().beep();
            int n = JOptionPane.showOptionDialog(SwUpgrade.this, SwUpgrade.this.rebootWarning, "Reboot?", 0, 3, null, new String[]{SwUpgrade.this.rebootButtonText, "Cancel"}, "Cancel");
            if (n != 0) {
                return;
            }
            SwUpgrade.this.gui.statusTextArea.append("Issuing the reload command... ");
            int n2 = 0;
            while (n2 < SwUpgrade.this.devices.length) {
                commonSwitch = SwUpgrade.this.devices[n2];
                commonSwitch.Cli.saveConfiguration(commonSwitch.esn);
                commonSwitch.Cli.rebootSwitch(commonSwitch.esn, 1);
                ++n2;
            }
            SwUpgrade.this.gui.statusTextArea.append("done.\n");
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(SwUpgrade.this, String.valueOf(SwUpgrade.this.rebootStart) + " will start rebooting in 1 minute" + "\nand the connection will then be lost.", "Warning", 2);
            SwUpgrade.this.dispose();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            SwUpgrade.this.updateBottomButtons();
        }

        public void updateDeviceFromMirror() {
            this.upgradeCopyImages();
        }

        public void updateGuiFromMirror() {
        }

        public void updateMirrorFromDevice() {
        }

        public void updateMirrorFromGui() {
            this.tftpAddr = SwUpgrade.this.gui.tftpField.getText().trim();
            if (!IpAddress.isFormatValid(this.tftpAddr)) {
                SwUpgrade.this.displayUserError("Invalid TFTP server IP address.");
            }
            this.imageName = SwUpgrade.this.gui.imageField.getText().trim();
            this.retainImageNames = SwUpgrade.this.gui.retainCheckBox.isSelected();
        }

        protected void upgradeCopyImages() {
            Object object;
            String string;
            String string2;
            String string3;
            String string4;
            Object var1_1 = null;
            String string5 = null;
            SwUpgrade.this.gui.statusTextArea.append("**** Software Upgrade process has started. ****\n");
            UpgradeListItem upgradeListItem = (UpgradeListItem)SwUpgrade.this.selectedListModel.get(0);
            String string6 = this.getTarFileName();
            int n = Switch.type(upgradeListItem.device.switchBoxName);
            if (n != 0) {
                SwUpgrade.this.gui.statusTextArea.append("Retrieving image name from the tar file. Please Wait...");
                CommonSwitch commonSwitch = this.getInfoDevice();
                string5 = commonSwitch.Cli.extractSingleFileFromTarToFlash(commonSwitch.esn, SwUpgrade.this.gui.tftpField.getText(), string6, null, "info");
                if (string5.indexOf("Operation timed out") != -1) {
                    SwUpgrade.this.gui.statusTextArea.append("failed. Operation timed out.\n");
                    return;
                }
                if (string5.indexOf("Timed out") != -1) {
                    SwUpgrade.this.gui.statusTextArea.append("failed. TFTP Server not found.\n");
                    return;
                }
                if (string5.indexOf("No such file") != -1) {
                    SwUpgrade.this.gui.statusTextArea.append("failed. No such file or directory.\n");
                    return;
                }
                if (string5.indexOf("extracting info") == -1) {
                    SwUpgrade.this.gui.statusTextArea.append("failed. TFTP Server failed.\n");
                    return;
                }
                string5 = commonSwitch.Cli.getFileContents(commonSwitch.esn, "info");
                int n2 = string5.indexOf("image_name: ");
                int n3 = string5.indexOf("image_file_size: ");
                string4 = new String(string5.substring(n2 + 12, n3));
                n2 = n3;
                n3 = string5.indexOf("image_min_dram: ");
                string3 = new String(string5.substring(n2 + 17, n3));
                n2 = n3;
                n3 = string5.indexOf("tar_file_size_k: ");
                string2 = new String(string5.substring(n2 + 16, n3));
                n2 = n3;
                string = new String(string5.substring(n2 + 17, string5.length()));
                SwUpgrade.this.gui.statusTextArea.append("done.\n");
                object = new StringBuffer("**** Software Upgrade will not proceed. ");
                boolean bl = Switch.isImageCompatible(n, string4, (StringBuffer)object);
                if (!bl) {
                    SwUpgrade.this.gui.statusTextArea.append(String.valueOf(String.valueOf(object)) + " ****\n");
                    return;
                }
            } else {
                string4 = "NA";
                string4 = SwUpgrade.this.gui.imageField.getText();
                string3 = "0";
                string2 = "0";
                string = "0";
                SwUpgrade.this.gui.statusTextArea.append("done.\n");
            }
            object = new String[SwUpgrade.this.selectedListModel.size()];
            Thread[] threadArray = new SVUpgrade[SwUpgrade.this.selectedListModel.size()];
            int n4 = 0;
            while (n4 < SwUpgrade.this.selectedListModel.size()) {
                upgradeListItem = (UpgradeListItem)SwUpgrade.this.selectedListModel.get(n4);
                CommonSwitch commonSwitch = upgradeListItem.device;
                String string7 = upgradeListItem.getBootImageName();
                threadArray[n4] = new SVUpgrade(commonSwitch, commonSwitch.esn, string4, string7, string6, SwUpgrade.this.gui.tftpField.getText(), SwUpgrade.this.gui.retainCheckBox.isSelected(), (String[])object, commonSwitch.switchName, string3, string2, string, SwUpgrade.this.selectedListModel.get(0).toString());
                threadArray[n4].setName(String.valueOf(n4));
                SwUpgrade.this.gui.statusTextArea.append("Software upgrade on " + commonSwitch.switchName + " started.\n");
                threadArray[n4].start();
                ++n4;
            }
            SwUpgrade.this.gui.statusTextArea.append("Software upgrade is in progress. Please wait...\n");
            this.indicateProgress();
            this.waitForThreads(threadArray);
            SwUpgrade.this.gui.statusTextArea.append("done.\n");
            int n5 = 0;
            while (n5 < SwUpgrade.this.selectedListModel.size()) {
                SwUpgrade.this.gui.statusTextArea.append(String.valueOf(object[n5]) + "\n");
                ++n5;
            }
        }

        protected void waitForThreads(Thread[] threadArray) {
            int n = 0;
            int n2 = threadArray.length;
            while (n < n2) {
                try {
                    threadArray[n].join();
                    ++n;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.upgradeInProgress = false;
            while (this.progressThread.isAlive()) {
                try {
                    this.progressThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected static class UpgradeListItem
    extends DeviceListItem {
        private String systemImageName;

        public UpgradeListItem(CommonSwitch commonSwitch) {
            super(commonSwitch);
            this.displayString = String.valueOf(this.displayString) + ", " + commonSwitch.switchBoxName + ", ";
            String string = commonSwitch.Cli.getSystemImageName(commonSwitch.esn);
            if (string.startsWith("flash:")) {
                this.displayString = String.valueOf(this.displayString) + string;
                this.systemImageName = string.substring(6);
            } else {
                this.displayString = String.valueOf(this.displayString) + "flash:" + string;
                this.systemImageName = string;
            }
            String string2 = commonSwitch.Cli.getSwVersion(commonSwitch.esn);
            this.displayString = String.valueOf(this.displayString) + ", " + string2;
        }

        public String getBootImageName() {
            String string = this.device.Cli.getBootImageName(this.device.esn);
            if (string.equals("")) {
                string = this.systemImageName;
            }
            return string;
        }

        public String getSystemImageName() {
            return this.systemImageName;
        }
    }
}

