/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class Edge {
    private ClusterPanel parent;
    private final Color activeEdgeColor = new Color(84, 116, 140);
    private final Color blockedEdgeColor = Color.red;
    int from;
    int to;
    double len;
    String lbl;
    String fromDevicePortLbl;
    String toDevicePortLbl;
    Port fromPort = null;
    Port toPort = null;
    boolean bFastEthChannel;
    boolean bDontLabelMe;
    String fromLbl;
    String toLbl = new String("");
    String fromClusterLbl = new String("");
    String toClusterLbl = new String("");
    String fromDeviceLbl = new String("");
    String toDeviceLbl = new String("");
    int fromClusterNode;
    int toClusterNode;
    int fromDeviceNode;
    int toDeviceNode;
    boolean isVisible;
    String FECNum;
    boolean isBlocked = false;
    boolean isGBIC = false;
    private boolean isSelected = false;
    private boolean primary = false;
    private boolean secondary = false;

    public Edge(ClusterPanel clusterPanel) {
        this.parent = clusterPanel;
    }

    public boolean canLaunchLinkGraph() {
        return this.canLaunchLinkReport();
    }

    public boolean canLaunchLinkReport() {
        boolean bl = false;
        Node node = this.fromPort.getDevice();
        Node node2 = this.toPort.getDevice();
        boolean bl2 = false;
        if (!node.isOldDevice() && !node.isRelay() && (node.isMember() || node.isCommand())) {
            bl = true;
        }
        if (!node2.isOldDevice() && !node2.isRelay() && (node2.isMember() || node2.isCommand())) {
            bl = true;
        }
        return bl;
    }

    public Node[] connectedNodes() {
        Node[] nodeArray = new Node[]{this.fromPort.getDevice(), this.toPort.getDevice()};
        return nodeArray;
    }

    public boolean connectedTo(Port port, Port port2) {
        if (port == this.fromPort && port2 == this.toPort) {
            return true;
        }
        return port == this.toPort && port == this.fromPort;
    }

    private void determineVisibility(ClusterPanel clusterPanel, Node node, Node node2) {
        this.isVisible = true;
        if (clusterPanel.bClusterBuilder) {
            if (node2.isDisqualified() || node.isDisqualified()) {
                this.isVisible = false;
            }
            if (!node.candidateNeighborsShown && node2.designation == 2) {
                this.isVisible = false;
            }
            if (!node2.candidateNeighborsShown && node.designation == 2) {
                this.isVisible = false;
            }
            if (node2.isHiddenCandidate || node.isHiddenCandidate) {
                this.isVisible = false;
            }
            if (this.secondary) {
                this.isVisible = false;
            }
        } else if (node2.bStack && node.bStack) {
            this.isVisible = false;
        }
    }

    public boolean isBetter(Edge edge) {
        boolean bl = false;
        if (edge == this) {
            bl = false;
        } else if (!this.isBlocked && edge.isBlocked) {
            bl = true;
        } else if (this.isGBIC && !edge.isGBIC) {
            bl = true;
        } else if (this.bFastEthChannel && !edge.bFastEthChannel) {
            bl = true;
        }
        return bl;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public boolean isNodeConnected(Node node) {
        if (node == this.fromPort.getDevice()) {
            return true;
        }
        return node == this.toPort.getDevice();
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isRazor() {
        return this.isGBIC;
    }

    public boolean isSecondary() {
        return this.secondary;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isValid() {
        return this.fromDevicePortLbl.length() > 0 && this.toDevicePortLbl.length() > 0;
    }

    public void paintEdge(Graphics graphics, ClusterPanel clusterPanel, FontMetrics fontMetrics) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        String string = "";
        String string2 = "";
        int n5 = this.toPort.getDevice().designation;
        int n6 = this.fromPort.getDevice().designation;
        Node node = this.fromPort.getDevice();
        Node node2 = this.toPort.getDevice();
        int n7 = (int)node.x;
        int n8 = (int)node.y;
        int n9 = (int)node2.x;
        int n10 = (int)node2.y;
        this.determineVisibility(clusterPanel, node, node2);
        if (!this.isVisible) {
            return;
        }
        if (!clusterPanel.bClusterBuilder) {
            if (!node.isVisible) {
                n7 = (int)clusterPanel.getCommander().x;
                n8 = (int)clusterPanel.getCommander().y;
            }
            if (!node2.isVisible) {
                n9 = (int)clusterPanel.getCommander().x;
                n10 = (int)clusterPanel.getCommander().y;
            }
        }
        if (!this.toPort.getDevice().bStack || !this.fromPort.getDevice().bStack) {
            graphics.setColor(this.activeEdgeColor);
            graphics.drawLine(n7, n8, n9, n10);
        } else {
            if (this.isBlocked) {
                graphics.setColor(this.blockedEdgeColor);
            } else {
                graphics.setColor(this.activeEdgeColor);
            }
            graphics.drawLine(n7 - 3, n8, n9 - 3, n10);
            graphics.drawLine(n7 - 2, n8, n9 - 2, n10);
            graphics.drawLine(n7 - 1, n8, n9 - 1, n10);
            graphics.drawLine(n7 + 1, n8, n9 + 1, n10);
            graphics.drawLine(n7 + 2, n8, n9 + 2, n10);
            graphics.drawLine(n7 + 3, n8, n9 + 3, n10);
            graphics.drawLine(n7, n8 - 3, n9, n10 - 3);
            graphics.drawLine(n7, n8 - 2, n9, n10 - 2);
            graphics.drawLine(n7, n8 - 1, n9, n10 - 1);
            graphics.drawLine(n7, n8 + 1, n9, n10 + 1);
            graphics.drawLine(n7, n8 + 2, n9, n10 + 2);
            graphics.drawLine(n7, n8 + 3, n9, n10 + 3);
            if (this.bFastEthChannel || this.isGBIC) {
                graphics.setColor(Color.yellow);
                graphics.drawLine(n7, n8, n9, n10);
            }
            if (this.primary) {
                object = ImageFactory.getEntry(ImageFactory.MULTI_LINK).getImage();
                n4 = n7 + (n9 - n7) / 4;
                n3 = n8 + (n10 - n8) / 4;
                n2 = ((Image)object).getWidth(clusterPanel);
                n = ((Image)object).getHeight(clusterPanel);
                graphics.drawImage((Image)object, n4 - n2 / 2, n3 - n / 2, n2, n, clusterPanel);
                n4 = n9 - (n9 - n7) / 4;
                n3 = n10 - (n10 - n8) / 4;
                graphics.drawImage((Image)object, n4 - n2 / 2, n3 - n / 2, n2, n, clusterPanel);
            }
        }
        if (clusterPanel.bLabel) {
            object = this.fromPort.getDevice();
            Node node3 = this.toPort.getDevice();
            if (!clusterPanel.bClusterBuilder) {
                string = String.valueOf(((Node)object).hostLbl) + ":";
                string2 = String.valueOf(node3.hostLbl) + ": ";
            }
            string = !((Node)object).isRelay() ? String.valueOf(string) + this.fromDevicePortLbl : String.valueOf(string) + "";
            if (!node3.isRelay()) {
                string2 = String.valueOf(string2) + this.toDevicePortLbl;
            } else {
                string = String.valueOf(string) + "";
            }
            n = fontMetrics.stringWidth(string) + 10;
            int n11 = fontMetrics.getHeight() + 4;
            int n12 = fontMetrics.stringWidth(string2) + 10;
            if (string.length() > 0) {
                n4 = n7 + (n9 - n7) / 3;
                n3 = n8 + (n10 - n8) / 3;
                graphics.setColor(Color.lightGray);
                graphics.fillRect(n4 - n / 2, n3 - n11 / 2, n, n11);
                graphics.setColor(Color.black);
                graphics.drawString(string, n4 - (n - 10) / 2, n3 - (n11 - 4) / 2 + fontMetrics.getAscent());
            }
            if (string2.length() > 0) {
                n4 = n7 + 2 * (n9 - n7) / 3;
                n3 = n8 + 2 * (n10 - n8) / 3;
                graphics.setColor(Color.lightGray);
                graphics.fillRect(n4 - n12 / 2, n3 - n11 / 2, n12, n11);
                graphics.setColor(Color.black);
                graphics.drawString(string2, n4 - (n12 - 10) / 2, n3 - (n11 - 4) / 2 + fontMetrics.getAscent());
            }
        }
        if (this.isGBIC) {
            object = ImageFactory.getEntry(ImageFactory.GBIC).getImage();
            n4 = n7 + (n9 - n7) / 2;
            n3 = n8 + (n10 - n8) / 2;
            n2 = ((Image)object).getWidth(clusterPanel);
            n = ((Image)object).getHeight(clusterPanel);
            graphics.drawImage((Image)object, n4 - n2 / 2, n3 - n / 2, n2, n, clusterPanel);
        }
        if (clusterPanel.bClusterBuilder && this.isSelected) {
            object = "Selected";
            n4 = n7 + (n9 - n7) / 2;
            n3 = n8 + (n10 - n8) / 2;
            n2 = fontMetrics.stringWidth((String)object) + 10;
            n = fontMetrics.getHeight() + 4;
            graphics.setColor(Color.red);
            graphics.drawString((String)object, n4 - (n2 - 10) / 2, n3 - (n - 4) / 2 + fontMetrics.getAscent());
        }
    }

    public void release() {
        this.lbl = null;
        this.fromDevicePortLbl = null;
        this.toDevicePortLbl = null;
        this.fromPort = null;
        this.toPort = null;
        this.fromLbl = null;
        this.toLbl = null;
        this.fromClusterLbl = null;
        this.toClusterLbl = null;
        this.fromDeviceLbl = null;
        this.toDeviceLbl = null;
        this.FECNum = null;
    }

    public void replaceNode(Node node, RelayNode relayNode) {
        if (node == this.fromPort.getDevice()) {
            node.removeEdge(this, this.fromDevicePortLbl);
            this.fromDevicePortLbl = "";
            this.setFromNode(relayNode);
        } else {
            node.removeEdge(this, this.toDevicePortLbl);
            this.toDevicePortLbl = "";
            this.setToNode(relayNode);
        }
    }

    public void setBlocked(boolean bl) {
        this.isBlocked = bl;
    }

    public void setFromNode(Node node) {
        Port port = node.addEdge(this, this.fromDevicePortLbl);
        this.fromDeviceLbl = node.deviceLbl;
        this.fromPort = port;
    }

    public void setPrimary() {
        this.primary = true;
        this.secondary = false;
    }

    public void setRazor(boolean bl) {
        this.isGBIC = bl;
    }

    public void setSecondary() {
        this.primary = false;
        this.secondary = true;
    }

    public void setSelected(boolean bl) {
        if (this.isSelected != bl) {
            this.isSelected = bl;
            this.parent.repaint();
        }
    }

    public void setToNode(Node node) {
        Port port = node.addEdge(this, this.toDevicePortLbl);
        this.toDeviceLbl = node.deviceLbl;
        this.toPort = port;
    }
}

