/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.SnmpException;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;

public class SASClient {
    public boolean connected = false;
    Socket sock;
    DataInputStream inp;
    DataOutputStream outp;
    boolean DEBUG = false;
    static int SAS_OPEN = 1;
    static int SAS_SEND = 2;
    static int SAS_RECEIVED = 3;
    static int SAS_CLOSE = 4;
    static int SAS_SAVE = 5;
    static int SAS_ERROR = 6;
    static int SAS_APPEND = 7;
    static int SAS_DELETE_FILE = 8;
    static int SAS_CREATE_DIR = 9;
    static int SAS_DELETE_DIR = 10;
    static int SAS_CLIENT_CALL = 11;
    static int SAS_CLIENT_RESPONSE = 12;
    int port;
    int len;
    byte[] data;
    String remoteHost;
    boolean gotResponse = true;
    byte[] callData;
    int CALL_TIMEOUT = 60;

    public SASClient(Applet applet, boolean bl) throws SnmpException {
        String string;
        String string2 = applet.getCodeBase().getHost();
        if (string2.equals("")) {
            string2 = "localhost";
        }
        string = (string = applet.getParameter("SAS_PORT_DIR")) == null ? "./" : String.valueOf(string) + File.separator;
        int n = 0;
        try {
            URL uRL = new URL(applet.getDocumentBase(), String.valueOf(string) + "SASocketPort");
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            String string3 = dataInputStream.readUTF();
            n = Integer.parseInt(string3);
            InetAddress inetAddress = InetAddress.getByName(string2);
            this.sock = new Socket(inetAddress, n, true);
            this.outp = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.inp = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        }
        catch (Exception exception) {
            if (n != 0) {
                System.err.println("Failed to connect: " + string2 + ":" + n + " - " + exception);
            }
            throw new SnmpException("Error: Connecting to Applet Host : " + exception);
        }
        this.connected = true;
    }

    void open(int n) {
        try {
            this.outp.writeInt(SAS_OPEN);
            this.outp.writeInt(n);
            this.outp.flush();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error opening socket at applet host.");
            return;
        }
    }

    public void send(String string, int n, byte[] byArray) throws IOException {
        this.outp.writeInt(SAS_SEND);
        this.outp.writeUTF(string);
        this.outp.writeInt(n);
        int n2 = byArray.length;
        this.outp.writeInt(n2);
        this.outp.write(byArray, 0, n2);
        this.outp.flush();
    }

    public void saveFile(String string, byte[] byArray) throws IOException {
        this.outp.writeInt(SAS_SAVE);
        this.outp.writeUTF(string);
        int n = byArray.length;
        this.outp.writeInt(n);
        this.outp.write(byArray, 0, n);
        this.outp.flush();
    }

    public void appendFile(String string, byte[] byArray) throws IOException {
        this.outp.writeInt(SAS_APPEND);
        this.outp.writeUTF(string);
        int n = byArray.length;
        this.outp.writeInt(n);
        this.outp.write(byArray, 0, n);
        this.outp.flush();
    }

    public void receive() throws SnmpException, IOException {
        int n = -1;
        n = this.inp.readInt();
        if (n == SAS_CLIENT_RESPONSE) {
            int n2 = this.inp.readInt();
            this.callData = new byte[n2];
            this.inp.readFully(this.callData, 0, n2);
            this.gotResponse = true;
            this.receive();
            return;
        }
        if (n != SAS_RECEIVED) {
            throw new SnmpException("Receive error");
        }
        this.remoteHost = this.inp.readUTF();
        this.port = this.inp.readInt();
        this.len = this.inp.readInt();
        this.data = new byte[this.len];
        this.inp.readFully(this.data, 0, this.len);
    }

    public void close() {
        try {
            this.outp.writeInt(SAS_CLOSE);
            this.outp.flush();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public synchronized byte[] clientCall(byte[] byArray) {
        int n;
        this.gotResponse = false;
        this.callData = null;
        try {
            this.outp.writeInt(SAS_CLIENT_CALL);
            n = byArray.length;
            this.outp.writeInt(n);
            this.outp.write(byArray, 0, n);
            this.outp.flush();
        }
        catch (IOException iOException) {
            System.err.println("IO error: " + iOException);
            return null;
        }
        n = 0;
        while (!this.gotResponse) {
            try {
                Thread.sleep(50L);
                if (n++ <= this.CALL_TIMEOUT * 20) continue;
                System.err.println("Client Call Timeout.");
                return null;
            }
            catch (Exception exception) {}
        }
        return this.callData;
    }

    public void createDir(String string) throws IOException {
        this.outp.writeInt(SAS_CREATE_DIR);
        this.outp.writeUTF(string);
        this.outp.flush();
    }

    public void deleteFile(String string) throws IOException {
        this.outp.writeInt(SAS_DELETE_FILE);
        this.outp.writeUTF(string);
        this.outp.flush();
    }

    public void deleteDir(String string) throws IOException {
        this.outp.writeInt(SAS_DELETE_DIR);
        this.outp.writeUTF(string);
        this.outp.flush();
    }
}

