/*
 * Decompiled with CFR 0.152.
 */
import Snmp.SnmpAPI;
import Snmp.SnmpException;
import Snmp.SnmpInt;
import Snmp.SnmpPDU;
import Snmp.SnmpSession;
import Snmp.SnmpString;
import Snmp.SnmpUnsignedInt;
import Snmp.SnmpVarBind;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.javascript.JSObject;

public class LinkDetective
extends Applet
implements Runnable,
ItemListener {
    SnmpAPI api;
    SnmpSession session;
    String ipAddress1;
    String ipAddress2;
    String deviceType1;
    String deviceType2;
    String thisIpAddress;
    String frameName;
    private Thread information_thread;
    private ThreadGroup threadGroup;
    private static final int NO_GROUP = -1;
    private static final int SWITCH_PICTURE = 0;
    private static final int ROUTER_PICTURE = 1;
    private static final int HUB_PICTURE = 2;
    private static final int MWEB_PICTURE = 3;
    private InfoBundle B1;
    private InfoBundle B2;
    private Vector device2Membership;
    private Vector device2Portnames;
    private Hashtable device1ToDevice2;
    private Hashtable device2ToDevice1;
    private String[] imageNames = new String[]{"switch.gif", "router.gif", "hub.gif", "microwebserver.gif"};
    Image[] devicegifs = new Image[this.imageNames.length];
    private boolean EOLflag = false;
    private boolean infoDone = false;
    private boolean infoTransmitted = false;
    private boolean usingFrame2 = true;
    private boolean usingIE = false;
    private static int acounter = 1;
    private static int icounter = 1;
    private boolean errorFlag = false;
    private static final String doneMsg = "Information complete";
    private static final String noSnmpMsg = "SNMP information unavailable";
    private static final String waitMsg = "Please wait...";
    private int spaceCounter;
    private Color GREYCOLOR = new Color(0xE0E0E0);
    private Color BLUECOLOR = new Color(6997472);
    public static final int COMMPORT = 1973;
    public Socket socket;
    private CommThread commthread;
    private String[] STPState = new String[]{"Unknown", "Other", "Disabled", "Blocking", "Listening", "Learning", "Preforwarding", "Forwarding", "Secure Forwarding", "Suspended", "Broken"};
    private String[] portRequests = new String[]{"c2900PortLinkbeatStatus", "c2900PortDuplexStatus", "c2900PortUsageApplication", "c2900PortGroupIndex", "c2900PortIfIndex", "c2900PortStatus"};
    private String[] ifRequests = new String[]{"ifSpeed", "ifDescr", "ifAdminStatus", "ifOperStatus"};
    private Hashtable intVectorMap;
    private Hashtable stringVectorMap;
    private Hashtable hashtableMap;
    DeviceCanvas Device1Canvas;
    DeviceCanvas Device2Canvas;
    LinkCanvas LinkDisplay;
    HelpCanvas OtherPortsCanvas;
    Label IPAddr1Txt;
    Label IPAddr11Txt;
    Label IPAddr2Txt;
    Label IPAddr22Txt;
    Label SpeedTxt;
    Label label4;
    Label Duplex1Txt;
    Label label6;
    List Device1PortList;
    List Device2PortList;
    Label VLANLabel1;
    TextField VLANTxt1;
    Label VLANLabel2;
    TextField VLANTxt2;
    Label NetPortLabel1;
    Label NetPortLabel2;
    TextField NetworkPortTxt1;
    TextField NetworkPortTxt2;
    Label LinkbeatLabel1;
    Label LinkbeatLabel2;
    TextField LinkbeatTxt1;
    TextField LinkbeatTxt2;
    Label Duplex2Txt;
    Label label2;
    TextField StatusMsgTxt;

    public void init() {
        this.frameName = this.getParameter("framename");
        if (!this.frameName.equals("Frame1")) {
            this.finishInit();
            return;
        }
        Font font = new Font("Courier", 3, 14);
        Font font2 = new Font("TimesRoman", 0, 12);
        Font font3 = new Font("Helvetica", 1, 12);
        Font font4 = new Font("Dialog", 0, 12);
        this.setLayout(null);
        this.setSize(500, 360);
        this.setBackground(this.BLUECOLOR);
        this.IPAddr1Txt = new Label("", 1);
        this.IPAddr1Txt.setBounds(14, 12, 182, 19);
        this.IPAddr1Txt.setFont(font);
        this.add(this.IPAddr1Txt);
        this.IPAddr11Txt = new Label("", 1);
        this.IPAddr11Txt.setBounds(14, 23, 182, 26);
        this.IPAddr11Txt.setFont(font);
        this.add(this.IPAddr11Txt);
        this.IPAddr2Txt = new Label("", 1);
        this.IPAddr2Txt.setBounds(300, 12, 182, 19);
        this.IPAddr2Txt.setFont(font);
        this.add(this.IPAddr2Txt);
        this.IPAddr22Txt = new Label("", 1);
        this.IPAddr22Txt.setBounds(300, 23, 182, 26);
        this.IPAddr22Txt.setFont(font);
        this.add(this.IPAddr22Txt);
        this.SpeedTxt = new Label("", 2);
        this.SpeedTxt.setBounds(204, 72, 36, 24);
        this.SpeedTxt.setFont(font2);
        this.add(this.SpeedTxt);
        this.label4 = new Label("MB");
        this.label4.setBounds(252, 72, 48, 24);
        this.label4.setFont(font3);
        this.add(this.label4);
        this.Duplex1Txt = new Label("", 2);
        this.Duplex1Txt.setBounds(48, 84, 36, 24);
        this.Duplex1Txt.setFont(font2);
        this.add(this.Duplex1Txt);
        this.label6 = new Label("Duplex");
        this.label6.setBounds(96, 84, 48, 24);
        this.label6.setFont(font3);
        this.add(this.label6);
        this.Device1PortList = new List(0, false);
        this.add(this.Device1PortList);
        this.Device1PortList.setBounds(20, 132, 132, 72);
        this.Device1PortList.setFont(font3);
        this.Device1PortList.setBackground(this.GREYCOLOR);
        this.Device2PortList = new List(0, false);
        this.add(this.Device2PortList);
        this.Device2PortList.setBounds(344, 132, 132, 72);
        this.Device2PortList.setFont(font3);
        this.Device2PortList.setBackground(this.GREYCOLOR);
        this.VLANLabel1 = new Label("VLANs:", 2);
        this.VLANLabel1.setBounds(12, 216, 48, 24);
        this.VLANLabel1.setFont(font3);
        this.add(this.VLANLabel1);
        this.VLANTxt1 = new TextField();
        this.VLANTxt1.setEditable(false);
        this.VLANTxt1.setBounds(72, 216, 96, 28);
        this.VLANTxt1.setFont(font4);
        ((Component)this.VLANTxt1).setBackground(this.GREYCOLOR);
        this.add(this.VLANTxt1);
        this.VLANLabel2 = new Label("VLANs:", 2);
        this.VLANLabel2.setBounds(336, 216, 48, 24);
        this.VLANLabel2.setFont(font3);
        this.add(this.VLANLabel2);
        this.VLANTxt2 = new TextField();
        this.VLANTxt2.setEditable(false);
        this.VLANTxt2.setBounds(396, 216, 96, 28);
        this.VLANTxt2.setFont(font4);
        ((Component)this.VLANTxt2).setBackground(this.GREYCOLOR);
        this.add(this.VLANTxt2);
        this.NetPortLabel1 = new Label("Network Port");
        this.NetPortLabel1.setBounds(56, 252, 96, 24);
        this.NetPortLabel1.setFont(font3);
        this.add(this.NetPortLabel1);
        this.NetPortLabel2 = new Label("Network Port");
        this.NetPortLabel2.setBounds(380, 252, 96, 24);
        this.NetPortLabel2.setFont(font3);
        this.add(this.NetPortLabel2);
        this.NetworkPortTxt1 = new TextField();
        this.NetworkPortTxt1.setEditable(false);
        this.NetworkPortTxt1.setBounds(24, 256, 16, 18);
        this.NetworkPortTxt1.setFont(font3);
        ((Component)this.NetworkPortTxt1).setBackground(this.GREYCOLOR);
        this.add(this.NetworkPortTxt1);
        this.NetworkPortTxt2 = new TextField();
        this.NetworkPortTxt2.setEditable(false);
        this.NetworkPortTxt2.setBounds(348, 256, 16, 18);
        this.NetworkPortTxt2.setFont(font3);
        ((Component)this.NetworkPortTxt2).setBackground(this.GREYCOLOR);
        this.add(this.NetworkPortTxt2);
        this.LinkbeatLabel1 = new Label("Linkbeat");
        this.LinkbeatLabel1.setBounds(56, 288, 96, 24);
        this.LinkbeatLabel1.setFont(font3);
        this.add(this.LinkbeatLabel1);
        this.LinkbeatLabel2 = new Label("Linkbeat");
        this.LinkbeatLabel2.setBounds(380, 288, 96, 24);
        this.LinkbeatLabel2.setFont(font3);
        this.add(this.LinkbeatLabel2);
        this.LinkbeatTxt1 = new TextField();
        this.LinkbeatTxt1.setEditable(false);
        this.LinkbeatTxt1.setBounds(24, 292, 16, 18);
        ((Component)this.LinkbeatTxt1).setBackground(this.GREYCOLOR);
        this.add(this.LinkbeatTxt1);
        this.LinkbeatTxt2 = new TextField();
        this.LinkbeatTxt2.setEditable(false);
        this.LinkbeatTxt2.setBounds(348, 292, 16, 18);
        ((Component)this.LinkbeatTxt2).setBackground(this.GREYCOLOR);
        this.add(this.LinkbeatTxt2);
        this.Duplex2Txt = new Label("", 2);
        this.Duplex2Txt.setBounds(360, 84, 36, 24);
        this.Duplex2Txt.setFont(font2);
        this.add(this.Duplex2Txt);
        this.label2 = new Label("Duplex");
        this.label2.setBounds(408, 84, 48, 24);
        this.label2.setFont(font3);
        this.add(this.label2);
        this.StatusMsgTxt = new TextField();
        this.StatusMsgTxt.setEditable(false);
        this.StatusMsgTxt.setBounds(12, 324, 480, 28);
        this.StatusMsgTxt.setFont(font4);
        ((Component)this.StatusMsgTxt).setBackground(this.GREYCOLOR);
        this.add(this.StatusMsgTxt);
        this.Device1Canvas = new DeviceCanvas();
        this.Device1Canvas.setBounds(84, 48, 32, 32);
        this.add(this.Device1Canvas);
        this.Device2Canvas = new DeviceCanvas();
        this.Device2Canvas.setBounds(376, 48, 32, 32);
        this.add(this.Device2Canvas);
        this.LinkDisplay = new LinkCanvas();
        this.LinkDisplay.setBounds(84, 54, 292, 12);
        this.add(this.LinkDisplay);
        this.OtherPortsCanvas = new HelpCanvas("Other ports in group", "STP state");
        this.OtherPortsCanvas.setBounds(154, 120, 188, 84);
        this.add(this.OtherPortsCanvas);
        this.finishInit();
    }

    private void finishInit() {
        this.ipAddress1 = this.getParameter("ipaddress1");
        this.ipAddress2 = this.getParameter("ipaddress2");
        this.deviceType1 = this.getParameter("type1");
        this.deviceType2 = this.getParameter("type2");
        if (this.frameName.equals("Frame1")) {
            Object object;
            if (this.ipAddress1.equals(this.ipAddress2)) {
                this.IPAddr1Txt.setText(this.deviceType1);
                this.IPAddr2Txt.setText(this.deviceType2);
            }
            this.IPAddr11Txt.setText(this.ipAddress1);
            this.IPAddr22Txt.setText(this.ipAddress2);
            this.thisIpAddress = this.ipAddress1;
            int n = 0;
            while (n < this.imageNames.length) {
                block9: {
                    object = null;
                    String string = null;
                    try {
                        string = "http://" + this.ipAddress1 + "/" + this.imageNames[n];
                        object = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.devicegifs[n] = null;
                        break block9;
                    }
                    this.devicegifs[n] = this.getImage((URL)object);
                }
                ++n;
            }
            this.Device1Canvas.setDeviceGif(this.getGif(this.deviceType1));
            this.Device2Canvas.setDeviceGif(this.getGif(this.deviceType2));
            object = this.getParameter("useframe");
            if (((String)object).equals("F")) {
                this.usingFrame2 = false;
            }
        } else {
            this.thisIpAddress = this.ipAddress2;
        }
        try {
            String string = System.getProperty("java.vendor");
            System.getProperty("os.name");
            this.usingIE = string.indexOf("Microsoft") != -1;
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    private Image getGif(String string) {
        String[] stringArray = new String[]{"switch", "router", "hub", "mweb200"};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] nArray2 = nArray;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return this.devicegifs[nArray2[n]];
            }
            ++n;
        }
        return this.devicegifs[0];
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        try {
            String string;
            int n;
            String string2;
            int n2 = itemEvent.getStateChange();
            if (this.errorFlag) {
                return;
            }
            if (itemEvent.getItemSelectable() == this.Device1PortList && n2 == 1) {
                string2 = this.Device1PortList.getSelectedItem();
                n = this.Device1PortList.getSelectedIndex();
                this.setInfo(string2, this.B1);
                this.informGraphPort(string2);
                this.Device2PortList.makeVisible(n);
                this.Device2PortList.select(n);
                string = this.Device2PortList.getSelectedItem();
                if (this.usingFrame2) {
                    this.setInfo(string, this.B2);
                }
            }
            if (itemEvent.getItemSelectable() == this.Device2PortList && n2 == 1) {
                string2 = this.Device2PortList.getSelectedItem();
                n = this.Device2PortList.getSelectedIndex();
                if (this.usingFrame2) {
                    this.setInfo(string2, this.B2);
                }
                this.Device1PortList.makeVisible(n);
                this.Device1PortList.select(n);
                string = this.Device1PortList.getSelectedItem();
                this.setInfo(string, this.B1);
                this.informGraphPort(string);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void start() {
        if (this.frameName.equals("Frame1")) {
            ((TextComponent)this.StatusMsgTxt).setText(waitMsg);
        }
        this.errorFlag = false;
        this.B1 = new InfoBundle();
        this.device2Membership = new Vector();
        this.device2Portnames = new Vector();
        this.B2 = new InfoBundle();
        this.device1ToDevice2 = new Hashtable();
        this.device2ToDevice1 = new Hashtable();
        if (this.frameName.equals("Frame1")) {
            this.Device1PortList.addItemListener(this);
            this.Device2PortList.addItemListener(this);
        }
        this.intVectorMap = new Hashtable();
        this.stringVectorMap = new Hashtable();
        this.hashtableMap = new Hashtable();
        this.stringVectorMap.put("linkStatusVector", this.B2.linkStatusVector);
        this.stringVectorMap.put("duplexStatusVector", this.B2.duplexStatusVector);
        this.intVectorMap.put("portStatusVector", this.B2.portStatusVector);
        this.intVectorMap.put("usageVector", this.B2.usageVector);
        this.intVectorMap.put("groupIndexVector", this.B2.groupIndexVector);
        this.intVectorMap.put("ifIndexVector", this.B2.ifIndexVector);
        this.intVectorMap.put("portSpeedVector", this.B2.portSpeedVector);
        this.stringVectorMap.put("portNameVector", this.B2.portNameVector);
        this.intVectorMap.put("portAdminStatusVector", this.B2.portAdminStatusVector);
        this.intVectorMap.put("portOperStatusVector", this.B2.portOperStatusVector);
        this.stringVectorMap.put("membership", this.device2Membership);
        this.stringVectorMap.put("portnames", this.device2Portnames);
        this.hashtableMap.put("portIndexMap", this.B2.portIndexMap);
        this.hashtableMap.put("ifIndexMap", this.B2.ifIndexMap);
        this.information_thread = new Thread((Runnable)this, "LinkDetective-Information-" + icounter++);
        this.information_thread.start();
    }

    public void stop() {
        if (this.frameName.equals("Frame1")) {
            this.Device1PortList.removeItemListener(this);
            this.Device2PortList.removeItemListener(this);
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        int n = threadGroup.activeCount();
        Thread[] threadArray = new Thread[n];
        threadGroup.enumerate(threadArray);
        int n2 = 0;
        while (n2 < n) {
            if (!threadArray[n2].equals(Thread.currentThread())) {
                try {
                    threadArray[n2].checkAccess();
                    threadArray[n2].stop();
                }
                catch (Exception exception) {
                    System.out.println("Not able to stop thread " + threadArray[n2].getName());
                }
            }
            ++n2;
        }
        this.EOLflag = true;
        if (this.information_thread != null) {
            this.information_thread.stop();
            this.information_thread = null;
        }
        this.cleanup();
    }

    private void cleanup() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.api != null) {
            this.api.stop();
            this.api = null;
        }
        if (this.commthread != null) {
            this.commthread.stop();
            this.commthread.closeSockets();
            this.commthread = null;
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
                return;
            }
        }
        catch (IOException iOException) {
            this.socket = null;
        }
    }

    public void run() {
        if (this.frameName.equals("Frame1")) {
            this.clearInformation();
        }
        this.getInformation();
        if (this.frameName.equals("Frame1")) {
            if (!this.errorFlag) {
                this.displayInformation(this.B1);
                if (this.usingFrame2) {
                    if (this.usingIE && !this.ipAddress1.equals(this.ipAddress2)) {
                        this.receiveInformation();
                    } else {
                        this.downloadInformation();
                    }
                    if (this.errorFlag) {
                        this.setUnknownInformation();
                    }
                } else {
                    this.Device2PortList.select(0);
                    this.setUnknownInformation();
                }
            }
            this.completeMessage();
        } else if (this.usingIE && !this.ipAddress1.equals(this.ipAddress2)) {
            this.transmitInformation();
        } else {
            this.uploadInformation();
        }
        this.cleanup();
        this.information_thread = null;
        System.gc();
    }

    private void setUnknownInformation() {
        ((TextComponent)this.VLANTxt2).setText("Unknown");
        this.Duplex2Txt.setText("?");
        this.OtherPortsCanvas.setMessage1("?", 1);
        this.OtherPortsCanvas.setMessage2("Unknown", 1);
        ((Component)this.LinkbeatTxt2).setBackground(Color.black);
        ((Component)this.NetworkPortTxt2).setBackground(Color.black);
    }

    private void clearInformation() {
        this.Device1PortList.removeAll();
        this.Device2PortList.removeAll();
        int n = 0;
        while (n < 2) {
            this.OtherPortsCanvas.setMessage1("", n);
            this.OtherPortsCanvas.setMessage2("", n);
            this.OtherPortsCanvas.setMessage1Ext("", n);
            ++n;
        }
        ((Component)this.NetworkPortTxt1).setBackground(this.GREYCOLOR);
        ((Component)this.NetworkPortTxt2).setBackground(this.GREYCOLOR);
        ((Component)this.LinkbeatTxt1).setBackground(this.GREYCOLOR);
        ((Component)this.LinkbeatTxt2).setBackground(this.GREYCOLOR);
        this.Duplex1Txt.setText("");
        this.Duplex2Txt.setText("");
        ((TextComponent)this.VLANTxt1).setText("");
        ((TextComponent)this.VLANTxt2).setText("");
        this.SpeedTxt.setText("");
    }

    private void sendInfoVar(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        JSObject jSObject = JSObject.getWindow((Applet)this);
        jSObject.call("sendInfoVar", objectArray);
    }

    private void getInformation() {
        try {
            Object object;
            int n;
            Object object2;
            String string;
            Object object3;
            String string2;
            Object object4;
            String string3;
            this.updateDevicePictures();
            this.api = new SnmpAPI();
            this.api.start();
            while (this.api.client == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            new ThreadGroup("LinkReportGroup" + icounter);
            this.session = new SnmpSession(this.api);
            this.session.peername = this.thisIpAddress;
            this.session.community = string3 = this.getParameter("snmp");
            this.session.retries = 2;
            this.session.timeout = 4000;
            try {
                this.session.open();
            }
            catch (SnmpException snmpException) {
                System.err.println(snmpException.getMessage());
                return;
            }
            int n2 = 0;
            SnmpPDUExt snmpPDUExt = null;
            SnmpPDU snmpPDU = null;
            String string4 = ".0";
            String string5 = SnmpPDUExt.getMibVar(this.portRequests[0]);
            int n3 = 0;
            boolean bl = false;
            while (!bl) {
                ++n3;
                this.updateDevicePictures();
                snmpPDUExt = new SnmpPDUExt(this.api);
                snmpPDUExt.command = (byte)-95;
                snmpPDUExt.addRequestList(this.portRequests, string4);
                snmpPDU = this.requestFromSNMP(snmpPDUExt);
                if (snmpPDU != null) {
                    if (snmpPDU.errstat != 0) break;
                    object4 = (SnmpVarBind)snmpPDU.variables.elementAt(0);
                    string2 = ((SnmpVarBind)object4).oid.toString();
                    if (string2.startsWith(string5)) {
                        string4 = string2.substring(string5.length());
                        this.recordPortData(snmpPDU, n2, 0);
                    } else {
                        bl = true;
                    }
                } else {
                    this.errorFlag = true;
                    return;
                }
                ++n2;
            }
            this.B1.portSpeedVector.setSize(this.B1.ifIndexVector.size());
            this.B1.portNameVector.setSize(this.B1.ifIndexVector.size());
            this.B1.portAdminStatusVector.setSize(this.B1.ifIndexVector.size());
            this.B1.portOperStatusVector.setSize(this.B1.ifIndexVector.size());
            object4 = SnmpPDUExt.getMibVar(this.ifRequests[0]);
            snmpPDUExt = new SnmpPDUExt(this.api);
            snmpPDUExt.command = (byte)-96;
            snmpPDUExt.addRequest("ifNumber", ".0");
            snmpPDU = this.requestFromSNMP(snmpPDUExt);
            if (snmpPDU != null && snmpPDU.errstat == 0) {
                ((SnmpInt)((SnmpVarBind)snmpPDU.variables.elementAt((int)0)).variable).intValue();
                int n4 = 0;
                bl = false;
                string4 = ".0";
                while (!bl) {
                    snmpPDUExt = new SnmpPDUExt(this.api);
                    snmpPDUExt.command = (byte)-95;
                    snmpPDUExt.addRequestList(this.ifRequests, "." + string4);
                    snmpPDU = this.requestFromSNMP(snmpPDUExt);
                    if (snmpPDU != null) {
                        if (snmpPDU.errstat == 0) {
                            object3 = (SnmpVarBind)snmpPDU.variables.elementAt(0);
                            string = ((SnmpVarBind)object3).oid.toString();
                            if (string.startsWith((String)object4)) {
                                string4 = string.substring(((String)object4).length());
                                object2 = (Integer)this.B1.ifIndexMap.get(string4);
                                if (object2 != null) {
                                    int n5 = (Integer)object2;
                                    n = (int)((SnmpUnsignedInt)((SnmpVarBind)object3).variable).longValue() / 1000000;
                                    this.B1.portSpeedVector.setElementAt(new Integer(n), n5);
                                    object3 = (SnmpVarBind)snmpPDU.variables.elementAt(1);
                                    object = (String)((SnmpString)((SnmpVarBind)object3).variable).toValue();
                                    if (((String)object).startsWith("ATM") && ((String)object).indexOf("/") == -1) {
                                        object = String.valueOf(object) + "/1";
                                    }
                                    this.B1.portNameVector.setElementAt(object, n5);
                                    object = ((String)object).replace('/', '.');
                                    this.B1.portIndexMap.put(((String)object).trim(), object2);
                                    object3 = (SnmpVarBind)snmpPDU.variables.elementAt(2);
                                    this.B1.portAdminStatusVector.setElementAt(new Integer(((SnmpInt)((SnmpVarBind)object3).variable).intValue()), n5);
                                    object3 = (SnmpVarBind)snmpPDU.variables.elementAt(3);
                                    this.B1.portOperStatusVector.setElementAt(new Integer(((SnmpInt)((SnmpVarBind)object3).variable).intValue()), n5);
                                }
                            } else {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        this.errorFlag = true;
                        return;
                    }
                    ++n4;
                }
            }
            if (this.frameName.equals("Frame1")) {
                string4 = ".0";
                string5 = SnmpPDUExt.getMibVar("cdpCacheAddress");
                this.Device1PortList.removeAll();
                this.Device2PortList.removeAll();
                while (!string4.equals("")) {
                    this.updateDevicePictures();
                    snmpPDUExt = new SnmpPDUExt(this.api);
                    snmpPDUExt.command = (byte)-95;
                    snmpPDUExt.addRequest("cdpCacheAddress", string4);
                    snmpPDUExt.addRequest("cdpCacheDeviceId", string4);
                    snmpPDUExt.addRequest("cdpCacheDevicePort", string4);
                    snmpPDU = this.requestFromSNMP(snmpPDUExt);
                    if (snmpPDU != null) {
                        string2 = (SnmpVarBind)snmpPDU.variables.elementAt(0);
                        object3 = ((SnmpVarBind)string2).oid.toString();
                        if (((String)object3).startsWith(string5)) {
                            String string6;
                            String string7;
                            byte[] byArray;
                            String string8;
                            string = (SnmpVarBind)snmpPDU.variables.elementAt(1);
                            object2 = ((SnmpVarBind)string).variable.toString();
                            string4 = ((String)object3).substring(string5.length());
                            String string9 = string4.substring(1, string4.lastIndexOf("."));
                            n = Integer.parseInt(string9);
                            object = (Integer)this.B1.ifIndexMap.get("." + n);
                            if (object == null || !(string8 = this.convertIpAddr(byArray = ((SnmpVarBind)string2).variable.toBytes())).equals(this.ipAddress2)) continue;
                            if (this.ipAddress1.equals(this.ipAddress2)) {
                                if (!((String)object2).startsWith(this.deviceType2)) continue;
                                string2 = (SnmpVarBind)snmpPDU.variables.elementAt(2);
                                string7 = (String)this.B1.portNameVector.elementAt((Integer)object);
                                string6 = (String)((SnmpString)((SnmpVarBind)string2).variable).toValue();
                                this.device1ToDevice2.put(string7, string6);
                                this.device2ToDevice1.put(string6, string7);
                                this.Device1PortList.add(string7);
                                this.Device2PortList.add(string6);
                                continue;
                            }
                            string2 = (SnmpVarBind)snmpPDU.variables.elementAt(2);
                            string7 = (String)this.B1.portNameVector.elementAt((Integer)object);
                            string6 = (String)((SnmpString)((SnmpVarBind)string2).variable).toValue();
                            this.device1ToDevice2.put(string7, string6);
                            this.device2ToDevice1.put(string6, string7);
                            this.Device1PortList.add(string7);
                            this.Device2PortList.add(string6);
                            continue;
                        }
                        string4 = "";
                        continue;
                    }
                    string4 = "";
                }
                this.Device1PortList.setBounds(19, 132, 132, 72);
                this.Device2PortList.setBounds(345, 132, 132, 72);
                return;
            }
        }
        catch (Exception exception) {
            this.errorFlag = true;
        }
    }

    private void updateDevicePictures() {
        if (this.frameName.equals("Frame1")) {
            this.Device1Canvas.repaint();
            this.Device2Canvas.repaint();
        }
    }

    private void recordPortData(SnmpPDU snmpPDU, int n, int n2) {
        String string = SnmpPDUExt.getMibVar(this.portRequests[0]);
        SnmpVarBind snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n2);
        String string2 = snmpVarBind.oid.toString();
        String string3 = ((SnmpInt)snmpVarBind.variable).intValue() == 2 ? "X" : "O";
        this.B1.linkStatusVector.addElement(string3);
        snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n2 + 1);
        string3 = ((SnmpInt)snmpVarBind.variable).intValue() == 1 ? "Full" : "Half";
        this.B1.duplexStatusVector.addElement(string3);
        snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n2 + 2);
        int n3 = ((SnmpInt)snmpVarBind.variable).intValue();
        this.B1.usageVector.addElement(new Integer(n3));
        snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n2 + 5);
        int n4 = ((SnmpInt)snmpVarBind.variable).intValue();
        this.B1.portStatusVector.addElement(new Integer(n4));
        switch (n3) {
            case 4: 
            case 6: {
                snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n2 + 3);
                this.B1.groupIndexVector.addElement(new Integer(((SnmpInt)snmpVarBind.variable).intValue()));
                break;
            }
            default: {
                this.B1.groupIndexVector.addElement(new Integer(-1));
            }
        }
        snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n2 + 4);
        int n5 = ((SnmpInt)snmpVarBind.variable).intValue();
        this.B1.ifIndexMap.put("." + n5, new Integer(n));
        this.B1.ifIndexVector.addElement(new Integer(n5));
        string2.substring(string.length());
    }

    private String convertIpAddr(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            string = String.valueOf(string) + n2;
            if (n != byArray.length - 1) {
                string = String.valueOf(string) + ".";
            }
            ++n;
        }
        return string;
    }

    private void setInfo(String string, InfoBundle infoBundle) {
        int n;
        int n2;
        int n3;
        String string2;
        Label label;
        TextField textField;
        TextField textField2;
        TextField textField3;
        if (infoBundle == this.B1) {
            textField3 = this.VLANTxt1;
            textField2 = this.NetworkPortTxt1;
            textField = this.LinkbeatTxt1;
            label = this.Duplex1Txt;
        } else {
            textField3 = this.VLANTxt2;
            textField2 = this.NetworkPortTxt2;
            textField = this.LinkbeatTxt2;
            label = this.Duplex2Txt;
        }
        String string3 = string.replace('/', '.');
        int n4 = (Integer)infoBundle.portIndexMap.get(string3);
        String string4 = (String)infoBundle.duplexStatusVector.elementAt(n4);
        label.setText(string4);
        int n5 = (Integer)infoBundle.usageVector.elementAt(n4);
        Color color = n5 == 5 || n5 == 6 ? Color.green : this.GREYCOLOR;
        ((Component)textField2).setBackground(color);
        string4 = (String)infoBundle.linkStatusVector.elementAt(n4);
        color = string4.equals("X") ? (string4.equals("X") ? Color.green : this.GREYCOLOR) : (string4.equals("O") ? Color.green : this.GREYCOLOR);
        ((Component)textField).setBackground(color);
        int n6 = (Integer)infoBundle.ifIndexVector.elementAt(n4);
        int n7 = (Integer)infoBundle.ifIndexMap.get("." + n6);
        string4 = (String)infoBundle.portNameVector.elementAt(n7);
        JSObject jSObject = JSObject.getWindow((Applet)this);
        Object[] objectArray = new Object[1];
        int n8 = 0;
        while (n8 < infoBundle.portNameVector.size()) {
            objectArray[0] = new Integer(n8);
            String string5 = string2 = infoBundle == this.B1 ? (String)jSObject.call("getName", objectArray) : (String)this.device2Portnames.elementAt(n8);
            if (string2.equals(string4)) break;
            ++n8;
        }
        string2 = infoBundle == this.B1 ? (String)jSObject.call("getVlans", objectArray) : (String)this.device2Membership.elementAt(n8);
        ((TextComponent)textField3).setText(string2);
        Vector<Integer> vector = new Vector<Integer>();
        int n9 = (Integer)infoBundle.portSpeedVector.elementAt(n7);
        if ((n5 == 4 || n5 == 6) && (n3 = ((Integer)infoBundle.groupIndexVector.elementAt(n4)).intValue()) != -1) {
            n2 = 0;
            while (n2 < infoBundle.groupIndexVector.size()) {
                if (n2 != n4 && n3 == (Integer)infoBundle.groupIndexVector.elementAt(n2)) {
                    vector.addElement(new Integer(n2));
                }
                ++n2;
            }
        }
        String[] stringArray = new String[]{vector.size() == 0 ? "None" : "", ""};
        n2 = 0;
        while (n2 < vector.size()) {
            n4 = (Integer)vector.elementAt(n2);
            n6 = (Integer)infoBundle.ifIndexVector.elementAt(n4);
            n7 = (Integer)infoBundle.ifIndexMap.get("." + n6);
            n = (Integer)infoBundle.portSpeedVector.elementAt(n7);
            if (n > n9) {
                n9 = n;
            }
            if (n2 <= 6) {
                int n10 = Math.min(n2, 5) / 3;
                if (!stringArray[n10].equals("")) {
                    stringArray[n10] = String.valueOf(stringArray[n10]) + ", ";
                }
                if (n2 == 6) {
                    stringArray[n10] = String.valueOf(stringArray[n10]) + "...";
                } else {
                    string4 = (String)infoBundle.portNameVector.elementAt(n7);
                    stringArray[n10] = String.valueOf(stringArray[n10]) + string4.substring(string4.indexOf("/") - 1);
                }
            }
            ++n2;
        }
        n = (Integer)infoBundle.portStatusVector.elementAt(n4);
        if (infoBundle == this.B1) {
            this.SpeedTxt.setText(String.valueOf(n9));
            this.OtherPortsCanvas.setMessage1(stringArray[0], 0);
            this.OtherPortsCanvas.setMessage1Ext(stringArray[1], 0);
            this.OtherPortsCanvas.setMessage2(this.STPState[n], 0);
            return;
        }
        this.OtherPortsCanvas.setMessage1(stringArray[0], 1);
        this.OtherPortsCanvas.setMessage1Ext(stringArray[1], 1);
        this.OtherPortsCanvas.setMessage2(this.STPState[n], 1);
    }

    private void displayInformation(InfoBundle infoBundle) {
        if (infoBundle == this.B1) {
            if (this.Device1PortList.getItemCount() > 0) {
                this.Device1PortList.select(0);
                String string = this.Device1PortList.getSelectedItem();
                this.setInfo(string, this.B1);
                this.informGraphPort(string);
            }
        } else if (this.Device2PortList.getItemCount() > 0) {
            this.Device2PortList.select(0);
            String string = this.Device2PortList.getSelectedItem();
            this.setInfo(string, this.B2);
        }
        this.OtherPortsCanvas.repaint();
    }

    public void transmitInformation() {
        if (!this.errorFlag) {
            Transmitter transmitter = new Transmitter(this);
            JSObject jSObject = JSObject.getWindow((Applet)this);
            transmitter.transmitInformation(this.B1, jSObject);
        }
    }

    private void receiveInformation() {
        this.commthread = new CommThread(this.B2, this);
        this.commthread.start();
        int n = 0;
        while (!this.commthread.doneFlag) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            if (n++ <= 240) continue;
            this.commthread.stop();
            this.errorFlag = true;
            break;
        }
        this.commthread = null;
        if (!this.errorFlag) {
            this.displayInformation(this.B2);
        }
    }

    private void downloadInformation() {
        int n = 0;
        while (!this.infoTransmitted) {
            try {
                Object[] objectArray = new Object[]{""};
                JSObject jSObject = JSObject.getWindow((Applet)this);
                jSObject.call("fetchInfoVars", objectArray);
            }
            catch (Exception exception) {
                this.errorFlag = true;
                break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            if (n++ <= 240) continue;
            this.errorFlag = true;
            break;
        }
        if (!this.errorFlag) {
            this.displayInformation(this.B2);
        }
    }

    private void uploadInformation() {
        if (!this.errorFlag) {
            Object object;
            int n = 0;
            while (n < this.B1.linkStatusVector.size()) {
                this.sendInfoVar("linkStatusVector[" + n + "]", this.B1.linkStatusVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.duplexStatusVector.size()) {
                this.sendInfoVar("duplexStatusVector[" + n + "]", this.B1.duplexStatusVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.portStatusVector.size()) {
                this.sendInfoVar("portStatusVector[" + n + "]", this.B1.portStatusVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.usageVector.size()) {
                this.sendInfoVar("usageVector[" + n + "]", this.B1.usageVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.groupIndexVector.size()) {
                this.sendInfoVar("groupIndexVector[" + n + "]", this.B1.groupIndexVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.ifIndexVector.size()) {
                this.sendInfoVar("ifIndexVector[" + n + "]", this.B1.ifIndexVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.portSpeedVector.size()) {
                this.sendInfoVar("portSpeedVector[" + n + "]", this.B1.portSpeedVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.portNameVector.size()) {
                this.sendInfoVar("portNameVector[" + n + "]", this.B1.portNameVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.portAdminStatusVector.size()) {
                this.sendInfoVar("portAdminStatusVector[" + n + "]", this.B1.portAdminStatusVector.elementAt(n).toString());
                ++n;
            }
            n = 0;
            while (n < this.B1.portOperStatusVector.size()) {
                this.sendInfoVar("portOperStatusVector[" + n + "]", this.B1.portOperStatusVector.elementAt(n).toString());
                ++n;
            }
            Enumeration enumeration = this.B1.portIndexMap.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.sendInfoVar("portIndexMap[" + (String)object + "]", this.B1.portIndexMap.get(object).toString());
            }
            enumeration = this.B1.ifIndexMap.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.sendInfoVar("ifIndexMap[" + (String)object + "]", this.B1.ifIndexMap.get(object).toString());
            }
            object = JSObject.getWindow((Applet)this);
            int n2 = this.B1.portNameVector.size();
            Object[] objectArray = new Object[1];
            n = 0;
            while (n < n2) {
                objectArray[0] = new Integer(n);
                this.sendInfoVar("membership[" + n + "]", (String)((JSObject)object).call("getVlans", objectArray));
                ++n;
            }
            n = 0;
            while (n < n2) {
                objectArray[0] = new Integer(n);
                this.sendInfoVar("portnames[" + n + "]", (String)((JSObject)object).call("getName", objectArray));
                ++n;
            }
            this.sendInfoVar("DONE", "TRUE");
        }
    }

    private void informGraphPort(String string) {
        Object[] objectArray = new Object[1];
        String string2 = string.substring(string.indexOf("/") - 1);
        objectArray[0] = "\"FAS~" + string2 + "\"";
        JSObject jSObject = JSObject.getWindow((Applet)this);
        jSObject.call("launchGraph", objectArray);
    }

    private String parseIndex(String string) {
        String string2 = string.substring(string.indexOf("/") - 1);
        return string2.replace('/', '.');
    }

    public void reportInfoSet(String string, String string2) {
        this.infoTransmitted = true;
        String string3 = string.substring(0, string.indexOf("["));
        Vector vector = (Vector)this.intVectorMap.get(string3);
        if (vector != null) {
            vector.addElement(new Integer(Integer.parseInt(string2)));
            return;
        }
        vector = (Vector)this.stringVectorMap.get(string3);
        if (vector != null) {
            vector.addElement(string2);
            return;
        }
        Hashtable hashtable = (Hashtable)this.hashtableMap.get(string3);
        if (hashtable != null) {
            String string4 = string.substring(string3.length() + 1, string.length() - 1);
            hashtable.put(string4, new Integer(Integer.parseInt(string2)));
        }
    }

    private SnmpPDU requestFromSNMP(SnmpPDU snmpPDU) {
        int n;
        SnmpPDU snmpPDU2 = null;
        try {
            n = this.session.send(snmpPDU);
        }
        catch (SnmpException snmpException) {
            return null;
        }
        boolean bl = false;
        do {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {}
            snmpPDU2 = this.session.receive(n);
            bl = this.session.checkTimeout(n);
        } while (snmpPDU2 == null && !bl);
        return snmpPDU2;
    }

    private void completeMessage() {
        this.infoDone = true;
        if (this.errorFlag) {
            ((TextComponent)this.StatusMsgTxt).setText(noSnmpMsg);
            return;
        }
        ((TextComponent)this.StatusMsgTxt).setText(doneMsg);
    }

    public int commPort() {
        String string;
        int n;
        String string2 = this.ipAddress1.substring(this.ipAddress1.lastIndexOf(".") + 1);
        int n2 = Integer.parseInt(string2);
        int n3 = (n2 << 8) + (n = Integer.parseInt(string = this.ipAddress2.substring(this.ipAddress2.lastIndexOf(".") + 1)));
        if (n3 < 1024) {
            n3 += 1024;
        }
        return n3;
    }
}

