/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.ASNTypes;
import Snmp.SnmpException;
import Snmp.SnmpVar;
import java.io.ByteArrayInputStream;

public class SnmpString
extends SnmpVar {
    protected String value;
    protected byte[] byteValue;

    public SnmpString(String string) {
        this.value = string == null ? new String("") : new String(string);
        this.Type = (byte)4;
    }

    public Object toValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public String toTagString() {
        return new String("STRING: " + this.value);
    }

    public String toByteString() {
        String string = this.value;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(String.valueOf(Integer.toString(ASNTypes.byteToInt(byArray[n]), 16)) + " ");
            ++n;
        }
        string = stringBuffer.toString();
        return string;
    }

    public byte[] toBytes() {
        return this.byteValue;
    }

    byte[] encode() {
        int n = this.value.length();
        byte[] byArray = ASNTypes.build_header((byte)4, n);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.value.getBytes(0, n, byArray2, byArray.length);
        return byArray2;
    }

    boolean decode(ByteArrayInputStream byteArrayInputStream, int n) throws SnmpException {
        ASNTypes.checkStream(byteArrayInputStream, n);
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, n);
        this.byteValue = byArray;
        this.value = new String(byArray, 0);
        return true;
    }
}

