/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.ASNTypes;
import Snmp.SnmpAPI;
import Snmp.SnmpException;
import Snmp.SnmpInt;
import Snmp.SnmpIpAddress;
import Snmp.SnmpNull;
import Snmp.SnmpOID;
import Snmp.SnmpString;
import Snmp.SnmpTimeticks;
import Snmp.SnmpVar;
import Snmp.SnmpVarBind;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpPDU {
    public InetAddress address;
    public String remoteHost;
    public int remotePort;
    public byte command;
    public int reqid;
    public int errstat;
    public int errindex;
    public SnmpOID enterprise;
    public InetAddress agent_addr;
    public int trap_type;
    public int specific_type;
    public long time;
    public Vector variables;
    public String community;
    public byte[] data;
    public int version = SnmpAPI.SNMP_VERSION_1;
    private SnmpAPI API;
    long time_sent;
    long time_expires;
    long time_received;
    int retries;

    public SnmpPDU(SnmpAPI snmpAPI) {
        this.API = snmpAPI;
        this.variables = new Vector();
        this.enterprise = new SnmpOID(SnmpAPI.Standard_Prefix);
    }

    public void addNull(SnmpOID snmpOID) {
        SnmpVarBind snmpVarBind = new SnmpVarBind();
        snmpVarBind.oid = snmpOID;
        snmpVarBind.variable = new SnmpNull();
        this.variables.addElement(snmpVarBind);
    }

    public void fix() {
        if (this.errindex > 0) {
            this.variables.removeElementAt(this.errindex - 1);
        }
    }

    public long round_trip_delay() {
        if (this.time_received > 0L) {
            return this.time_received - this.time_sent;
        }
        return -1L;
    }

    public String printVarBinds() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            stringBuffer.append(snmpVarBind.toTagString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int get_encoded_length() {
        this.encode();
        if (this.data != null) {
            return this.data.length;
        }
        return -1;
    }

    boolean encode() {
        Object object;
        Object object2;
        Object object3;
        byte[][] byArray = new byte[this.variables.size()][];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        byte[] byArray8 = null;
        byte[] byArray9 = null;
        byte[] byArray10 = null;
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            byArray[n] = snmpVarBind.encode();
            if (byArray[n] == null) {
                return this.error("Encoding variable binding - prob. has undef. (null) element: reqid" + this.reqid);
            }
            n2 += byArray[n++].length;
        }
        byArray10 = ASNTypes.build_header((byte)48, (int)n2);
        if (byArray10 == null) {
            return this.error("Encoding PDU: reqid: " + this.reqid);
        }
        n2 += byArray10.length;
        if (this.command != -92) {
            object3 = new SnmpInt(this.reqid);
            object2 = new SnmpInt(this.errstat);
            object = new SnmpInt(this.errindex);
            byArray2 = object3.encode();
            if (byArray2 == null || (byArray3 = object2.encode()) == null || (byArray4 = object.encode()) == null) {
                return this.error("Encoding PDU: reqid: " + this.reqid);
            }
            n2 += byArray2.length + byArray3.length + byArray4.length;
        } else {
            object3 = null;
            object3 = this.agent_addr != null ? new SnmpIpAddress(this.agent_addr.getAddress()) : new SnmpIpAddress("0.0.0.0");
            object2 = new SnmpInt(this.trap_type);
            object = new SnmpInt(this.specific_type);
            SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.time);
            byArray5 = this.enterprise.encode();
            if (byArray5 == null || (byArray6 = object3.encode()) == null || (byArray7 = object2.encode()) == null || (byArray8 = object.encode()) == null || (byArray9 = snmpTimeticks.encode()) == null) {
                return this.error("Cannot encode trap variables.");
            }
            n2 += byArray5.length + byArray6.length + byArray7.length;
            n2 += byArray8.length + byArray9.length;
        }
        object3 = ASNTypes.build_header((byte)this.command, (int)n2);
        if (object3 == null) {
            return this.error("Encoding PDU: reqid: " + this.reqid);
        }
        object2 = this.buildAuth(n2 += ((SnmpInt)object3).length);
        if (object2 == null) {
            return this.error("Encoding PDU: reqid: " + this.reqid);
        }
        object = new ByteArrayOutputStream();
        ((ByteArrayOutputStream)object).write((byte[])object2, 0, ((SnmpInt)object2).length);
        ((ByteArrayOutputStream)object).write((byte[])object3, 0, ((SnmpInt)object3).length);
        if (this.command != -92) {
            ((ByteArrayOutputStream)object).write(byArray2, 0, byArray2.length);
            ((ByteArrayOutputStream)object).write(byArray3, 0, byArray3.length);
            ((ByteArrayOutputStream)object).write(byArray4, 0, byArray4.length);
        } else {
            ((ByteArrayOutputStream)object).write(byArray5, 0, byArray5.length);
            ((ByteArrayOutputStream)object).write(byArray6, 0, byArray6.length);
            ((ByteArrayOutputStream)object).write(byArray7, 0, byArray7.length);
            ((ByteArrayOutputStream)object).write(byArray8, 0, byArray8.length);
            ((ByteArrayOutputStream)object).write(byArray9, 0, byArray9.length);
        }
        ((ByteArrayOutputStream)object).write(byArray10, 0, byArray10.length);
        int n3 = 0;
        while (n3 < this.variables.size()) {
            ((ByteArrayOutputStream)object).write(byArray[n3], 0, byArray[n3].length);
            ++n3;
        }
        this.data = ((ByteArrayOutputStream)object).toByteArray();
        return true;
    }

    public boolean decode() throws SnmpException {
        String string;
        if (this.data == null) {
            return this.error("Parse Error: No data to decode.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
        if (this.parseAuth(byteArrayInputStream) == null) {
            return this.error("Parse Error: Decoding auth");
        }
        SnmpVar snmpVar = null;
        int[] nArray = ASNTypes.parse_header((ByteArrayInputStream)byteArrayInputStream);
        this.command = (byte)nArray[0];
        if (this.command != -92) {
            snmpVar = this.decodeType(byteArrayInputStream, (byte)2);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding reqid.");
            }
            this.reqid = (Integer)snmpVar.toValue();
            snmpVar = this.decodeType(byteArrayInputStream, (byte)2);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding errstat.");
            }
            this.errstat = (Integer)snmpVar.toValue();
            snmpVar = this.decodeType(byteArrayInputStream, (byte)2);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding errindex.");
            }
            this.errindex = (Integer)snmpVar.toValue();
        } else {
            snmpVar = this.decodeType(byteArrayInputStream, (byte)6);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding enterprise.");
            }
            this.enterprise = (SnmpOID)snmpVar;
            snmpVar = this.decodeType(byteArrayInputStream, (byte)64);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding agent_address.");
            }
            try {
                string = (String)snmpVar.toValue();
                byte[] byArray = new byte[4];
                string.getBytes(0, 4, byArray, 0);
                SnmpIpAddress cfr_ignored_0 = (SnmpIpAddress)snmpVar;
                this.agent_addr = InetAddress.getByName(SnmpIpAddress.netbToString((byte[])byArray));
            }
            catch (UnknownHostException unknownHostException) {
                this.API.client.debugPrint("Unknown Host: " + (SnmpString)snmpVar);
            }
            catch (SecurityException securityException) {
                System.err.println("Security error decoding agent address.");
            }
            snmpVar = this.decodeType(byteArrayInputStream, (byte)2);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding trap_type.");
            }
            this.trap_type = (Integer)snmpVar.toValue();
            snmpVar = this.decodeType(byteArrayInputStream, (byte)2);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding specific_type.");
            }
            this.specific_type = (Integer)snmpVar.toValue();
            snmpVar = this.decodeType(byteArrayInputStream, (byte)67);
            if (snmpVar == null) {
                return this.error("Parse Error: Decoding uptime.");
            }
            this.time = (Long)snmpVar.toValue();
        }
        nArray = ASNTypes.parse_header((ByteArrayInputStream)byteArrayInputStream);
        string = null;
        int n = byteArrayInputStream.available();
        while (n - byteArrayInputStream.available() < nArray[1]) {
            string = new SnmpVarBind();
            string.decode(byteArrayInputStream);
            this.variables.addElement(string);
        }
        return true;
    }

    private String parseAuth(ByteArrayInputStream byteArrayInputStream) throws SnmpException {
        SnmpVar snmpVar = null;
        int[] nArray = ASNTypes.parse_header((ByteArrayInputStream)byteArrayInputStream);
        if (nArray == null) {
            return null;
        }
        if (nArray[0] != 48) {
            throw new SnmpException("Parse Auth: Incorrect ASN header");
        }
        snmpVar = ASNTypes.decodeVar((ByteArrayInputStream)byteArrayInputStream);
        if (snmpVar.Type != 2) {
            throw new SnmpException("Parse Version: Incorrect ASN header");
        }
        this.version = (Integer)snmpVar.toValue();
        if (this.version != SnmpAPI.SNMP_VERSION_1) {
            System.err.println("Parse Error: Wrong SNMP Version: " + this.version);
            System.err.println("Continuing Anyway");
        }
        snmpVar = ASNTypes.decodeVar((ByteArrayInputStream)byteArrayInputStream);
        if (snmpVar.Type != 4) {
            throw new SnmpException("Parse Community: Incorrect ASN header");
        }
        this.community = (String)snmpVar.toValue();
        return this.community;
    }

    byte[] buildAuth(int n) {
        byte[] byArray;
        SnmpInt snmpInt = new SnmpInt(this.version);
        SnmpString snmpString = new SnmpString(this.community);
        byte[] byArray2 = snmpInt.encode();
        if (byArray2 == null || (byArray = snmpString.encode()) == null) {
            return null;
        }
        byte[] byArray3 = ASNTypes.build_header((byte)48, (int)(n + byArray2.length + byArray.length));
        if (byArray3 == null) {
            return null;
        }
        byte[] byArray4 = new byte[byArray2.length + byArray.length + byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray4, byArray2.length + byArray3.length, byArray.length);
        return byArray4;
    }

    public SnmpPDU copy() {
        SnmpPDU snmpPDU = new SnmpPDU(this.API);
        snmpPDU.remoteHost = this.remoteHost;
        snmpPDU.remotePort = this.remotePort;
        snmpPDU.time_sent = this.time_sent;
        snmpPDU.time_expires = this.time_expires;
        snmpPDU.time_received = this.time_received;
        snmpPDU.retries = this.retries;
        if (this.address != null) {
            try {
                snmpPDU.address = InetAddress.getByName(SnmpIpAddress.netbToString((byte[])this.address.getAddress()));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (this.data != null) {
            snmpPDU.data = new byte[this.data.length];
            System.arraycopy(this.data, 0, snmpPDU.data, 0, this.data.length);
            try {
                if (snmpPDU.decode()) {
                    return snmpPDU;
                }
            }
            catch (SnmpException snmpException) {}
            this.error("Unable to clone PDU properly.");
        }
        snmpPDU.command = this.command;
        snmpPDU.reqid = this.reqid;
        snmpPDU.errstat = this.errstat;
        snmpPDU.errindex = this.errindex;
        snmpPDU.enterprise = this.enterprise;
        if (this.agent_addr != null) {
            try {
                snmpPDU.agent_addr = InetAddress.getByName(this.agent_addr.getHostName());
            }
            catch (UnknownHostException unknownHostException) {}
        }
        snmpPDU.trap_type = this.trap_type;
        snmpPDU.specific_type = this.specific_type;
        snmpPDU.time = this.time;
        if (this.variables != null) {
            snmpPDU.variables = (Vector)this.variables.clone();
        }
        snmpPDU.community = this.community;
        return snmpPDU;
    }

    private boolean error(String string) {
        System.err.println(string);
        return false;
    }

    private SnmpVar decodeType(ByteArrayInputStream byteArrayInputStream, byte by) throws SnmpException {
        SnmpVar snmpVar = null;
        snmpVar = ASNTypes.decodeVar((ByteArrayInputStream)byteArrayInputStream);
        if (snmpVar == null) {
            this.error("Parse Error: Decoding SNMP Variable returned null.");
            return null;
        }
        if (snmpVar.Type != by) {
            this.error("Parse Error: Decoding SNMP Variable returned wrong type.");
            return null;
        }
        return snmpVar;
    }
}

