/*
 * Decompiled with CFR 0.152.
 */
import Snmp.SnmpAPI;
import Snmp.SnmpException;
import Snmp.SnmpInt;
import Snmp.SnmpPDU;
import Snmp.SnmpSession;
import Snmp.SnmpString;
import Snmp.SnmpUnsignedInt;
import Snmp.SnmpVar;
import Snmp.SnmpVarBind;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.javascript.JSObject;

public class SwitchDetective
extends Applet
implements Runnable,
ActionListener,
ItemListener {
    Choice InfoTypeSel;
    Label IpAddressTxt;
    Label StatusTxt;
    Panel SysPanel;
    Label UpLabel;
    Label UpTxt;
    Label AddrCapLabel;
    Label AddrCapTxt;
    Label BandwidthLabel;
    Label BandwidthTxt;
    Label UnitsLabel;
    Label MacAddrLabel;
    Label FlashAvailLabel;
    Label FlashTotalLabel;
    Label NVRAMBufLabel;
    Label ImageFileLabel;
    Label WebConsoleLabel;
    Label FirmwareLabel;
    Label FirmwareTxt;
    Label WebConsoleTxt;
    Label FlashAvailTxt;
    Label FlashTotalTxt;
    Label NVRAMBufTxt;
    Label ImageFileTxt;
    Panel PortPanel;
    Label PortSelectLabel;
    Panel PortStatusPanel;
    Label PortLabel;
    TextField PortTxt;
    Button MacAddrBtn;
    List MacAddrList;
    Panel PortLabelPanel;
    Label IfSpeedTxt;
    Label SpeedTxt;
    Label PhysAddrLabel;
    Label PhysAddrTxt;
    Label FullDupLabel;
    Panel PortLabelPanel1;
    Panel PortStatusPanel1;
    Panel PortLabelPanel2;
    Panel PortStatusPanel2;
    Label MBLabel;
    Label AdminStatusLabel;
    Label AdminStatusTxt;
    TextField FullDupMode;
    Panel ConfigPanel;
    Label NameLabel;
    Label DescLabel;
    Label LocLabel;
    Label ContactLabel;
    Label NameTxt;
    Label ContactTxt;
    Label LocTxt;
    Label IpAddressLabel;
    Label IpMaskLabel;
    Label DefaultGatewayLabel;
    Label DomainNameLabel;
    Label CDPEnableLabel;
    Label STPEnableLabel;
    Label IpAddrTxt;
    Label IpMaskTxt;
    Label DefaultGateTxt;
    Label DomainNameTxt;
    Label CDPEnableTxt;
    Label STPEnableTxt;
    TextArea DescTxt;
    TrafficAnimator StatusArea;
    SnmpAPI api;
    String ipAddress;
    SnmpSession session;
    Button[] portStatusArray;
    Label[] portLabelArray;
    Vector ifIndexVector;
    Vector modulePortVector;
    Panel[] portLabelPanels = new Panel[3];
    Panel[] portStatusPanels = new Panel[3];
    private static final Color GREYCOLOR = new Color(0xE0E0E0);
    private static final int SYSTEM_INFO = 0;
    private static final int PORT_INFO = 1;
    private static final int BRIDGE_INFO = 2;
    private static final int ANIMATION = 3;
    private Thread[] activeThreads;
    private boolean abortFlag = false;
    int portNumber;
    String portIndex = "0/0";
    int dispatch = 0;
    int progressMarker;
    static final String[] requestList = new String[]{"sysName", "sysDescr", "sysLocation", "sysContact", "sysUpTime", "c2900InfoAddrCapacity", "c2900BandwidthUsageCurrent"};
    Hashtable cliValues;
    boolean snmpAvail = false;
    String[] imageNames = new String[]{"getinfo0.gif", "getinfo1.gif", "getinfo2.gif", "getinfo3.gif", "getinfo4.gif", "getinfo5.gif", "getinfo6.gif", "getinfo7.gif", "getinfo8.gif", "getinfo9.gif", "getinfo10.gif", "getinfo11.gif", "getinfo12.gif", "getinfo13.gif", "getinfo14.gif", "getinfo15.gif", "getinfo16.gif", "getinfo17.gif", "getinfo18.gif"};
    Image[] traffic;
    private static int acounter = 1;
    private static int scounter = 1;
    private static int bcounter = 1;
    private static int pcounter = 1;

    public void init() {
        this.setLayout(null);
        this.setSize(500, 360);
        this.setBackground(new Color(6996707));
        this.InfoTypeSel = new Choice();
        this.InfoTypeSel.addItem("Config Information");
        this.InfoTypeSel.addItem("System Information");
        this.InfoTypeSel.addItem("Port Information");
        this.add(this.InfoTypeSel);
        this.InfoTypeSel.setBounds(328, 12, 164, 24);
        this.InfoTypeSel.setForeground(new Color(0));
        this.InfoTypeSel.setBackground(new Color(0xE0E0E0));
        this.IpAddressTxt = new Label("", 2);
        this.IpAddressTxt.setBounds(210, 12, 108, 24);
        this.IpAddressTxt.setFont(new Font("Dialog", 1, 12));
        this.add(this.IpAddressTxt);
        this.StatusTxt = new Label("");
        this.StatusTxt.setBounds(140, 12, 68, 24);
        this.StatusTxt.setFont(new Font("Dialog", 0, 12));
        this.add(this.StatusTxt);
        this.SysPanel = new Panel();
        this.SysPanel.setLayout(null);
        this.SysPanel.setVisible(false);
        this.SysPanel.setBounds(0, 48, 500, 312);
        this.add(this.SysPanel);
        this.UpLabel = new Label("System up since:", 2);
        this.UpLabel.setBounds(4, 36, 172, 16);
        this.UpLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.UpLabel);
        this.UpTxt = new Label("");
        this.UpTxt.setBounds(192, 36, 300, 16);
        this.SysPanel.add(this.UpTxt);
        this.AddrCapLabel = new Label("Address capacity:", 2);
        this.AddrCapLabel.setBounds(4, 232, 172, 16);
        this.AddrCapLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.AddrCapLabel);
        this.AddrCapTxt = new Label("");
        this.AddrCapTxt.setBounds(192, 232, 48, 16);
        this.SysPanel.add(this.AddrCapTxt);
        this.BandwidthLabel = new Label("Bandwidth in use:", 2);
        this.BandwidthLabel.setBounds(4, 260, 172, 16);
        this.BandwidthLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.BandwidthLabel);
        this.BandwidthTxt = new Label("");
        this.BandwidthTxt.setBounds(192, 260, 48, 16);
        this.SysPanel.add(this.BandwidthTxt);
        this.UnitsLabel = new Label("megabits per second");
        this.UnitsLabel.setBounds(244, 260, 168, 16);
        this.UnitsLabel.setFont(new Font("Dialog", 0, 12));
        this.SysPanel.add(this.UnitsLabel);
        this.MacAddrLabel = new Label("MAC addresses maximum");
        this.MacAddrLabel.setBounds(244, 232, 168, 16);
        this.MacAddrLabel.setFont(new Font("Dialog", 0, 12));
        this.SysPanel.add(this.MacAddrLabel);
        this.FlashAvailLabel = new Label("Flash space (available):", 2);
        this.FlashAvailLabel.setBounds(4, 204, 172, 16);
        this.FlashAvailLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.FlashAvailLabel);
        this.FlashTotalLabel = new Label("Flash space (total):", 2);
        this.FlashTotalLabel.setBounds(4, 176, 172, 16);
        this.FlashTotalLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.FlashTotalLabel);
        this.NVRAMBufLabel = new Label("NVRAM buffer size:", 2);
        this.NVRAMBufLabel.setBounds(4, 148, 172, 16);
        this.NVRAMBufLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.NVRAMBufLabel);
        this.ImageFileLabel = new Label("IOS Image filename:", 2);
        this.ImageFileLabel.setBounds(4, 120, 172, 16);
        this.ImageFileLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.ImageFileLabel);
        this.WebConsoleLabel = new Label("Switch Manager Release:", 2);
        this.WebConsoleLabel.setBounds(4, 92, 172, 16);
        this.WebConsoleLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.WebConsoleLabel);
        this.FirmwareLabel = new Label("IOS Release:", 2);
        this.FirmwareLabel.setBounds(4, 64, 172, 16);
        this.FirmwareLabel.setFont(new Font("Dialog", 1, 12));
        this.SysPanel.add(this.FirmwareLabel);
        this.FirmwareTxt = new Label("");
        this.FirmwareTxt.setBounds(192, 64, 252, 16);
        this.SysPanel.add(this.FirmwareTxt);
        this.WebConsoleTxt = new Label("");
        this.WebConsoleTxt.setBounds(192, 92, 252, 16);
        this.SysPanel.add(this.WebConsoleTxt);
        this.FlashAvailTxt = new Label("");
        this.FlashAvailTxt.setBounds(192, 204, 144, 16);
        this.SysPanel.add(this.FlashAvailTxt);
        this.FlashTotalTxt = new Label("");
        this.FlashTotalTxt.setBounds(192, 176, 144, 16);
        this.SysPanel.add(this.FlashTotalTxt);
        this.NVRAMBufTxt = new Label("");
        this.NVRAMBufTxt.setBounds(192, 148, 204, 16);
        this.SysPanel.add(this.NVRAMBufTxt);
        this.ImageFileTxt = new Label("");
        this.ImageFileTxt.setBounds(192, 120, 288, 16);
        this.SysPanel.add(this.ImageFileTxt);
        this.PortPanel = new Panel();
        this.PortPanel.setLayout(null);
        this.PortPanel.setVisible(false);
        this.PortPanel.setBounds(0, 48, 500, 312);
        this.add(this.PortPanel);
        this.PortSelectLabel = new Label("Select a port:", 1);
        this.PortSelectLabel.setBounds(84, 24, 108, 24);
        this.PortSelectLabel.setFont(new Font("Dialog", 3, 14));
        this.PortPanel.add(this.PortSelectLabel);
        this.PortStatusPanel = new Panel();
        this.PortStatusPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.PortStatusPanel.setBounds(0, 72, 500, 12);
        this.PortPanel.add(this.PortStatusPanel);
        this.PortLabel = new Label("Port:", 2);
        this.PortLabel.setBounds(72, 144, 48, 24);
        this.PortLabel.setFont(new Font("Dialog", 1, 12));
        this.PortPanel.add(this.PortLabel);
        this.PortTxt = new TextField();
        this.PortTxt.setEditable(false);
        this.PortTxt.setBounds(132, 142, 72, 28);
        ((Component)this.PortTxt).setBackground(new Color(0xE0E0E0));
        this.PortPanel.add(this.PortTxt);
        this.MacAddrBtn = new Button();
        this.MacAddrBtn.setActionCommand("button");
        this.MacAddrBtn.setLabel("List learned addresses");
        this.MacAddrBtn.setBounds(276, 108, 168, 24);
        this.MacAddrBtn.setFont(new Font("Dialog", 1, 12));
        this.MacAddrBtn.setBackground(new Color(0xC0C0C0));
        this.PortPanel.add(this.MacAddrBtn);
        this.MacAddrList = new List(0, false);
        this.PortPanel.add(this.MacAddrList);
        this.MacAddrList.setBounds(276, 144, 168, 132);
        this.MacAddrList.setBackground(new Color(0xE0E0E0));
        this.PortLabelPanel = new Panel();
        this.PortLabelPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.PortLabelPanel.setBounds(0, 60, 500, 12);
        this.PortPanel.add(this.PortLabelPanel);
        this.IfSpeedTxt = new Label(" Speed:", 2);
        this.IfSpeedTxt.setBounds(48, 216, 60, 24);
        this.IfSpeedTxt.setFont(new Font("Dialog", 1, 12));
        this.PortPanel.add(this.IfSpeedTxt);
        this.SpeedTxt = new Label("", 2);
        this.SpeedTxt.setBounds(132, 216, 48, 24);
        this.PortPanel.add(this.SpeedTxt);
        this.PhysAddrLabel = new Label("MAC address:", 2);
        this.PhysAddrLabel.setBounds(12, 108, 120, 24);
        this.PhysAddrLabel.setFont(new Font("Dialog", 1, 12));
        this.PortPanel.add(this.PhysAddrLabel);
        this.PhysAddrTxt = new Label("");
        this.PhysAddrTxt.setBounds(140, 108, 128, 24);
        this.PortPanel.add(this.PhysAddrTxt);
        this.FullDupLabel = new Label("Full duplex");
        this.FullDupLabel.setBounds(120, 180, 84, 24);
        this.FullDupLabel.setFont(new Font("Dialog", 1, 12));
        this.PortPanel.add(this.FullDupLabel);
        this.PortLabelPanel1 = new Panel();
        this.PortLabelPanel1.setLayout(new GridLayout(1, 1, 0, 0));
        this.PortLabelPanel1.setBounds(216, 24, 128, 12);
        this.PortPanel.add(this.PortLabelPanel1);
        this.PortStatusPanel1 = new Panel();
        this.PortStatusPanel1.setLayout(new GridLayout(1, 1, 0, 0));
        this.PortStatusPanel1.setBounds(216, 36, 128, 12);
        this.PortPanel.add(this.PortStatusPanel1);
        this.PortLabelPanel2 = new Panel();
        this.PortLabelPanel2.setLayout(new GridLayout(1, 1, 0, 0));
        this.PortLabelPanel2.setBounds(372, 24, 128, 12);
        this.PortPanel.add(this.PortLabelPanel2);
        this.PortStatusPanel2 = new Panel();
        this.PortStatusPanel2.setLayout(new GridLayout(1, 1, 0, 0));
        this.PortStatusPanel2.setBounds(372, 36, 128, 12);
        this.PortPanel.add(this.PortStatusPanel2);
        this.MBLabel = new Label("MB");
        this.MBLabel.setBounds(192, 216, 36, 24);
        this.MBLabel.setFont(new Font("Dialog", 1, 12));
        this.PortPanel.add(this.MBLabel);
        this.AdminStatusLabel = new Label("Admin status:", 2);
        this.AdminStatusLabel.setBounds(36, 246, 112, 24);
        this.AdminStatusLabel.setFont(new Font("Dialog", 1, 12));
        this.PortPanel.add(this.AdminStatusLabel);
        this.AdminStatusTxt = new Label("");
        this.AdminStatusTxt.setBounds(168, 246, 84, 24);
        this.PortPanel.add(this.AdminStatusTxt);
        this.FullDupMode = new TextField();
        this.FullDupMode.setEditable(false);
        this.FullDupMode.setBounds(96, 183, 14, 18);
        this.FullDupMode.setFont(new Font("Symbol", 1, 14));
        ((Component)this.FullDupMode).setBackground(new Color(0xE0E0E0));
        this.PortPanel.add(this.FullDupMode);
        this.FullDupMode.setEnabled(false);
        this.ConfigPanel = new Panel();
        this.ConfigPanel.setLayout(null);
        this.ConfigPanel.setBounds(0, 48, 500, 312);
        this.add(this.ConfigPanel);
        this.NameLabel = new Label("Name:", 2);
        this.NameLabel.setBounds(4, 16, 124, 16);
        this.NameLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.NameLabel);
        this.DescLabel = new Label("Description:", 2);
        this.DescLabel.setBounds(4, 44, 124, 16);
        this.DescLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.DescLabel);
        this.LocLabel = new Label("Location:", 2);
        this.LocLabel.setBounds(4, 120, 124, 16);
        this.LocLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.LocLabel);
        this.ContactLabel = new Label("Contact:", 2);
        this.ContactLabel.setBounds(4, 148, 124, 16);
        this.ContactLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.ContactLabel);
        this.NameTxt = new Label("");
        this.NameTxt.setBounds(144, 16, 276, 16);
        this.ConfigPanel.add(this.NameTxt);
        this.ContactTxt = new Label("");
        this.ContactTxt.setBounds(144, 148, 276, 16);
        this.ConfigPanel.add(this.ContactTxt);
        this.LocTxt = new Label("");
        this.LocTxt.setBounds(144, 120, 276, 16);
        this.ConfigPanel.add(this.LocTxt);
        this.IpAddressLabel = new Label("IP address:", 2);
        this.IpAddressLabel.setBounds(4, 176, 124, 16);
        this.IpAddressLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.IpAddressLabel);
        this.IpMaskLabel = new Label("Mask:", 2);
        this.IpMaskLabel.setBounds(264, 176, 48, 16);
        this.IpMaskLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.IpMaskLabel);
        this.DefaultGatewayLabel = new Label("Default gateway:", 2);
        this.DefaultGatewayLabel.setBounds(4, 204, 124, 16);
        this.DefaultGatewayLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.DefaultGatewayLabel);
        this.DomainNameLabel = new Label("Domain name:", 2);
        this.DomainNameLabel.setBounds(4, 232, 124, 16);
        this.DomainNameLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.DomainNameLabel);
        this.CDPEnableLabel = new Label("CDP:", 2);
        this.CDPEnableLabel.setBounds(48, 260, 78, 16);
        this.CDPEnableLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.CDPEnableLabel);
        this.STPEnableLabel = new Label("STP:", 2);
        this.STPEnableLabel.setBounds(240, 260, 72, 16);
        this.STPEnableLabel.setFont(new Font("Dialog", 1, 12));
        this.ConfigPanel.add(this.STPEnableLabel);
        this.IpAddrTxt = new Label("");
        this.IpAddrTxt.setBounds(144, 176, 108, 16);
        this.ConfigPanel.add(this.IpAddrTxt);
        this.IpMaskTxt = new Label("");
        this.IpMaskTxt.setBounds(336, 176, 108, 16);
        this.ConfigPanel.add(this.IpMaskTxt);
        this.DefaultGateTxt = new Label("");
        this.DefaultGateTxt.setBounds(144, 204, 144, 16);
        this.ConfigPanel.add(this.DefaultGateTxt);
        this.DomainNameTxt = new Label("");
        this.DomainNameTxt.setBounds(144, 232, 144, 16);
        this.ConfigPanel.add(this.DomainNameTxt);
        this.CDPEnableTxt = new Label("");
        this.CDPEnableTxt.setBounds(144, 260, 96, 16);
        this.ConfigPanel.add(this.CDPEnableTxt);
        this.STPEnableTxt = new Label("");
        this.STPEnableTxt.setBounds(336, 260, 108, 16);
        this.ConfigPanel.add(this.STPEnableTxt);
        this.DescTxt = new TextArea();
        this.DescTxt.setEditable(false);
        this.DescTxt.setBounds(144, 44, 348, 68);
        ((Component)this.DescTxt).setBackground(new Color(0xF0F0F0));
        this.ConfigPanel.add(this.DescTxt);
        this.InfoTypeSel.addItemListener(this);
        this.MacAddrBtn.addActionListener(this);
        this.ipAddress = this.getParameter("ipaddress");
        if (this.ipAddress == null) {
            this.ipAddress = this.getDocumentBase().getHost();
        }
        this.IpAddressTxt.setText(this.ipAddress);
        this.portLabelPanels[0] = this.PortLabelPanel;
        this.portLabelPanels[1] = this.PortLabelPanel1;
        this.portLabelPanels[2] = this.PortLabelPanel2;
        this.portStatusPanels[0] = this.PortStatusPanel;
        this.portStatusPanels[1] = this.PortStatusPanel1;
        this.portStatusPanels[2] = this.PortStatusPanel2;
        this.cliValues = new Hashtable();
        this.cliValues.put("Default gateway", new Integer(0));
        this.cliValues.put("Domain name", new Integer(1));
        this.cliValues.put("CDP state", new Integer(2));
        this.cliValues.put("STP state", new Integer(3));
        this.cliValues.put("Firmware version", new Integer(4));
        this.cliValues.put("WebConsole version", new Integer(5));
        this.cliValues.put("Image filename", new Integer(6));
        this.cliValues.put("NVRAM buffer size", new Integer(7));
        this.cliValues.put("Flash total", new Integer(8));
        this.cliValues.put("Flash available", new Integer(9));
        this.cliValues.put("IP address", new Integer(10));
        this.cliValues.put("IP mask", new Integer(11));
        this.activeThreads = new Thread[4];
        int n = 0;
        while (n < 4) {
            this.activeThreads[n] = null;
            ++n;
        }
        this.traffic = new Image[this.imageNames.length];
        int n2 = 0;
        while (n2 < this.imageNames.length) {
            block5: {
                URL uRL = null;
                String string = null;
                try {
                    string = "http://" + this.ipAddress + "/" + this.imageNames[n2];
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println("Caught MalformedURLException: " + string);
                    this.traffic[n2] = null;
                    break block5;
                }
                this.traffic[n2] = this.getImage(uRL);
            }
            ++n2;
        }
        this.StatusArea = new TrafficAnimator(this.traffic);
        this.StatusArea.setBounds(6, 6, 128, 32);
        this.add(this.StatusArea);
    }

    public void start() {
        try {
            this.StatusArea.zero();
            this.dispatch = 3;
            this.activeThreads[3] = new Thread((Runnable)this, "SwitchDetective-Animation-" + acounter++);
            this.activeThreads[3].start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            this.dispatch = 0;
            this.activeThreads[0] = new Thread((Runnable)this, "SwitchDetective-SystemInfo-" + scounter++);
            this.activeThreads[0].start();
            this.informGraphPort("");
            return;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in 'start'");
            this.stop();
            return;
        }
    }

    public void destroy() {
    }

    public void stop() {
        int n = 0;
        while (n < 4) {
            if (this.activeThreads[n] != null) {
                this.activeThreads[n].stop();
                this.activeThreads[n] = null;
            }
            ++n;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.api != null) {
            this.api.stop();
            this.api = null;
        }
    }

    private int determineThreadCode() {
        Thread thread = Thread.currentThread();
        int n = 0;
        while (n < this.activeThreads.length) {
            if (this.activeThreads[n] == thread) {
                return n;
            }
            ++n;
        }
        System.out.println("Error: cannot determine thread");
        return 0;
    }

    public void run() {
        int n = this.determineThreadCode();
        if (n == 3) {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(50L);
                        this.checkProgress();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        Font font = new Font("Dialog", 0, 12);
        Font font2 = new Font("Dialog", 2, 12);
        this.StatusTxt.setFont(font2);
        this.StatusTxt.setText("Working...");
        this.StatusArea.zero();
        switch (n) {
            case 0: {
                this.snmpAvail = this.getInformation();
                break;
            }
            case 1: {
                if (!this.snmpAvail) break;
                this.getPortInformation(this.portNumber);
                break;
            }
            case 2: {
                if (!this.snmpAvail) break;
                this.getLearnedAddresses(this.portIndex);
                break;
            }
        }
        if (this.snmpAvail) {
            this.StatusTxt.setFont(font);
            this.StatusTxt.setText("Ready");
        } else {
            Font font3 = new Font("Dialog", 1, 12);
            this.StatusTxt.setFont(font3);
            this.StatusTxt.setText("No SNMP");
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.StatusArea.zero();
        this.activeThreads[n] = null;
        System.gc();
        return;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.activeThreads[0] != null || this.activeThreads[1] != null) {
            return;
        }
        if (actionEvent.getSource() == this.MacAddrBtn) {
            if (this.activeThreads[2] != null) {
                return;
            }
            this.MacAddrList.removeAll();
            try {
                String string = this.PortTxt.getText();
                int n = Integer.parseInt(string.substring(2, 3));
                int n2 = Integer.parseInt(string.substring(4));
                this.portNumber = this.computePortNum(n, n2);
                this.portIndex = String.valueOf(n) + "." + n2;
                this.dispatch = 2;
                this.activeThreads[2] = new Thread((Runnable)this, "SwitchDetective-BridgeInfo-" + bcounter++);
                this.activeThreads[2].start();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        int n = 1;
        while (n <= this.portStatusArray.length) {
            if (actionEvent.getSource() == this.portStatusArray[n - 1]) {
                if (this.activeThreads[2] != null) {
                    this.abortFlag = true;
                }
                String string = (String)this.modulePortVector.elementAt(n - 1);
                int n3 = Integer.parseInt(string.substring(0, 1));
                int n4 = Integer.parseInt(string.substring(2));
                Font font = new Font("TimesRoman", 1, 12);
                if (this.portNumber != 0) {
                    Font font2 = new Font("TimesRoman", 0, 10);
                    this.portLabelArray[this.portNumber - 1].setFont(font2);
                }
                this.portLabelArray[n - 1].setFont(font);
                this.MacAddrList.removeAll();
                this.portNumber = n;
                this.dispatch = 1;
                this.activeThreads[1] = new Thread((Runnable)this, "SwitchDetective-PortInfo-" + pcounter++);
                this.activeThreads[1].start();
                this.informGraphPort("FAS~" + n3 + "/" + n4);
                return;
            }
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        if (this.activeThreads[2] != null) {
            this.abortFlag = true;
        }
        if ((string = (String)itemEvent.getItem()).equals("Config Information")) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    this.ConfigPanel.setVisible(true);
                    this.SysPanel.setVisible(false);
                    this.PortPanel.setVisible(false);
                    this.informGraphPort("");
                    if (this.activeThreads[2] == null) break;
                    this.abortFlag = true;
                    break;
                }
            }
        }
        if (string.equals("System Information")) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    this.ConfigPanel.setVisible(false);
                    this.SysPanel.setVisible(true);
                    this.PortPanel.setVisible(false);
                    this.informGraphPort("");
                    if (this.activeThreads[2] == null) break;
                    this.abortFlag = true;
                    break;
                }
            }
        }
        if (string.equals("Port Information")) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    this.ConfigPanel.setVisible(false);
                    this.SysPanel.setVisible(false);
                    this.PortPanel.setVisible(true);
                    this.informGraphPort("");
                    if (this.activeThreads[2] == null) break;
                    this.abortFlag = true;
                    return;
                }
            }
        }
    }

    private void informGraphPort(String string) {
        Object[] objectArray = new Object[]{"\"" + string + "\""};
        JSObject jSObject = JSObject.getWindow((Applet)this);
        if (string.equals("")) {
            jSObject.call("launchDefaultGraph", objectArray);
            return;
        }
        jSObject.call("launchGraph", objectArray);
    }

    private boolean getInformation() {
        String string;
        String string2;
        Object object;
        int n;
        Object object2;
        SnmpVarBind snmpVarBind;
        this.api = new SnmpAPI();
        this.api.start();
        while (this.api.client == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.session = new SnmpSession(this.api);
        this.session.peername = this.ipAddress;
        this.session.community = "public";
        try {
            this.session.open();
        }
        catch (SnmpException snmpException) {
            System.out.println(snmpException.getMessage());
            return false;
        }
        SnmpPDUExt snmpPDUExt = new SnmpPDUExt(this.api);
        snmpPDUExt.command = (byte)-96;
        int n2 = 0;
        while (n2 < requestList.length) {
            snmpPDUExt.addRequest(requestList[n2], 0);
            ++n2;
        }
        this.session.retries = 2;
        this.session.timeout = 4000;
        SnmpPDU snmpPDU = this.requestFromSNMP(snmpPDUExt);
        if (snmpPDU == null) {
            System.out.println("NULL response PDU.");
            return false;
        }
        Component[] componentArray = new Component[]{this.NameTxt, this.DescTxt, this.LocTxt, this.ContactTxt, this.UpTxt, this.AddrCapTxt, this.BandwidthTxt};
        int n3 = 0;
        while (n3 < componentArray.length) {
            snmpVarBind = (SnmpVarBind)snmpPDU.variables.elementAt(n3);
            if (componentArray[n3] instanceof Label) {
                object2 = (Label)componentArray[n3];
                ((Label)object2).setText(snmpVarBind.variable.toString());
            } else {
                object2 = (TextArea)componentArray[n3];
                ((TextComponent)object2).setText(snmpVarBind.variable.toString());
            }
            ++n3;
        }
        snmpVarBind = new SnmpVarBind[]{this.ipAddress};
        object2 = JSObject.getWindow((Applet)this);
        ((JSObject)object2).call("transmitReportInfo", (Object[])snmpVarBind);
        System.out.println("Switch Detective getInfo");
        Vector<Integer> vector = new Vector<Integer>();
        this.modulePortVector = new Vector();
        this.ifIndexVector = new Vector();
        this.session.retries = 2;
        this.session.timeout = 4000;
        snmpPDUExt = null;
        snmpPDU = null;
        String string3 = SnmpPDUExt.getMibVar("c2900PortLinkbeatStatus");
        String string4 = ".0.0";
        int n4 = 0;
        while (n4 <= 6) {
            snmpPDUExt = new SnmpPDUExt(this.api);
            snmpPDUExt.command = (byte)-96;
            n = n4 * 4 + 1;
            while (n <= (n4 + 1) * 4) {
                object = ".0." + n;
                snmpPDUExt.addRequest("c2900PortLinkbeatStatus", (String)object);
                snmpPDUExt.addRequest("c2900PortIfIndex", (String)object);
                ++n;
            }
            snmpPDU = this.requestFromSNMP(snmpPDUExt);
            if (snmpPDU == null) break;
            int n5 = 0;
            while (n5 < 4) {
                if (snmpPDU.errstat == 0) {
                    string2 = (SnmpVarBind)snmpPDU.variables.elementAt(n5 * 2);
                    vector.addElement(new Integer(((SnmpInt)((SnmpVarBind)string2).variable).intValue()));
                    string = ((SnmpVarBind)string2).oid.toString();
                    string2 = (SnmpVarBind)snmpPDU.variables.elementAt(n5 * 2 + 1);
                    this.ifIndexVector.addElement(new Integer(((SnmpInt)((SnmpVarBind)string2).variable).intValue()));
                    string4 = string.substring(string3.length());
                    this.modulePortVector.addElement(string4.substring(1));
                }
                ++n5;
            }
            ++n4;
        }
        n = 1;
        while (n <= 2) {
            int n6 = 1;
            while (n6 <= 4) {
                snmpPDUExt = new SnmpPDUExt(this.api);
                snmpPDUExt.command = (byte)-96;
                string2 = "." + n + "." + n6;
                snmpPDUExt.addRequest("c2900PortLinkbeatStatus", string2);
                snmpPDUExt.addRequest("c2900PortIfIndex", string2);
                snmpPDU = this.requestFromSNMP(snmpPDUExt);
                if (snmpPDU != null) {
                    if (snmpPDU.errstat != 0) break;
                    string = (SnmpVarBind)snmpPDU.variables.elementAt(0);
                    vector.addElement(new Integer(((SnmpInt)((SnmpVarBind)string).variable).intValue()));
                    String string5 = ((SnmpVarBind)string).oid.toString();
                    string = (SnmpVarBind)snmpPDU.variables.elementAt(1);
                    this.ifIndexVector.addElement(new Integer(((SnmpInt)((SnmpVarBind)string).variable).intValue()));
                    string4 = string5.substring(string3.length());
                    this.modulePortVector.addElement(string4.substring(1));
                }
                ++n6;
            }
            ++n;
        }
        this.portLabelArray = new Label[vector.size()];
        this.portStatusArray = new Button[vector.size()];
        object = new Font("TimesRoman", 0, 10);
        int n7 = 1;
        while (n7 <= vector.size()) {
            string = (String)this.modulePortVector.elementAt(n7 - 1);
            int n8 = Integer.parseInt(string.substring(0, 1));
            int n9 = Integer.parseInt(string.substring(2));
            this.portLabelArray[n7 - 1] = new Label();
            this.portLabelArray[n7 - 1].setAlignment(1);
            this.portLabelArray[n7 - 1].setFont((Font)object);
            this.portLabelArray[n7 - 1].setText(Integer.toString(n9));
            this.portLabelPanels[n8].add(this.portLabelArray[n7 - 1]);
            this.portStatusArray[n7 - 1] = new Button();
            switch ((Integer)vector.elementAt(n7 - 1)) {
                case 2: {
                    this.portStatusArray[n7 - 1].setBackground(Color.green);
                    break;
                }
                case 3: {
                    this.portStatusArray[n7 - 1].setBackground(Color.cyan);
                    break;
                }
                default: {
                    this.portStatusArray[n7 - 1].setBackground(Color.orange);
                }
            }
            this.portStatusPanels[n8].add(this.portStatusArray[n7 - 1]);
            this.portStatusArray[n7 - 1].addActionListener(this);
            ++n7;
        }
        this.adjustLayout();
        return true;
    }

    private void getPortInformation(int n) {
        String string;
        Object object;
        String[] stringArray = new String[]{"", "Up", "Down", "Testing"};
        this.session.retries = 3;
        this.session.timeout = 2000;
        SnmpPDUExt snmpPDUExt = null;
        snmpPDUExt = new SnmpPDUExt(this.api);
        snmpPDUExt.command = (byte)-96;
        int n2 = 0;
        n2 = (Integer)this.ifIndexVector.elementAt(n - 1);
        snmpPDUExt.addRequest("ifSpeed", n2);
        snmpPDUExt.addRequest("ifPhysAddress", n2);
        snmpPDUExt.addRequest("ifAdminStatus", n2);
        snmpPDUExt.addRequest("ifName", n2);
        SnmpPDU snmpPDU = this.requestFromSNMP(snmpPDUExt);
        if (snmpPDU != null) {
            object = (SnmpVarBind)snmpPDU.variables.elementAt(3);
            string = (String)((SnmpString)object.variable).toValue();
            ((TextComponent)this.PortTxt).setText(string);
            this.SpeedTxt.setText(this.determinePortSpeed(string));
            object = (SnmpVarBind)snmpPDU.variables.elementAt(1);
            this.PhysAddrTxt.setText(this.convertToPhysAddr(object.variable));
            object = (SnmpVarBind)snmpPDU.variables.elementAt(2);
            int n3 = ((SnmpInt)object.variable).intValue();
            this.AdminStatusTxt.setText(stringArray[n3]);
        }
        snmpPDUExt = new SnmpPDUExt(this.api);
        snmpPDUExt.command = (byte)-96;
        object = "";
        object = (String)this.modulePortVector.elementAt(n - 1);
        snmpPDUExt.addRequest("c2900PortDuplexStatus", (String)object);
        snmpPDUExt.addRequest("c2900PortNumberOfLearnedAddresses", (String)object);
        snmpPDU = this.requestFromSNMP(snmpPDUExt);
        if (snmpPDU != null) {
            string = (SnmpVarBind)snmpPDU.variables.elementAt(0);
            SnmpVar snmpVar = ((SnmpVarBind)string).variable;
            if (snmpVar.Type != 5) {
                int n4 = ((SnmpInt)((SnmpVarBind)string).variable).intValue();
                Color color = GREYCOLOR;
                switch (n4) {
                    case 1: {
                        color = Color.green;
                        break;
                    }
                }
                ((Component)this.FullDupMode).setBackground(color);
            }
            string = (SnmpVarBind)snmpPDU.variables.elementAt(1);
            snmpVar = ((SnmpVarBind)string).variable;
            if (snmpVar.Type != 5) {
                ((SnmpUnsignedInt)((SnmpVarBind)string).variable).longValue();
            }
        }
    }

    private String determinePortSpeed(String string) {
        String string2;
        String string3 = string.substring(0, 2);
        if (string3.compareTo("Gi") == 0) {
            return "1000";
        }
        if (string3.compareTo("AT") == 0) {
            return "155";
        }
        String string4 = string.substring(string.indexOf("/") - 1);
        String string5 = "http://" + this.ipAddress + "/exec/-/show/interfaces/FastEthernet/" + string4.substring(0, 1) + "%5c/" + string4.substring(2) + "/speed/actual/CR";
        String string6 = this.getHttpResponse(string5);
        int n = string6.indexOf(string2 = " speed actual");
        if (n != -1) {
            String string7 = string6.substring(n + string2.length());
            n = string7.indexOf("<");
            while (n != -1) {
                string7 = string7.substring(n + 1);
                int n2 = string7.indexOf(">");
                n = (string7 = string7.substring(n2 + 1)).indexOf("<");
                if (n == -1) continue;
                String string8 = string7.substring(0, n);
                string8.trim();
                if (string8.equals("")) continue;
                return string8;
            }
        }
        return "?";
    }

    private void getLearnedAddresses(String string) {
        String string2 = this.PortTxt.getText();
        String string3 = string2.substring(0, 2);
        String string4 = "FastEthernet";
        if (string3.compareTo("Gi") == 0) {
            string4 = "GigabitEthernet";
        } else if (string3.compareTo("AT") == 0) {
            string4 = "ATM";
        }
        String string5 = "http://" + this.ipAddress + "/exec/-/show/mac-address-table/dynamic/interface/" + string4 + "/" + string.substring(0, 1) + "%5c/" + string.substring(2) + "/CR";
        String string6 = this.getHttpResponse(string5);
        int n = string6.indexOf("<option>");
        while (n != -1 && !this.abortFlag) {
            string6 = string6.substring(n);
            String string7 = string6.substring(8, 22);
            String string8 = String.valueOf(string7.substring(0, 2)) + ":" + string7.substring(2, 4) + ":" + string7.substring(5, 7) + ":" + string7.substring(7, 9) + ":" + string7.substring(10, 12) + ":" + string7.substring(12, 14);
            this.markProgress();
            this.MacAddrList.addItem(string8);
            string6 = string6.substring(8);
            n = string6.indexOf("<option>");
        }
        if (this.abortFlag) {
            this.MacAddrList.removeAll();
            this.abortFlag = false;
        }
    }

    private String getHttpResponse(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("URL exception: " + string);
            return "?";
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string2 = "";
            do {
                try {
                    this.markProgress();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                n = inputStream.available();
                n2 += n;
                if (n == 0) {
                    ++n3;
                    continue;
                }
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                string2 = String.valueOf(string2) + new String(byArray);
                n3 = 0;
            } while (n2 == 0 || n3 < 5);
            inputStream.close();
            return string2;
        }
        catch (IOException iOException) {
            System.out.println("IO exception during HTTP request");
            return "";
        }
    }

    private String convertToPhysAddr(SnmpVar snmpVar) {
        String string = "";
        byte[] byArray = snmpVar.toBytes();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] >> 4 & 0xF;
            int n3 = byArray[n] & 0xF;
            string = String.valueOf(string) + Integer.toHexString(n2) + Integer.toHexString(n3);
            if (n + 1 != byArray.length) {
                string = String.valueOf(string) + ":";
            }
            ++n;
        }
        return string;
    }

    private int computePortNum(int n, int n2) {
        int n3 = 0;
        while (n3 < this.modulePortVector.size()) {
            String string = (String)this.modulePortVector.elementAt(n3);
            if (string.equals(n + "." + n2)) {
                int n4 = n3 + 1;
                return n4;
            }
            ++n3;
        }
        return 1;
    }

    private void adjustLayout() {
        int n = 0;
        while (n < 3) {
            Component[] componentArray = this.portStatusPanels[n].getComponents();
            Component[] componentArray2 = this.portLabelPanels[n].getComponents();
            int n2 = this.portStatusPanels[n].getSize().width;
            if (componentArray.length != 0) {
                int n3 = n2 / componentArray.length;
                Dimension dimension = new Dimension(n3, 12);
                int n4 = 0;
                while (n4 < componentArray.length) {
                    Button button = (Button)componentArray[n4];
                    Label label = (Label)componentArray2[n4];
                    String string = label.getText();
                    int n5 = Integer.parseInt(string);
                    Point point = new Point((n5 - 1) * n3, 0);
                    button.setLocation(point);
                    button.setSize(dimension);
                    label.setLocation(point);
                    label.setSize(dimension);
                    ++n4;
                }
                this.portStatusPanels[n].repaint();
                this.portLabelPanels[n].repaint();
            }
            ++n;
        }
    }

    private SnmpPDU requestFromSNMP(SnmpPDU snmpPDU) {
        int n;
        SnmpPDU snmpPDU2 = null;
        try {
            n = this.session.send(snmpPDU);
        }
        catch (SnmpException snmpException) {
            return null;
        }
        boolean bl = false;
        do {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            this.markProgress();
            snmpPDU2 = this.session.receive(n);
            bl = this.session.checkTimeout(n);
        } while (snmpPDU2 == null && !bl);
        return snmpPDU2;
    }

    public void reportInfoSet(String string, String string2) {
        Label[] labelArray = new Label[]{this.DefaultGateTxt, this.DomainNameTxt, this.CDPEnableTxt, this.STPEnableTxt, this.FirmwareTxt, this.WebConsoleTxt, this.ImageFileTxt, this.NVRAMBufTxt, this.FlashTotalTxt, this.FlashAvailTxt, this.IpAddrTxt, this.IpMaskTxt};
        Integer n = (Integer)this.cliValues.get(string);
        if (n != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            String string3 = stringTokenizer.nextToken();
            String string4 = string2.substring(string2.indexOf(string3));
            labelArray[n].setText(string4);
        }
    }

    private synchronized void checkProgress() {
        while (this.progressMarker != 0) {
            this.StatusArea.move();
            --this.progressMarker;
        }
    }

    private synchronized void markProgress() {
        ++this.progressMarker;
    }

    private String threadName(int n) {
        String string = "UNKNOWN";
        switch (n) {
            case 3: {
                string = "ANIMATION";
                break;
            }
            case 0: {
                string = "SYSTEM INFO";
                break;
            }
            case 2: {
                string = "BRIDGE INFO";
                break;
            }
            case 1: {
                string = "PORT INFO";
                break;
            }
        }
        return string;
    }

    private void timestamp(String string) {
        System.out.println(String.valueOf(string) + "[" + Thread.currentThread() + "] at: " + new Date().toString());
    }
}

