/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLabel
extends Canvas {
    private Image image;
    private static String defaultImageString = "http://java.sun.com/lib/images/logo.java.color-transp.55x60.gif";
    private String imageString = "<Existing Image>";
    private boolean debug = false;
    private int border;
    private Color borderColor;
    private int width;
    private int height;
    private boolean explicitSize = false;
    private int explicitWidth;
    private int explicitHeight;
    private MediaTracker tracker;
    private static int lastTrackerID;
    private int currentTrackerID;
    private boolean doneLoading = false;
    private Container parentContainer;

    public ImageLabel() {
        this(defaultImageString);
    }

    public ImageLabel(String string) {
        this(ImageLabel.makeURL(string));
    }

    public ImageLabel(URL uRL) {
        this(ImageLabel.loadImage(uRL));
        this.imageString = uRL.toExternalForm();
    }

    public ImageLabel(URL uRL, String string) {
        this(ImageLabel.makeURL(uRL, string));
        this.imageString = string;
    }

    public ImageLabel(Image image) {
        this.image = image;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(image, this.currentTrackerID);
    }

    public void waitForImage(boolean bl) {
        if (!this.doneLoading) {
            this.debug("[waitForImage] - Resizing and waiting for " + this.imageString);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("Error loading " + this.imageString + ": " + exception.getMessage());
                exception.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading image " + this.imageString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.image.getWidth(this) + 2 * this.border;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.image.getHeight(this) + 2 * this.border;
            this.setSize(this.width, this.height);
            this.debug("[waitForImage] - " + this.imageString + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && bl) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.doLayout();
            }
        }
    }

    public void centerAt(int n, int n2) {
        this.debug("Placing center of " + this.imageString + " at (" + n + "," + n2 + ")");
        this.setLocation(n - this.width / 2, n2 - this.height / 2);
    }

    public synchronized boolean contains(int n, int n2) {
        return n >= 0 && n <= this.width && n2 >= 0 && n2 <= this.height;
    }

    public void paint(Graphics graphics) {
        if (!this.doneLoading) {
            this.waitForImage(true);
            return;
        }
        if (this.explicitSize) {
            graphics.drawImage(this.image, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
        } else {
            graphics.drawImage(this.image, this.border, this.border, this);
        }
        this.drawRect(graphics, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
    }

    public Dimension getPreferredSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getMinimumSize();
    }

    public void setSize(int n, int n2) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (n > 0) {
                this.explicitWidth = n;
            }
            if (n2 > 0) {
                this.explicitHeight = n2;
            }
        }
        super.setSize(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (n3 > 0) {
                this.explicitWidth = n3;
            }
            if (n4 > 0) {
                this.explicitHeight = n4;
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawRect(n, n2, n3, n4);
            if (n6 < n5 - 1) {
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
            ++n6;
        }
    }

    protected void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private static URL makeURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL " + string + ": " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    private static URL makeURL(URL uRL, String string) {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL " + uRL.toExternalForm() + ", " + string + ": " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return uRL2;
    }

    private static Image loadImage(URL uRL) {
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public Image getImage() {
        return this.image;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected boolean hasExplicitSize() {
        return this.explicitSize;
    }

    public static String getDefaultImageString() {
        return defaultImageString;
    }

    public static void setDefaultImageString(String string) {
        defaultImageString = string;
    }

    protected String getImageString() {
        return this.imageString;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setIsDebugging(boolean bl) {
        this.debug = bl;
    }
}

