/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionParser {
    String expression;
    int currentCharIndex;
    int varBindIndex;
    StringTokenizer tokenizer;
    ParseNode pTree;
    Vector vbSymbols;

    public ExpressionParser(String string) {
        this(string, 0);
    }

    public ExpressionParser(String string, int n) {
        this.expression = string;
        this.expression.trim();
        this.currentCharIndex = 0;
        this.varBindIndex = n;
        this.vbSymbols = new Vector();
        this.tokenizer = new StringTokenizer(this.expression);
    }

    public boolean parse() {
        ParseNode parseNode = this.parseExpr();
        String string = this.nextToken();
        if (parseNode != null && string == null) {
            this.pTree = parseNode;
            return true;
        }
        return false;
    }

    public ParseNode parseTree() {
        return this.pTree;
    }

    public Vector symbols() {
        return this.vbSymbols;
    }

    private ParseNode parseExpr() {
        ParseNode parseNode;
        block6: {
            ParseNode parseNode2;
            block7: {
                parseNode2 = this.parseTerm();
                parseNode = null;
                String string = this.nextToken();
                if (parseNode2 == null) break block6;
                if (string == null) break block7;
                switch (string.charAt(0)) {
                    case '+': {
                        ParseNode parseNode3 = this.parseExpr();
                        if (parseNode3 != null) {
                            parseNode = new PlusNode(parseNode2, parseNode3);
                            break;
                        }
                        break block6;
                    }
                    case '-': {
                        ParseNode parseNode4 = this.parseExpr();
                        if (parseNode4 != null) {
                            parseNode = new MinusNode(parseNode2, parseNode4);
                            break;
                        }
                        break block6;
                    }
                    default: {
                        this.resetLastToken(string);
                        parseNode = parseNode2;
                        break;
                    }
                }
                break block6;
            }
            parseNode = parseNode2;
        }
        return parseNode;
    }

    private ParseNode parseTerm() {
        ParseNode parseNode;
        block6: {
            ParseNode parseNode2;
            block7: {
                parseNode2 = this.parseItem();
                parseNode = null;
                String string = this.nextToken();
                if (parseNode2 == null) break block6;
                if (string == null) break block7;
                switch (string.charAt(0)) {
                    case '*': {
                        ParseNode parseNode3 = this.parseTerm();
                        if (parseNode3 != null) {
                            parseNode = new MultNode(parseNode2, parseNode3);
                            break;
                        }
                        break block6;
                    }
                    case '/': {
                        ParseNode parseNode4 = this.parseTerm();
                        if (parseNode4 != null) {
                            parseNode = new DivNode(parseNode2, parseNode4);
                            break;
                        }
                        break block6;
                    }
                    default: {
                        this.resetLastToken(string);
                        parseNode = parseNode2;
                        break;
                    }
                }
                break block6;
            }
            parseNode = parseNode2;
        }
        return parseNode;
    }

    private ParseNode parseItem() {
        ParseNode parseNode;
        block3: {
            String string;
            block4: {
                ParseNode parseNode2;
                block2: {
                    parseNode2 = null;
                    parseNode = null;
                    string = this.nextToken();
                    if (string == null || !string.equals("(")) break block2;
                    parseNode2 = this.parseExpr();
                    if (parseNode2 == null || (string = this.nextToken()) == null || !string.equals(")")) break block3;
                    parseNode = parseNode2;
                    break block3;
                }
                if (string == null || !string.equals("DELTA")) break block4;
                string = this.nextToken();
                if (string == null || !string.equals("(") || (parseNode2 = this.parseSymbol(true)) == null || (string = this.nextToken()) == null || !string.equals(")")) break block3;
                parseNode = parseNode2;
                break block3;
            }
            try {
                long l = Long.parseLong(string);
                parseNode = new ConstNode(l);
            }
            catch (NumberFormatException numberFormatException) {
                this.resetLastToken(string);
                parseNode = this.parseSymbol();
            }
        }
        return parseNode;
    }

    private ParseNode parseSymbol() {
        return this.parseSymbol(false);
    }

    private ParseNode parseSymbol(boolean bl) {
        SymNode symNode = null;
        String string = this.nextToken();
        if (string != null && Character.isLetter(string.charAt(0))) {
            symNode = new SymNode(string, bl, this.varBindIndex++);
            this.vbSymbols.addElement(string);
        }
        return symNode;
    }

    private String nextToken() {
        if (this.tokenizer.hasMoreTokens()) {
            String string = this.tokenizer.nextToken();
            int n = this.expression.substring(this.currentCharIndex).indexOf(string);
            this.currentCharIndex += n + string.length();
            return string;
        }
        return null;
    }

    private void resetLastToken(String string) {
        if (string != null) {
            this.currentCharIndex -= string.length();
            this.tokenizer = new StringTokenizer(this.expression.substring(this.currentCharIndex));
        }
    }
}

