/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

class CommThread
extends Thread {
    ServerSocket ss;
    Socket s;
    public boolean doneFlag = false;
    private InfoBundle bundle;
    private LinkDetective report;
    private static final int MAX_PORT_ATTEMPTS = 100;

    public CommThread(InfoBundle infoBundle, LinkDetective linkDetective) {
        super("CommThread");
        this.bundle = infoBundle;
        this.report = linkDetective;
    }

    public void run() {
        String string;
        int n;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Unknown host");
            return;
        }
        this.ss = null;
        this.s = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        int n2 = n = this.report.commPort();
        boolean bl = false;
        while (!bl) {
            System.out.println("Trying server port: " + n2);
            try {
                this.ss = new ServerSocket(n2);
                this.s = this.ss.accept();
                inputStream = this.s.getInputStream();
            }
            catch (IOException iOException) {
                System.out.println("Server port " + n2 + " failed: " + iOException.getMessage());
                if (++n2 - n <= 100) continue;
                return;
            }
            try {
                OutputStream outputStream = this.s.getOutputStream();
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
                System.out.println("Server sending handshake...");
                printWriter.println(this.report.ipAddress1);
                printWriter.flush();
                printWriter.println(this.report.ipAddress2);
                printWriter.flush();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 32384);
                int n3 = 10;
                while (n3 > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    boolean bl2 = bufferedReader.ready();
                    System.out.println("Server waiting for handshake response {" + n3 + "} : " + bl2);
                    if (bl2) {
                        string = bufferedReader.readLine();
                        System.out.println("Client sent: " + string);
                        if (string.equals("READY")) {
                            System.out.println("Client authenticated to server!");
                            bl = true;
                            break;
                        }
                        System.out.println("Client NOT authenticated to server!");
                        ++n2;
                        break;
                    }
                    --n3;
                }
                printWriter.close();
                if (bl) continue;
                bufferedReader.close();
                this.s.close();
                this.s = null;
                this.ss.close();
                this.ss = null;
            }
            catch (IOException iOException) {}
        }
        System.out.println(String.valueOf(this.report.thisIpAddress) + ": localPort " + this.s.getLocalPort() + " port: " + this.s.getPort());
        int n4 = 0;
        while (n4 < 240) {
            try {
                boolean bl3 = bufferedReader.ready();
                if (bl3) {
                    n4 = 0;
                    String string2 = bufferedReader.readLine();
                    if (string2.equals("DONE")) {
                        this.doneFlag = true;
                        break;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        this.report.reportInfoSet(string, string3);
                    }
                    continue;
                }
                ++n4;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                System.out.println("IOException during data fetch: " + iOException.getMessage());
                return;
            }
        }
        System.out.println("Exiting information loop");
        try {
            this.s.close();
            this.s = null;
            this.ss.close();
            this.ss = null;
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOException during close");
            return;
        }
    }

    public void closeSockets() {
        try {
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            if (this.ss != null) {
                this.ss.close();
                this.ss = null;
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException during close");
            return;
        }
    }
}

