#!/bin/sh

JAVA_VER_STR="1_5 1_6"
JAVA_VER="1.5 1.6"

# The Java Executable
JAVA_EXEC=java
JAVA_HOME_PROP_FOUND=0

for ver in $JAVA_VER_STR
do
   JAVA_HOME_PROP=`grep "java_$ver\.home\=" $HOME/.cwirc 2>/dev/null`
   if [ $? -eq 0 ]; then
      JAVA_HOME_VALUE=`echo $JAVA_HOME_PROP | awk -F= '{ print $2 }' 2>/dev/null`
      if [ $? -eq 0 ]; then
         if [ -f $JAVA_HOME_VALUE/bin/java ]; then
               JAVA_EXEC=$JAVA_HOME_VALUE/bin/java
               JAVA_HOME_PROP_FOUND=1
         fi
      fi
   fi
done

IS_VER_CORRECT=0;
if [ $JAVA_HOME_PROP_FOUND -eq 0 ]; then
   grep "" $0 2>&1 > /dev/null
   if [ $? -eq 0 ]; then
      for ver in $JAVA_VER
      do
         java -version 2>&1 | grep "[^0-9.]$ver" > /dev/null
         if [ $? -eq 0 ]; then
            IS_VER_CORRECT=1
         fi
      done
   fi
else
   IS_VER_CORRECT=1
fi

if [ $IS_VER_CORRECT -eq 0 ]; then
    echo "Incompatible java version found. This version of CWI requires JRE "$JAVA_VER
    exit 1
fi

$JAVA_EXEC -jar installer.jar
exit 0

