<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// discover.js - Will discover 3550 devices.
//Supported WS-C3550-12T, WS-C3550-24, WS-C3550-48, WS-C3550-24-DC
//WS-C3550-24-PWR, WS-C3550-12G, WS-C355024-FX

function constructLEds24_48Chassis() {
        var dev = new top.device();
	dev.x=0;
	dev.y=0;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3550_mode.gif");
	modeBtn.x = 6;
	modeBtn.y = 46;
        modeBtn.width = 18;
        modeBtn.height = 12;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;


        //Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 52;
	tempLed.y = 31;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 52;
	tempLed.y = 37;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 51;
	tempLed.y = 47;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 48;
	tempLed.y = 61;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 46;
	tempLed.y = 68;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
        
        return dev
}


function constructLEds12Chassis() {
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c355012t_mode.gif");
	modeBtn.x = 4;
	modeBtn.y = 38;
	modeBtn.width = 17;
        modeBtn.height = 12;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 54;
	tempLed.y = 24;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 54;
	tempLed.y = 31;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 51;
	tempLed.y = 41;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 45;
	tempLed.y = 55;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 42;
	tempLed.y = 62;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
        return dev;

}

function WSC355012G(int_status, media_type) {
        var dev = constructLEds12Chassis();
        dev.image = "images/c355012g.gif";
	var portImages = top.rj45portImages();
        // Add the 10 GBIC ports.
	var port;
	var xPortCoord = 97;
	var portWidth  = 36;
	var xPortGap   = 57;
	for(i=0; i<10; i++) {       
	   
		if( i%2 == 0 ) yPortCoord = 28;
		else yPortCoord = 56;
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if ( i%2 == 1 ) xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

	// Add the 2 Fixed RJ45 GigabitEthernet ports
        portWidth = 19;
	xPortGap = 20;
	xPortStartPos = 557;
	xPortCoord = xPortStartPos;
	yPortCoord = 47;
	for(i=10; i<12; i++) {
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;	   	   
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}
	return dev;
}

function WSC355024PWR(int_status, media_type) {
        var dev = new top.device();
	dev.noofports = 26;
        dev.x=0;
	dev.y=0;
	dev.image = "images/c355024pwr.gif";	

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3550_mode.gif");
	modeBtn.x = 6;
	modeBtn.y = 39;
        modeBtn.width = 18;
        modeBtn.height = 12;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

        //Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 51;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 51;
	tempLed.y = 32;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 50;
	tempLed.y = 42;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 48;
	tempLed.y = 55;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 46;
	tempLed.y = 62;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 44;
	tempLed.y = 69;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

        // Create the Ports.
     	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 30;
        var xPortStartPos = 115;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

       // Add the 24 FastEthernet ports in 2 groups of 12 each.
       for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 24;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 40;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
 		dev.addPort(port);
        }

        // Add the 2 GBIC ports.
	xPortCoord = 561;
	yPortGap = 10;
        yPortCoord = 23;
	portheight = 18;
	for(i=24; i<26; i++) {       
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord += (portheight + yPortGap);
		dev.addPort(port);
	}	
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED", "INLINE PWR");
	return dev;
}

function WSC355024FX(int_status, media_type) {
        var dev = constructLEds24_48Chassis();
	dev.noofports = 26;
        dev.image = "images/c355024fx.gif";	


       // Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.fxportImages();
	var xPortGap = 1;
	var xPortGroupGap = 13;
        var xPortStartPos = 78;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

       // Add the 24 FX ports in 3 groups of 8 each.
       for(i=0; i<24; i++) {       
		yPortCoord = 40;
		port = new top.fxport(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i == 7 || i == 15) {
			xPortCoord += (portWidth + xPortGap +xPortGroupGap);
		}
                else{
                  xPortCoord += (portWidth + xPortGap);
                }
		dev.addPort(port);
        }

        // Add the 2 GBIC ports.
	xPortCoord = 598;
	yPortGap = 10;
        yPortCoord = 23;
	portheight = 18;
	for(i=24; i<26; i++) {       
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord += (portheight + yPortGap);
		dev.addPort(port);
	}	
	return dev;
}

function WSC355024(int_status, media_type) {
        var dev = constructLEds24_48Chassis();
	dev.noofports = 26;
	dev.image = "images/c355024.gif";	

        // Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 30;
        var xPortStartPos = 115;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

        // Add the 24 FastEthernet ports in 2 groups of 12 each.
        for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 24;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 40;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
        }

        // Add the 2 GBIC ports.
	xPortCoord = 469;
	xPortGap = 61;
	portWidth = 36;
	for(i=24; i<26; i++) {       
		yPortCoord = 37;		
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	return dev;
}

function WSC355048(int_status, media_type) {
        var dev = constructLEds24_48Chassis();
	dev.noofports = 50;
	dev.image = "images/c355048.gif";	
        // Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
        var xPortStartPos = 81;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

        // Add the 48 FastEthernet ports in 3 groups of 16 each.
        for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31 || i == 47 ) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
        }

        // Add the 2 GBIC ports.
	xPortCoord = 595;
	yPortGap = 10;
        yPortCoord = 23;
	portheight = 18;
	for(i=48; i<50; i++) {       
				
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord += (portheight + yPortGap);
		dev.addPort(port);
	}	
	return dev;
}

function WSC355012T(int_status, media_type) {
        var dev = constructLEds12Chassis();
	dev.image = "images/c355012t.gif";	
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 27;
	var xPortStartPos = 87;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 50;

	// Add the 10 Fixed RJ45 GigabitEthernet ports
	for(i=0; i<10; i++) {
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;	   	   
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

	// Add the 2 GBIC ports.
	for(i=10; i<12; i++) {       
	    xPortCoord = 569;
		if(i == 10) yPortCoord = 30;
		else yPortCoord = 53;
		port = new top.GBICport(int_status[i][6], portImages); // pass the module type plugged-in the GBIC slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}
	return dev;
}

function createDevice(int_status, media_type, deviceType) {
	var device = null;
	
	if(deviceType == null) {
	return device;	
        }	
	if(deviceType == "WS-C3550-12T") {
		device = new WSC355012T(int_status, media_type);		
	}
        else if(deviceType == "WS-C3550-12G") {
		device = new WSC355012G(int_status, media_type);		
	}
        else if(deviceType == "WS-C3550-24" || deviceType.indexOf("WS-C3550-24-DC") !=-1  ) {
                device = new WSC355024(int_status, media_type);
        }
	else if(deviceType == "WS-C3550-24-PWR") {
		device = new WSC355024PWR(int_status, media_type);		
	}	
	else if(deviceType == "WS-C3550-48") {
		device = new WSC355048(int_status, media_type);
	}
        else if(deviceType == "WS-C3550-24-FX") {
		device = new WSC355024FX(int_status, media_type);
	}

	if(device != null) {
		device.type = deviceType;
		device.family = "3550";
	}
	
	return device;
}
