/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.compression.codec;

import com.cisco.cpnm.boot.internal.compression.codec.BitSet2;
import com.cisco.cpnm.boot.internal.compression.codec.Util;
import java.util.ArrayList;

public class StartStepStopEncoder {
    private int mStart;
    private int mStep;
    private int mStop;
    private int[] maxValuePerStep;

    public static void main(String[] args) {
        int i;
        StartStepStopEncoder sssEncoder = null;
        try {
            sssEncoder = new StartStepStopEncoder(3, 2, 9);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        int[] testValues = new int[]{0, 8, 40, 168};
        int s = 0;
        int previousMaxVal = -1;
        while (s < sssEncoder.maxValuePerStep.length) {
            System.out.print("" + sssEncoder.maxValuePerStep[s] + ", prefix = " + sssEncoder.prefix(s) + ", blocksize = " + sssEncoder.blockSize(s) + ", ");
            boolean[] maxValueBits = Util.toBooleanArray(sssEncoder.maxValuePerStep[s] - previousMaxVal - 1);
            i = 0;
            while (i < maxValueBits.length) {
                System.out.print("" + (maxValueBits[i] ? 1 : 0));
                ++i;
            }
            String bitString = Util.toBitString(sssEncoder.encodeSymbol(testValues[s]));
            bitString = bitString.substring(0, bitString.length() - 1);
            System.out.println(", " + testValues[s] + " = " + bitString);
            previousMaxVal = sssEncoder.maxValuePerStep[s];
            ++s;
        }
        int[] decodedText = sssEncoder.decode(sssEncoder.encode(testValues));
        System.out.print("\n\rDecoded = ");
        i = 0;
        while (i < decodedText.length) {
            System.out.print(", " + decodedText[i]);
            ++i;
        }
        System.out.println();
    }

    public StartStepStopEncoder(int start, int step, int stop) throws Exception {
        if (start < 0 || step < 0 || stop < 0 || stop < start) {
            throw new Exception("start < 0 || step < 0 || stop < 0 || stop < start");
        }
        if ((stop - start) % step != 0) {
            throw new Exception("(stop - start) % step != 0");
        }
        this.mStart = start;
        this.mStep = step;
        this.mStop = stop;
        this.maxValuePerStep = new int[1 + (stop - start) / step];
        int s = 0;
        while (start + s * step <= stop) {
            this.maxValuePerStep[s] = 1 << start + s * step;
            if (s == 0) {
                int n = s;
                this.maxValuePerStep[n] = this.maxValuePerStep[n] - 1;
            } else {
                int n = s;
                this.maxValuePerStep[n] = this.maxValuePerStep[n] + this.maxValuePerStep[s - 1];
            }
            ++s;
        }
    }

    public int maxValue() {
        return this.maxValuePerStep[this.maxValuePerStep.length - 1];
    }

    public byte[] encode(int[] cleartext) {
        byte[] rv = null;
        BitSet2 codebits = new BitSet2();
        int numBits = 0;
        int i = 0;
        while (i < cleartext.length) {
            BitSet2 symbolCodebits = this.encodeSymbol(cleartext[i]);
            if (symbolCodebits == null) {
                rv = null;
                return rv;
            }
            int j = 0;
            while (j < symbolCodebits.length() - 1) {
                codebits.set(numBits, symbolCodebits.get(j));
                ++j;
                ++numBits;
            }
            ++i;
        }
        int numLastSignificantBits = numBits % 8;
        if (numLastSignificantBits == 0) {
            numLastSignificantBits = 8;
        }
        int numFullBytes = numBits / 8;
        rv = new byte[numLastSignificantBits == 8 ? numFullBytes + 1 : numFullBytes + 2];
        int i2 = 0;
        int bitBaseOffset = 0;
        while (i2 < rv.length - 1) {
            byte byte1 = 0;
            int j = 0;
            while (j < 8 && bitBaseOffset + j < numBits) {
                if (codebits.get(bitBaseOffset + j)) {
                    byte1 = (byte)(byte1 | 1 << 7 - j);
                }
                ++j;
            }
            rv[i2] = byte1;
            bitBaseOffset += 8;
            ++i2;
        }
        rv[rv.length - 1] = (byte)numLastSignificantBits;
        return rv;
    }

    public int[] decode(byte[] code) {
        int[] rv = null;
        int numLastSignificantBits = code[code.length - 1];
        if (numLastSignificantBits > 8) {
            numLastSignificantBits = 8;
        } else if (numLastSignificantBits < 1) {
            numLastSignificantBits = 1;
        }
        BitSet2 codebits = new BitSet2();
        int i = 0;
        int bitBaseOffset = 0;
        while (i < code.length - 1) {
            int numSignificantBits = i != code.length - 2 ? 8 : numLastSignificantBits;
            int j = 0;
            while (j < numSignificantBits) {
                boolean bit = (code[i] & 1 << 7 - j) != 0;
                codebits.set(bitBaseOffset + j, bit);
                ++j;
            }
            ++i;
            bitBaseOffset += 8;
        }
        codebits.set(8 * (code.length - 2) + numLastSignificantBits);
        ArrayList<Integer> symbolsAL = new ArrayList<Integer>();
        int offset = 0;
        while (offset < codebits.length() - 1) {
            int[] symbol = this.decodeNextSymbol(codebits, offset);
            if (symbol[0] == -1) break;
            symbolsAL.add(new Integer(symbol[0]));
            offset += symbol[1];
        }
        if (offset == codebits.length() - 1) {
            rv = new int[symbolsAL.size()];
            int i2 = 0;
            while (i2 < rv.length) {
                int symbolInt;
                rv[i2] = symbolInt = ((Integer)symbolsAL.get(i2)).intValue();
                ++i2;
            }
        }
        return rv;
    }

    private int[] decodeNextSymbol(BitSet2 bits, int offset) {
        int[] invalid;
        int[] rv = invalid = new int[]{-1, -1};
        if (offset < bits.length() - 1) {
            int blockSize;
            int numSteps;
            int numDecodedBits = 0;
            while (numDecodedBits < this.maxValuePerStep.length - 1 && bits.get(offset + numDecodedBits)) {
                ++numDecodedBits;
            }
            if ((numSteps = numDecodedBits++) < this.maxValuePerStep.length - 1) {
                // empty if block
            }
            if (offset + numDecodedBits + (blockSize = this.blockSize(numSteps)) > bits.length() - 1) {
                return invalid;
            }
            int intValue = 0;
            int i = 0;
            while (i < blockSize) {
                int p = blockSize - 1 - i;
                if (bits.get(offset + numDecodedBits + i)) {
                    intValue |= 1 << p;
                }
                ++i;
            }
            numDecodedBits += blockSize;
            if (numSteps > 0) {
                intValue += this.maxValuePerStep[numSteps - 1] + 1;
            }
            if (intValue != -1) {
                rv[0] = intValue;
                rv[1] = numDecodedBits;
            }
        }
        return rv;
    }

    private BitSet2 encodeSymbol(int cleartextInt) {
        BitSet2 rv = null;
        if (cleartextInt <= this.maxValuePerStep[this.maxValuePerStep.length - 1]) {
            StringBuffer rvSB = new StringBuffer();
            int s = -1;
            s = this.maxValuePerStep.length - 1;
            while (s >= 1 && cleartextInt <= this.maxValuePerStep[s - 1]) {
                --s;
            }
            int codedValue = cleartextInt - (s > 0 ? this.maxValuePerStep[s - 1] + 1 : 0);
            int blockSize = this.blockSize(s);
            boolean[] codedValueBits = Util.toBooleanArray(codedValue);
            rvSB.append(this.prefix(s));
            int i = codedValueBits.length - blockSize;
            while (i < codedValueBits.length) {
                rvSB.append(codedValueBits[i] ? (char)'1' : '0');
                ++i;
            }
            rv = new BitSet2();
            int i2 = 0;
            while (i2 < rvSB.length()) {
                rv.set(i2, rvSB.charAt(i2) == '1');
                ++i2;
            }
            rv.set(rvSB.length());
        }
        return rv;
    }

    private String prefix(int numSteps) {
        StringBuffer rv = new StringBuffer();
        BitSet2 rvTemp = new BitSet2();
        if (numSteps == this.maxValuePerStep.length - 1) {
            rvTemp.set(0, numSteps + 1);
        } else {
            rvTemp.set(0, numSteps);
            rvTemp.set(numSteps, false);
            rvTemp.set(numSteps + 1);
        }
        int i = 0;
        while (i < rvTemp.length() - 1) {
            rv.append(rvTemp.get(i) ? (char)'1' : '0');
            ++i;
        }
        return rv.toString();
    }

    private int blockSize(int numSteps) {
        return this.mStart + numSteps * this.mStep;
    }
}

