/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.compression.codec;

import com.cisco.cpnm.boot.internal.compression.codec.Util;
import java.util.Arrays;

public class ByteSubstring
implements Comparable {
    private static final boolean sUseUnsignedByteComparisons = true;
    private byte[] mBString;
    private int mStartIdx = -1;
    private int mEndIdx = -1;

    public ByteSubstring(byte[] bstring, int startIdx, int endIdx) {
        if (startIdx < 0 || startIdx > endIdx || endIdx - startIdx > bstring.length) {
            throw new IllegalArgumentException();
        }
        this.mBString = bstring;
        this.mStartIdx = startIdx;
        this.mEndIdx = endIdx;
    }

    public final int getStartIdx() {
        return this.mStartIdx;
    }

    public final int getEndIdx() {
        return this.mEndIdx;
    }

    public final byte[] getByteString() {
        return this.mBString;
    }

    public int compareTo(Object arg) {
        ByteSubstring argSString = (ByteSubstring)arg;
        int rv = this.mEndIdx - this.mStartIdx - (argSString.mEndIdx - argSString.mStartIdx);
        int lengthToCompare = Math.min(this.mEndIdx - this.mStartIdx, argSString.mEndIdx - argSString.mStartIdx) + 1;
        int i = 0;
        while (i < lengthToCompare) {
            byte thisByte = this.mBString[this.mStartIdx + i];
            byte thatByte = argSString.mBString[argSString.mStartIdx + i];
            if (thisByte != thatByte) {
                rv = (int)(Util.unsignedLong(thisByte) - Util.unsignedLong(thatByte));
                break;
            }
            ++i;
        }
        return rv;
    }

    public static void main(String[] args) {
        byte[][] bstrings = new byte[][]{{16, -1, 0, 7, 58, 1, 67, 1, 89, 0, 3, -57}, {16, 25, 0, 7, 58, 1, 67, 1, 89, 0, 3, 0, 6, 5, 5}, {15, 25, 7, 58, 67, 89, 3}, {16, 25, 8, 58, 67}, {16, 25, 6, 58, 67, 89, 3}};
        Object[] bsstrings = new ByteSubstring[]{new ByteSubstring(bstrings[0], 0, 11), new ByteSubstring(bstrings[0], 1, 11), new ByteSubstring(bstrings[0], 2, 11), new ByteSubstring(bstrings[0], 3, 11), new ByteSubstring(bstrings[0], 4, 11), new ByteSubstring(bstrings[0], 5, 11), new ByteSubstring(bstrings[0], 6, 11), new ByteSubstring(bstrings[0], 7, 11), new ByteSubstring(bstrings[0], 8, 11), new ByteSubstring(bstrings[0], 9, 11), new ByteSubstring(bstrings[0], 10, 11), new ByteSubstring(bstrings[0], 11, 11)};
        Arrays.sort(bsstrings);
        int i = 0;
        while (i < bsstrings.length) {
            byte[] byteString = ((ByteSubstring)bsstrings[i]).getByteString();
            int startIdx = ((ByteSubstring)bsstrings[i]).getStartIdx();
            int endIdx = ((ByteSubstring)bsstrings[i]).getEndIdx();
            int k = startIdx;
            while (k <= endIdx) {
                System.out.print("\t" + byteString[k]);
                ++k;
            }
            System.out.println();
            ++i;
        }
    }
}

