/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class CSIProperties
extends Properties {
    public static final String SIGNED = "101";
    public static final String UNSIGNED = "201";
    private static final String CSI_PROPERTIES_FILE = ".cms_csi.cfg";
    private boolean existed = false;
    private String propertyFile;

    public CSIProperties() {
        StringBuffer filename = new StringBuffer();
        filename.append(System.getProperty("user.home"));
        filename.append(System.getProperty("file.separator"));
        filename.append(CSI_PROPERTIES_FILE);
        this.propertyFile = filename.toString();
        this.load();
    }

    public boolean existed() {
        return this.existed;
    }

    public boolean isEnabled() {
        Boolean enabled = new Boolean(this.getProperty("enabled", "false"));
        return enabled;
    }

    public boolean isValid() {
        String versionPath;
        File versionFile;
        File repositoryFile;
        String repository = this.getRepository();
        String archivePath = this.getArchivePath();
        if (!this.isEnabled()) {
            return false;
        }
        String version = this.getVersion();
        if (version != null && version.equals("2")) {
            if (repository == null || archivePath == null) {
                return false;
            }
            repositoryFile = new File(repository);
            if (!repositoryFile.exists()) {
                return false;
            }
            File archiveFile = new File(archivePath);
            if (!archiveFile.exists()) {
                return false;
            }
        } else {
            if (repository == null) {
                return false;
            }
            repositoryFile = new File(repository);
            if (!repositoryFile.exists()) {
                return false;
            }
        }
        return (versionFile = new File(versionPath = repository + "/version.xml")).exists();
    }

    public void setEnabled(boolean v) {
        if (v) {
            this.setProperty("enabled", "true");
        } else {
            this.setProperty("enabled", "false");
        }
    }

    public String getRepository() {
        String repository = this.getProperty("repository");
        if (repository == null) {
            repository = this.getDefaultRepositoryName();
            this.setRepository(repository);
        }
        return repository;
    }

    public void setRepository(String v) {
        this.setProperty("repository", v);
    }

    public String getNewArchive() {
        String archive = this.getProperty("active");
        if (archive != null) {
            this.setBackupArchive(archive);
        }
        archive = this.getDefaultArchiveName();
        this.setArchive(archive);
        return archive;
    }

    public String getArchive() {
        return this.getProperty("active");
    }

    public void setArchive(String v) {
        this.setProperty("active", v);
    }

    public void setBackupArchive(String v) {
        this.setProperty("backup", v);
    }

    public String getVersion() {
        return this.getProperty("version");
    }

    public void setVersion(String v) {
        this.setProperty("version", v);
    }

    public String getArchivePath() {
        String path = null;
        String archive = this.getArchive();
        String repository = this.getRepository();
        if (repository != null && archive != null) {
            path = repository + System.getProperty("file.separator") + archive;
        }
        return path;
    }

    public String getPropertyFileName() {
        return this.propertyFile;
    }

    private void load() {
        try {
            FileInputStream inStream = new FileInputStream(new File(this.propertyFile));
            this.load(inStream);
            this.existed = true;
        }
        catch (IOException ex) {
            if (this.getProperty("version") == null) {
                this.setProperty("version", "2");
            }
            if (this.getProperty("enabled") == null) {
                this.setProperty("enabled", "false");
            }
            if (this.getProperty("repository") == null) {
                this.setProperty("repository", this.getDefaultRepositoryName());
            }
            this.existed = false;
        }
    }

    public String getDefaultRepositoryName() {
        StringBuffer repository = new StringBuffer();
        repository.append(System.getProperty("user.home"));
        repository.append("/CiscoCMS");
        return repository.toString();
    }

    public String getDefaultArchiveName() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyMMddHHmmss");
        String dateString = fmt.format(new Date());
        StringBuffer newName = new StringBuffer();
        newName.append("CSI-");
        newName.append(dateString);
        newName.append(".jar");
        return newName.toString();
    }

    public void save() {
        this.setProperty("version", "2");
        if (!this.isEnabled()) {
            this.remove("active");
            this.remove("backup");
            this.remove("repository");
        }
        try {
            FileOutputStream outStream = new FileOutputStream(new File(this.propertyFile));
            this.store(outStream, "CMS Client Side Install Properties");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

