/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.compression.codec;

import com.cisco.cpnm.boot.internal.compression.codec.BitSet2;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

public class HuffmanTable {
    private Node[] m0_thLevelNodes;
    private Node mRootNode;

    public HuffmanTable(int[] weights) {
        this.m0_thLevelNodes = new Node[weights.length];
        TreeSet<Node> candidateNodes = new TreeSet<Node>(new NodeComparator());
        int i = 0;
        while (i < weights.length) {
            Node node;
            this.m0_thLevelNodes[i] = node = new Node();
            node.symbol = i;
            node.weight = weights[i];
            candidateNodes.add(node);
            ++i;
        }
        int dummySymbol = -2;
        while (candidateNodes.size() >= 2) {
            Node candidateNode1 = (Node)candidateNodes.first();
            candidateNodes.remove(candidateNode1);
            Node candidateNode2 = (Node)candidateNodes.first();
            candidateNodes.remove(candidateNode2);
            Node newNode = new Node();
            newNode.symbol = dummySymbol--;
            newNode.descendant1 = candidateNode1;
            newNode.descendant2 = candidateNode2;
            newNode.descendant1.bitcode = false;
            newNode.descendant2.bitcode = true;
            newNode.descendant1.parent = newNode;
            newNode.descendant2.parent = newNode;
            newNode.level = Math.max(newNode.descendant1.level, newNode.descendant2.level) + 1;
            newNode.weight = newNode.descendant1.weight + newNode.descendant2.weight;
            candidateNodes.add(newNode);
        }
        this.mRootNode = (Node)candidateNodes.first();
        candidateNodes.clear();
    }

    public HuffmanTable(int[] cleartextSample, Object dummyDiscriminator) throws Exception {
        this(HuffmanTable.makeWeights(cleartextSample));
    }

    public HuffmanTable(int[][] encodedSymbols) throws Exception {
        this.m0_thLevelNodes = new Node[encodedSymbols.length];
        this.mRootNode = new Node();
        this.mRootNode.level = Integer.MAX_VALUE;
        int i = 0;
        while (i < encodedSymbols.length) {
            if (encodedSymbols[i] == null) {
                throw new Exception("There is a null entry in encodedSymbols.");
            }
            int numSignificantBits = encodedSymbols[i][1];
            if (numSignificantBits > 32) {
                numSignificantBits = 32;
            } else if (numSignificantBits < 1) {
                numSignificantBits = 1;
            }
            Node node = this.mRootNode;
            Node newNode = null;
            int j = 0;
            while (j < numSignificantBits) {
                boolean bit = (encodedSymbols[i][0] & 1 << 31 - j) != 0;
                newNode = new Node();
                newNode.bitcode = bit;
                newNode.level = Integer.MAX_VALUE;
                if (node.descendant1 == null) {
                    newNode.parent = node;
                    node = node.descendant1 = newNode;
                } else if (node.descendant1.bitcode == bit) {
                    node = node.descendant1;
                } else if (node.descendant2 == null) {
                    newNode.parent = node;
                    node = node.descendant2 = newNode;
                } else if (node.descendant2.bitcode == bit) {
                    node = node.descendant2;
                }
                ++j;
            }
            if (node != newNode) {
                throw new Exception("encodedSymbols is not a prefix code.");
            }
            node.level = 0;
            node.symbol = i;
            this.m0_thLevelNodes[i] = node;
            ++i;
        }
    }

    private static int[] makeWeights(int[] cleartextSample) throws Exception {
        int[] rv = new int[]{};
        int maxSymbol = 0;
        int i = 0;
        while (i < cleartextSample.length) {
            maxSymbol = Math.max(maxSymbol, cleartextSample[i]);
            ++i;
        }
        int[] weights = new int[maxSymbol + 1];
        int i2 = 0;
        while (i2 < cleartextSample.length) {
            int n = cleartextSample[i2];
            weights[n] = weights[n] + 1;
            ++i2;
        }
        int i3 = 0;
        while (i3 < weights.length) {
            if (weights[i3] == 0) {
                throw new Exception("Symbol '" + i3 + "' is missing in cleartextSample.");
            }
            ++i3;
        }
        rv = weights;
        return rv;
    }

    public int[] decode(byte[] code) {
        int[] rv = null;
        int numLastSignificantBits = code[code.length - 1];
        if (numLastSignificantBits > 8) {
            numLastSignificantBits = 8;
        } else if (numLastSignificantBits < 1) {
            numLastSignificantBits = 1;
        }
        BitSet2 codebits = new BitSet2();
        int i = 0;
        int bitBaseOffset = 0;
        while (i < code.length - 1) {
            int numSignificantBits = i != code.length - 2 ? 8 : numLastSignificantBits;
            int j = 0;
            while (j < numSignificantBits) {
                boolean bit = (code[i] & 1 << 7 - j) != 0;
                codebits.set(bitBaseOffset + j, bit);
                ++j;
            }
            ++i;
            bitBaseOffset += 8;
        }
        codebits.set(8 * (code.length - 2) + numLastSignificantBits);
        ArrayList<Integer> symbolsAL = new ArrayList<Integer>();
        int offset = 0;
        while (offset < codebits.length() - 1) {
            int[] symbol = this.decodeNextSymbol(codebits, offset);
            if (symbol[0] == -1) break;
            symbolsAL.add(new Integer(symbol[0]));
            offset += symbol[1];
        }
        if (offset == codebits.length() - 1) {
            rv = new int[symbolsAL.size()];
            int i2 = 0;
            while (i2 < rv.length) {
                int symbolInt;
                rv[i2] = symbolInt = ((Integer)symbolsAL.get(i2)).intValue();
                ++i2;
            }
        }
        return rv;
    }

    private int[] decodeNextSymbol(BitSet2 bits, int offset) {
        int[] rv = new int[]{-1, -1};
        if (offset < bits.length() - 1) {
            int numDecodedBits = 0;
            Node node = null;
            node = this.mRootNode;
            while (node.level != 0) {
                if (offset + numDecodedBits >= bits.length() - 1) {
                    node = null;
                    break;
                }
                boolean bit = bits.get(offset + numDecodedBits);
                if (node.descendant1.bitcode == bit) {
                    node = node.descendant1;
                } else if (node.descendant2.bitcode == bit) {
                    node = node.descendant2;
                } else {
                    node = null;
                    break;
                }
                ++numDecodedBits;
            }
            if (node != null) {
                rv[0] = node.symbol;
                rv[1] = numDecodedBits;
            }
        }
        return rv;
    }

    public byte[] encode(int[] cleartext) {
        byte[] rv = null;
        BitSet2 codebits = new BitSet2();
        int numBits = 0;
        int i = 0;
        while (i < cleartext.length) {
            BitSet2 symbolCodebits = this.encodeSymbol(cleartext[i]);
            if (symbolCodebits == null) {
                rv = null;
                return rv;
            }
            int j = 0;
            while (j < symbolCodebits.length() - 1) {
                codebits.set(numBits, symbolCodebits.get(j));
                ++j;
                ++numBits;
            }
            ++i;
        }
        int numLastSignificantBits = numBits % 8;
        if (numLastSignificantBits == 0) {
            numLastSignificantBits = 8;
        }
        int numFullBytes = numBits / 8;
        rv = new byte[numLastSignificantBits == 8 ? numFullBytes + 1 : numFullBytes + 2];
        int i2 = 0;
        int bitBaseOffset = 0;
        while (i2 < rv.length - 1) {
            byte byte1 = 0;
            int j = 0;
            while (j < 8 && bitBaseOffset + j < numBits) {
                if (codebits.get(bitBaseOffset + j)) {
                    byte1 = (byte)(byte1 | 1 << 7 - j);
                }
                ++j;
            }
            rv[i2] = byte1;
            bitBaseOffset += 8;
            ++i2;
        }
        rv[rv.length - 1] = (byte)numLastSignificantBits;
        return rv;
    }

    private BitSet2 encodeSymbol(int cleartextInt) {
        BitSet2 rv = null;
        if (cleartextInt < this.m0_thLevelNodes.length) {
            BitSet2 temp = new BitSet2();
            int idx = 0;
            Node node = this.m0_thLevelNodes[cleartextInt];
            while (node != this.mRootNode) {
                temp.set(idx, node.bitcode);
                node = node.parent;
                ++idx;
            }
            temp.set(idx);
            rv = new BitSet2();
            rv.set(temp.length() - 1);
            int i = 0;
            while (i < temp.length() - 1) {
                rv.set(i, temp.get(temp.length() - 2 - i));
                ++i;
            }
        }
        return rv;
    }

    private static class NodeComparator
    implements Comparator {
        private NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            int rv = 0;
            Node node1 = (Node)o1;
            Node node2 = (Node)o2;
            rv = node1.weight - node2.weight;
            if (rv == 0) {
                rv = node1.level - node2.level;
            }
            if (rv == 0) {
                rv = node1.symbol - node2.symbol;
            }
            return rv;
        }
    }

    private static class Node {
        public int symbol = -1;
        public int level;
        public int weight;
        boolean bitcode;
        public Node parent;
        public Node descendant1;
        public Node descendant2;

        private Node() {
        }
    }
}

