/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.external.BootEvent;
import com.cisco.cpnm.boot.external.BootEventListener;
import com.cisco.cpnm.boot.external.ComponentIF;
import com.cisco.cpnm.boot.external.DistInfo;
import com.cisco.cpnm.boot.internal.BootDebug;
import com.cisco.cpnm.boot.internal.BootstrapApplet;
import com.cisco.cpnm.boot.internal.CSIProperties;
import com.cisco.cpnm.boot.internal.Component;
import com.cisco.cpnm.boot.internal.ComponentDb;
import com.cisco.cpnm.boot.internal.Distribution;
import com.cisco.cpnm.boot.internal.Package;
import com.cisco.cpnm.boot.internal.VersionFile;
import com.cisco.cpnm.boot.internal.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class ComponentHelper
implements ComponentIF,
BootDebug {
    private BootstrapApplet boot;
    private boolean saving = false;
    private BootEventListener progressCallback = null;
    private Vector bootEventListeners = new Vector();
    private File lockFile = null;
    private FileChannel lockChannel = null;
    private FileLock lock = null;
    private RandomAccessFile rafFile = null;
    private boolean rebootRequired = false;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$internal$CSIProperties;
    static /* synthetic */ Class class$com$cisco$cpnm$boot$internal$ComponentDb;

    public ComponentHelper(BootstrapApplet boot) {
        this.boot = boot;
    }

    public VersionNumber getBootVersion() {
        return this.boot.getBootVersion();
    }

    protected void saving(boolean v) {
        this.saving = v;
    }

    public boolean existed() {
        CSIProperties csi = (CSIProperties)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = ComponentHelper.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties);
        return csi.existed();
    }

    public boolean isEnabled() {
        CSIProperties csi = (CSIProperties)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = ComponentHelper.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties);
        return csi.isEnabled();
    }

    public void setEnabled(boolean v) {
        CSIProperties csi = (CSIProperties)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = ComponentHelper.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties);
        csi.setEnabled(v);
    }

    public boolean isRebootRequired() {
        return this.rebootRequired;
    }

    public void setRebootRequired(boolean v) {
        this.rebootRequired = v;
    }

    public String getRepository() {
        CSIProperties csi = (CSIProperties)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = ComponentHelper.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties);
        return csi.getRepository();
    }

    public void setRepository(String v) {
        CSIProperties csi = (CSIProperties)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = ComponentHelper.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties);
        csi.setRepository(v);
    }

    public void save() {
        CSIProperties csi = (CSIProperties)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = ComponentHelper.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties);
        csi.save();
    }

    public boolean csiLock() {
        boolean success;
        block3: {
            success = false;
            StringBuffer sb = new StringBuffer();
            sb.append(System.getProperty("user.home"));
            sb.append(System.getProperty("file.separator"));
            sb.append(".cms_csi.cfg");
            if (this.lock != null) break block3;
            try {
                this.lockFile = new File(sb.toString());
                this.rafFile = new RandomAccessFile(this.lockFile, "rw");
                this.lockChannel = this.rafFile.getChannel();
                this.lock = this.lockChannel.tryLock();
                if (this.lock != null) {
                    success = true;
                    break block3;
                }
                this.lockChannel.close();
                this.rafFile.close();
                success = false;
            }
            catch (Exception ex) {
                this.lock = null;
                ex.printStackTrace();
            }
        }
        return success;
    }

    public boolean csiUnlock() {
        boolean success = false;
        if (this.lock != null) {
            try {
                this.lock.release();
                this.lockChannel.close();
                this.rafFile.close();
                success = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.lock = null;
        }
        return success;
    }

    public boolean isSaveNeeded() {
        ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
        return cdb.isSaveNeeded();
    }

    public void saveIfNeeded(BootEventListener progressCallback) {
        this.addBootEventListener(progressCallback);
        Thread worker = new Thread("CSI Save"){

            public void run() {
                ComponentDb cdb = (ComponentDb)ComponentHelper.this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
                cdb.saveIfNeeded();
            }
        };
        worker.start();
    }

    public void uninstall(BootEventListener progressCallback) {
        this.addBootEventListener(progressCallback);
        ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
        cdb.uninstall();
    }

    public int getSaveCount() {
        ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
        return cdb.getSaveCount();
    }

    public int getStoredCount() {
        ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
        return cdb.getStoredCount();
    }

    public void addBootEventListener(BootEventListener listener) {
        if (listener != null && !this.bootEventListeners.contains(listener)) {
            this.bootEventListeners.add(listener);
        }
    }

    public void removeBootEventListener(BootEventListener listener) {
        if (listener != null && this.bootEventListeners.contains(listener)) {
            this.bootEventListeners.remove(listener);
        }
    }

    protected void distributeBootEvent(BootEvent bootEvent) {
        int size = this.bootEventListeners.size();
        if (size > 0) {
            BootEventListener[] bels = new BootEventListener[size];
            bels = this.bootEventListeners.toArray(bels);
            int i = 0;
            while (i < bels.length) {
                bels[i].bootEventOccured(bootEvent);
                ++i;
            }
        }
    }

    public void progressUpdate(int count, int total) {
        Iterator it = this.bootEventListeners.iterator();
        while (it.hasNext()) {
            BootEventListener bel = (BootEventListener)it.next();
            if (count > total) {
                count = total;
            }
            bel.progressUpdate(count, total);
        }
    }

    public DistInfo[] getDistributionInformation() {
        DistInfo[] distInfo = null;
        ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
        List d = cdb.getContribDists();
        if (d != null) {
            Object[] da = d.toArray();
            distInfo = new DistInfo[da.length];
            int i = 0;
            while (i < da.length) {
                Distribution dist = (Distribution)da[i];
                distInfo[i] = dist;
                ++i;
            }
        }
        return distInfo;
    }

    public void writeComponentInformation(PrintWriter pw) {
        boolean i = false;
        ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
        List d = cdb.getContribDists();
        if (d != null) {
            this.writeDistributionInformation(d, pw);
        }
    }

    private void writeDistributionInformation(List d, PrintWriter pw) {
        Object[] da = d.toArray();
        int i = 0;
        while (i < da.length) {
            Distribution dist = (Distribution)da[i];
            pw.print(dist.getName());
            String desc = dist.getDescription();
            if (desc != null) {
                pw.print(" : ");
                pw.println(desc);
            } else {
                pw.println();
            }
            List p = dist.getPackages();
            if (p != null) {
                this.writePackageInformation(p, pw);
            }
            ++i;
        }
    }

    private void writePackageInformation(List p, PrintWriter pw) {
        Object[] pa = p.toArray();
        int j = 0;
        while (j < pa.length) {
            Package pkg = (Package)pa[j];
            pw.print("  ");
            pw.println(pkg.getName());
            List c = pkg.getComponents();
            if (c != null) {
                this.writeComponentInformation(c, pw);
            }
            ++j;
        }
    }

    private void writeComponentInformation(List c, PrintWriter pw) {
        Object[] ca = c.toArray();
        int i = 0;
        while (i < ca.length) {
            Component comp = (Component)ca[i];
            pw.print("    ");
            pw.print(comp.getName());
            pw.print(" [");
            pw.print(comp.getVersion());
            pw.println("]");
            ++i;
        }
    }

    public String getDefaultRepositoryName() {
        CSIProperties csi = (CSIProperties)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$CSIProperties == null ? (class$com$cisco$cpnm$boot$internal$CSIProperties = ComponentHelper.class$("com.cisco.cpnm.boot.internal.CSIProperties")) : class$com$cisco$cpnm$boot$internal$CSIProperties);
        return csi.getDefaultRepositoryName();
    }

    public void saveVersion(String newFileName) throws IOException {
        File newFile = new File(newFileName);
        ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
        cdb.outputVersionFile(newFile);
    }

    public boolean isNewCode(URL codebase) {
        boolean result = false;
        try {
            VersionFile version;
            ComponentDb cdb = (ComponentDb)this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
            String name = this.getSwitchDistID(codebase);
            if (name != null && !cdb.alreadySeen(name) && !(result = cdb.hasNewVersions(version = VersionFile.loadSwitchVersionFile(codebase)))) {
                cdb.addSeen(version.getDistributions());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private String getSwitchDistName(URL codebase) {
        String dist_name;
        try {
            URL info_file = new URL(codebase, "distinfo.dat");
            InputStream info_stream = info_file.openStream();
            Properties info_properties = new Properties();
            info_properties.load(info_stream);
            info_stream.close();
            dist_name = info_properties.getProperty("DistributionName");
        }
        catch (Exception ex) {
            dist_name = null;
        }
        return dist_name;
    }

    private String getSwitchDistID(URL codebase) {
        String dist_id;
        try {
            URL info_file = new URL(codebase, "distinfo.dat");
            InputStream info_stream = info_file.openStream();
            Properties info_properties = new Properties();
            info_properties.load(info_stream);
            info_stream.close();
            String dist_name = info_properties.getProperty("DistributionName");
            if (dist_name == null) {
                dist_id = null;
            } else {
                dist_id = info_properties.getProperty("DistributionID");
                if (dist_id == null) {
                    dist_id = "12.1(19)EA1";
                }
            }
        }
        catch (Exception ex) {
            dist_id = null;
        }
        return dist_id;
    }

    public DistInfo[] queryFilesystem(URL codebase) {
        DistInfo[] distInfo;
        block3: {
            distInfo = null;
            try {
                VersionFile version = VersionFile.loadSwitchVersionFile(codebase);
                List d = version.getDistributions();
                if (d == null) break block3;
                Object[] da = d.toArray();
                distInfo = new DistInfo[da.length];
                int i = 0;
                while (i < da.length) {
                    Distribution dist = (Distribution)da[i];
                    distInfo[i] = dist;
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return distInfo;
    }

    public void integrateFilesystem(URL[] codebase, BootEventListener progressCallback) {
        this.addBootEventListener(progressCallback);
        final URL[] cb_array = codebase;
        Thread worker = new Thread("CSI Integrate"){

            public void run() {
                ComponentDb cdb = (ComponentDb)ComponentHelper.this.boot.getInstance(class$com$cisco$cpnm$boot$internal$ComponentDb == null ? (class$com$cisco$cpnm$boot$internal$ComponentDb = ComponentHelper.class$("com.cisco.cpnm.boot.internal.ComponentDb")) : class$com$cisco$cpnm$boot$internal$ComponentDb);
                cdb.integrateFilesystem(cb_array);
            }
        };
        worker.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

