/*
 *------------------------------------------------------------------
 * forms.js --  Form Utilities
 *
 * March 2002,
 *
 * Copyright (c) 2003 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */
 
//Global vars
var ConfigMsg = "WARNING:\nThe settings shown on this page will be updated.\nClick 'OK' to continue.";
var ClearLogMsg = "WARNING:\nThe Event Log will be cleared.\nClick 'OK' to continue.";
var RestoreMsg = "WARNING:\nYou have requested that ALL settings on this page be reverted to their Factory Defaults!\nClick 'OK' to continue.";
var TextDisableMsg = "DISABLED"

//display properties of a JS object
function dump_props(obj,obj_name)
{
  var result = ""
  for( var i in obj )
  {
    result += obj_name + "." + i + " = " + obj[i] + "\n"
  }
  return result
}

//Encode the IOS command string(s) in src
function encode(src)
{
 var     dst = "";
 var     c;
 var     i;
 for( i = 0 ; i < src.length ; i += 1 )
 {
  c = src.charAt(i);
  if( c >= 'A' && c <= 'Z' )
     dst += c;
  else if( c >= 'a' && c <= 'z' )
     dst += c;
  else if( c >= '0' && c <= '9' )
     dst += c;
  else if( c == ' ' )
     dst += '+';
  else if( c == '/' )
     dst += "%2f";
  else
     dst += escape(c);
 }
 return dst;
}

//Determine if a string is blank
function isBlank(testStr)
{
  if (testStr.search(/\S/) == -1)
    return true
  return false
}


//Determine if a password valid for CLI; like isCLIString, except 
//beginning ! # ; ARE allowed
function isCLIPasswd(testStr)
{
  if (isBlank(testStr))
    return false
  if (testStr.search(/[\t?"$+\[]/) != -1)
    return false
  return true
}

//Determine if a string is a valid IP address
function isIP(testStr)
{
  var     dots = 0;
  for( var i = 0 ; i < testStr.length ; ++i )
  {
    if( testStr.charAt(i) >= '0' && testStr.charAt(i) <= '9') {
       continue;
    } else if( testStr.charAt(i) == '.' ) {
       ++dots;
       continue;
    } else {
       break;
    }
  }
  if (i==0 || i!=testStr.length || dots != 3)
    return false;
  
  var fieldArray = testStr.split(".")
  var octet1 = parseInt(fieldArray[0], 10)
  var octet2 = parseInt(fieldArray[1], 10)
  var octet3 = parseInt(fieldArray[2], 10)
  var octet4 = parseInt(fieldArray[3], 10)
  //make sure no blank fields
  if (isNaN(octet1) || isNaN(octet2) || isNaN(octet3) || isNaN(octet4))
    return false
  if (octet1 < 0 || octet1 > 255)
    return false;
  if (octet2 < 0 || octet2 > 255)
    return false;
  if (octet3 < 0 || octet3 > 255)
    return false;
  if (octet4 < 0 || octet4 > 255)
    return false;
  return true;
}

function getFormattedIP(ipStr)
{
  var fieldArray = ipStr.split(".")
  var ip = parseInt(fieldArray[0], 10); 
  ip += "." + parseInt(fieldArray[1], 10);
  ip += "." + parseInt(fieldArray[2], 10);
  ip += "." + parseInt(fieldArray[3], 10);
  return ip;
}

//Determine if form object is at default value. Returns false if newly selected or de-selected.
function def(obj)
{
    if( obj.type == "text" || obj.type == "password")
    {
        //don't treat a blank field as unchanged, since page may interpret blank as delete
        if( obj.value == obj.defaultValue)
            return true;
    }
    else if( obj.type == "checkbox" || obj.type == "radio")
    {
        if( obj.checked == obj.defaultChecked )
            return true;
    }
    else if( obj.type == "select-one" )
    {
        var noSelectDefault = true;   //IE may have no select default at startup
        if (obj.selectedIndex < 0)
            return true
        for (i=0; i<obj.length; i++) {
            if (obj.options[i].defaultSelected == true)
                noSelectDefault = false
        }
        if( obj.options[obj.selectedIndex].selected == 
            obj.options[obj.selectedIndex].defaultSelected )
            return true;
        if (noSelectDefault)
            return true;
    }
    else if( obj.type == "select-multiple" )
    {
        for( i = 0 ; i < obj.length ; i += 1 )
            if( obj.options[i].selected != obj.options[i].defaultSelected )
                return false;
        return true;
    }
    else
        alert("def() does not know object type\n" + dump_props(obj,"obj"));
    return false;
}

//Determine if form object is modified. Returns true if newly selected.
function modified(obj)
{
    if( obj.type == "text" || obj.type == "password" )
    {
        //don't treat a blank field as unchanged, since page may interpret blank as delete
        if( obj.value != obj.defaultValue)
            return true;
    }
    else if( obj.type == "checkbox" )
    {
        if( obj.checked == true )
            if( obj.defaultChecked == false )
                return true;
    }
    else if( obj.type == "select-one")
    {
        if ( obj.selectedIndex >= 0 )
            if( obj.options[obj.selectedIndex].selected != obj.options[obj.selectedIndex].defaultSelected)
                return true;
    }
    else if( obj.type == "radio")
    {
        if ( obj.checked == true )
            if( obj.defaultChecked == false )
                return true;
    }
    else
        alert("modified() does not know object type=" + obj.type + "\n" + dump_props(obj,"obj"));
    return false;
}
