<!-- Copyright (c) 2005 by Cisco Systems, Inc. -->
// smartports.js - Will create the frontPanel for 2950 devices.
// <include a list of SKUs here>

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
   //	alert ("deviceType is:" + deviceType);
	if(deviceType == "WS-C2950-12") {
		device = new WSC295012(uiPortDataArr);
	} else if(deviceType == "WS-C2950-24") {
		device = new WSC295024(uiPortDataArr);
	} else if(deviceType == "WS-C2950C-24") {
		device = new WSC2950C24(uiPortDataArr);
	} else if((deviceType == "WS-C2950SX-24") || (deviceType == "WS-C2950T-24")) {
		device = new WSC2950SX24(uiPortDataArr);
	} else if(deviceType == "WS-C2950G-12-EI") {
		device = new WSC2950G12EI(uiPortDataArr);
	} else if(deviceType == "WS-C2950G-24-EI" || deviceType == "WS-C2950G-24-EI-DC") {
		device = new WSC2950G24EI(uiPortDataArr);
	} else if(deviceType == "WS-C2950G-48-EI") {
		device = new WSC2950G48EI(uiPortDataArr);
	} else if(deviceType == "WS-C2950SX-48-SI" || deviceType == "WS-C2950T-48-SI") {
		device = new WSC2950SX_T48SI(uiPortDataArr);
	} else if(deviceType == "WS-C2950ST-24-LRE" || deviceType == "WS-C2950ST-8-LRE") { 
		device = new WSC2950ST24_8LRE(uiPortDataArr); //for both 24 and 8 port devices only gigabit ports are displayed, hence a single fn. is used
	}
}

/*
 *  This is unit tested.
 */
function WSC2950SX_T48SI(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();
		
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')
		document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-2; portId < portCount ; portId++) {
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
	 	document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')
					
}


/*
 *  This is unit tested.
 */

function WSC2950G48EI(uiPortDataArr) {
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "33" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-2; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "33" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-2; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "33" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}


/*
 *  This is unit tested.
 */
function WSC2950G24EI(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                       
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}

/*
 *  This is unit tested.
 */
function WSC2950SX24(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "35" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount - 2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 8 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
		
		for (var portId = portCount - 2; portId < portCount ; portId++) {
		 	document.writeln('\
					<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')								  
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "35" height="9" bgcolor="#f4f4f4">')
	   	document.writeln('\
				  </td></tr>')					
}


/*
 *  This is unit tested.
 */
function WSC2950C24(uiPortDataArr) {

	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "35" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount - 2 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 8 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
		
		for (var portId = portCount - 2; portId < portCount ; portId++) {
		 document.writeln('\
					<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')								  
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "35" height="9" bgcolor="#f4f4f4">')
		document.writeln('\
				  </td></tr>')					
}
/*
 *  This is unit tested.
 */
function WSC295024(uiPortDataArr) {

	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "32" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 8 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "32" height="9" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')					
}


/*
 *  This is unit tested.
 */
function WSC2950G12EI(uiPortDataArr) {

	portCount = uiPortDataArr.length;
	
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount - 2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 == 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  
		writeSpaceCell();
						  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-2; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell(); writeSpaceCell();                                                         
		
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}


function WSC2950ST24_8LRE(uiPortDataArr) {

	portCount = uiPortDataArr.length;
	document.writeln('\
			  <tr><td colspan= "20" height="9" bgcolor="#f4f4f4">')
	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	//writeSpaceCell(); 	writeSpaceCell(); 	//writeSpaceCell();
	for (var portId = 2; portId < portCount ; portId++) {
		document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
	}
				  
	for (var portId = 0; portId < 2 ; portId++) {
	 document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
		document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')								  
	}
	document.writeln('\
				<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell(); 	writeSpaceCell(); //	writeSpaceCell();
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "20" height="9" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')					
}

/*
 *  This is unit tested.
 */
function WSC295012(uiPortDataArr) {

	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "18" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 8 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "32" height="9" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')					
}



function getPortLabel(intName) {
	var intNumber = intName.substring(intName.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	if ((deviceType == "WS-C2950-12") || (deviceType == "WS-C2950-24") || (deviceType == "WS-C2950SX-24")
		|| (deviceType == "WS-C2950SX-48-SI") || (deviceType == "WS-C2950T-48-SI")) {
		return false;
	}		
}

function getMaxVlans() {
	if(deviceType == "WS-C2950-12") {
		return 64;
	} else if(deviceType == "WS-C2950-24") {
		return 64;
	} else if(deviceType == "WS-C2950T-24") {
      return 250;
	} else if(deviceType == "WS-C2950C-24") {
      return 250;
	} else if(deviceType == "WS-C2950SX-24") {		
      return 250;
	} else if(deviceType == "WS-C2950G-12-EI") {
      return 250;
	} else if(deviceType == "WS-C2950G-24-EI" || deviceType == "WS-C2950G-24-EI-DC") {
      return 250;
	} else if(deviceType == "WS-C2950G-48-EI") {
      return 250;
	} else if(deviceType == "WS-C2950SX-48-SI") {
      return 64;
	} else if(deviceType == "WS-C2950T-48-SI") {
      return 64;
	}
}
