/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal;

import cisco.dsbu.cms.boot.internal.Package;
import cisco.dsbu.cms.boot.internal.VersionFile;
import cisco.dsbu.cms.boot.internal.VersionXml;
import cisco.dsbu.cms.boot.internal.util.JreVersion;
import cisco.dsbu.cms.boot.internal.xmllite.CharString;
import cisco.dsbu.cms.boot.internal.xmllite.Handler;
import cisco.dsbu.cms.boot.internal.xmllite.ParseException;
import cisco.dsbu.cms.boot.internal.xmllite.Parser;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class Distribution
implements Handler,
VersionXml {
    private static final boolean DEBUG = true;
    private VersionFile container;
    private String name;
    private JreVersion jreVer;
    private int majVer;
    private List packages;
    private int numLatest;
    private CharString currElem;

    Distribution(VersionFile versionFile) {
        this.container = versionFile;
        this.packages = new ArrayList();
    }

    URL getFilesystem() {
        return this.container.getFilesystem();
    }

    String getName() {
        return this.name;
    }

    List getPackages() {
        return this.packages;
    }

    boolean isContributing() {
        return this.numLatest > 0;
    }

    void updateNumLatest(boolean bl) {
        this.numLatest = bl ? ++this.numLatest : --this.numLatest;
        this.container.updateNumLatest(bl);
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString charString) throws ParseException {
        this.currElem = null;
        if (charString.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (charString.equals(VersionXml.MINIMUM_JRE)) {
            this.currElem = VersionXml.MINIMUM_JRE;
        } else if (charString.equals(VersionXml.MAJOR_VERSION)) {
            this.currElem = VersionXml.MAJOR_VERSION;
        } else if (charString.equals(VersionXml.PACKAGE)) {
            this.currElem = VersionXml.PACKAGE;
            Package package_ = new Package(this);
            this.packages.add(package_);
            parser.pushHandler(package_);
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString charString) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = charString.toString();
        } else if (this.currElem == VersionXml.MINIMUM_JRE) {
            this.jreVer = new JreVersion(charString.toString());
        } else if (this.currElem == VersionXml.MAJOR_VERSION) {
            this.majVer = charString.toInt();
        }
    }

    public void endElement(Parser parser, CharString charString) throws ParseException {
        if (charString.equals(VersionXml.DISTRIBUTION)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }
}

