/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import treeview.ImageSet;

public class TreeViewConnectorImageSet
extends ImageSet {
    protected static Image vertical_line;
    protected static Image line;
    protected static Image line_start;
    protected static Image line_tee;
    protected static Image line_end;
    protected static Image button_collapsed;
    protected static Image button_expanded;
    protected static final int IMAGE_WIDTH = 16;
    protected static final int IMAGE_HEIGHT = 16;
    public static final int VERTICAL_LINE = 0;
    public static final int LINE = 1;
    public static final int LINE_START = 2;
    public static final int LINE_TEE = 3;
    public static final int LINE_END = 4;
    public static final int BUTTON_COLLAPSED = 5;
    public static final int BUTTON_EXPANDED = 6;

    private static Image makeImage(byte[] byArray, ColorModel colorModel) {
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, colorModel, byArray, 0, 16));
    }

    private static void drawLine(byte[] byArray) {
        int n = 4;
        do {
            byArray[144 + n] = 1;
        } while ((n += 2) < 15);
    }

    private static void drawEnd(byte[] byArray) {
        TreeViewConnectorImageSet.drawLine(byArray);
        int n = 1;
        do {
            byArray[n * 16 + 4] = 1;
        } while ((n += 2) <= 9);
    }

    private static void drawVertLine(byte[] byArray) {
        int n = 1;
        do {
            byArray[n * 16 + 4] = 1;
        } while ((n += 2) <= 15);
    }

    private static void drawStart(byte[] byArray) {
        TreeViewConnectorImageSet.drawLine(byArray);
        int n = 9;
        do {
            byArray[n * 16 + 4] = 1;
        } while ((n += 2) <= 15);
    }

    private static void drawTee(byte[] byArray) {
        TreeViewConnectorImageSet.drawLine(byArray);
        int n = 1;
        do {
            byArray[n * 16 + 4] = 1;
        } while ((n += 2) <= 15);
    }

    private static void drawMinus(byte[] byArray) {
        int n = 2;
        do {
            byArray[144 + n] = 2;
        } while (++n <= 6);
    }

    private static void drawPlus(byte[] byArray) {
        TreeViewConnectorImageSet.drawMinus(byArray);
        int n = 7;
        do {
            byArray[n * 16 + 4] = 2;
        } while (++n <= 11);
    }

    public TreeViewConnectorImageSet() {
        this.images = new Image[7];
        this.images[0] = vertical_line;
        this.images[1] = line;
        this.images[2] = line_start;
        this.images[3] = line_tee;
        this.images[4] = line_end;
        this.images[5] = button_collapsed;
        this.images[6] = button_expanded;
    }

    private static void drawBox(byte[] byArray) {
        int n = 5;
        do {
            int n2 = 0;
            do {
                byArray[n * 16 + n2] = n2 == 0 ? 1 : (n2 == 8 ? 1 : (n == 5 ? 1 : (n == 13 ? 1 : 3)));
            } while (++n2 < 9);
        } while (++n < 14);
    }

    static {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byArray[0] = -1;
        byArray2[0] = -1;
        byArray3[0] = -1;
        byArray[1] = -128;
        byArray2[1] = -128;
        byArray3[1] = -128;
        byArray[2] = 0;
        byArray2[2] = 0;
        byArray3[2] = 0;
        byArray[3] = -1;
        byArray2[3] = -1;
        byArray3[3] = -1;
        IndexColorModel indexColorModel = System.getProperty("java.vendor").startsWith("Microsoft") && System.getProperty("java.version").startsWith("1.1") && System.getProperty("os.name").startsWith("Windows NT") ? new IndexColorModel(8, 4, byArray, byArray2, byArray3) : new IndexColorModel(8, 4, byArray, byArray2, byArray3, 0);
        byte[] byArray4 = new byte[256];
        TreeViewConnectorImageSet.drawVertLine(byArray4);
        vertical_line = TreeViewConnectorImageSet.makeImage(byArray4, indexColorModel);
        byArray4 = new byte[256];
        TreeViewConnectorImageSet.drawLine(byArray4);
        line = TreeViewConnectorImageSet.makeImage(byArray4, indexColorModel);
        byArray4 = new byte[256];
        TreeViewConnectorImageSet.drawStart(byArray4);
        line_start = TreeViewConnectorImageSet.makeImage(byArray4, indexColorModel);
        byArray4 = new byte[256];
        TreeViewConnectorImageSet.drawTee(byArray4);
        line_tee = TreeViewConnectorImageSet.makeImage(byArray4, indexColorModel);
        byArray4 = new byte[256];
        TreeViewConnectorImageSet.drawEnd(byArray4);
        line_end = TreeViewConnectorImageSet.makeImage(byArray4, indexColorModel);
        byArray4 = new byte[256];
        TreeViewConnectorImageSet.drawBox(byArray4);
        TreeViewConnectorImageSet.drawMinus(byArray4);
        button_expanded = TreeViewConnectorImageSet.makeImage(byArray4, indexColorModel);
        byArray4 = new byte[256];
        TreeViewConnectorImageSet.drawBox(byArray4);
        TreeViewConnectorImageSet.drawPlus(byArray4);
        button_collapsed = TreeViewConnectorImageSet.makeImage(byArray4, indexColorModel);
    }
}

