<!-- Copyright (c) 2005, 2009 by Cisco Systems, Inc. -->
// smartports.js - Will create the ports panel for EagleEye Layer 2 SKUs.
/* <include a list of SKUs here>
 
	List of EagleEye Layer 2 SKUs are
    EAGLEEYE SM-ES2-16-P				    15->Fa0/1-15 RJ45 & 1->Gi0/0 RJ45  
    EAGLEEYE SM-ES2-24						23->Fa0/1-23 RJ45 & 1->Gi0/0 RJ45
    EAGLEEYE SM-ES2-24-P					23->Fa0/1-23 RJ45 & 1->Gi0/0 RJ45
	EAGLEEYE SM-D-ES2-48				    48->Fa0/2-49 RJ45 & 2->Gi0/0-1 SFP
 */

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
	if(deviceType == null)
		return device;	
	if(deviceType == "SM-ES2-16-P") { 
		uiPortDataArr = removeInternalPorts(new Array("16","17"));
		device = new SM_ES2_16P(uiPortDataArr);
	}else if(deviceType == "SM-ES2-24-P" || deviceType == "SM-ES2-24") {
		uiPortDataArr = removeInternalPorts(new Array("24","25"));
		device = new SM_ES2_24(uiPortDataArr);
	}else if(deviceType == "SM-D-ES2-48") {
		uiPortDataArr = removeInternalPorts(new Array("50","51"));
		device = new SMD_ES2_48(uiPortDataArr);
	}
}


function getPortLabel(intName) {
	var tmpStr = intName.substring(intName.indexOf('/')+1);
	var intNumber = tmpStr.substring(tmpStr.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
  	return 250;	
}
//removes internal ports from the two port arrays and returns the UI port array
function removeInternalPorts(excludePortsArr) {
	var tempArr1 = uiPortDataArr;
	var tempArr2 = devicePortDataArr;
	if(excludePortsArr.length > 0) {
		for(var i=excludePortsArr.length-1; i>=0; i--) {
			tempArr1 = tempArr1.slice(0, parseInt(excludePortsArr[i]));
			tempArr2 = tempArr2.slice(0, parseInt(excludePortsArr[i]));
		}
		uiPortDataArr = tempArr1;
		devicePortDataArr = tempArr2;
		return uiPortDataArr;
	}
}
//For SM-ES2-16-P
function SM_ES2_16P(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId = portCount-2; portId >=0 ; portId--) {
  		//Odd numbered ports in first row in reverse order: 15 - 3
		if (portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		//External Gigabit port at the end of first row
		for (var portId = portCount-1; portId < portCount; portId++) {
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
		
		for (var portId = portCount-2; portId >=0 ; portId--) {
			//Even numbered ports in second row in reverse order: 16 - 2
			if (portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}
//For SM-ES2-24 & SM-ES2-24-P 
function SM_ES2_24(uiPortDataArr){ 	
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId = portCount-2; portId >=0 ; portId--) {
  		// This is extra space between port 15 and 17
		if(portId == 14) { 
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row in reverse order: 23 - 3
		if (portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		//External Gigabit port at the end of first row
		for (var portId = portCount-1; portId < portCount; portId++) {
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
		
		for (var portId = portCount-2; portId >=0 ; portId--) {
			// This is extra space between port 16 and 18
			if(portId == 15) { 
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row in reverse order: 24 - 2
			if (portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}
//EagleEye SM-D-ES2-48
function SMD_ES2_48(uiPortDataArr) {//PoE ready for future
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-3; portId >=0 ; portId--) {
  		// This is extra space between port 17 & 19 and 33 & 35
		if(portId == 14 || portId == 30) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row in reverse order: 49 - 3		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	var portId = portCount-2;// add first SFP port
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-3; portId >=0 ; portId--) {
		// This is extra space between port 18 & 20 and 34 & 36
		if(portId == 15 || portId == 31) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row in reverse order: 50 - 4
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}

	}
	var portId = portCount-1; //add second SFP port
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');	
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}
//*** End Of Layer 2 EagleEye SKUs Smartports Creation ***//