
#!/bin/sh
#   This is the POST2 script generated through XSL for BUILDID: 161
#
#   Required local variables
#
post_start_time=``
nPost=0
exit_status=0
slot=0
slot_message=""
blade=
logFile=/tmp/post2Log


#
#	Check for fwdl in progress
#
baddev=`bootenv BadRootDev 2>/dev/null`
softupgrade=`bootenv SoftUpgrade 2>/dev/null`

#
#   getPlatform() function
#
getPlatform()
{
#
#   Should be pizzabox
#
if [ $1 == 0 ]
then
_abc=`/sbin/sin | \
    /bin/grep Platform | \
    /usr/bin/cut -d" " -f2 | \
    /usr/bin/cut -d"," -f1`

case $_abc in

"SWBD162" )
blade="WEDGE64"
;;

"SWBD169" )
blade="CHEWBACCA"
;;

"SWBD170" )
blade="CHEWBACCA24"
;;

* )
blade="UNKNOWN"
;;
esac

else
#
#   Should be chassis
#
case $2 in

"171" )
blade="WEDGE64"
;;

"190" )
blade="CHEWBACCA"
;;

"196" )
blade="CHEWBACCA24"
;;

* )
blade="UNKNOWN"
;;
esac

fi
}

#
#   Post_cleanup() function
#
post_cleanup()
{
    if [ $?child ]
    then
        /bin/kill $child
    fi

    #
    #  display all performed test result
    #
    _current_time=`/bin/date \+\%s`
    _date=`/bin/date`
    _duration=`/usr/bin/expr $_current_time - $startTime`
    _minute=`/usr/bin/expr $_duration / 60`
    _hour=`/usr/bin/expr $_minute / 60`
    _sec=`/usr/bin/expr $_duration % 60`
    _minute=`/usr/bin/expr $_minute % 60`
    /bin/echo "POST2:$slot_message script has been ABORTED $_date took ($_hour:$_minute:$_sec)"
    /bin/echo "POST2:$slot_message script has been ABORTED $_date took ($_hour:$_minute:$_sec)" >> $logFile.$slot
    /bin/echo "POST2:$slot_message Completed totally $nPost diagnostic tests..."
    /bin/echo "POST2:$slot_message Completed totally $nPost diagnostic tests..." >> $logFile.$slot
    if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] || [ "$blade" = "KESTREL3" ]  || [ "$blade" = "SHENLONG" ]; }
    then
        $smmi -reg DIAG_STATUS_ID -data POST2_FAILINIT
    fi
    exit 1
}

#
#   checkStatus of the command and setup exit_status variable
#
checkStatus()
{
    export child=$!
    wait $child
    rval=$?
    _current_time=`/bin/date \+\%s`
    _date=`/bin/date`
    if [ $nPost -ne 1 ]
        then
            _duration=`/usr/bin/expr $_current_time - $post_start_time`
        else
            _duration=`/usr/bin/expr $_current_time - $startTime`
    fi
    _minute=`/usr/bin/expr $_duration / 60`
    _hour=`/usr/bin/expr $_minute / 60`
    _sec=`/usr/bin/expr $_duration % 60`
    _minute=`/usr/bin/expr $_minute % 60`

    case $rval in
    139 | 237 )
        /bin/echo "POST2:$slot_message $* SKIPPED due to known issue ($rval). Please, run following command manually..."
        /bin/echo "POST2:$slot_message $* SKIPPED due to known issue ($rval). Please, run following command manually..." >>  $logFile.$slot
        /bin/cp $logFile.$slot /var/log
		/bin/echo "Copied $logFile.$slot to persistent storage..."
        ;;
    0 )
        status=PASSED
        ;;
    * )
        status=FAILED
#       copy the POST log to permanent storage for FA
        /fabos/link_bin/sync
        /bin/cp $logFile.$slot /var/log
        /fabos/link_bin/sync

        exit_status=`/usr/bin/expr $exit_status + 1`
	    if  { [ "$blade" = "KESTREL2" ] || [ "$blade" = "BLAZER3" ] ; }
	    then
	        $smmi -reg DIAG_STATUS_ID -data $fail_code
	    fi
        if { [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "KESTREL3" ] || [ "$blade" = "SHENLONG" ]; }
        then
            $smmi -reg DIAG_STATUS_ID -data POST2_FAIL1
            exit $exit_status
        fi
	    ;;
    esac

    if [ $rval -gt 127 ]
    then
        rval=`/usr/bin/expr $rval - 256`
    fi
    /bin/echo "POST2:$slot_message Test #$nPost: $* Status: $status exit_status $rval $_date took ($_hour:$_minute:$_sec)"
    /bin/echo "POST2:$slot_message Test #$nPost: $* Status: $status (exit_status $rval)..." >> $logFile.$slot
    /bin/echo "$status" >> $logFile.$slot.$status
    if [ $exit_status -ne 0 ]
        then
            exit $exit_status
    fi
}

trap "" 2
trap post_cleanup INT TERM KILL

#
#   Fill slot variable from FABOS_SLOTNO
#
if [ $?FABOS_SLOTNO ]
then
    slot=$FABOS_SLOTNO
    fi
#
#   Fill bladeId variable from Param passed
#
if [ -n "$1" ]
then
    bladeId=$1
fi

#
#   Identify blade here
#
getPlatform $slot $bladeId

#
#   Cleanup the old log file
#
if [ -f $logFile.$slot ]
then
    /bin/rm $logFile.$slot
fi

if [ $blade = UNKNOWN ]; then
    /bin/echo "POST2: Blade is UNKNOWN Slot=$slot Blade=$blade" >> $logFile.$slot
    #   Not an error; We dont define the platform, POST2 test list; We continue to enable the blade/system
    sleep 5
    exit 0
fi

#
#	Prevent post from running when fw commit is in progress
#
#if [ -f "/tmp/fwcommit" ]
#then
#    /bin/echo "POST2 skipped due to firmwarecommit in progress $_date" >> $logFile.$slot
#    sleep 5
#    exit 0
#fi

#
#   Sourcing diagcommon.sh
#
home="/fabos/share"
util="diagcommon.sh"
ok=0
for f in "./$util" "$FABOSHOME/share/$util" "$home/$util" ; do
    if [ -r $f ] ; then
        . $f
        ok=1
        break;
    fi
done
if [ $ok -ne 1 ] ; then
    /bin/echo "POST2: Could not locate $util; Aborting"
    /bin/echo "POST2: Could not locate $util; Aborting" >> $logFile.$slot
    exit 3
fi

#
#  Check post level control register from FPGA 0xc0
#  if 0x00 or 0x01 exit post1
#
 smmi=`commandPath setmmi`
 gmmi=`commandPath getmmi`
 setdbg=`commandPath setdbg`
 $setdbg DIAG 1
if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "KESTREL3" ] ; }
then
     state=`$gmmi -reg "POST CONFIG"| cut -d" " -f2`
     state1=`expr $state / 63`
     case $state1 in
         0 ) $smmi -reg DIAG_STATUS_ID -data INIT_COMPLETE
             exit 0;;
          *) ;;
     esac


     # if POST1 failed keep the value
     state=`$gmmi -reg "DIAG_STATUS_ID" | cut -d" " -f2`
     if [ $state = POST_FAIL2 ]
       then
       state1 = 100
     fi
fi
if { [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] ; }
then
    state=`$gmmi -reg "POST CONFIG" | cut -d" " -f2`
    case $state in
        0) $smmi -reg DIAG_STATUS_ID -data INIT_COMPLETE
            exit 0;;
        *) ;;
    esac
fi
if [ "$blade" = "SHENLONG" ]
then
     state=`$gmmi -reg "POST CONFIG"| cut -d" " -f2`
     /bin/echo "POST2: get POST CONFIG Value" >> $logFile.$slot
     state1=`expr $state / 63`
     case $state1 in
         0 ) $smmi -reg DIAG_STATUS_ID -data INIT_COMPLETE
             exit 0;;
          *) ;;
     esac


     # if POST1 failed keep the value
     state=`$gmmi -reg "DIAG_STATUS_ID" | cut -d" " -f2`
     if [ $state = POST_FAIL2 ]
       then
       state1 = 100
     fi
fi

#
#   Check Pizzabox/Chassis variant during runtime; isMultiBlade is defined in diagcommon.sh
#   Also setup slot_message variable
#
multiBlade=`isMultiBlade`
if [ $multiBlade = TRUE ]
then
    slot_message="Slot $slot"
    export syntax="$0 -slot [slot] essScript"
else
    export syntax="$0 essScript"
fi

#
#   Export Environment variables
#
DIAG_POST=1 ; export DIAG_POST
DIAG_USR_FAILLIM=1 ; export DIAG_USR_FAILLIM
if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] || [ "$blade" = "KESTREL3" ] || [ "$blade" = "SHENLONG" ]; }
then
     $smmi -reg DIAG_STATUS_ID -data POST2_INIT
fi
#
#   Add blade identifiers to our Log file for debugging purpose; Zero means pizzabox
#
/bin/echo "POST2:$slot_message running for platform: $blade, Slot#: $slot, Logfile: $logFile"  >> $logFile.$slot

#
#   Setup commandPaths
#
cmd=`commandPath exec_diag`
setdbg=`commandPath setdbg`
$setdbg DIAG 1
#
#   Start message to the user
#
startTime=`/bin/date \+\%s`
_date=`/bin/date`
/bin/echo "" >> $logFile.$slot
/bin/echo "POST2:$slot_message started running $_date"
/bin/echo "POST2:$slot_message started running $_date" >> $logFile.$slot

#
#   Reset Error on each port
#
/bin/echo "POST2:$slot_message Clearing errors" >> $logFile.$slot
$cmd diagclearerror $slot > /dev/null

#
#   Detect and handle bplb_mode
#
bplb_mode=`getConfig diag.mode.bplb 2 0`
if [ "$bplb_mode" != "0" ]
then
    /bin/echo "POST2:$slot_message BPLB mode is ON"
    /bin/echo "$slot_message BPLB mode is ON" >> $logFile.$slot
fi

#
#	Check whether VF is enabled
#	If VF enabled, get the number fabid of the default switch
#	from a parse of the lscfg --show command.
#
VFOUTPUT=`lscfg --show 2> /dev/null`

if [ "$VFOUTPUT" != "" ]
then
    fabid=`lscfg --show | \
    /bin/grep ds | \
    /usr/bin/tr " " "\n" | \
    /bin/grep ds | \
    /usr/bin/cut -d"(" -f1`
    if [ $fabid -ne $CURRENT_VF ]
    then
        export CURRENT_VF=$fabid
    fi
fi

if { [ "$blade" = "TOMAHAWK" ] || [ "$blade" = "SPIRIT" ] || [ "$blade" = "THOR" ] ; }
then
user_ports=`$cmd diagshow -use_bports 1 | /bin/grep "   OK" | /usr/bin/cut -d " " -f 2 | /bin/grep -v "\-\-" | /bin/sort -n | /usr/bin/xargs /bin/echo`
if [ -z "$user_ports" ] ;
then
	/bin/echo "POST2:$slot_message ABORT - Nothing to test (NO active ports)"
	/bin/echo "POST2:$slot_message ABORT - Nothing to test (NO active ports)" >> $logFile.$slot
	exit 3 ;
else
	/bin/echo "POST2:$slot_message Testing User ports: $user_ports" >> $logFile.$slot
fi
fi



if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "PHAROS" ] || [ "$blade" = "PHAROS_LITE" ] || [ "$blade" = "BLAZER3" ] || [ "$blade" = "KESTREL3" ] || [ "$blade" = "SHENLONG" ]; }
then
     $smmi -reg DIAG_STATUS_ID -data POST2_TEST3
     if [ $exit_status -ne 0 ]
     then
        $smmi -reg DIAG_STATUS_ID -data POST2_FAIL3
     fi
fi
#
#   Execute command-set as per platform
#
case $blade in

#
#   Platform: Platform name not found
#
"UNKNOWN" )
echo "POST2 Script error: Could not determine blade (Parameters: Slot=$slot, Blade=$blade). Aborting" >> $logFile.$slot
exit 4
;;


#
#   Platform: WEDGE64
#
"WEDGE64" )

#
#   Test: portloopbacktest
#

cmd3=`commandPath exec_diag`

nPost=`/usr/bin/expr $nPost + 1`
post_start_time=`/bin/date \+\%s`
_date=`/bin/date`
/bin/echo "POST2:$_date:$slot_message Test #$nPost - Running portloopbacktest" >> $logFile.$slot
/bin/echo "POST2:$_date:$slot_message Test #$nPost - Running portloopbacktest"
$cmd3 portloopbacktest -lb_mode 2 2>&1 >> $logFile.$slot &
checkStatus portloopbacktest -lb_mode 2 2>&1
#
#   Test: Diagcleanup
#

cmd3=`commandPath exec_diag`

_date=`/bin/date`
/bin/echo "POST2:$_date:$slot_message Test - Running Diagcleanup (Silent)" >> $logFile.$slot
$cmd3 usdsetupfortest --slot $slot -test_step 3 -post 1 2>&1 >> $logFile.$slot
status_local=$?

if [ $status_local -ne 0 ]
then
    exit_status=`/usr/bin/expr $exit_status + 1`
fi

;;

#
#   Platform: CHEWBACCA
#
"CHEWBACCA" )

#
#   Test: portloopbacktest
#

cmd3=`commandPath exec_diag`

nPost=`/usr/bin/expr $nPost + 1`
post_start_time=`/bin/date \+\%s`
_date=`/bin/date`
/bin/echo "POST2:$_date:$slot_message Test #$nPost - Running portloopbacktest" >> $logFile.$slot
/bin/echo "POST2:$_date:$slot_message Test #$nPost - Running portloopbacktest"
$cmd3 portloopbacktest -lb_mode 2 2>&1 >> $logFile.$slot &
checkStatus portloopbacktest -lb_mode 2 2>&1
#
#   Test: Diagcleanup
#

cmd3=`commandPath exec_diag`

_date=`/bin/date`
/bin/echo "POST2:$_date:$slot_message Test - Running Diagcleanup (Silent)" >> $logFile.$slot
$cmd3 usdsetupfortest --slot $slot -test_step 3 -post 1 2>&1 >> $logFile.$slot
status_local=$?

if [ $status_local -ne 0 ]
then
    exit_status=`/usr/bin/expr $exit_status + 1`
fi

;;

#
#   Platform: CHEWBACCA24
#
"CHEWBACCA24" )

#
#   Test: portloopbacktest
#

cmd3=`commandPath exec_diag`

nPost=`/usr/bin/expr $nPost + 1`
post_start_time=`/bin/date \+\%s`
_date=`/bin/date`
/bin/echo "POST2:$_date:$slot_message Test #$nPost - Running portloopbacktest" >> $logFile.$slot
/bin/echo "POST2:$_date:$slot_message Test #$nPost - Running portloopbacktest"
$cmd3 portloopbacktest -lb_mode 2 2>&1 >> $logFile.$slot &
checkStatus portloopbacktest -lb_mode 2 2>&1
#
#   Test: Diagcleanup
#

cmd3=`commandPath exec_diag`

_date=`/bin/date`
/bin/echo "POST2:$_date:$slot_message Test - Running Diagcleanup (Silent)" >> $logFile.$slot
$cmd3 usdsetupfortest --slot $slot -test_step 3 -post 1 2>&1 >> $logFile.$slot
status_local=$?

if [ $status_local -ne 0 ]
then
    exit_status=`/usr/bin/expr $exit_status + 1`
fi

;;

esac



if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "KESTREL3" ] ; }
then
    if [ $state1 = 100 ]
       then
       $smmi -reg DIAG_STATUS_ID -data POST_FAIL2
       exit_status = 100
     fi
fi
if [ "$blade" = "SHENLONG" ]
then
    if [ $state1 = 100 ]
       then
       $smmi -reg DIAG_STATUS_ID -data POST_FAIL2
       /bin/echo "Shenlong POST2:set DIAG_STATUS_ID -data POST_FAIL2" >> $logFile.$slot 
       exit_status = 100
     fi
fi

#
#   Display completed test count
#
/bin/echo "POST2:$slot_message  ********** $slot_message POST Summary  **********" >> $logFile.$slot
/bin/echo "POST2:$slot_message Completed totally $nPost diagnostic tests..." >> $logFile.$slot

#
#   If exit_status > 0, report FAILED
#
if [ $exit_status -ne 0 ]
then
    status=FAILED
#	copy the POST log to permanent storage for FA
	/fabos/link_bin/sync
	/bin/cp $logFile.$slot /var/log
	/fabos/link_bin/sync
else
    status=PASSED
    if { [ "$blade" = "KESTREL2" ] || [ "$blade" = "KESTREL3" ] ; }
    then
        $smmi -reg DIAG_STATUS_ID -data INIT_COMPLETE
    fi
    if [ "$blade" = "SHENLONG" ]
    then
        $smmi -reg DIAG_STATUS_ID -data INIT_COMPLETE
        /bin/echo "Shenlong POST2: set DIAG_STATUS_ID -data INIT_COMPLETE" >> $logFile.$slot
    fi
fi

#
#   Display final exit_status
#
_current_time=`/bin/date \+\%s`
_date=`/bin/date`
_duration=`/usr/bin/expr $_current_time - $startTime`
_minute=`/usr/bin/expr $_duration / 60`
_hour=`/usr/bin/expr $_minute / 60`
_sec=`/usr/bin/expr $_duration % 60`
_minute=`/usr/bin/expr $_minute % 60`
/bin/echo "POST2:$slot_message Script $status with exit status of $exit_status $_date took ($_hour:$_minute:$_sec)"
/bin/echo "POST2:$slot_message Script $status with exit_status of $exit_status $_date took ($_hour:$_minute:$_sec)" >> $logFile.$slot
/bin/echo "" >> $logFile.$slot

#
#   Return with the error code (Zero shows no error)
#
exit $exit_status
