#
#    Copyright (c) 2004 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    File name:   debugcommon.sh
#    Module name: diag/scripts
#
#    This file contains several useful functions used by the
#    internal debugging support command scripts.  They are shared.
#

get_minis_chip_port_list()
{
	file=$1
	if [ ! -f $file ] ; then
		return
	fi
		
    next_line=0
    /bin/cat $file | while read line
    do
	    if [ "$line" = "" ] ; then
		    continue
	    fi

        STR_CTL=`/bin/echo $line | /usr/bin/cut -d" " -f1`
        if [ "$STR_CTL" = "CTL" ] ; then
            next_line=1
            return
        fi
        echo "$line"
    done
}

get_chip_line_in_minis_chip_port_list()
{
    if [ $# -lt 2 ] ; then
        return
    fi

    file=$1
    if [ ! -f $file ] ; then
        return
    fi
    
    chip_idx=$2
    chips=0
    minisChipPortList=`get_minis_chip_port_list $file`
    if [ "$minisChipPortList" = "" ] ; then
        return
    fi

    /bin/echo "$minisChipPortList" | while read line
    do
        chipsPerMinis=`/bin/echo $line | /usr/bin/cut -d" " -f2`
        chipCount=`/bin/echo $chipsPerMinis | /usr/bin/cut -d"=" -f2`
        name=`/bin/echo $chipsPerMinis | /usr/bin/cut -d"=" -f1`
        if [ ! "$name" = "chips/Minis" ] ; then
            continue
        fi
        chips=`/usr/bin/expr $chips + $chipCount`
        if [ $chip_idx -lt $chips ] ; then
            echo "$line"
            return
        fi
    done
}

get_port_line_in_minis_chip_port_list()
{
    if [ $# -lt 2 ] ; then
        return
    fi

    file=$1
    if [ ! -f $file ] ; then
        return
    fi
    
    port_idx=$2
	ports=0

	minisChipPortList=`get_minis_chip_port_list $file`
	if [ "$minisChipPortList" = "" ] ; then
	    return
	fi

    /bin/echo "$minisChipPortList" | while read line
	do
		chipsPerMinis=`/bin/echo $line | /usr/bin/cut -d" " -f2`
		portsPerChip=`/bin/echo $line | /usr/bin/cut -d" " -f3`
		name=`/bin/echo $chipsPerMinis | /usr/bin/cut -d"=" -f1`
		if [ ! "$name" = "chips/Minis" ] ; then
		    continue
		fi

		chipCount=`/bin/echo $chipsPerMinis | /usr/bin/cut -d"=" -f2`
		portCount=`/bin/echo $portsPerChip | /usr/bin/cut -d"=" -f2`
		portCount=`/usr/bin/expr $portCount \* $chipCount`
		ports=`/usr/bin/expr $ports + $portCount`
		if [ $port_idx -lt $ports ] ; then
		    echo "$line"
			return
		fi
	done
}

# Get list of ports based on slot number only.
# This does not do error checking and assumes the slot exist.
# Input: slot number($1)
get_bport_list()
{
    file="/proc/fabos/blade/$1/portmap"
    cat $file | sed -e 's/DIS/ENB/g' | grep ENB | grep -v "NULL (UNUSED)" | cut -d' ' -f 2
}

# check whether the provided port is a CPSAS port.
# This does not do error checking and assumes the slot exist.
# Input: slot number($1)
#      : port number($2)
isCPSASPort()
{
	cpsas_flag="FALSE"
	file="/proc/fabos/blade/$1/portmap"

	cpsas_list=`cat $file | sed -e 's/DIS/ENB/g' | grep ENB | grep -v "NULL (UNUSED)" |grep CPSAS | cut -d' ' -f 2`

	for bportno in $cpsas_list; do
		if [ $bportno == $2 ]; then
			 cpsas_flag="TRUE"
		fi
	done
	/bin/echo $cpsas_flag
}


# check whether the provided port is a pinball port.
# This does not do error checking and assumes the slot exist.
# Input: slot number($1)
#      : port number($2)
isPinballPort()
{
	pball_flag="FALSE"
	file="/proc/fabos/blade/$1/portmap"

	pball_list=`cat $file | sed -e 's/DIS/ENB/g' | grep ENB | grep -v "NULL (UNUSED)" |grep PINBALL | cut -d' ' -f 2`

	for bportno in $pball_list; do
		if [ $bportno == $2 ]; then
			 pball_flag="TRUE"
		fi
	done
	/bin/echo $pball_flag
}

# Get list of chips based on slot number only.
# This does not do error checking and assumes the slot exist.
# Input: slot number($1)
get_chip_list()
{
    file="/proc/fabos/blade/$1/portmap"
    chip_list=`cat $file | sed -e 's/DIS/ENB/g' | grep ENB | grep -v "NULL (UNUSED)" | sed -e 's/  / /g' | sed -e 's/  / /g' | cut -d' ' -f10 | uniq`
    echo $chip_list
}

# fast access to check the BPt only
get_BPt_portmap_list()
{
num_next=0
dashslot_matched=0
dashslot_found=0
slot=0
bport_matched=0
bport_found=0
bport=0

num_next=0
skipNext=0

if [ $# -eq 0 ] ; then
    exit 1
fi
file=$1
shift
for param in $@ ; do

    #
    # if the previous param was "--slot" :
    #
    # 1) we check if the current param is a number.
    # 2) we check if slot/port parameter already set the slot number.
    # 3) we set $slot_num with current parameter if none of the above
    #    condition is met. otherwise we just shift or generate error.
    #
	
    if [ $skipNext -eq 1 ] ; then
        skipNext=0
        continue
    fi

    # -------------------------------------------------------
	# get -bl - blade number
	# -------------------------------------------------------
    # get the argument name
    # echo "param = $param, $#"
    dashslot_matched=`echo $param | /bin/sed 's/[-]\{1,\}bl//'`
    if [ -z "$dashslot_matched" ] ; then
        dashslot_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -bl need a blade number"
            exit 3
        fi
        shift
	    # get the number
	    num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
	    if [ -z "$num_matched" ] ; then
            slot=$1
        fi
        skipNext=1
        shift 
        continue
    else
	# --------------------------------------------------------
	# -BPt : blade port number
	# --------------------------------------------------------
    bport_matched=`echo $param | /bin/sed 's/[-]\{1,\}BPt//'`
    if [ -z "$bport_matched" ] ; then
        bport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            bport=$1
        fi
        skipNext=1
        shift
        continue
    fi # BPt		
    fi # blade
done

# find the file location based on the slot

next_line=0
/bin/cat $file | while read line
do
	if [ "$line" = "" ] ; then
		continue
	fi

    STR_CTL=`/bin/echo $line | /usr/bin/cut -d" " -f1`
    if [ "$STR_CTL" = "CTL" ] ; then
        next_line=1
		echo "$line"
        continue
    fi

    if [ $next_line -eq 1 ] ; then
        next_line=2
		echo "$line"
        continue
    fi

    if [ $next_line -ne 2 ] ; then
        continue
    fi

#    _CTL=`/bin/echo $line | /usr/bin/cut -d" " -f1`
	
    if [ $dashslot_found -eq 1 ] ; then
	    paramstr=`echo $paramstr -bl $slot`
    fi
    if [ $bport_found -eq 1 ] ; then
	    _BPt=`/bin/echo $line | /usr/bin/cut -d" " -f2`
	    if [ $_BPt -ne $bport ] ; then
			continue;
		fi
    fi

	echo "$line"
	return
done
}
# fast access to check the BPt only
get_CH_portmap_list()
{
num_next=0
dashslot_matched=0
dashslot_found=0
slot=0
chipId_matched=0
chipId_found=0
chipId=0
chipPort_matched=0
chipPort_found=0
chipPort=0

num_next=0
skipNext=0
if [ $# -eq 0 ] ; then
    exit 1
fi
file=$1
shift
for param in $@ ; do

    #
    # if the previous param was "--slot" :
    #
    # 1) we check if the current param is a number.
    # 2) we check if slot/port parameter already set the slot number.
    # 3) we set $slot_num with current parameter if none of the above
    #    condition is met. otherwise we just shift or generate error.
    #
	
    if [ $skipNext -eq 1 ] ; then
        skipNext=0
        continue
    fi

    # -------------------------------------------------------
	# get -bl - blade number
	# -------------------------------------------------------
    # get the argument name
    # echo "param = $param, $#"
    dashslot_matched=`echo $param | /bin/sed 's/[-]\{1,\}bl//'`
    if [ -z "$dashslot_matched" ] ; then
        dashslot_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -bl need a blade number"
            exit 3
        fi
        shift
	    # get the number
	    num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
	    if [ -z "$num_matched" ] ; then
            slot=$1
        fi
        skipNext=1
        shift 
        continue
    else
	# --------------------------------------------------------
	# -CH : chip number
	# --------------------------------------------------------
    chipId_matched=`echo $param | /bin/sed 's/[-]\{1,\}CH//'`
    if [ -z "$chipId_matched" ] ; then
        chipId_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            chipId=$1
        fi
        skipNext=1
        shift
        continue
	else
	#---------------------------------------------------------
	# -CPt: Port number
	#---------------------------------------------------------

    chipPort_matched=`echo $param | /bin/sed 's/[-]\{1,\}CPt//'`
    if [ -z "$chipPort_matched" ] ; then
        chipPort_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -CPt need a port number"
            exit 3
        fi
        shift
	    # get the number
	    num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
	    if [ -z "$num_matched" ] ; then
            chipPort=$1
        fi
        skipNext=1
        shift 
        continue
    fi # CPt		
    fi # CH		
    fi # blade
done

# find the file location based on the slot

next_line=0
/bin/cat $file | while read line
do
	if [ "$line" = "" ] ; then
		continue
	fi

    STR_CTL=`/bin/echo $line | /usr/bin/cut -d" " -f1`
    if [ "$STR_CTL" = "CTL" ] ; then
        next_line=1
		echo "$line"
        continue
    fi

    if [ $next_line -eq 1 ] ; then
        next_line=2
		echo "$line"
        continue
    fi

    if [ $next_line -ne 2 ] ; then
        continue
    fi

#    _CTL=`/bin/echo $line | /usr/bin/cut -d" " -f1`
	
    if [ $dashslot_found -eq 1 ] ; then
	    paramstr=`echo $paramstr -bl $slot`
    fi
	if [ $chipId_found -eq 1 ] ; then
		_CH=`/bin/echo $line | /usr/bin/cut -d" " -f10`
		if [ $_CH -ne $chipId ] ; then
			continue;
		fi
	fi

	if [ $chipPort_found -eq 1 ] ; then
		_CPt=`/bin/echo $line | /usr/bin/cut -d" " -f6`
		if [ $_CPt -ne $chipPort ] ; then
			continue;
		fi
		# Just print given chip port
		echo "$line"
		break;
	fi

	echo "$line"
done
}

# -BPt -UPt -SPt
get_portmap_list()
{
num_next=0
dashslot_matched=0
dashslot_found=0
slot=0
bport_matched=0
bport_found=0
bport=0
uport_matched=0
uport_found=0
uport=0
sport_matched=0
sport_found=0
sport=0
mport_matched=0
mport_found=0
mport=0
cport_matched=0
cport_found=0
cport=0
lport_matched=0
lport_found=0
lport=0
gport_matched=0
gport_found=0
gport=0
chipId_matched=0
chipId_found=0
chipId=0
minisId_matched=0
minisId_found=0
minisId=0
groupId_matched=0
groupId_found=0
groupId=0

num_next=0
skipNext=0

if [ $# -eq 0 ] ; then
    exit 1
fi
file=$1
shift
for param in $@ ; do

    #
    # if the previous param was "--slot" :
    #
    # 1) we check if the current param is a number.
    # 2) we check if slot/port parameter already set the slot number.
    # 3) we set $slot_num with current parameter if none of the above
    #    condition is met. otherwise we just shift or generate error.
    #
	
    if [ $skipNext -eq 1 ] ; then
        skipNext=0
        continue
    fi

    # -------------------------------------------------------
	# get -bl - blade number
	# -------------------------------------------------------
    # get the argument name
    # echo "param = $param, $#"
    dashslot_matched=`echo $param | /bin/sed 's/[-]\{1,\}bl//'`
    if [ -z "$dashslot_matched" ] ; then
        dashslot_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -bl need a blade number"
            exit 3
        fi
        shift
	    # get the number
	    num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
	    if [ -z "$num_matched" ] ; then
            slot=$1
        fi
        skipNext=1
        shift 
        continue
    else
	# --------------------------------------------------------
	# -BPt : blade port number
	# --------------------------------------------------------
    bport_matched=`echo $param | /bin/sed 's/[-]\{1,\}BPt//'`
    if [ -z "$bport_matched" ] ; then
        bport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            bport=$1
        fi
        skipNext=1
        shift
        continue
    else
	# --------------------------------------------------------
	# -UPt : user port number
	# --------------------------------------------------------
    uport_matched=`echo $param | /bin/sed 's/[-]\{1,\}UPt//'`
    if [ -z "$uport_matched" ] ; then
        uport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            uport=$1
        fi
        skipNext=1
        shift
        continue
	else
	# --------------------------------------------------------
	# -SPt : slot relative port number
	# --------------------------------------------------------
    sport_matched=`echo $param | /bin/sed 's/[-]\{1,\}SPt//'`
    if [ -z "$sport_matched" ] ; then
        sport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            sport=$1
        fi
        skipNext=1
        shift
        continue
	else	
	# --------------------------------------------------------
	# -MPt : mini switch port number
	# --------------------------------------------------------
    mport_matched=`echo $param | /bin/sed 's/[-]\{1,\}MPt//'`
    if [ -z "$mport_matched" ] ; then
        mport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            mport=$1
        fi
        skipNext=1
        shift
        continue
	else	
	# --------------------------------------------------------
	# -CPt : chip port number
	# --------------------------------------------------------
    cport_matched=`echo $param | /bin/sed 's/[-]\{1,\}MPt//'`
    if [ -z "$cport_matched" ] ; then
        cport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            cport=$1
        fi
        skipNext=1
        shift
        continue
	else
	# --------------------------------------------------------
	# -LPt : logical port number
	# --------------------------------------------------------
    lport_matched=`echo $param | /bin/sed 's/[-]\{1,\}LPt//'`
    if [ -z "$lport_matched" ] ; then
        lport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            lport=$1
        fi
        skipNext=1
        shift
        continue
	else
	# --------------------------------------------------------
	# -GPt : group port number
	# --------------------------------------------------------
    gport_matched=`echo $param | /bin/sed 's/[-]\{1,\}GPt//'`
    if [ -z "$gport_matched" ] ; then
        lport_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            gport=$1
        fi
        skipNext=1
        shift
        continue
	else
	# --------------------------------------------------------
	# -MS : mini switch number
	# --------------------------------------------------------
    minisId_matched=`echo $param | /bin/sed 's/[-]\{1,\}MS//'`
    if [ -z "$minisId_matched" ] ; then
        minisId_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            minisId=$1
        fi
        skipNext=1
        shift
        continue
	else
	# --------------------------------------------------------
	# -CH : chip number
	# --------------------------------------------------------
    chipId_matched=`echo $param | /bin/sed 's/[-]\{1,\}CH//'`
    if [ -z "$chipId_matched" ] ; then
        chipId_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            chipId=$1
        fi
        skipNext=1
        shift
        continue
	else
	# --------------------------------------------------------
	# -GR : group number
	# --------------------------------------------------------
    groupId_matched=`echo $param | /bin/sed 's/[-]\{1,\}GR//'`
    if [ -z "$groupId_matched" ] ; then
        groupId_found=1
        num_next=1
        if [ $# -eq 1 ] ; then
            echo "Invalid param: -UPt need a blade port number"
            exit 3
        fi
        shift
        # get the number
        num_matched=`echo $1 | /bin/sed 's/[0-9]\{1,\}//'`
        if [ -z "$num_matched" ] ; then
            groupId=$1
        fi
        skipNext=1
        shift
        continue
	else
	    echo "Invalid param : $param"
        exit 3
	fi # GP group number
	fi # CH chip number
	fi # MS mini switch
	fi # GPt
	fi # LPt
	fi # CPt
	fi # MPt
	fi # SPt
	fi # UPt
    fi # BPt		
    fi # blade
done

if [ $dashslot_found -eq 1 ] ; then
	paramstr=`echo $paramstr -bl $slot`
fi
if [ $bport_found -eq 1 ] ; then
	paramstr=`echo $paramstr -BPt $bport`
fi
if [ $uport_found -eq 1 ] ; then
	paramstr=`echo $paramstr -UPt $uport`
fi
if [ $sport_found -eq 1 ] ; then
	paramstr=`echo $paramstr -SPt $sport`
fi
if [ $mport_found -eq 1 ] ; then
	paramstr=`echo $paramstr -MPt $cport`
fi
if [ $cport_found -eq 1 ] ; then
	paramstr=`echo $paramstr -CPt $sport`
fi
if [ $lport_found -eq 1 ] ; then
	paramstr=`echo $paramstr -LPt $lport`
fi
if [ $gport_found -eq 1 ] ; then
	paramstr=`echo $paramstr -GPt $gport`
fi
if [ $minisId_found -eq 1 ] ; then
	paramstr=`echo $paramstr -MS $minisId`
fi
if [ $chipId_found -eq 1 ] ; then
	paramstr=`echo $paramstr -CH $chipId`
fi
if [ $groupId_found -eq 1 ] ; then
	paramstr=`echo $paramstr -GR $groupId`
fi
# echo $paramstr

# find the file location based on the slot

#
#file="./testdata"
next_line=0
/bin/cat $file | while read line
do
    if [ "$line" = "" ] ; then
        continue
    fi

    STR_CTL=`/bin/echo $line | /usr/bin/cut -d" " -f1`
    if [ "$STR_CTL" = "CTL" ] ; then
        next_line=1
        echo "$line"
        continue
    fi

    if [ $next_line -eq 1 ] ; then
        next_line=2
        echo "$line"
        continue
    fi

    if [ $next_line -ne 2 ] ; then
        continue
    fi

    if [ $dashslot_found -eq 1 ] ; then
	    paramstr=`echo $paramstr -bl $slot`
    fi
    if [ $bport_found -eq 1 ] ; then
	    _BPt=`/bin/echo $line | /usr/bin/cut -d" " -f2`
	    if [ $_BPt -ne $bport ] ; then
			continue;
		fi
    fi
    if [ $uport_found -eq 1 ] ; then
	    _UPt=`/bin/echo $line | /usr/bin/cut -d" " -f3`
	    if [ $_UPt -ne $uport ] ; then
			continue;
		fi
	fi
	if [ $sport_found -eq 1 ] ; then
	    _SPt=`/bin/echo $line | /usr/bin/cut -d" " -f4`
		if [ $_SPt -ne $sport ] ; then
			continue;
		fi
	fi
	if [ $mport_found -eq 1 ] ; then
		_MPt=`/bin/echo $line | /usr/bin/cut -d" " -f5`
		if [ $_MPt -ne $mport ] ; then
			continue;
		fi
	fi
	if [ $cport_found -eq 1 ] ; then
		_CPt=`/bin/echo $line | /usr/bin/cut -d" " -f6`
		if [ $_CPt -ne $cport ] ; then
			continue;
		fi
	fi
	if [ $lport_found -eq 1 ] ; then
		_LPt=`/bin/echo $line | /usr/bin/cut -d" " -f7`
		if [ $_LPt -ne $lport ] ; then
			continue;
		fi
	fi
	if [ $gport_found -eq 1 ] ; then
		_GPt=`/bin/echo $line | /usr/bin/cut -d" " -f8`
		if [ $_GPt -ne $gport ] ; then
			continue;
		fi
	fi
	if [ $minisId_found -eq 1 ] ; then
		_MS=`/bin/echo $line | /usr/bin/cut -d" " -f9`
		if [ $_MS -ne $minisId ] ; then
			continue;
		fi
	fi
	if [ $chipId_found -eq 1 ] ; then
		_CH=`/bin/echo $line | /usr/bin/cut -d" " -f10`
		if [ $_CH -ne $chipId ] ; then
			continue;
		fi
	fi
	if [ $groupId_found -eq 1 ] ; then
		_GR=`/bin/echo $line | /usr/bin/cut -d" " -f11`
		if [ $_GR -ne $groupId ] ; then
			continue;
		fi
	fi

	echo "$line"
done
}
