<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<html>
			<head>
				<meta content="no-cache" http-equiv="Pragma"/>
				<title>Switch Health Report</title>
			</head>
			<body bgcolor="#ffffff">
				<xsl:apply-templates select="SwitchHealthReport"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="SwitchHealthReport">
		<xsl:choose>
			<xsl:when test="..=/">
				<table width="100%" border="0" cellspacing="0" cellpadding="5">
					<tbody>
						<tr bgcolor="#c0c0c0">
							<td>
								<xsl:value-of select="ReportName"/> Report
							</td>
							<td align="left">Report Time: <xsl:value-of select="ReportTime"/>
							</td>
						</tr>
					</tbody>
				</table>
				<p/>
				<table border="0">
					<tbody>
						<tr>
							<td width="120">Switch Name:</td>
							<td align="left">
								<xsl:value-of select="SwitchInfo/@SwitchName"/>
							</td>
						</tr>
						<tr>
							<td width="120">IP Address:</td>
							<td align="left">
								<xsl:value-of select="SwitchInfo/@IPAddress"/>
							</td>
						</tr>
					</tbody>
				</table>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
		<table border="0">
			<tbody>
				<tr>
					<td width="120">Switch State:</td>
					<xsl:choose>
						<xsl:when test="SwitchStatus/@State='HEALTHY'">
							<td bgcolor="#00ff00" align="left">
								<xsl:value-of select="SwitchStatus/@State"/>
							</td>
						</xsl:when>
						<xsl:when test="SwitchStatus/@State='MARGINAL'">
							<td bgcolor="#ffcc66" align="left">
								<xsl:value-of select="SwitchStatus/@State"/>
							</td>
						</xsl:when>
						<xsl:when test="SwitchStatus/@State='FAULTY' or SwitchStatus/@State='DOWN'">
							<td bgcolor="#ff6666" align="left">
								<xsl:value-of select="SwitchStatus/@State"/>
							</td>
						</xsl:when>
						<xsl:when test="SwitchStatus/@State='OFFLINE'">
							<td bgcolor="#ffffff" align="left">
								<xsl:value-of select="SwitchStatus/@State"/>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td align="left">
								<xsl:value-of select="SwitchStatus/@State"/>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
				<tr>
					<td width="120">Duration (H:M):</td>
					<td align="left">
						<div>
							<div/>
						</div>
						<xsl:value-of select="floor(SwitchStatus/@Duration div 3600)"/>:
						<xsl:value-of select="floor(SwitchStatus/@Duration mod 3600 div 60)"/>
					</td>
				</tr>
			</tbody>
		</table>
		<p/>
		<xsl:apply-templates select="MonitorStateGroup"/>
		<p/>
		<xsl:apply-templates select="PortStateGroup"/>
	</xsl:template>
	<xsl:template match="PortStateGroup">
		<xsl:choose>
			<xsl:when test="count(./*)=0">
				All ports are healthy.
			</xsl:when>
			<xsl:otherwise>
				<!--Use nested table to make thin border  //-->
				<table bgcolor="#999999" cellpadding="0" border="0" width="50%">
					<tr>
						<td bgcolor="#999999">
							<table width="100%" bgcolor="#999999" cellpadding="3" cellspacing="1" border="0">
								<tbody>
									<tr style="font-family:sans-serif, Arial, helvetica; font-size:9pt;font-weight: bold">
										<th bgcolor="#ffffff" align="center">Port #</th>
										<th bgcolor="#ffffff" align="center">State</th>
									</tr>
									<xsl:apply-templates select="PortStateItem"/>
								</tbody>
							</table>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="PortStateItem">
		<tr style="font-family:sans-serif,Arial, helvetica; font-size:8pt;">
			<td nowrap="yes" bgcolor="#ffffff">
				<xsl:choose>
					<xsl:when test="@PortNumber &lt; 10">00</xsl:when>
					<xsl:when test="@PortNumber &lt; 100">0</xsl:when>
				</xsl:choose>
				<xsl:value-of select="@PortNumber"/>
				<xsl:if test="string(@Location)">
					[<xsl:value-of select="@Location"/>]	
				</xsl:if>
			</td>
			<xsl:choose>
				<xsl:when test="@PortState='HEALTHY'">
					<td bgcolor="#00ff00" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:when test="@PortState='MARGINAL'">
					<td bgcolor="#ffcc66" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:when test="@PortState='FAULTY' or @PortState='DOWN'">
					<td bgcolor="#ff6666" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:when test="@PortState='OFFLINE'">
					<td bgcolor="#ffffff" align="center">
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td>
						<xsl:value-of select="@PortState"/>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>
	<xsl:template match="MonitorStateGroup">
		<!--Use nested table to make thin border  //-->
		<table bgcolor="#999999" cellpadding="0" border="0" width="50%">
			<tr>
				<td bgcolor="#999999">
					<table width="100%" bgcolor="#999999" cellpadding="3" cellspacing="1" border="0">
						<tbody>
							<tr style="font-family:sans-serif,Arial, helvetica; font-size:9pt; font-weight:bold">
								<th nowrap="yes" bgcolor="#ffffff" align="center">Switch State Contributors</th>
								<th bgcolor="#ffffff" align="center">State</th>
							</tr>
							<xsl:apply-templates select="MonitorStateItem"/>
						</tbody>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="MonitorStateItem">
		<tr style="font-family:sans-serif,Arial, helvetica; font-size:8pt;">
			<td width="50%" bgcolor="#ffffff">
				<xsl:choose>
					<xsl:when test="@MonitorType='POWERSUPPLY'">Power Supplies Monitor</xsl:when>
					<xsl:when test="@MonitorType='TEMPERATURE'">Temperatures Monitor</xsl:when>
					<xsl:when test="@MonitorType='FAN'">Fans Monitor</xsl:when>
					<xsl:when test="@MonitorType='WWN'">WWN Servers Monitor</xsl:when>
					<xsl:when test="@MonitorType='CP'">Standby CP Monitor</xsl:when>
					<xsl:when test="@MonitorType='BLADE'">Blades Monitor</xsl:when>
					<xsl:when test="@MonitorType='MARGINALPORT'">Marginal Ports Monitor</xsl:when>
					<xsl:when test="@MonitorType='FAULTYPORT'">Faulty Ports Monitor</xsl:when>
					<xsl:when test="@MonitorType='SFP'">Missing SFPs Monitor</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@MonitorType"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<xsl:choose>
				<xsl:when test="@MonitorState='HEALTHY'">
					<td bgcolor="#00ff00" align="center">
						<xsl:value-of select="@MonitorState"/>
					</td>
				</xsl:when>
				<xsl:when test="@MonitorState='MARGINAL'">
					<td bgcolor="#ffcc66" align="center">
						<xsl:value-of select="@MonitorState"/>
					</td>
				</xsl:when>
				<xsl:when test="@MonitorState='FAULTY' or @MonitorState='DOWN'">
					<td bgcolor="#ff6666" align="center">
						<xsl:value-of select="@MonitorState"/>
					</td>
				</xsl:when>
				<xsl:when test="@MonitorState='OFFLINE'">
					<td bgcolor="#ffffff" align="center">
						<xsl:value-of select="@MonitorState"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td>
						<xsl:value-of select="@MonitorState"/>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>
</xsl:stylesheet>
