<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<html>
			<head>
				<meta content="no-cache" http-equiv="Pragma"/>
				<title>SAM Report</title>
			</head>
			<body bgcolor="#ffffff">
				<xsl:apply-templates select="SAMReport"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="SAMReport">
		<xsl:choose>
			<xsl:when test="..=/">
				<table width="100%" border="0" cellspacing="0" cellpadding="5">
					<tbody>
						<tr bgcolor="#c0c0c0">
							<td>
								<xsl:value-of select="ReportName"/> Report</td>
							<td align="left">Report Time: <xsl:value-of select="ReportTime"/>
							</td>
						</tr>
					</tbody>
				</table>
				<p/>
				<table border="0">
					<tbody>
						<tr>
							<td width="120">Switch Name:</td>
							<td align="left">
								<xsl:value-of select="SwitchInfo/@SwitchName"/>
							</td>
						</tr>
						<tr>
							<td width="120">IP Address:</td>
							<td align="left">
								<xsl:value-of select="SwitchInfo/@IPAddress"/>
							</td>
						</tr>
					</tbody>
				</table>
			</xsl:when>
			<xsl:otherwise>	</xsl:otherwise>
		</xsl:choose>
		<p/>
		<xsl:apply-templates select="PortAvailGroup"/>
		<p/>
		<hr/>
		<table width="100%" cellpadding="3" style="font-family:sans-serif,Arial, helvetica; font-size:8pt;">
			<tr>
				<td nowrap="yes">
					<a name="UpTime">Total Up Time :</a>
				</td>
				<td align="left">Percentage of time that a port stays up as an E_Port, L_Port, or F/FL Port.</td>
			</tr>
			<tr>
				<td align="top" nowrap="yes">
					<a name="DownTime">Total Down Time :</a>
				</td>
				<td align="left">Percentage of time that a port goes down/faulty either due to loss of synchronization or because the port does not receive idle frames after speed negotiation.</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="Occur">Down Occurrence :</a>
				</td>
				<td align="left">Amount of times that a port occurs down/faulty.</td>
			</tr>
			<tr>
				<td nowrap="yes">
					<a name="OffTime">Total OfflineTime :</a>
				</td>
				<td align="left">Percentage of time that a port goes offline due to non-usage.</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="PortAvailGroup">
		<!--Use nested table to make thin border  //-->
		<table bgcolor="#999999" cellpadding="0" border="0" width="100%">
			<tr>
				<td bgcolor="#999999">
					<table width="100%" bgcolor="#999999" cellpadding="3" cellspacing="1" border="0">
						<tbody>
							<tr style="font-family:sans-serif,Arial, helvetica; font-size:9pt;">
								<th nowrap="yes" bgcolor="#ffffff" align="center">Port #</th>
								<th bgcolor="#ffffff" align="center">Type</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#UpTime">Total Up Time  (Percent)</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#DownTime">Total Down Time (Percent)</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#Occur">Down Occurrence (Times)</a>
								</th>
								<th bgcolor="#ffffff" align="center">
									<a href="#OffTime">Total Offline Time (Percent)</a>
								</th>
							</tr>
							<xsl:apply-templates select="PortAvailItem"/>
						</tbody>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="PortAvailItem">
		<tr style="font-family:sans-serif,Arial, helvetica; font-size:8pt;">
			<td nowrap="yes" bgcolor="#ffffff">
				<xsl:choose>
					<xsl:when test="@PortNumber &lt; 10">00</xsl:when>
					<xsl:when test="@PortNumber &lt; 100">0</xsl:when>
				</xsl:choose>
				<xsl:value-of select="@PortNumber"/>
				<xsl:if test="string(@Location)">
                                [<xsl:value-of select="@Location"/>]
                                </xsl:if>
			</td>
			<td bgcolor="#ffffff">
				<xsl:value-of select="@PortType"/>
			</td>
			<td bgcolor="#ffffff">
				<xsl:value-of select="@TotalUpTime"/>
			</td>
			<td bgcolor="#ffffff">
				<xsl:value-of select="@TotalDownTime"/>
			</td>
			<td bgcolor="#ffffff">
				<xsl:value-of select="@Occurrences"/>
			</td>
			<td bgcolor="#ffffff">
				<xsl:value-of select="@TotalOffTime"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
