#!/bin/sh
#
#    Copyright (c) 2003 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    File name:   shellFlowControlEnable.sh
#    Module name: fabos/src/utils/sys
#
PATH=/bin:/usr/bin:/fabos/sbin:/fabos/cliexec
CONSOLE_TTY=/dev/ttyS0
arg_cmd=$1
setupOnly=0
ENABLE_COMMAND=shellFlowControlEnable
DISABLE_COMMAND=shellFlowControlDisable

# TRACE=printf # for debugging only

# let us get the original configuration
origVal=`config get system.login.ixonoff 2`
# Make it either 0 or 1
if [ "$origVal" != "1" ]
then
	origVal=0
else
	origVal=1
fi

# test what this command actually wanted to do
# Either argument will say the function or the command name
if [ -z "$arg_cmd" ]
then
	# no argument is given, so let us decide on the command name
	if [ "`printf \"$0\" | grep -c -i $ENABLE_COMMAND`" -ne 0 ]
	then
		arg_cmd="enable"
	elif [ "`printf \"$0\" | grep -c -i $DISABLE_COMMAND`" -ne 0 ]
	then
		arg_cmd="disable"
	else
       		printf "`basename $0`: command not found\n"
        	exit 1
	fi
fi
case "$arg_cmd" in
	enable)
		printf "Enabling flowcontrol\n"
		ENABLE_IXON=1
		IX_ON_OFF="IXON"
		;;

	disable)
		printf "Disabling flowcontrol\n"
	        ENABLE_IXON=0
		IX_ON_OFF="-IXON"
		;;

	setup)
		printf "Setting up flowcontrol\n"
		setupOnly=1
		if [ "$origVal" = "1" ]
		then
			ENABLE_IXON=1
			IX_ON_OFF="IXON"
		else
			ENABLE_IXON=0
			IX_ON_OFF="-IXON"
		fi
		;;

	*)
		printf "Command Not Recognized!\n"
		exit 0
		;;
esac

if [ $setupOnly -eq 0 ]
then
	# We insist this command be run from console only
	if [ "`tty`" != $CONSOLE_TTY ]
	then
		printf "flow control commands must be run from console\n"
		exit 0
	fi
fi

# check the existing gettydefs file
DASH_IXON_LINES=`grep "^console#" /etc/gettydefs  | tr -t ' ' "\n" |              grep "\-IXON" | wc -l`
IXON_LINES=`grep "^console#" /etc/gettydefs  | tr -t ' ' "\n" |                   grep "^IXON" | wc -l`

# check if we really need to do any work
if [  $ENABLE_IXON = "1"  -a  "$origVal" = "1" ]
then
	# Now let us make sure the /etc/gettydefs is in accordance
	if [ $DASH_IXON_LINES -eq 0 -a $IXON_LINES -ne 0 ]
	then
		printf "Flow control already enabled -- no change\n"
		exit 0
	fi
fi

if [  $ENABLE_IXON = "0"   -a   "$origVal" = "0" ]
then
	# Now let us make sure the /etc/gettydefs is in accordance
	if [ $IXON_LINES -eq 0 -a $DASH_IXON_LINES -ne 0 ]
	then
		printf "Flow control already disabled -- no change\n"
		exit 0
	fi
fi

# at this time we found gettydefs is not in agreement with config attribute
# or the command given


# update the /etc/gettydefs

# code to add / remove IXON from getty defs field
/bin/sed -n -e  "
s/^consol/&/
t console_line
# this line has nothing to do with console definiton
# so, just reproduce it
# s/./&/p
p
b
# this is a line containing console description
:console_line
# see if we have IXON and remove them all
s/-IXON //g
s/IXON //g
# next add IXON or -IXON just after B9600
s/SANE /&${IX_ON_OFF} /g
# s/./&/p
p
b
" /etc/gettydefs > /tmp/gettydefs.new
/bin/cp /tmp/gettydefs.new /etc/gettydefs
sync

# Now let us get rid of old getty, if any on the console
# ps -ef|grep getty|grep console|grep -v grep|cut -c 10-15|xargs kill -9>/dev/null 2>&1
# inform to init process of the change
/sbin/init q
# do an fdatasync on this file

# probagate and save this only if this is NOT a setup call
if [ $setupOnly -eq 0 ]
then
	# probagate this change
	/fabos/cliexec/config set system.login.ixonoff 2 $ENABLE_IXON

	# update this configuration
	/fabos/cliexec/config update
fi

# setup the console accordingly
if [ $ENABLE_IXON = "1" ]
then
	stty ixon -F /dev/console
	printf "flow control is now enabled\n"
else
	stty -ixon -F /dev/console
	printf "flow control is now disabled\n"
fi
