#!/bin/sh
#
#    Copyright (c) 1996-2001 Brocade Communications Systems, Inc.
#    All rights reserved.
#
#    Script to redirect supportshow output and copy the redirected file to
#    remote server
#

#Redirection of supportshow to the file
#1) user
#2) pass
#3) host
#4) dirname	- remote Directory name
#5) size 
#6) sizeflag
#7) protocol 
#8) file 	- Filename
#9) flag - to identify whether its transfer to tmp file in switch or remote file
#10) port 

y="/tmp/$8"
if [ $9 -eq 1 ]; then
/fabos/bin/supportshow > $y 2>/dev/null
filesize=`ls -l $y | awk '{print $5}'`

#To check the size specified by the user. 
#If user enters the size greater than the ssshow file size, than the file will
#be redirected to the user specified location, else it will be exited.
if [ $6 -eq 1 ]; then
if [ $filesize -gt $5 ]; then
rm $y
exit 100;
fi
fi
else
#Redirecting the output to the file in remote server
if [ "$7" == "scp" ] ; then
	/usr/bin/scp -q -oStrictHostKeyChecking=no $y $1@[$3]:$4  # > /dev/null 2>&1
elif [ "$7" == "sftp" ] ; then
	x="/tmp/snmpd_sftp_file.bat"
	echo "put $y $8" > $x #2>/dev/null
	/usr/bin/sftp -oPort=${10} -oPreferredAuthentications=password -oSSHPassword=$2 -oStrictHostKeyChecking=no -b $x $1@[$3]:$4   #> /dev/null 2>&1
	retVal=$?
	if [ "$retVal" != 0 ] ; then
	if [ "${10}" -gt 0 ] ; then
		/usr/bin/sftp -oPort=${10} -oPreferredAuthentications=password -oSSHPassword=$2 -oStrictHostKeyChecking=no -oBatchMode=no -b $x $1@[$3]:$4  # > /dev/null 2>&1
	else
    /usr/bin/sftp -oPreferredAuthentications=password -oSSHPassword=$2 -oStrictHostKeyChecking=no -oBatchMode=no -b $x $1@[$3]:$4
    fi
	fi
elif [ "$7" == "ftp" ] ; then
	/bin/ncftpput -t 60 -u $1 -p $2 $3 $4 $y #> /dev/null 2>&1  
fi
retVal=$?
echo $retVal
rm "$y"
if [ -e "$x" ] ; then
	rm "$x"
fi
fi
exit $retVal
