/*****************************************************************************
 *
 * Copyright 2000 Rhapsody Networks Inc
 *
 * Module Name:
 *     cs.h
 *
 * Abstract:
 *     common services header file
 *
 * Revision History:
 *     $Revision: 1.4 $
 *
 ****************************************************************************/
#ifndef _CS_H
#define _CS_H

#ifndef __ARM
/* System Includes */
#include <sys/types.h>

#ifdef _KERNEL
#include <sys/time.h>
#include <sys/param.h>
#include <sys/malloc.h>
#include <sys/errno.h>
extern int errno;
#else
#include <assert.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <stdio.h>
/* for compiling on LINUX */
#include <string.h>
#endif /* _KERNEL */

/* Library Includes */
#include "stdtypes.h"
#ifdef CSMSG_ENABLED
#include "protocol/fc.h"
#endif
#endif /* __ARM */

#define cs_nelem(a)   (sizeof(a)/sizeof(a[0]))
#define cs_max(a, b)  (((a)>(b))?(a):(b))
#define cs_min(a, b)  (((a)<(b))?(a):(b))

#define CS_SUCCESS  0

#endif /* _CS_H */
