#ifndef _CN_H_
#define _CN_H_

#include "cs/cscn.h"
#include "cspool.h"

#define CN_IP_MAX      4

#define CN_NO_PARTIAL_WR        1
#define CN_USER                 2
#define CN_LISTEN               3
#define CN_RW                   4

#define CN_MSG_MAGIC_NO_1   0x1a1a1a1a
#define CN_MSG_MAGIC_NO_2   0x2b2b2b2b

#define cn_ch_no_partial_wr_set(_ch)        (_ch->type = CN_NO_PARTIAL_WR)
#define cn_ch_is_no_partial_wr(_ch)         (_ch->type == CN_NO_PARTIAL_WR)

#define cn_ch_user_set(_ch)                 (_ch->type = CN_USER)
#define cn_ch_is_user(_ch)                  (_ch->type == CN_USER)

#define cn_ch_listen_set(_ch)               (_ch->type = CN_LISTEN)
#define cn_ch_is_listen(_ch)                (_ch->type == CN_LISTEN)

#define cn_ch_rw_set(_ch)                   (_ch->type = CN_RW)
#define cn_ch_is_rw(_ch)                    (_ch->type == CN_RW)

#define cn_ch_inprogress_set(_ch)           (_ch->flags.is_inprogress = 1)
#define cn_ch_inprogress_clr(_ch)           (_ch->flags.is_inprogress = 0)
#define cn_ch_is_inprogress(_ch)            (_ch->flags.is_inprogress)

#define cn_ch_read_set(_ch)                 (_ch->flags.is_read = 1)
#define cn_ch_read_clr(_ch)                 (_ch->flags.is_read = 0)
#define cn_ch_is_read(_ch)                  (_ch->flags.is_read)

#define cn_ch_write_set(_ch)                (_ch->flags.is_write = 1)
#define cn_ch_write_clr(_ch)                (_ch->flags.is_write = 0)
#define cn_ch_is_write(_ch)                 (_ch->flags.is_write)

#define cn_ch_txt_set(_ch)                  (_ch->flags.is_txt = 1)
#define cn_ch_txt_clr(_ch)                  (_ch->flags.is_txt = 0)
#define cn_ch_is_txt(_ch)                   (_ch->flags.is_txt)

#define cn_ch_error_set(_ch)                (_ch->flags.error = 1)
#define cn_ch_error_clr(_ch)                (_ch->flags.error = 0)
#define cn_ch_is_error(_ch)                 (_ch->flags.error)

#define cn_ch_msg_in_waitq_set(_ch)         (_ch->flags.msg_in_waitq = 1)
#define cn_ch_msg_in_waitq_clr(_ch)         (_ch->flags.msg_in_waitq = 0)
#define cn_ch_is_msg_in_waitq(_ch)          (_ch->flags.msg_in_waitq)

#define cn_ch_msgl_reqd_set(_ch)            (_ch->flags.msgl_reqd = 1)
#define cn_ch_msgl_reqd_clr(_ch)            (_ch->flags.msgl_reqd = 0)
#define cn_ch_msgl_reqd(_ch)                (_ch->flags.msgl_reqd)

#define cn_ch_xbar_set(_ch)                 ((_ch)->flags.is_xbar = 1)
#define cn_ch_xbar_clr(_ch)                 ((_ch)->flags.is_xbar = 0)
#define cn_ch_is_xbar(_ch)                  ((_ch)->flags.is_xbar)

#define cn_ch_csmsg_xbar_set(_ch)           ((_ch)->flags.is_csmsg_xbar = 1)
#define cn_ch_csmsg_xbar_clr(_ch)           ((_ch)->flags.is_csmsg_xbar = 0)
#define cn_ch_is_csmsg_xbar(_ch)            ((_ch)->flags.is_csmsg_xbar)

#define cn_msg_msgl_set(_m)                 (_m->flags.is_msgl = 1)
#define cn_msg_is_msgl(_m)                  (_m->flags.is_msgl)

#define cn_msg_iov_set(_m)                  (_m->flags.is_iov = 1)
#define cn_msg_iov_clr(_m)                  (_m->flags.is_iov = 0)
#define cn_msg_is_iov(_m)                   (_m->flags.is_iov)

#define cn_msg_hdr_read_complete_set(_m)    (_m->flags.hdr_read_complete = 1)
#define cn_msg_hdr_read_complete_clr(_m)    (_m->flags.hdr_read_complete = 0)
#define cn_msg_is_hdr_read_complete(_m)     (_m->flags.hdr_read_complete)

#define cn_msg_xbar_set(_m)                 (_m->flags.is_xbar = 1)
#define cn_msg_is_xbar(_m)                  (_m->flags.is_xbar)

#define cn_smsgq_enq(_ch, _qe)              {(_ch)->nsmsg++;                  \
                                             cs_q_enq(&(_ch)->smsgq, _qe); }

#define cn_smsgq_enq_head(_ch, _qe)         {(_ch)->nsmsg++;                  \
                                             cs_q_enq_head(&(_ch)->smsgq, _qe);}

#define cn_smsgq_deq(_ch, _qe)              {(_ch)->nsmsg--;                  \
                                             cs_q_deq(&(_ch)->smsgq, _qe); }

#define cn_msg_is_from_pool(_m)             {((_m)->mn1 == CN_MSG_MAGIC_NO_1  \
                                             && (_m)->mn2 == CN_MSG_MAGIC_NO_2)\
                                             ? 1 : 0;   }                 \

typedef enum {
    CN_BUF_DONE     =1,
    CN_BUF_PARTIAL,
    CN_BUF_ERROR,
    CN_BUF_CLOSE,
    CN_BUF_ECONNRESET
} cn_buf_status_t;

/* globals and defines */
typedef struct {
    struct {
        uint32_t    init:1;
        uint32_t    stop:1;
        uint32_t    destroyed:1;
        uint32_t    selinit:1;
    } flags;
    cs_q_t          usedq;
    cs_q_t          prioq;
    cs_q_t          freeq;
    cs_q_t          closedq;
    cs_q_t          waitq;
    cs_q_t          lwaitq;
    cs_pool_t       *msgph;
    cs_pool_t       *msglph;
    cs_cn_cfg_t     cfg;
} cn_info_t;

typedef struct {
    int n_sallocs;
    int n_sfrees;
    int n_lallocs;
    int n_lfrees;
} cn_msg_stats_t;

extern cn_info_t cninfo;
extern cn_hdl_t *cnarr;
extern cn_msg_stats_t cs_cn_msg_stats;

#ifdef _KERNEL
#define cn_log_init(_ident, _logopt, _sigterm_hdl)
#else
void            cn_log_init (char *ident, int logopt,
                            void (*sigterm_hdl) (int sig));
#endif /* !_KERNEL */

void            cn_connect_check (cn_hdl_t *ch);
void            cn_connect_retry (void *arg);
int             cn_connect (cn_hdl_t *ch);
void            cn_accept (cn_hdl_t *lch);
void            cn_send_msg (cn_hdl_t *ch);
void            cn_recv_msg (cn_hdl_t *ch);
cn_hdl_t        *cn_alloc (void);
void            cn_enqueue(cn_hdl_t *cn, bool_t prio_fd);
void            cn_close_check(void);
void            cn_error (cn_hdl_t *ch, bool_t is_close, cs_cn_rval_t errnum);
cn_buf_status_t cn_io (int fd, char *buf, int len, int *off, bool_t is_read);
void            cn_buf_ready (void *arg);
cn_msg_hdl_t    *cn_msgl_alloc (void);
cn_msg_hdl_t    *cn_msgl_switch (cn_hdl_t *ch, cn_msg_hdl_t *msg, int len);
void            cn_msgl_wait (cs_cn_msg_wait_qe_t *mwqe);
void            cn_fd_add (cs_q_t *q);
int             cn_fd_chk_rdy (cs_q_t *q);
void            cn_update_iov(cn_msg_hdl_t *msg, int nbytes);
void            cn_recv_txt(cn_hdl_t *ch);
void            cn_recv_csmsg_xbar(cn_hdl_t *ch);
void			cs_cn_cleanup(cs_cn_hdl_t ch);

#endif /*_CN_H_ */
