/*****************************************************************************
 *
 * Copyright 2000 Rhapsody Networks Inc
 *
 * Module Name:
 *     cstrc.h
 *
 * Abstract:
 *     provides support for the cs_trc() stuff
 *
 * Revision History:
 *     $Revision: 1.2 $
 *
 ****************************************************************************/

#ifndef _CSTRC_H
#define _CSTRC_H

#include "stdtypes.h"

#ifdef _KERNEL

#define cs_trc_lock()       cstrcbuf.spl = splnet()
#define cs_trc_unlock()     splx(cstrcbuf.spl)
#define cs_trc_ticks()      (uint32_t) hardclock_ticks

#else

#define cs_trc_lock()
#define cs_trc_unlock()
#define cs_trc_ticks()      cstrcbuf.ticks++        /* not thread safe  */

#endif

typedef struct {
    uint32_t            module;
    uint32_t            line;
    uint32_t            ticks;
    uint32_t            data;
} cs_trace_t;

typedef struct {
    int         head;
    int         tail;
    int         ntrc;
    int         asserted;
    cs_trace_t  *trc;
#ifdef _KERNEL
    int         spl;
#else
    int         ticks;
#endif
    char        assert_str[512];
} cs_trace_buf_t;

extern cs_trace_buf_t cstrcbuf;
extern void cs_trc_init(int ntrc);

#define cs_trc_incr(_ndx)   {                       \
    cstrcbuf._ndx++;                                \
    cstrcbuf._ndx &= (cstrcbuf.ntrc - 1);           \
}

#define cs_trc(_data) do {                              \
    int     next;                                       \
                                                        \
    if (!cstrcbuf.asserted) {                           \
        cs_trc_lock();                                  \
        next = cstrcbuf.tail;                           \
        cstrcbuf.trc[next].module   = CS_TRC_MODULE;    \
        cstrcbuf.trc[next].line     = __LINE__;         \
        cstrcbuf.trc[next].data     = (uint32_t)(_data);\
        cstrcbuf.trc[next].ticks    = cs_trc_ticks();   \
        cs_trc_incr(tail);                              \
        if (cstrcbuf.tail == cstrcbuf.head)             \
            cs_trc_incr(head);                          \
        cs_trc_unlock();                                \
    }                                                   \
} while (0)

#endif /* _CSDBG_H */

