/*
 *
 *    Copyright (c) 2005 Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Description:
 *		Sflipper register space definitions, shared by CP and 1250
 *
 */
#ifndef __SFLIPPER_REG_DEF_H__
#define __SFLIPPER_REG_DEF_H__

typedef struct sfpr_fps_s{
    uint32_t   rdy_hi_pri;				/* 0x100 */         
    uint32_t   in_frame_enc_error;      /* 0x104 */
    uint32_t   crc_error;				/* 0x108 */
    uint32_t   trunc_error;				/* 0x10c */
    uint32_t   too_long_error;			/* 0x110 */
    uint32_t   bad_eof;					/* 0x114 */
    uint32_t   out_frame_enc_error;		/* 0x118 */
    uint32_t   invalid_ordered_set;		/* 0x11c */
    uint32_t   fpl_crc_eof;				/* 0x120 */
    uint32_t   short_arb;				/* 0x124 */
} sfpr_fps_stats_t;

typedef struct sfpr_csi_reg_s {
	/* CSI registers */
	uint32_t	csi_config;					/* 0x00000000 */
	uint32_t	csi_status;					/* 0x00000004 */
	uint32_t	csi_mask_1;					/* 0x00000008 */
	uint32_t	csi_mask_2;					/* 0x0000000C */
	uint32_t	csi_gpio_440_if;			/* 0x00000010 */
	uint32_t	csi_revision;				/* 0x00000014 */
	uint32_t	csi_side;					/* 0x00000018 */
	uint32_t	csi_bfr_bkt_set[2];			/* 0x0000001C */
	uint32_t	csi_bfr_bkt_clr[2];			/* 0x00000024 */
} sfpr_csi_reg_t;

typedef struct sfpr_fps_reg_s {
	/* FPS registers */
	uint32_t	fps_stop_inc;				/* 0x00004000 */
	uint32_t	fps_clear_acc;				/* 0x00004004 */
	uint32_t	fps_ram_par_intr_en;		/* 0x00004008 */
	uint32_t	fps_ram_par_intr_status;	/* 0x0000400c */
	uint32_t	fps_par_ctrl;				/* 0x00004010 */
	uint32_t	fps_outflag_en;				/* 0x00004014 */
	uint32_t	fps_intr_status_set;		/* 0x00004018 */
	uint32_t	fps_ram_par_err_addr;		/* 0x0000401c */
	uint32_t	fps_slow_stats_status;		/* 0x00004020 */
	uint32_t	fps_pad0[(0x100 - 0x024)/4];	
	sfpr_fps_stats_t fps_stats;				/* 4100 - 4124 */
}sfpr_fps_reg_t;

typedef struct sfpr_comp_decomp_reg_s {
	/* Compression/Decompression registers */
    uint32_t	comp_config;				/* 0x00008000 */
	uint32_t 	comp_status;				/* 0x00008004 */
	uint32_t	comp_mask1;					/* 0x00008008 */
	uint32_t	comp_mask2;					/* 0x0000800C */
	uint32_t	comp_rw;					/* 0x00008010 */
	uint32_t	comp_cmd;					/* 0x00008014 */
	uint32_t	comp_sm;					/* 0x00008018 */
	uint32_t	comp_first_error;			/* 0x0000801C */
	uint32_t	decomp_rw;					/* 0x00008020 */
	uint32_t	decomp_cmd;					/* 0x00008024 */
	uint32_t	decomp_sm;					/* 0x00008028 */
	uint32_t	comp_pad0;					/* 0x0000802c */
	uint32_t	rx_cnt_from_hifn;			/* 0x00008030 */
	uint32_t	tx_cnt_from_hifn;			/* 0x00008034 */
	uint32_t	bypassed_frm_cnt;			/* 0x00008038 */
	uint32_t	comp_par_err_inject;		/* 0x0000803c */
	uint32_t	uncomp_word_cnt[8];			/* 0x00008040 */
	uint32_t	comp_word_cnt[8];			/* 0x00008060 */
	uint32_t	comp_unread_word_cnt;		/* 0x00008080 */
	uint32_t	comp_debug_reg;				/* 0x00008084 */
} sfpr_comp_decomp_reg_t;

typedef struct sfpr_fcip_reg_s {
	/* FCIP registers */
	uint32_t	fcip_config;				/* 0x0000c000 */
	uint32_t	fcip_status;				/* 0x0000c004 */
	uint32_t	fcip_mask_1;				/* 0x0000c008 */
	uint32_t	fcip_mask_2;				/* 0x0000c00c */
	uint32_t	der_blinky_light;			/* 0x0000c010 */
	uint32_t	gmac_gap;					/* 0x0000c014 */
	uint32_t	pause_thrshold;				/* 0x0000c018 */
	uint32_t	fcip_pad0[7];				/* 0xc01c - 34 */
	uint32_t	fcip_state;					/* 0x0000c038 */
	uint32_t	fcip_pad1[2];				/* 0xc03c-40 */
	uint32_t	mdio_status;				/* 0x0000c044 */
	uint32_t	fcip_comp_type;				/* 0x0000c048 */
	uint32_t	tx_cksum_water_mark;		/* 0x0000c04c */
	uint32_t	tx_ob_ram_water_mark;		/* 0x0000c050 */
	uint32_t	tx_cksum_ram_size;			/* 0x0000c054 */
	uint32_t	tx_ob_ram_size;				/* 0x0000c058 */
	uint32_t	fcip_status_2;				/* 0x0000c05c */
} sfpr_fcip_reg_t;

typedef struct sfpr_txq_reg_s {
	/* Txq/credit registers */
	uint32_t	txq_config;					/* 0x00010000 */
	uint32_t	txq_status;					/* 0x00010004 */
	uint32_t	txq_mask_1;					/* 0x00010008 */
	uint32_t	txq_mask_2;					/* 0x0001000c */
	uint32_t	txq_brcm_frm_cnt;			/* 0x00010010 */
	uint32_t	txq_rx_tx_frm_cnt;			/* 0x00010014 */
	uint32_t	txq_brcm_frm_cnt_port_2;	/* 0x00010018 */
	uint32_t	txq_first_error;			/* 0x0001001C */
	uint32_t	txq_bfr_bkt_claim[3];		/* 0x00010020 */
	uint32_t	txq_pad0;					/* 0x0001002c */
	uint32_t	txq_bfr_bkt_clear[3];		/* 0x00010030 */
	uint32_t	txq_pad1;					/* 0x0001003c */
	uint32_t	txq_bfr_bkt_has_frm[3];		/* 0x00010040 */
	uint32_t	txq_pad2;					/* 0x0001004c */
	uint32_t	txq_rx_vc_credit[17];		/* 0x00010050 */
	uint32_t	txq_pad3[4];				/* 0x00010094 */
	uint32_t	txq_parity_mem_addr;		/* 0x000100a0 */
	uint32_t	txq_ctrl_word_fail;			/* 0x000100a8 */
	uint32_t	txq_pad4;					/* 0x000100ac */
	uint32_t	txq_mem_upper_wd;			/* 0x000100b0 */
	uint32_t	txq_debug_reg_1;			/* 0x000100b4 */
	uint32_t	txq_debug_reg_2;			/* 0x000100b8 */
	uint32_t	txq_pad5;					/* 0x000100bc */
	uint32_t	txq_disable;				/* 0x000100c0 */
	uint32_t	txq_clear;					/* 0x000100c4 */
	uint32_t	txq_pad6;					/* 0x000100c8 */
} sfpr_txq_reg_t;

typedef struct sfpr_bbc_reg_s {
	/* BBC registers */
	uint32_t	bbc_trc[17];				/* 0x00014000 - 0x040 */
	uint32_t	bbc_pad0[(0x80 - 0x44)/4];	/* 0x044 - 0x080 */
	uint32_t	bbc_rqc[17];				/* 0x00014080 - 0x0c0 */
	uint32_t	bbc_pad1[(0x180 - 0xc4)/4];	/* 0x0c4 - 0x180 */
	uint32_t	bbc_rqc_inc;				/* 0x00014180 */
	uint32_t	bbc_pad2[(0x190 - 0x184)/4];	/* 0x184 - 0x190 */ 
	uint32_t	bbc_trc_inc;				/* 0x00014190 */
	uint32_t	bbc_counter_clr;			/* 0x00014194 */
} sfpr_bbc_reg_t;

typedef struct sfpr_fpl_reg_s {
	/* FPL registers */
	uint32_t	port_config;				/* 0x00200000 */
	uint32_t	fpl_pad_01;					/* 0x00200004 */
	uint32_t	fpl_pad_02;					/* 0x00200008 */
	uint32_t	fpl_lli_os_ctl;				/* 0x0020000c */
	uint32_t	fpl_pad_03;					/* 0x00200010 */
	uint32_t	fpl_lli_ctl;				/* 0x00200014 */
	uint32_t	fpl_pad_04;					/* 0x00200018 */
	uint32_t	fpl_pad_05;					/* 0x0020001c */
	uint32_t	fpl_lli_intr_enable;		/* 0x00200020 */
	uint32_t	fpl_pad_06;					/* 0x00200024 */
	uint32_t	fpl_lli_def;				/* 0x00200028 */
	uint32_t	fpl_pad_07;					/* 0x0020002c */
	uint32_t	fpl_pad_08;					/* 0x00200030 */
	uint32_t	fpl_lli_ns_status;			/* 0x00200034 */
	uint32_t	fpl_lli_intr_status;		/* 0x00200038 */
	uint32_t	fpl_lli_intr_status_set;	/* 0x0020003c */
	uint32_t	serdes_ctl;					/* 0x00200040 */
	uint32_t	serdes_pma;					/* 0x00200044 */
	uint32_t	fpl_link_init_ctl;			/* 0x00200048 */
	uint32_t	fpl_link_init_stat;			/* 0x0020004c */
	uint32_t	fpl_err_status;				/* 0x00200050 */
	uint32_t	fpl_pad_09;					/* 0x00200054 */
	uint32_t	fpl_err_intr_en;			/* 0x00200058 */
	uint32_t	fpl_out_flag_en;			/* 0x0020005c */
	uint32_t	fpl_err_first;				/* 0x00200060 */
	uint32_t	fpl_debug;					/* 0x00200064 */
	uint32_t	dummy;						/* 0x00200068 */
} sfpr_fpl_reg_t;

#endif /* __SFLIPPER_REG_DEF_H__ */


