/*
 *
 *  Copyright (c) 2005 Brocade Communication Systems, Inc.
 *  All rights reserved.
 * 
 * 
 * Description:
 *      SWITCHBOARD message header and body definitions
 * 
 * 
 */

#ifndef  _SB_MGMT_H
#define  _SB_MGMT_H

#include "cmn_mhdr.h"

#define    SB_MAX_OPCODES				128         /*  Maximum opcodes per SAP          */
#define    SB_MAX_SAPS                  64			/*  Maximum number of SAPs           */
#define    SB_MAX_SUBSCRIBERS       	1024		/*  Maximum subscribers per SAP      */        
#define    SB_MAX_NAME_LEN              16

#define    SB_SUCCESS                   0
#define	   SB_FAILURE					!SB_SUCCESS 	 

#define		SB_LISTEN_PORT				8401		// JLL DEBUG MOVE TO COMMON FILE 


/*
**  SwitchBoard Management error codes as returned 
**  in the result code in the message header.    
*/

typedef enum _SB_MGMT_ERROR {	
	SB_INVALID_SAP				= 1,
	SB_INVALID_OPCODE,				/* 2 */
	SB_INVALID_FD					/* 3 */ 
} SB_MGMT_ERROR;


/*
**  Following definitions are used for the flags field of the message header.
*/
#define		SB_NON_SUBSCRIBER			1


/*
**  Message header magic number
*/
#define		SB_MAGIC_NUMBER				0x1A2B3C4D


#define sb_msg_hdr_t cmn_mhdr_t
#define SB_HDR		 sb_msg_hdr_t

#define SBHDR_SIZE(sb_hdr)  (sb_hdr)->size
#define SBHDR_SAP(sb_hdr)  (sb_hdr)->sap
#define SBHDR_OP(sb_hdr)  (sb_hdr)->op
#define SBHDR_SRC(sb_hdr)  (sb_hdr)->src_slot
#define SBHDR_DST(sb_hdr)  (sb_hdr)->dst_slot
#define SBHDR_FLAGS(sb_hdr)  (sb_hdr)->flags
#define SBHDR_RESULT(sb_hdr)  (sb_hdr)->result
#define SBHDR_TRANSID(sb_hdr)  (sb_hdr)->trans_id
#define SBHDR_MAGIC(sb_hdr)  (sb_hdr)->magic_num
#define SBHDR_WS(sb_hdr)  (sb_hdr)->sb_ws

/* DATA STRUCTURES FOR SAP_SB_MGMT(1)    */

/*
**  NOTE :
**     For response messages, use the generic message header since it already contains
**     the fields for result and error codes.
*/


typedef struct {							/* SB_SUBSCRIBE_REQ					*/
	sb_msg_hdr_t  hdr;						/* subscription message header		*/
    uint8_t	 sub_name_len;					/* application name length          */ 
    uint8_t  sub_name[SB_MAX_NAME_LEN];	    /* application name					*/
	uint8_t  sap;                           /* Service Access Point             */
	uint8_t  num_opcode;
    uint8_t  opcode_list[SB_MAX_OPCODES];
    uint32_t sub_pid; 
} sb_subscribe_req_t;

typedef struct {							/* SB_SUBSCRIBE_RSP					*/
	sb_msg_hdr_t  hdr;						/* subscription message header		*/
	uint8_t  sap;                           /* Service Access Point	            */
} sb_subscribe_rsp_t;

typedef struct {							/* SB_DEL_SUBSCRIBE_REQ				*/
    sb_msg_hdr_t  hdr;						/* subscription message header      */ 
    uint8_t	sap;							/* SAP to be deleted                */ 
} sb_del_subscribe_req_t;

typedef struct {							/* SB_DEL_SUBSCRIBE_RSP				*/
    sb_msg_hdr_t  hdr;						/* subscription message header      */ 
    uint8_t	sap;							/* SAP to be deleted                */ 
} sb_del_subscribe_rsp_t;

typedef struct {							/* SB_SUBSCRIBE_REQ					*/
	sb_msg_hdr_t  hdr;						/* subscription message header		*/
	uint8_t  sap;                           /* Service Access Point             */
	uint8_t  opcode;                        /* Opcode                                 */ 
    uint32_t num_subscribers;               /* Number of subscribers for this SAP/OP  */
    uint32_t sub_fd[SB_MAX_SUBSCRIBERS];
    uint32_t sub_pid[SB_MAX_SUBSCRIBERS];
} sb_get_sap_op_subscribers_t;

typedef struct {
	sb_msg_hdr_t	hdr;					/* SB_CPFAILOVER					*/
	uint32_t		ipaddr_cp;				/* IP address of failed over CP 	*/
} sb_cpfailover_t;

#endif /* _SB_MGMT_H */
