/*****************************************************************************
 *
 * Copyright (c) 1996-2006 by Brocade Communications Systems, Inc.
 * All rights reserved.
 *
 * Module Name:
 *     nsmsg.h
 *
 * Abstract:
 *     nameserver messaging library defines
 *
 * Revision History:
 *
 *
 ****************************************************************************/

#ifndef _NSMSG_H
#define _NSMSG_H

#define NS_CT_MSGHDR_VERSION  0x01  /* version number in the msg header */

#define ERR_STATUS -1

typedef enum {
	ZS_QUERY_ZONE_ALL = 0,
	ZS_QUERY_ZONE_COMMITTED = 1
} zs_query_type_t;

typedef struct {
    uint32_t      version:8;
    uint32_t      flags:8;
    uint32_t      reserved:16;
    uint32_t      pl_len;
    uint32_t      ctx;
    uint32_t      op_code;
} ns_cl_msg_hdr_t;

typedef struct {
	int rval;
} zs_resp_zone_t;

/* Name server query requests based on keys (ID, PN, NN, FT) */
typedef struct {
    uint8_t         reserved;
    uint8_t         domain_id;  /* domain, 0 - all fabric               */
    uint8_t         area_id;    /* area, 0 - whole domain               */
    uint8_t         fc4_type;   /* FC_TYPE_SCSI_FCP for SCSI devices    */
} ns_gdapft_req_t, ns_gpnft_req_t;


typedef struct {
    uint32_t        reserved:8;
    uint32_t        dap:24;      /* port identifier */
} ns_gnndap_req_t, ns_gdappn_resp_t,
  ns_gdap_req_t, ns_gspndap_req_t;


typedef struct {
    wwn_t           port_name;  /* port wwn         */
} ns_gdappn_req_t;



typedef struct {
    wwn_t           node_name;  /* node wwn         */
} ns_gnndap_resp_t , ns_gdapnn_req_t;

/* Name server accepts for requests on FT*/
typedef struct {
#ifdef RN_BIGENDIAN
    uint8_t     last    :1; /* Is this the last port identifier  */
    uint8_t     reserved:7;
#else
    uint8_t     reserved:7;
    uint8_t     last    :1;
#endif /* RN_BIGENDIAN */
    uint32_t    dap:24;     /* port identifier                   */
} ns_gdapft_resp_t;



typedef struct
{
#ifdef RN_BIGENDIAN
	uint32_t 	last	:1;
	uint32_t	rsvd	:7;
#else
	uint32_t	rsvd	:7;
	uint32_t 	last	:1;
#endif
	uint32_t	dap	:24;
    uint32_t    rsvd1;
    wwn_t 		port_name;

} ns_gpnft_resp_t;


/* Get the Symbolic Port Name for the Specific ID */
typedef struct {
    uint8_t     name_len;
    uint8_t		sym_port_name[255];

} ns_gspndap_resp_t;

/* Get object response request for specific id */
typedef struct {
	uint32_t	port_type :8;
	uint32_t	dap:24;
	wwn_t		port_name;
    uint8_t     sym_pn_len;
    uint8_t     sym_pn[255];
	wwn_t		node_name;
    uint8_t     sym_nn_len;
    uint8_t     sym_nn[255];
	uint32_t	ipa[2];
	uint32_t	node_ip[4];
	uint32_t	cos;
	uint32_t	fc4_type[8];
	uint32_t	port_ip[4];
	wwn_t		fabric_pn;
	uint32_t    rsvd :2;
	uint32_t    vtype:3;    /* 0 - phy 1 - vir 2 - NPV */
	uint32_t    devtype:3;  /* 0 - unknown 1 - host 2 - target 3 - both */
	uint32_t	hard_address :24;
} ns_gdap_resp_t;

typedef struct {
             wwn_t ini_wwn;
             wwn_t tgt_wwn;
             wwn_t vi_wwn; 
             wwn_t vt_wwn;
             int policy;
             int across_fcr;
             int status;
 } zs_add_zone_req_t; 

typedef struct {
             wwn_t ini_wwn;
             wwn_t tgt_wwn;
	     int policy;
             int across_fcr;
             int status;
 } zs_remove_zone_req_t;

 typedef struct {
             int status;
 } zs_commit_req_t;

typedef struct tuple {
    uint32_t     ns_pid;
    wwn_t        ns_pname;
    wwn_t        ns_nname;
} tuple_t;


typedef struct {
	uint32_t npid;
	tuple_t *rscn_tuple_list;
} scpd_rscn_info_t;

typedef struct {
	zs_query_type_t     query_type;  /* All or committed zones only. */
} zs_query_req_t;

typedef struct {
	wwn_t   h_wwn ;  /* host wwn */
	wwn_t   t_wwn;    /* target wwn */
	int     policy;     /* restartable/non restartable */
	int     across_fcr;
} fr_zone_t;

typedef struct {
	int     status;
	int     zone_count;
	fr_zone_t fr_zones[1] ;
} zs_query_resp_t;

#endif /* _NSMSG_H */
