/*
 *
 *  Copyright (C) 2003 - 2004 Brocade Communications
 *  All rights reserved.
 *
 *  Description:
 *  This file include the data definitation of Message Definition Object
 *  Each message definition is generated from XML file which create by 
 *  developer
 *
 *  These coded instructions and statements contain unpublished trade
 *  secrets and proprietary information.  They are protected by federal
 *  copyright law and by trade secret law, and may not be disclosed to
 *  third parties or used, copied, or duplicated in any form, in whole
 *  or in part, without the prior written consent of Brocade Communications.
 *
 */


#ifndef __RASLOG_MSGDEF_H__
#define __RASLOG_MSGDEF_H__

/* maximum length of msg definition format string */
#define	MAX_MESSAGE_LEN		128

/* maximum length of msg id string, need end with '\0' */
#define MAX_MESSAGE_VALUE_LEN	9

/*
 * maximum number of bytes to store a msg object arguemnt
 * The argument can be string or defined data type
 */
#define MSG_ARG_LEN		(256) /* end with '\0' */

/*
 * raslog support upto 8 msg arguments in each msg boject.
 * Each argument has to be one of pre-defined type.
 * raslog encode all the arguemnt's types in a 32 bits varable in 
 * msg object. Each arguemnt types took 4 bits of this variable for
 * encoding.
 */
#define RLMD_ARG_MASK		0x03
#define RLMD_ARG_TYPE		2
/*
 * internal information for rasevt message ID bits
 */
#define RASLOG_NO_FLAGS		0
#define RASLOG_INTERNAL		0x10000000
#define RASLOG_SYS			0x20000000
#define RASLOG_MODID_OFFSET	16

/* macros to decode msg id */
#ifdef RASLOG_CHK
#define	RLMD_GET_MOD_ID(msgid)	(0)
#define	RLMD_GET_MSG_IDX(msgid)	(0)
#define	RLMD_IS_INTERNAL(msgid)	(0)
#define	RLMD_IS_SYS(msgid)	(0)
#else
#define	RLMD_GET_MOD_ID(msgid)	((msgid >> RASLOG_MODID_OFFSET) & 0x3ff)
#define	RLMD_GET_MSG_IDX(msgid)	(msgid & 0xffff)
#define	RLMD_IS_INTERNAL(msgid)	(msgid & RASLOG_INTERNAL)
#define	RLMD_IS_SYS(msgid)	(msgid & RASLOG_SYS)
#define	RLMD_IS_FFDC(msgid)	(msgid & RLMD_ATTR_FFDC)
#endif

#define	RLMD_MOD_ID_74MASK	0x300
#define RASLOG_INTERNAL_53  0x01000000
#define RASLOG_SYS_53       0x02000000

/* encode offset of the argument type of each argument */
#define	RLMD_ARG0		(0*RLMD_ARG_TYPE)
#define	RLMD_ARG1		(1*RLMD_ARG_TYPE)
#define	RLMD_ARG2		(2*RLMD_ARG_TYPE)
#define	RLMD_ARG3		(3*RLMD_ARG_TYPE)
#define	RLMD_ARG4		(4*RLMD_ARG_TYPE)
#define	RLMD_ARG5		(5*RLMD_ARG_TYPE)
#define	RLMD_ARG6		(6*RLMD_ARG_TYPE)
#define	RLMD_ARG7		(7*RLMD_ARG_TYPE)
#define	RLMD_ARG8		(8*RLMD_ARG_TYPE)
#define	RLMD_ARG9		(9*RLMD_ARG_TYPE)
#define	RLMD_ARG10		(10*RLMD_ARG_TYPE)
#define	RLMD_ARG11		(11*RLMD_ARG_TYPE)
#define	RLMD_ARG12		(12*RLMD_ARG_TYPE)
#define	RLMD_ARG13		(13*RLMD_ARG_TYPE)
#define	RLMD_ARG14		(14*RLMD_ARG_TYPE)
#define	RLMD_ARG15		(15*RLMD_ARG_TYPE)
#ifdef tt
/* supported argument type */
typedef enum {
	RLMD_S = 0,	/* string */
	RLMD_D,		/* decimal */
	RLMD_I,		/* integer */
	RLMD_O,
	RLMD_U,		/* unsigned integer */
	RLMD_X,		/* hex number */
	RLMD_F,		/* floating */
	RLMD_C,		/* character ?? */
	RLMD_L,		/* double */
	RLMD_P		/* pointer */
} rlmd_arg_type_t;
#endif

/* supported argument type */
typedef enum {
	RLMD_STRING = 0,	/* string */
	RLMD_1BYTE,		/* one byte argument */
	RLMD_4BYTES,		/* four bytes argument */
	RLMD_8BYTES		/* eight bytes argument */
} rlmd_arg_type_t;


#define	RLMD_S 	RLMD_STRING	/* string */
#define	RLMD_C	RLMD_1BYTE	/* character */
#define	RLMD_D	RLMD_4BYTES	/* decimal */
#define	RLMD_I	RLMD_4BYTES	/* integer */
#define	RLMD_O	RLMD_4BYTES
#define	RLMD_U	RLMD_4BYTES	/* unsigned integer */
#define	RLMD_X	RLMD_4BYTES	/* hex number */
#define	RLMD_P	RLMD_4BYTES	/* pointer */	
#define	RLMD_F	RLMD_8BYTES	/* floating */
#define	RLMD_L	RLMD_4BYTES	/* long */

/* msg definition structure */
typedef struct rlmd_msgdef {
	raslog_msg_id_t msg_id;	/* message id */
	int 	attributes; /* attributes of the message */
	int 	class; /* attributes of the message */
	int	severity;	/* severity level */
	char	msg_value[MAX_MESSAGE_VALUE_LEN+1];	/* msg string */
	char	message[MAX_MESSAGE_LEN + 1];	/* msg format string */
	int	arg_type;	/* argument type */
	int	arg_num;	/* number of argument */
	char 	cat_name[RAS_CAT_NAME_LEN];
} rlmd_msgdef_t;

/* msg definition structure */
typedef struct rlmd_old_msgdef {
	raslog_msg_id_t msg_id;	/* message id */
	int 	attributes; /* attributes of the message */
	int	severity;	/* severity level */
	char	msg_value[MAX_MESSAGE_VALUE_LEN+1];	/* msg string */
	char	message[MAX_MESSAGE_LEN + 1];	/* msg format string */
	int	arg_type;	/* argument type */
	int	arg_num;	/* number of argument */
} rlmd_old_msgdef_t;

/* macros to access the msg definition object */
/* get argument number */
#define RLMD_SET_ARG_NUM(msgdef, value) ((msgdef)->arg_num = value)
#define RLMD_GET_ARG_NUM(msgdef) ((msgdef)->arg_num)

/* get argument type */
#define RLMD_SET_ARG_TYPE(msgdef, value) ((msgdef)->arg_type = value)
#define RLMD_GET_ARG_TYPE_ALL(msgdef) ((msgdef)->arg_type)

#define RLMD_GET_ARG_TYPE(msgdef, idx) (((msgdef)->arg_type >> \
(idx * RLMD_ARG_TYPE)) & RLMD_ARG_MASK)

#define RLMD_SET_CLASS(msgdef, value) ((msgdef)->class = value)
#define RLMD_GET_CLASS(msgdef) ((msgdef)->class)

#define RLMD_SET_ATTR(msgdef, value) ((msgdef)->attributes = value)
#define RLMD_GET_ATTR(msgdef) ((msgdef)->attributes)
#define RLMD_ADD_ATTR(msgdef, attribute) ((msgdef)->attributes |= attribute)
#define RLMD_REMOVE_ATTR(msgdef, attribute) ((msgdef)->attributes &= ~attribute)

#define RLMD_SET_SEVERITY(msgdef, value) ((msgdef)->severity =  value)
#define RLMD_GET_SEVERITY(msgdef) ((msgdef)->severity)

#define RLMD_COPY_MSG_ID_STRING(dest, src) \
   memcpy((void *)(dest)->msg_value, (void *)(src)->msg_value, \
   MAX_MESSAGE_VALUE_LEN+1)
#define RLMD_GET_MSG_ID_STRING(msgdef) ((msgdef)->msg_value)

#define RLMD_COPY_MSG_FMT_STRING(dest, src) \
  memcpy((void *)(dest)->message, (void *)(src)->message, MAX_MESSAGE_LEN + 1)
#define RLMD_GET_MSG_FMT_STRING(msgdef) ((msgdef)->message)

#define RLMD_SET_MSG_ID(msgdef, value) ((msgdef)->msg_id = value)
#define RLMD_GET_MSG_ID(msgdef) ((msgdef)->msg_id)
#define RLMD_SET_CATNAME(msgdef, name) \
  (strncpy((msgdef)->cat_name, name, RAS_CAT_NAME_LEN - 1))
#define RLMD_GET_CATNAME(msgdef) ((msgdef)->cat_name)

/* check to see if this is a valid msg id */
#define RLMD_VALID_MSG_ID(msgdef) ((msgdef)->msg_id != 0)



/* macro for raslog_old_msgdef_t and raslog_msgdef_t conversion */
#define RLMD_COPY_V3_TO_V1(v1, v3) do { \
        RLMD_SET_MSG_ID(v1, RLMD_GET_MSG_ID(v3)); \
        RLMD_SET_ATTR(v1, RLMD_GET_ATTR(v3)); \
        RLMD_SET_SEVERITY(v1, RLMD_GET_SEVERITY(v3)); \
        RLMD_COPY_MSG_ID_STRING((v1), (v3));\
	RLMD_COPY_MSG_FMT_STRING((v1), (v3));\
        RLMD_SET_ARG_TYPE((v1), RLMD_GET_ARG_TYPE_ALL(v3)); \
        RLMD_SET_ARG_NUM(v1, RLMD_GET_ARG_NUM(v3));\
}  while(0)

#define RLMD_COPY_V1_TO_V2(v2, v1) do { \
	RLMD_SET_MSG_ID((v2), RLMD_GET_MSG_ID(v1)); \
        RLMD_SET_ATTR((v2), RLMD_GET_ATTR(v1));\
        RLMD_ADD_ATTR((v2), RLMD_ATTR_LOG);\
        RLMD_SET_SEVERITY((v2), RLMD_GET_SEVERITY(v1));\
        RLMD_SET_CLASS((v2), RASEVENT_CLASS_NONE);\
        RLMD_COPY_MSG_ID_STRING((v2), (v1));\
        RLMD_COPY_MSG_FMT_STRING((v2), (v1));\
        RLMD_SET_ARG_TYPE((v2), RLMD_GET_ARG_TYPE_ALL(v1));\
        RLMD_SET_ARG_NUM((v2), RLMD_GET_ARG_NUM(v1));\
} while(0)

#endif
