/*
 *
 *  Copyright (C) 2003 - 2004 Brocade Communications
 *  All rights reserved.
 *
 *  Description:
 *  This file include the data definitation of Message Object
 *  A Message Object will be created by raslog Logging library when raslog()
 *  function is called by application to generate a message. The Message Object
 *  provides the interface to retrieve the message object information. Message
 *  object information will be set up by different raslog object while
 *  traveling from Logging Library to message receiver. The information such
 *  as service_id, instance, comp_id, msg_id flags, objid and argument list
 *  will be setup by Logging Library. The time_stamp, global_seq and
 *  external_seq will be setup by Incoming Message Queue Object. The repeat
 *  count will be setup by kernel message de-queue thread. And the overflow
 *  count will be setup by Incoming Message Queue Object or by kernel
 *  message de-queue thread. Every message object base on message receiver
 *  filter setting will be delivered to message receiver for future
 *  processing. Each message object is identified by msg_id.
 *  And the msg_id is used to refer to corresponded message entry in Message
 *  Catalog.
 *
 *  These coded instructions and statements contain unpublished trade
 *  secrets and proprietary information.  They are protected by federal
 *  copyright law and by trade secret law, and may not be disclosed to
 *  third parties or used, copied, or duplicated in any form, in whole
 *  or in part, without the prior written consent of Brocade Communications.
 *
 */


#ifndef __RASLOG_COMM_H__
#define __RASLOG_COMM_H__


#ifdef RASLOG_CHK
typedef char * raslog_msg_id_t;
#else
typedef int raslog_msg_id_t;
#endif

#define RAS_CAT_NAME_LEN	8

/* message id struct with CAT_NAME */
typedef struct raslog_cat_msg_id {
	raslog_msg_id_t	 msg_id;
	char cat_name[RAS_CAT_NAME_LEN];
} raslog_cat_msg_id_t;



#endif
