/*
 * Copyright (c) 2006 Brocade Communications Systems, Inc.
 * All rights reserved.
 *
 * Description:
 *    CSMsg interface header definition.  The driver does not directly
 *    reference the header fields at this time.  However at some future
 *    date CQ selection may be based on destination queue (or other fields).
 *
 */

#ifndef _CSMSGHDR_H
#define _CSMSGHDR_H

/* 
 * CSMSG layer will not touch the following fields:
 * 		- force
 * 		- P
 * 		- M
 * 		- q_code
 * 		- feeder_code
 * 		- sw_hdr
 *
 * 	The caller can choose to fill any value in these field(s).
 *
 * 	NOTE: 
 * 		The byte ordering is not an issue on actual CM. For PC based CSMSG, 
 * 		the CSMSG kernel driver does the byte swapping of the csmsg_hdr. 
 */
typedef struct csmsg_hdr {
	/* Word 1 */
#if defined(RN_SWAPI2) && !defined(__BIG_ENDIAN)
	uint32_t	dest_queue 	: 10;
	uint32_t	res1 		: 2;
	uint32_t	q_code 		: 4;
	uint32_t	dest_addr 	: 10;
	uint32_t	M 			: 1;
	uint32_t	P 			: 1;
    uint32_t	force 		: 4;
#else
	uint32_t	force 		: 4;
	uint32_t	P 			: 1;
	uint32_t	M 			: 1;
	uint32_t	dest_addr 	: 10;
	uint32_t	q_code 		: 4;
	uint32_t	res1 		: 2;
	uint32_t	dest_queue 	: 10;
#endif

	/* Word 2 */
#if defined(RN_SWAPI2) && !defined(__BIG_ENDIAN)
	uint32_t	msg_len 	: 13;   /* length includes the header size too! */
	uint32_t	sw_hdr 		: 3; 	/* sw_hdr cannot be used in CSMSG! has to 
									 * be 0 
									 */
	uint32_t	src_port 	: 9;
    uint32_t	feeder_code : 7;
#else
	uint32_t	feeder_code : 7;
	uint32_t	src_port 	: 9;
	uint32_t	sw_hdr 		: 3; 	/* sw_hdr cannot be used in CSMSG! has to 
									 * be 0 
									 */
	uint32_t	msg_len 	: 13;   /* length includes the header size too! */
#endif

	/* Word 3 */
	uint32_t	res2;				/* see the comment on 
									 * CSMSG_FILL_CSMSG_DEST_ADDR below 
									 */

} csmsg_hdr_t;

#endif /* _CSMSGHDR_H */
